/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "xedit.h"

#include <X11/Xos.h>
#include <sys/stat.h>

extern Widget messwidget;

void
XeditPrintf (str)
     char *str;
{
  XawTextBlock text;
  static XawTextPosition pos = 0;

  text.length = strlen (str);
  text.ptr = str;
  text.firstPos = 0;
  text.format = FMT8BIT;

  XawTextReplace (messwidget, pos, pos, &text);

  pos += text.length;
  XawTextSetInsertionPoint (messwidget, pos);
}

Widget MakeCommandButton (box, name, function)
     Widget
       box;
     char *
       name;
     XtCallbackProc
       function;
{
  Widget w =
    XtCreateManagedWidget (name, commandWidgetClass, box, NULL, ZERO);
  if (function != NULL)
    XtAddCallback (w, XtNcallback, function, (XtPointer) NULL);
  return w;
}

Widget MakeStringBox (parent, name, string)
     Widget
       parent;
     String
       name, string;
{
  Arg args[5];
  Cardinal numargs = 0;
  Widget StringW;

  XtSetArg (args[numargs], XtNeditType, XawtextEdit);
  numargs++;
  XtSetArg (args[numargs], XtNstring, string);
  numargs++;

  StringW = XtCreateManagedWidget (name, asciiTextWidgetClass,
				   parent, args, numargs);
  return (StringW);
}

String GetString (w)
     Widget
       w;
{
  String str;
  Arg arglist[1];

  XtSetArg (arglist[0], XtNstring, &str);
  XtGetValues (w, arglist, ONE);
  return (str);
}

#include <stdio.h>

FileAccess MaybeCreateFile (file)
     char *
       file;
{
  Boolean exists;

  FILE *fp;
  fp = fopen (file, "w");
  fclose (fp);

  if (fp == NULL)
    return (READ_OK);
  return (WRITE_OK);
}

FileAccess CheckFilePermissions (file, exists)
     char *
       file;
     Boolean *
       exists;
{
  char temp[BUFSIZ], *ptr;

  *exists = FALSE;

  strcpy (temp, file);
  if ((ptr = rindex (temp, '/')) == NULL)
    strcpy (temp, ".");
  else
    *ptr = '\0';

  return (NO_READ);
}
