/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "xedit.h"

extern Widget textwindow, labelwindow, filenamewindow;

void ResetSourceChanged ();

static void ResetDC ();

static Boolean double_click = FALSE, source_changed = FALSE;

AddDoubleClickCallback (w, state)
     Widget w;
     Boolean state;
{
  Arg args[1];
  static XtCallbackRec cb[] = {
    {NULL, NULL},
    {NULL, NULL}
  };

  if (state)
    cb[0].callback = ResetDC;
  else
    cb[0].callback = NULL;

  XtSetArg (args[0], XtNcallback, cb);
  XtSetValues (w, args, ONE);
}

static void
ResetDC (w, junk, garbage)
     Widget w;
     XtPointer junk, garbage;
{
  double_click = FALSE;

  AddDoubleClickCallback (w, FALSE);
}

void
DoQuit ()
{
  if (double_click || !source_changed)
    mainwin_popdown_abv ();

  XeditPrintf ("Unsaved changes. Save them, or Quit again.\n");
  Feep ();
  double_click = TRUE;
  AddDoubleClickCallback (textwindow, TRUE);
}

char *
makeBackupName (buf, filename)
     String buf, filename;
{
  sprintf (buf, "%s%s%s", app_resources.backupNamePrefix,
	   filename, app_resources.backupNameSuffix);
  return (buf);
}

#if defined(USG) && !defined(CRAY)
int
rename (from, to)
     char *from, *to;
{
  (void) unlink (to);
  if (link (from, to) == 0)
    {
      unlink (from);
      return 0;
    }
  else
    {
      return -1;
    }
}
#endif

void
DoSave ()
{
  String filename = "abstmpmacro";
  char buf[BUFSIZ];

  if ((filename == NULL) || (strlen (filename) == 0))
    {
      XeditPrintf ("Save:  no filename specified -- nothing saved\n");
      Feep ();
      return;
    }

  if (app_resources.enableBackups)
    {
      char backup_file[BUFSIZ];
      makeBackupName (backup_file, filename);

      if (rename (filename, backup_file) != 0)
	{
	  sprintf (buf, "error backing up file:  %s\n", backup_file);
	  XeditPrintf (buf);
	}
    }

  switch (MaybeCreateFile (filename))
    {
    case NO_READ:
    case READ_OK:
      sprintf (buf, "File %s could not be opened for writing.\n", filename);
      break;
    case WRITE_OK:
      if (XawAsciiSaveAsFile (XawTextGetSource (textwindow), "abstmpmacro"))
	{
	  ResetSourceChanged (textwindow);
	  updatemodule ();
	  sprintf (buf, "Module Updated!\n");
	}
      else
	sprintf (buf, "Error saving file:  %s\n", filename);
      break;
    default:
      sprintf (buf, "%s %s", "Internal function MaybeCreateFile()",
	       "returned unexpected value.\n");
    }

  XeditPrintf (buf);
}

void
DoLoad ()
{
  Arg args[5];
  Cardinal num_args = 0;
  String filename = GetString (filenamewindow);
  char buf[BUFSIZ], label_buf[BUFSIZ];

  if (source_changed && !double_click)
    {
      XeditPrintf ("Unsaved changes. Save them, or press Load again.\n");
      Feep ();
      double_click = TRUE;
      AddDoubleClickCallback (textwindow, TRUE);
      return;
    }
  double_click = FALSE;

  if ((filename != NULL) && ((int) strlen (filename) > 0))
    {
      Boolean exists;

      switch (CheckFilePermissions (filename, &exists))
	{
	case NO_READ:
	  if (exists)
	    sprintf (buf, "File %s, %s", filename,
		     "exists, and could not be opened for reading.\n");
	  else
	    sprintf (buf, "File %s %s %s", filename, "does not exist, and",
		     "the directory could not be opened for writing.\n");

	  XeditPrintf (buf);
	  Feep ();
	  return;
	case READ_OK:
	  XtSetArg (args[num_args], XtNeditType, XawtextRead);
	  num_args++;
	  sprintf (label_buf, "%s       READ ONLY", filename);
	  sprintf (buf, "File %s opened READ ONLY.\n", filename);
	  break;
	case WRITE_OK:
	  XtSetArg (args[num_args], XtNeditType, XawtextEdit);
	  num_args++;
	  sprintf (label_buf, "%s       Read - Write", filename);
	  sprintf (buf, "File %s opened read - write.\n", filename);
	  break;
	default:
	  sprintf (buf, "%s %s", "Internal function MaybeCreateFile()",
		   "returned unexpected value.\n");
	  XeditPrintf (buf);
	  return;
	}

      XeditPrintf (buf);

      if (exists)
	{
	  XtSetArg (args[num_args], XtNstring, filename);
	  num_args++;
	}
      else
	{
	  XtSetArg (args[num_args], XtNstring, NULL);
	  num_args++;
	}

      XtSetValues (textwindow, args, num_args);

      num_args = 0;
      XtSetArg (args[num_args], XtNlabel, label_buf);
      num_args++;
      XtSetValues (labelwindow, args, num_args);
      ResetSourceChanged (textwindow);
      return;
    }

  XeditPrintf ("Load: No file specified.\n");
  Feep ();
}

int
xedit_newfile (char *filename)
{
  Arg args[5];
  Cardinal num_args = 0;
  XtSetArg (args[num_args], XtNstring, filename);
  num_args++;
  XtSetValues (textwindow, args, num_args);
}

static void
SourceChanged (w, junk, garbage)
     Widget w;
     XtPointer junk, garbage;
{
  XtRemoveCallback (w, XtNcallback, SourceChanged, NULL);
  source_changed = TRUE;
}

void
ResetSourceChanged (widget)
     Widget widget;
{
  XtAddCallback (XawTextGetSource (widget), XtNcallback, SourceChanged, NULL);
  source_changed = FALSE;
}
