/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "separator.h"
#include "pixmaps/right.xpm"
#include "button.h"
#include "file_selector.h"
#include "main.h"

static char *separatorpane[] = {
  "Delimiters"
};

extern int insertfile
  (char *filename, int icomma, int itab, int ispace, int isemicom, int other,
   int asone, char *o);

Widget tab, space, comma, semicom, other, asone;
Widget filename, filenamebtn, filenamelabel;

void
separatorfile (name)
     char *name;
{
  SetEntryString (filename, name);
}

void
X11m_browsefile ()
{
  MakePrompt (gettop (), "insert file:", separatorfile, "default.txt");
}

static int action = INSERTFILE;

void
X11m_separator (int a)
{
  action = a;
  display_prompt (td4, gettop ());
}

void
doseparator ()
{
  int icomma = getcheck (comma);
  int itab = getcheck (tab);
  int ispace = getcheck (space);
  int isemicom = getcheck (semicom);
  int iasone = getcheck (asone);
  char *name = (char *) GetEntryString (filename);
  if (action == INSERTFILE)
    insertfile (name, icomma, itab, ispace, isemicom, 0, iasone, NULL);
  if (action == EXPORTFILE)
    exportfile (name, icomma, itab, ispace, isemicom, 0, iasone, NULL);
}

void
initseparatordial ()
{

}

int
make_separator_dial ()
{

  Widget base;

  td4 =
    CreateThumbDialog (gettop (), XtNumber (separatorpane), separatorpane,
		       doseparator, initseparatordial);

  base = get_base (td4);

  w_n = 0;
  w_rel (NULL, 20, 35);
  comma = (Widget) make_check (base, "comma", NULL, (XtPointer) td4);
  w_set (comma);
  setcheck (comma, 0);
  addpanechild (td4, 0, comma);
  addpanechild (td4, 0, CreateLabel (base, "Comma", 40, 35, 100, 20));

  w_n = 0;
  w_rel (NULL, 20, 55);
  tab = (Widget) make_check (base, "tab", NULL, (XtPointer) td4);
  w_set (tab);
  setcheck (tab, 0);
  addpanechild (td4, 0, tab);
  addpanechild (td4, 0, CreateLabel (base, "Tabulation", 40, 55, 100, 20));

  w_n = 0;
  w_rel (NULL, 20, 75);
  space = (Widget) make_check (base, "space", NULL, (XtPointer) td4);
  w_set (space);
  setcheck (space, 0);
  addpanechild (td4, 0, space);
  addpanechild (td4, 0, CreateLabel (base, "Space", 40, 75, 100, 20));

  w_n = 0;
  w_rel (NULL, 180, 35);
  semicom = (Widget) make_check (base, "semicom", NULL, (XtPointer) td4);
  w_set (semicom);
  setcheck (semicom, 0);
  addpanechild (td4, 0, semicom);
  addpanechild (td4, 0, CreateLabel (base, "Semi comma", 200, 35, 100, 20));

  w_n = 0;
  w_rel (NULL, 180, 75);
  asone = (Widget) make_check (base, "asone", NULL, (XtPointer) td4);
  w_set (asone);
  setcheck (asone, 0);
  addpanechild (td4, 0, asone);
  addpanechild (td4, 0,
		CreateLabel (base, "Successive as one", 200, 75, 180, 20));

  addpanechild (td4, 0, CreateLabel (base, "File:", 20, 120, 100, 20));
  filename = (Widget) CreateEntry (base, "filename", 80, 120, 280, 22, "");
  w_n = 0;
  w_bONw ();
  w_set (filename);
  addpanechild (td4, 0, filename);
  filenamebtn =
    (Widget) make_button_pixmap (base, "filenamebtn", right_xpm,
				 X11m_browsefile, NULL);
  w_n = 0;
  w_rel (filename, 3, -17);
  w_set (filenamebtn);
  addpanechild (td4, 0, filenamebtn);

  activepane (td4, 0);
  return 0;
}
