/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "popnindex.h"
#include "button.h"
#include "info_dialog.h"
#include "inputbox.h"
#include "workbook.h"
#include "mainwin.h"
#include "left.xpm"
#include "right.xpm"
#include "first.xpm"
#include "last.xpm"

#include "callback.h"
#include "gr_interf.h"

static struct menuEntry popupMenuEntries[] = {
  {"Cut", m_cut},
  {"Copy", m_copy},
  {"Paste", m_paste},
  {"Copy Down", m_copyd},
  {"Copy Right", m_copyr},
};

Widget make_alone_popup (Widget _toplevel, char *name)
{
  Arg args[20];
  register int n;
  Widget popupmenu, entry;
  int i;
  n = 0;

  XtSetArg (args[n], XtNinput, True);
  n++;

  popupmenu = XtCreatePopupShell
    ("popupMenu", simpleMenuWidgetClass, _toplevel, args, n);

  for (i = 0; i < XtNumber (popupMenuEntries); i++)
    {
      entry = XtCreateManagedWidget (popupMenuEntries[i].name,
				     smeBSBObjectClass, popupmenu, NULL,
				     (Cardinal) 0);
      XtAddCallback (entry, XtNcallback, popupMenuEntries[i].function, NULL);
    }

  return popupmenu;
}

void
changesheetname (w, pointer, event, ctd)
     Widget w;
     XtPointer pointer;
     XEvent *event;
     Boolean *ctd;
{
  int s = 0;
  int sheet;
  char *value;
  int i;

  if (((XButtonEvent *) event)->button == Button1)
    {
      int s = 0;
      for (s = 0; s < 20; s++)
	if (w == ActiveMainwin->selectsheet[s])
	  cb_changesheet (s + ActiveWorkbook->first_vis_wks);
      return;
    }

  if (((XButtonEvent *) event)->button != Button3)
    return;

  for (s = 0; s < 20; s++)
    if (w == ActiveMainwin->selectsheet[s])
      sheet = s + ActiveWorkbook->first_vis_wks;
  value =
    inputbox ("New worksheet name:", "worksheet name",
	      ActiveWorkbook->Worksheets[sheet]->Name);
  if (value != NULL)
    if (strlen (value) > 0)
      {
	for (i = 0; i < ActiveWorkbook->nbworksheet; i++)
	  {
	    if (strcasecmp (ActiveWorkbook->Worksheets[i]->Name, value) == 0)
	      {
		Inform ("Worksheet name allready in use!", NULL);
		return;
	      }
	  }

	worksheet_setname (ActiveWorkbook->Worksheets[sheet], value);
      }
}

static Widget thumbpar;

void
build_thumb (Widget parent)
{
  int i;
  int width;
  int pos = 0;
  char *name = "?";

  ActiveMainwin->first =
    make_button_pixmap (ActiveMainwin->sheetbtn, "first", first_xpm,
			cb_first_sheet, NULL);
  w_n = 0;
  w_rel (NULL, 0, 0);
  w_set (ActiveMainwin->first);

  ActiveMainwin->previous =
    make_button_pixmap (ActiveMainwin->sheetbtn, "previous", left_xpm,
			cb_previous_sheet, NULL);
  w_n = 0;
  w_relv (NULL, 0);
  w_relh (ActiveMainwin->first, 0);
  w_set (ActiveMainwin->previous);

  ActiveMainwin->next =
    make_button_pixmap (ActiveMainwin->sheetbtn, "next", right_xpm,
			cb_next_sheet, NULL);
  w_n = 0;
  w_relh (ActiveMainwin->previous, 0);
  w_relv (NULL, 0);
  w_set (ActiveMainwin->next);

  ActiveMainwin->last =
    make_button_pixmap (ActiveMainwin->sheetbtn, "last", last_xpm,
			cb_last_sheet, NULL);
  w_n = 0;
  w_relh (ActiveMainwin->next, 0);
  w_relv (NULL, 0);
  w_set (ActiveMainwin->last);

  thumbpar = parent;

  for (i = 0; i < 20; i++)
    {
      width = 20;
      w_n = 0;
      w_relv (NULL, 0);
      w_relh (NULL, pos);

      w_dim (width + 15, 20);
      w_bord (0);
      pos += width + 15;
      XtSetArg (w_args[w_n], XtNbackground, absblack);
      w_n++;
      XtSetArg (w_args[w_n], XtNforeground, abswhite);
      w_n++;

      if (i == 0)
	{
	  XtSetArg (w_args[w_n - 2], XtNforeground, absblack);
	  XtSetArg (w_args[w_n - 1], XtNbackground, abswhite);

	}

      if (i > 0)
	{

	}
      ActiveMainwin->selectsheet[i] =
	XtCreateWidget (name, commandWidgetClass, parent, w_args, w_n);

      XtAddEventHandler (ActiveMainwin->selectsheet[i], ButtonReleaseMask,
			 True, changesheetname,
			 ActiveMainwin->selectsheet[i]);

    }
  return;
}

int
rebuild_thumb ()
{
  int i, j;
  int width;
  int nb;
  int pos = 0;
  char *name;

  if (ActiveWorkbook == NULL)
    return -1;
  if (BatchMode)
    return 0;

  for (i = 0; i < 20; i++)
    if (ActiveMainwin->selectsheet[i] != NULL)
      {
	XtUnmanageChild (ActiveMainwin->selectsheet[i]);
      }
  nb = ActiveWorkbook->nbworksheet;
  j = 0;
  for (i = ActiveWorkbook->first_vis_wks; i < nb && j < 19; i++)
    {
      name = ActiveWorkbook->Worksheets[i]->Name;
      if (name == NULL)
	name = "?";
      width = gettextw (name, strlen (name), 1, 0, 2) + 25;
      w_n = 0;
      w_relh (NULL, pos);
      w_dim (width, 20);
      XtSetArg (w_args[w_n], XtNlabel, name);
      w_n++;

      pos += width;
      if (ActiveWorkbook->Worksheets[i] == ActiveWorkbook->activeworksheet)
	{
	  XtSetArg (w_args[w_n], XtNforeground, absblack);
	  w_n++;
	  XtSetArg (w_args[w_n], XtNbackground, abswhite);
	  w_n++;

	}

      else
	{
	  XtSetArg (w_args[w_n], XtNbackground, absblack);
	  w_n++;
	  XtSetArg (w_args[w_n], XtNforeground, abswhite);
	  w_n++;

	}

      w_set (ActiveMainwin->selectsheet[j]);
      XtManageChild (ActiveMainwin->selectsheet[j]);
      j++;
    }

  return 0;
}

void
cb_previous_sheet ()
{
  if (ActiveWorkbook == NULL)
    return;
  if (ActiveWorkbook->first_vis_wks > 0)
    ActiveWorkbook->first_vis_wks--;
  rebuild_thumb ();
}

void
cb_next_sheet ()
{
  if (ActiveWorkbook == NULL)
    return;
  if (ActiveWorkbook->first_vis_wks < ActiveWorkbook->nbworksheet - 1)
    ActiveWorkbook->first_vis_wks++;
  rebuild_thumb ();
}

void
cb_last_sheet ()
{
  if (ActiveWorkbook == NULL)
    return;
  ActiveWorkbook->first_vis_wks = ActiveWorkbook->nbworksheet - 2;
  rebuild_thumb ();
}

void
cb_first_sheet ()
{
  if (ActiveWorkbook == NULL)
    return;
  ActiveWorkbook->first_vis_wks = 0;
  rebuild_thumb ();
}
