/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Core.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Shell.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/List.h>
#include <X11/RectObj.h>
#include <stdio.h>
#include <sys/stat.h>
#include  <dirent.h>
#include "mydialog.h"
#include "gr_interf.h"
#include "memory.h"

Widget get_base (td)
     ThumbDialog *
       td;
{
  return td->promptDialog;
}

int
addpanechild (td, pane, child)
     ThumbDialog *td;
     int pane;
     Widget child;
{
  td->pane_child[pane][td->npane_child[pane]] = child;
  td->npane_child[pane]++;

  XtAddEventHandler (child, ButtonPressMask, False,
		     (XtEventHandler) childtouched, (XtPointer) td);
  return 0;
}

void
separation_line (widget, pointer, junk)
     Widget widget;
     XtPointer pointer;
     XtPointer junk;
{
  ThumbDialog *td = (ThumbDialog *) pointer;

  int i;
  int x1, x2;
  int w = 400;
  int x0 = 2;
  int xn = w - x0 - 2;

  int l = (xn - x0) / td->npane;

  desactivate_zoom ();
  for (i = 0; i < td->npane; i++)
    {
      x1 = x0 + i * l;
      x2 = x1 + l;

      if (td->active_pane == i)
	{
	  drawline (XtDisplay (td->promptDialog), XtWindow (td->promptDialog),
		    0, x0, 29, x1, 29, 0, 0);
	  drawline (XtDisplay (td->promptDialog), XtWindow (td->promptDialog),
		    0, x2 + 1, 29, xn, 29, 0, 0);
	  drawline (XtDisplay (td->promptDialog), XtWindow (td->promptDialog),
		    0, x0, 29, x0, 210, 0, 0);
	  drawline (XtDisplay (td->promptDialog), XtWindow (td->promptDialog),
		    1, x0 + 1, 210, xn, 210, 0, 0);
	  drawline (XtDisplay (td->promptDialog), XtWindow (td->promptDialog),
		    1, xn, 210, xn, 30, 0, 0);

	  drawline (XtDisplay (td->promptDialog), XtWindow (td->promptDialog),
		    0, x1, 6, x1, 29, 0, 0);
	  drawline (XtDisplay (td->promptDialog), XtWindow (td->promptDialog),
		    0, x1 + 1, 5, x2, 5, 0, 0);
	  drawline (XtDisplay (td->promptDialog), XtWindow (td->promptDialog),
		    1, x2 + 1, 6, x2 + 1, 29, 0, 0);
	}
      else
	{
	  if (td->active_pane != i - 1)
	    drawline (XtDisplay (td->promptDialog),
		      XtWindow (td->promptDialog), 0, x1 + 1, 8, x1 + 1, 28,
		      0, 0);

	  if (td->active_pane != i + 1)
	    drawline (XtDisplay (td->promptDialog),
		      XtWindow (td->promptDialog), 1, x2 - 1, 8, x2 - 1, 28,
		      0, 0);

	  drawline (XtDisplay (td->promptDialog), XtWindow (td->promptDialog),
		    0, x1 + 2, 7, x2 - 2, 7, 0, 0);
	}
    }
  reactivate_zoom ();

}

void
childtouched (widget, pointer, junk)
     Widget widget;
     XtPointer pointer;
     XtPointer junk;
{
  ThumbDialog *td = (ThumbDialog *) pointer;

  td->touched_pane[td->active_pane] = 1;

}

void
paneselect (widget, pointer, junk)
     Widget widget;
     XtPointer pointer;
     XtPointer junk;
{
  ThumbDialog *td = (ThumbDialog *) pointer;
  int i = 0;
  for (i = 0; i < td->npane_child[td->active_pane]; i++)
    XtUnmanageChild (td->pane_child[td->active_pane][i]);

  XClearWindow (XtDisplay (td->promptDialog), XtWindow (td->promptDialog));

  i = 0;
  while (td->pane_btn[i] != widget && i < 20)
    i++;

  td->active_pane = i;
  for (i = 0; i < td->npane_child[td->active_pane]; i++)
    XtManageChild (td->pane_child[td->active_pane][i]);

  td->touched_pane[td->active_pane] = 1;

  separation_line (widget, pointer, junk);

  return;

}

int
activepane (td, a)
     ThumbDialog *td;
     int a;
{
  int i, j;
  for (j = 0; j < 20; j++)
    for (i = 0; i < td->npane_child[j]; i++)
      XtUnmanageChild (td->pane_child[j][i]);

  td->active_pane = a;

  for (i = 0; i < td->npane_child[td->active_pane]; i++)
    XtManageChild (td->pane_child[td->active_pane][i]);

  return 0;

}

int *
get_touched_pane (td)
     ThumbDialog *td;
{
  return td->touched_pane;
}

void
PromptCancelAction (widget, pointer, junk)
     Widget widget;
     XtPointer pointer;
     XtPointer junk;
{
  ThumbDialog *td = (ThumbDialog *) pointer;
  XtSetKeyboardFocus (td->parent, (Widget) None);
  XtUnmanageChild (td->promptShell);
}

void
PromptAcceptAction (widget, pointer, junk)
     Widget widget;
     XtPointer pointer;
     XtPointer junk;
{
  ThumbDialog *td = (ThumbDialog *) pointer;
  XtSetKeyboardFocus (td->parent, (Widget) None);
  XtUnmanageChild (td->promptShell);
  (*td->promptfunction) ();
}

ThumbDialog *
CreateThumbDialog (parent, npane, panename, func, cbfunc)
     Widget parent;
     int npane;
     char **panename;
     void (*func) ();
     void (*cbfunc) ();
{
  Arg args[20];
  int n, i;
  Widget cancel, ok, box;
  ThumbDialog *td;

  td =
    (ThumbDialog *) absmalloc (sizeof (ThumbDialog), "CreateThumbDialog:td ");

  td->npane = npane;
  td->parent = parent;
  n = 0;
  XtSetArg (args[n], XtNinput, True);
  n++;
  XtSetArg (args[n], XtNwidth, 402);
  n++;
  XtSetArg (args[n], XtNheight, 250);
  n++;
  td->promptShell = XtCreatePopupShell
    ("promptShell", transientShellWidgetClass, parent, args, 3);

  n = 0;
  XtSetArg (args[n], XtNwidth, 402);
  n++;
  XtSetArg (args[n], XtNheight, 250);
  n++;

  td->promptDialog = XtCreateManagedWidget ("promptDialog", formWidgetClass,
					    td->promptShell, args, n);

  XtAddEventHandler (td->promptShell, ExposureMask, False, separation_line,
		     (XtPointer) td);
  XtAddEventHandler (td->promptShell, StructureNotifyMask, False,
		     separation_line, (XtPointer) td);
  XtAddEventHandler (td->promptShell, VisibilityChangeMask, False,
		     separation_line, (XtPointer) td);

  n = 0;
  XtSetArg (args[n], XtNwidth, 402);
  n++;
  XtSetArg (args[n], XtNheight, 1);
  n++;
  XtSetArg (args[n], XtNborderWidth, 0);
  n++;
  box = XtCreateManagedWidget ("promptDialog", formWidgetClass,
			       td->promptDialog, args, n);
  n = 0;
  XtSetArg (args[n], XtNwidth, 1);
  n++;
  XtSetArg (args[n], XtNheight, 250);
  n++;
  XtSetArg (args[n], XtNborderWidth, 0);
  n++;
  box = XtCreateManagedWidget ("promptDialog", formWidgetClass,
			       td->promptDialog, args, n);

  w_n = 0;
  w_dim (85, 20);
  w_rel (NULL, 200, 220);
  ok = XtCreateManagedWidget
    ("Ok", commandWidgetClass, td->promptDialog, w_args, w_n);
  XtAddCallback (ok, XtNcallback, PromptAcceptAction, (XtPointer) td);

  w_n = 0;
  w_dim (85, 20);
  w_rel (NULL, 300, 220);
  cancel = XtCreateManagedWidget
    ("Cancel", commandWidgetClass, td->promptDialog, w_args, w_n);
  XtAddCallback (cancel, XtNcallback, PromptCancelAction, (XtPointer) td);

  td->active_pane = 0;
  if (npane > 1)
    {
      for (i = 0; i < npane; i++)
	{
	  w_n = 0;
	  w_dim ((400 - 4) / npane - 8, 20);
	  w_rel (NULL, i * ((400 - 4) / npane) + 2 + 2, 9);
	  w_bord (0);
	  XtSetArg (w_args[w_n], XtNhighlightThickness, 0);
	  w_n++;

	  td->pane_btn[i] = XtCreateManagedWidget
	    (panename[i], commandWidgetClass, td->promptDialog, w_args, w_n);
	  XtAddCallback (td->pane_btn[i], XtNcallback, paneselect,
			 (XtPointer) td);

	  td->npane_child[i] = 0;
	}
    }

  XtRealizeWidget (td->promptShell);

  for (i = 0; i < 20; i++)
    td->npane_child[i] = 0;

  td->promptfunction = func;
  td->popupcb = cbfunc;
  return td;
}

void
display_prompt (td, centerw)
     ThumbDialog *td;
     Widget centerw;
{
  Arg centerArgs[2];
  int i;
  Position source_x, source_y;
  Position dest_x, dest_y;
  Dimension center_width, center_height;
  Dimension prompt_width, prompt_height;

  XtSetArg (centerArgs[0], XtNwidth, &center_width);
  XtSetArg (centerArgs[1], XtNheight, &center_height);
  XtGetValues (centerw, centerArgs, 2);
  XtSetArg (centerArgs[0], XtNwidth, &prompt_width);
  XtSetArg (centerArgs[1], XtNheight, &prompt_height);
  XtGetValues (td->promptShell, centerArgs, 2);
  source_x = (int) (center_width - prompt_width) / 2;
  source_y = (int) (center_height - prompt_height) / 3;
  XtTranslateCoords (centerw, source_x, source_y, &dest_x, &dest_y);
  XtSetArg (centerArgs[0], XtNx, dest_x);
  XtSetArg (centerArgs[1], XtNy, dest_y);
  XtSetValues (td->promptShell, centerArgs, 2);
  XtManageChild (td->promptShell);

  for (i = 0; i < 20; i++)
    td->touched_pane[i] = 0;

  td->touched_pane[td->active_pane] = 1;

  if (td->popupcb != NULL)
    (*td->popupcb) ();
  XtSetKeyboardFocus (td->parent, td->promptShell);

}

void
cb_flpopup (w, pointer, event, ctd)
     Widget w;
     XtPointer pointer;
     XEvent *event;
     Boolean *ctd;
{
  XtRemoveGrab ((Widget) pointer);
  XtPopdown ((Widget) pointer);

}

void
cb_pmpopup (w, pointer, event, ctd)
     Widget w;
     XtPointer pointer;
     XEvent *event;
     Boolean *ctd;
{
  printf ("pointer motion\n");
}
