/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef MENUBAR_H
#define MENUBAR_H
#include <stdio.h>
#include "param.h"
#include "cblist.h"

typedef struct
{
  int Initialized;
  Widget btn1;
  Widget btn2;
  Widget btn3;
  Widget btn4;
  Widget btn5;
  Widget btn6;
  Widget popup1;
  Widget popup2;
  Widget popup3;
  Widget popup4;
  Widget popup5;
  Widget popup6;

}
Menubar;

struct _Menu_ele
{
  char *name;
  int type;
  struct _Menu_ele *popup;
  void (*cb) ();
};

typedef struct _Menu_ele Menu_ele;

extern void nocb ();
extern void X11m_openfile ();
extern void X11m_savefile ();
extern void X11m_saveasfile ();
extern void X11m_insertfile ();
extern void X11m_exportfile ();
extern void X11m_macro ();
extern void X11m_macroplay ();
extern void X11m_macrorec ();
extern void X11m_macrostop ();
extern void X11m_sheetname ();
extern void X11m_formatborder ();
extern void m_print ();
extern void m_close ();

extern Widget make_bar_button (Widget menu_bar, char *name);

extern Widget make_popup (Widget bar_button, char *name, char *button_name,
			  struct menuEntry *menuentry, int num);
extern Widget add_entry (Widget popupmenu, char *name, void (*func) ());

extern int add_window_name (char *name);
extern int remove_windox_name (char *name);

extern int recursive_build (Menubar * mb_obj, Widget parent, Menu_ele * menu);
extern Menubar *newmenubar (Widget menubar);

#endif
