/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef MAINWIN_H
#define MAINWIN_H

#include "commandline.h"
#include "menubar.h"
#include "buttonbar.h"
#include "formatbar.h"
#include "myscroll.h"
#include "param.h"

typedef struct
{
  Widget toplevel;
  Widget baseform;
  Widget menubar;
  Menubar *menubar_obj;
  Widget buttonbar;
  Buttonbar *buttonbar_obj;
  int buttonbar_ismanaged;
  Widget formatbar;
  Formatbar *formatbar_obj;
  int formatbar_ismanaged;
  Widget commandline;
  Commandline *commandline_obj;
  Widget wbform;

  Widget corner;
  Widget linindex;
  Widget colindex;
  Widget draw;
  Myscroll *scrollv;
  Myscroll *scrollh;
  Widget sheetselform;
  Widget popup;
  Widget abv_editor;
  Widget sheetbottom;
  Widget selectsheet[20];
  Widget sheetbtn;
  Widget first, previous, next, last;
  Widget cell;

  Display *dpy;
}
Mainwin;

extern Mainwin *ActiveMainwin;
extern Mainwin *newmainwin (Widget top);
extern int mainwin_popup_abv ();
extern int mainwin_popdown_abv ();
extern void setscrollv (double v);
extern void setscrollh (double v);
extern int popupcell (int x, int y, int w, int h);
extern int popdowncell ();
extern int LetextLooseFocus ();
extern int LetextGetFocus ();
extern int mainwin_inform (char *str);

extern Display *mainwin_drawdpy ();

extern void
event_KeyPressed (Widget widget, XtPointer pointer, XEvent * event,
		  Boolean * ctd);
extern void event_KeyReleased (Widget widget, XtPointer pointer,
			       XEvent * event, Boolean * ctd);

extern void buttonbar_onoff ();
extern void formatbar_onoff ();
#endif
