/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Core.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Shell.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/List.h>
#include <X11/RectObj.h>
#include "param.h"

#define RET_NONE 0
#define RET_YES 1
#define RET_OK  2
#define RET_CANCEL 3
#define RET_NO  4

typedef struct
{
  Widget Dialog;
  Widget Shell;
  void (*function) ();
  Widget parent;
  Widget Message;
  Widget iconbox;
  Widget input;
  Widget cancel;
  Widget no;
  Widget ok;
}
InfoDialog;

extern int Inform (char *message, void (*func) ());
extern int Ask (char *message, void (*func) ());
extern int Input (char *message, void (*func) ());
extern char *GetInputValue ();
extern int SetInputValue ();

extern void CreateInfoDialog (Widget parent, void (*func) ());

extern void
InfoCancelAction (Widget widget, XtPointer pointer, XtPointer junk);

extern void
InfoAcceptAction (Widget widget, XEvent * event, String * params,
		  Cardinal * num_params);
extern void cb_AcceptAction (Widget widget, XtPointer pointer,
			     XtPointer junk);

extern void InfoNoAction (Widget widget, XtPointer pointer, XtPointer junk);

extern void InfoDisplay (Widget centerw);
