/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "formula.h"
#include "libfct.h"
#include "memory.h"
#include "mainwin.h"
#include "callback.h"

static char *formulapane[] = {
  "Delimiters"
};

static char *category[] = {
  "All",
  "Math",
  "Text",
  "Statistic",
  "Information",
  NULL
};

static Widget categorylist, namelist;

static char **fctnames = NULL;
static char *selectedname;
static int selectedindex = 1;
static int selectedcategory = 1;

void
change_category (w, closure, call_data)
     Widget w;
     XtPointer closure, call_data;
{

  int first, last, n;
  int i;

  XawListReturnStruct *item = (XawListReturnStruct *) call_data;
  selectedcategory = item->list_index + 1;
  first = 13;
  last = 153;
  switch (selectedcategory)
    {
    case 1:
      first = 13;
      last = 156;
      break;
    case 2:
      first = 13;
      last = 71;
      break;
    case 3:
      first = 73;
      last = 82;
      break;
    case 4:
      first = 83;
      last = 153;
      break;
    case 5:
      first = 154;
      last = 156;
      break;
    }
  n = last - first;

  fctnames =
    (char **) absrealloc (fctnames, (n + 3) * sizeof (char *),
			  "change_category:names");
  for (i = first; i <= last; i++)
    {
      fctnames[i - first] = arrayfct[i].name;
    }
  fctnames[last - first + 1] = NULL;

  XawListChange (namelist, fctnames, 0, 0, True);

}

void
change_name (w, closure, call_data)
     Widget w;
     XtPointer closure, call_data;
{
  XawListReturnStruct *item = (XawListReturnStruct *) call_data;
  selectedname = item->string;
  selectedindex = item->list_index + 1;
}

void
X11m_formula ()
{
  display_prompt (td5, gettop ());
}

void
doformula ()
{
  char buf[64];
  sprintf (buf, "%s ()", selectedname);
  echofct (buf);
  XtSetKeyboardFocus (ActiveMainwin->toplevel,
		      ActiveMainwin->commandline_obj->text);
}

void
initformuladial ()
{

  int first, last, n;
  int i;

  first = 13;
  last = 153;
  n = last - first;
  XawListChange (categorylist, category, 0, 0, True);
  fctnames =
    (char **) absrealloc (fctnames, (n + 3) * sizeof (char *),
			  "change_category:names");
  for (i = first; i <= last; i++)
    {
      fctnames[i - first] = arrayfct[i].name;
    }
  fctnames[last - first + 1] = NULL;

  XawListChange (namelist, fctnames, 0, 0, True);

}

int
make_formula_dial ()
{
  Widget viewport1, viewport2;
  Widget base, vsrl;

  td5 =
    CreateThumbDialog (gettop (), XtNumber (formulapane), formulapane,
		       doformula, initformuladial);

  base = get_base (td5);

  addpanechild (td5, 0,
		CreateLabel (base, "Function Category", 20, 25, 140, 20));

  w_n = 0;
  w_bord (0);
  w_dim (120, 100);
  w_rel (NULL, 20, 55);
  XtSetArg (w_args[w_n], XtNuseRight, True);
  w_n++;
  XtSetArg (w_args[w_n], XtNallowVert, True);
  w_n++;
  XtSetArg (w_args[w_n], XtNforceBars, True);
  w_n++;

  viewport1 = XtCreateManagedWidget ("viewport1",
				     viewportWidgetClass, base, w_args, w_n);
  vsrl = XtNameToWidget (viewport1, "vertical");
  if (vsrl != (Widget) NULL)
    {
      modscroll (vsrl);
    }

  addshadow (viewport1, 6);
  addpanechild (td5, 0, viewport1);

  w_n = 0;
  w_bord (0);
  XtSetArg (w_args[w_n], XtNdefaultColumns, 1);
  w_n++;
  XtSetArg (w_args[w_n], XtNforceColumns, True);
  w_n++;
  w_bONw ();
  categorylist = XtCreateManagedWidget ("categorylist", listWidgetClass,
					viewport1, w_args, w_n);
  XtAddCallback (categorylist, XtNcallback, change_category, NULL);
  addshadow (categorylist, 6);

  addpanechild (td5, 0,
		CreateLabel (base, "Function Name", 200, 25, 100, 20));

  w_n = 0;
  w_bord (0);
  w_dim (120, 100);
  w_rel (NULL, 200, 55);
  XtSetArg (w_args[w_n], XtNuseRight, True);
  w_n++;
  XtSetArg (w_args[w_n], XtNallowVert, True);
  w_n++;
  XtSetArg (w_args[w_n], XtNforceBars, True);
  w_n++;

  viewport2 = XtCreateManagedWidget ("viewport2",
				     viewportWidgetClass, base, w_args, w_n);
  vsrl = XtNameToWidget (viewport2, "vertical");
  if (vsrl != (Widget) NULL)
    {
      modscroll (vsrl);
    }

  addshadow (viewport2, 6);
  addpanechild (td5, 0, viewport2);

  w_n = 0;
  w_bord (0);
  XtSetArg (w_args[w_n], XtNdefaultColumns, 1);
  w_n++;
  XtSetArg (w_args[w_n], XtNforceColumns, True);
  w_n++;
  w_bONw ();
  namelist = XtCreateManagedWidget ("namelist", listWidgetClass,
				    viewport2, w_args, w_n);
  XtAddCallback (namelist, XtNcallback, change_name, NULL);
  addshadow (namelist, 6);

  activepane (td5, 0);

  return 0;

}
