/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "dialog.h"

static AbsDialog AbsInfoDialog;
static int absinfodialogexist = 0;

#define RET_NONE 0
#define RET_OK 1

static int answer;

AbsInform (message, func)
     char *message;
     void (*func) ();
{
  Arg arglist[1];
  XtAppContext context;
  answer = RET_NONE;

  if (!absinfodialogexist)
    CreateAbsDialog ((Widget) gettop (), func);
  XtManageChild (AbsInfoDialog.Dialog);

  return 0;
};

void
CreateAbsDialog (parent, func)
     Widget parent;
     void (*func) ();
{
  Arg args[20];
  int n, i;
  Widget ok, box;

  if (BatchMode)
    return;

  AbsInfoDialog.parent = parent;
  n = 0;
  XtSetArg (args[n], XtNwidth, 200);
  n++;
  XtSetArg (args[n], XtNheight, 100);
  n++;

  AbsInfoDialog.Dialog = XtCreateWidget ("absinfodialog", dialogWidgetClass,
					 AbsInfoDialog.parent, args, n);

  AbsInfoDialog.function = func;
  absinfodialogexist = 1;
}

void
AbsDialogDisplay (centerw)
     Widget centerw;
{
  Arg valueArgs[2];
  Arg centerArgs[2];
  Arg args[20];
  int n, i;
  Position source_x, source_y;
  Position dest_x, dest_y;
  Dimension center_width, center_height;
  Dimension Info_width, Info_height;

  XtSetArg (centerArgs[0], XtNwidth, &center_width);
  XtSetArg (centerArgs[1], XtNheight, &center_height);
  XtGetValues (centerw, centerArgs, 2);
  XtSetArg (centerArgs[0], XtNwidth, &Info_width);
  XtSetArg (centerArgs[1], XtNheight, &Info_height);
  XtGetValues (AbsInfoDialog.Dialog, centerArgs, 2);
  source_x = (int) (center_width - Info_width) / 2;
  source_y = (int) (center_height - Info_height) / 3;
  XtTranslateCoords (centerw, source_x, source_y, &dest_x, &dest_y);
  XtSetArg (centerArgs[0], XtNx, dest_x);
  XtSetArg (centerArgs[1], XtNy, dest_y);
  XtSetValues (AbsInfoDialog.Dialog, centerArgs, 2);
  XtManageChild (AbsInfoDialog.Dialog);

}
