/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "button.h"

#include "check0.xpm"
#include "check1.xpm"
#include "radio0.xpm"
#include "radio1.xpm"

Pixmap make_bitmap_from_data (parent, bits, w, h)
     Widget
       parent;
     char *
       bits;
     int
       w, h;
{
  return
    XCreateBitmapFromData (XtDisplay (parent),
			   DefaultRootWindow (XtDisplay (parent)), bits, w,
			   h);
}

int
make_pixmap_from_data (Widget parent, char **bits, Pixmap * bm)
{
  XpmAttributes xpm_attr;
  XpmColorSymbol none_color = { NULL, "None", (Pixel) 0 };

  xpm_attr.valuemask = XpmSize | XpmCloseness;
  xpm_attr.closeness = 40000;
  xpm_attr.numsymbols = 1;
  xpm_attr.colorsymbols = &none_color;
  XtVaGetValues (parent, XtNbackground, &none_color.pixel, NULL);
  XpmCreatePixmapFromData (XtDisplay (parent),
			   DefaultRootWindow (XtDisplay (parent)), bits, bm,
			   NULL, &xpm_attr);

  return 0;
}

Widget
make_button_pixmap (Widget parent, char *name, char **pix_bits,
		    void (*ftccallback) (), XtPointer param)
{
  Widget button;
  Pixmap bm;
  Arg args[20];
  register int n;

  n = 0;
  make_pixmap_from_data (parent, pix_bits, &bm);
  XtSetArg (args[n], XtNbitmap, bm);
  n++;
  XtSetArg (args[n], XtNlabel, "");
  n++;

  if (ftccallback != NULL)
    {
      XtSetArg (args[n], XtNhighlightThickness, 1);
      n++;
      XtSetArg (args[n], XtNborderWidth, 0);
      n++;
      XtSetArg (args[n], XtNinternalHeight, 1);
      n++;
      XtSetArg (args[n], XtNinternalWidth, 1);
      n++;
    }
  else
    {
      XtSetArg (args[n], XtNhighlightThickness, 0);
      n++;
      XtSetArg (args[n], XtNborderWidth, 0);
      n++;
      XtSetArg (args[n], XtNinternalHeight, 1);
      n++;
      XtSetArg (args[n], XtNinternalWidth, 1);
      n++;
    }
  button = XtCreateManagedWidget (name, commandWidgetClass, parent, args, n);
  if (ftccallback != NULL)
    XtAddCallback (button, XtNcallback, ftccallback, param);
  return button;
}

Widget make_bar_button_pixmap (Widget menu_bar, char *name, char **pix_bits)
{
  Pixmap bm;
  Arg args[20];
  register int n;

  n = 0;
  make_pixmap_from_data (menu_bar, pix_bits, &bm);
  XtSetArg (args[n], XtNbitmap, bm);
  n++;
  XtSetArg (args[n], XtNlabel, "");
  n++;

  XtSetArg (args[n], XtNhighlightThickness, 1);
  n++;
  XtSetArg (args[n], XtNborderWidth, 0);
  n++;
  XtSetArg (args[n], XtNinternalHeight, 1);
  n++;
  XtSetArg (args[n], XtNinternalWidth, 1);
  n++;
  return XtCreateManagedWidget
    (name, menuButtonWidgetClass, menu_bar, args, n);
}

Widget
make_repeater_pixmap (Widget parent, char *name, char **pix_bits,
		      void (*ftccallback) (), XtPointer param)
{
  Widget button;
  Pixmap bm;
  Arg args[20];
  register int n;

  n = 0;
  make_pixmap_from_data (parent, pix_bits, &bm);
  XtSetArg (args[n], XtNbitmap, bm);
  n++;
  XtSetArg (args[n], XtNlabel, "");
  n++;

  XtSetArg (args[n], XtNhighlightThickness, 1);
  n++;
  XtSetArg (args[n], XtNborderWidth, 0);
  n++;
  XtSetArg (args[n], XtNinternalHeight, 1);
  n++;
  XtSetArg (args[n], XtNinternalWidth, 1);
  n++;
  button = XtCreateManagedWidget (name, repeaterWidgetClass, parent, args, n);
  XtAddCallback (button, XtNcallback, ftccallback, param);
  return button;
}

Widget make_toggle_pixmap (parent, name, pix_bits, ftccallback, param)
     Widget
       parent;
     char *
       name;
     char **
       pix_bits;
     void (*ftccallback) ();
     XtPointer
       param;
{
  Widget button;
  Pixmap bm;
  Arg args[20];
  register int n;

  n = 0;
  make_pixmap_from_data (parent, pix_bits, &bm);
  XtSetArg (args[n], XtNbitmap, bm);
  n++;
  XtSetArg (args[n], XtNlabel, "");
  n++;

  XtSetArg (args[n], XtNhighlightThickness, 1);
  n++;
  XtSetArg (args[n], XtNborderWidth, 0);
  n++;
  XtSetArg (args[n], XtNinternalHeight, 1);
  n++;
  XtSetArg (args[n], XtNinternalWidth, 1);
  n++;
  button = XtCreateManagedWidget (name, toggleWidgetClass, parent, args, n);
  if (ftccallback != NULL)
    XtAddCallback (button, XtNcallback, ftccallback, param);
  return button;
}

Widget
make_menu_button_pixmap (Widget parent, char *name, char **pix_bits,
			 void (*ftccallback) (), XtPointer param)
{
  Pixmap bm;
  Arg args[20];
  register int n;

  n = 0;
  make_pixmap_from_data (parent, pix_bits, &bm);
  XtSetArg (args[n], XtNbitmap, bm);
  n++;
  XtSetArg (args[n], XtNlabel, "");
  n++;

  XtSetArg (args[n], XtNhighlightThickness, 1);
  n++;
  XtSetArg (args[n], XtNborderWidth, 0);
  n++;
  XtSetArg (args[n], XtNinternalHeight, 1);
  n++;
  XtSetArg (args[n], XtNinternalWidth, 1);
  n++;
  return XtCreateManagedWidget (name, menuButtonWidgetClass, parent, args, n);

}

static int first_check = 1;
static Pixmap check0;
static Pixmap check1;

void
changecheck (w, closure, call_data)
     Widget w;
     XtPointer closure, call_data;
{
  Arg args[1];
  Boolean on;

  XtSetArg (args[0], XtNstate, &on);
  XtGetValues (w, args, 1);

  if (on)
    XtSetArg (args[0], XtNbitmap, check1);
  else
    XtSetArg (args[0], XtNbitmap, check0);

  XtSetValues (w, args, 1);
}

int
setcheck (w, on)
     Widget w;
     int on;
{
  Arg args[2];

  XtSetArg (args[0], XtNstate, on);

  if (on)
    XtSetArg (args[1], XtNbitmap, check1);
  else
    XtSetArg (args[1], XtNbitmap, check0);

  XtSetValues (w, args, 2);
  return on;
}

Boolean getcheck (w)
     Widget
       w;
{
  Boolean on;
  Arg args[1];
  XtSetArg (args[0], XtNstate, &on);
  XtGetValues (w, args, 1);
  return on;
}

Widget make_check (parent, name, ftccallback, param)
     Widget
       parent;
     char *
       name;
     void (*ftccallback) ();
     XtPointer
       param;
{
  Widget button;
  Arg args[20];
  register int n;

  if (first_check)
    {
      make_pixmap_from_data (parent, check0_xpm, &check0);
      make_pixmap_from_data (parent, check1_xpm, &check1);
      first_check = 0;
    }

  n = 0;
  XtSetArg (args[n], XtNbitmap, check0);
  n++;
  XtSetArg (args[n], XtNlabel, "");
  n++;

  XtSetArg (args[n], XtNhighlightThickness, 0);
  n++;
  XtSetArg (args[n], XtNborderWidth, 0);
  n++;
  XtSetArg (args[n], XtNinternalHeight, 0);
  n++;
  XtSetArg (args[n], XtNinternalWidth, 0);
  n++;
  button = XtCreateManagedWidget (name, toggleWidgetClass, parent, args, n);

  XtAddCallback (button, XtNcallback, changecheck, NULL);

  if (ftccallback != NULL)
    XtAddCallback (button, XtNcallback, ftccallback, param);
  return button;
}

static int first_radio = 1;
static Pixmap radio0;
static Pixmap radio1;

void
changeradio (w, closure, call_data)
     Widget w;
     XtPointer closure, call_data;
{
  Arg args[1];
  Boolean on;

  XtSetArg (args[0], XtNstate, &on);
  XtGetValues (w, args, 1);

  if (on)
    XtSetArg (args[0], XtNbitmap, radio1);
  else
    XtSetArg (args[0], XtNbitmap, radio0);

  XtSetValues (w, args, 1);
}

int
setradio (w, on)
     Widget w;
     int on;
{
  Arg args[2];

  XtSetArg (args[0], XtNstate, on);

  if (on)
    XtSetArg (args[1], XtNbitmap, radio1);
  else
    XtSetArg (args[1], XtNbitmap, radio0);

  XtSetValues (w, args, 2);
  return on;
}

Boolean getradio (w)
     Widget
       w;
{
  Boolean on;
  Arg args[1];
  XtSetArg (args[0], XtNstate, &on);
  XtGetValues (w, args, 1);
  return on;
}

Widget
make_radio (Widget parent, char *name, Widget group, void (*ftccallback) (),
	    XtPointer param)
{
  Widget button;
  Arg args[20];
  register int n;

  if (first_radio)
    {
      make_pixmap_from_data (parent, radio0_xpm, &radio0);
      make_pixmap_from_data (parent, radio1_xpm, &radio1);
      first_radio = 0;
    }

  n = 0;
  XtSetArg (args[n], XtNlabel, "");
  n++;

  XtSetArg (args[n], XtNhighlightThickness, 0);
  n++;
  XtSetArg (args[n], XtNborderWidth, 0);
  n++;
  XtSetArg (args[n], XtNinternalHeight, 0);
  n++;
  XtSetArg (args[n], XtNinternalWidth, 0);
  n++;
  if (group != NULL)
    {
      XtSetArg (args[n], XtNradioGroup, group);
      n++;
      XtSetArg (args[n], XtNbitmap, radio0);
      n++;
    }
  else
    {
      XtSetArg (args[n], XtNstate, True);
      n++;
      XtSetArg (args[n], XtNbitmap, radio1);
      n++;
    }
  button = XtCreateManagedWidget (name, toggleWidgetClass, parent, args, n);

  XtAddCallback (button, XtNcallback, changeradio, NULL);

  if (ftccallback != NULL)
    XtAddCallback (button, XtNcallback, ftccallback, param);
  return button;
}
