/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef WORKSHEET_VB_H
#define WORKSHEET_VB_H
#include "worksheet.h"
#include "class.h"

extern obj vb_getworksheet (int narg, obj * arg);

extern obj vb_get_Worksheets ();
extern obj vb_get_ActiveWorksheet ();

extern obj vb_worksheet_setname (int narg, obj * arg);
extern obj vb_worksheet_getname (int narg, obj * arg);
extern obj vb_worksheet_activate (int narg, obj * arg);
extern obj vb_worksheet_calculate (int narg, obj * arg);
extern obj vb_worksheet_copy (int narg, obj * arg);
extern obj vb_worksheet_delete (int narg, obj * arg);
extern obj vb_worksheet_move (int narg, obj * arg);
extern obj vb_worksheet_paste (int narg, obj * arg);
extern obj vb_worksheet_printout (int narg, obj * arg);
extern obj vb_worksheet_getcell (int narg, obj * arg);
extern obj vb_worksheet_getchart (int narg, obj * arg);

extern obj vb_shapes_add (int narg, obj * arg);

extern obj vb_worksheets_setcount (int narg, obj * arg);
extern obj vb_worksheets_getcount (int narg, obj * arg);
extern obj vb_worksheets_add (int narg, obj * arg);
extern obj vb_worksheets_item (int narg, obj * arg);
extern obj vb_worksheets_remove (int narg, obj * arg);

static Memberdata Worksheetsdata[] = {
  {"Count", INTEGER, &vb_worksheets_setcount, &vb_worksheets_getcount},
  {NULL, 0, NULL, NULL}
};

static Fct Worksheetsfct[] = {
  {"Item", &vb_worksheets_item, WORKSHEET, 0},
  {"Add", &vb_worksheets_add, WORKSHEET, 0},
  {"Remove", &vb_worksheets_remove, INTEGER, 0},
  {NULL, NULL, 0, 0}
};

static Memberdata Worksheetdata[] = {
  {"name", STRING, &vb_worksheet_setname, &vb_worksheet_getname},
  {"ChartObjects", OBJECT, NULL, NULL},
  {"Shapes", OBJECT, NULL, NULL},
  {"Buttons", OBJECT, NULL, NULL},
  {NULL, 0, NULL, NULL}
};

static Fct Worksheetfct[] = {
  {"Activate", &vb_worksheet_activate, WORKSHEET, 0},
  {"Calculate", &vb_worksheet_calculate, INTEGER, 0},
  {"Copy", &vb_worksheet_copy, INTEGER, 2},
  {"Delete", &vb_worksheet_delete, INTEGER, 0},
  {"Move", &vb_worksheet_move, INTEGER, 2},
  {"Paste", &vb_worksheet_paste, INTEGER, 2},
  {"PrintOut", &vb_worksheet_printout, INTEGER, 0},
  {"Cells", &vb_worksheet_getcell, CELL, 2},
  {"ChartObjects", &vb_worksheet_getchart, CHARTOBJECT, 2},
  {NULL, NULL, 0, 0}
};

static Memberdata Shapesdata[] = {
  {NULL, 0, NULL, NULL}
};

static Fct Shapesfct[] = {
  {"AddShape", &vb_shapes_add, 5, INTEGER_CONSTANT},
  {"AddLine", &vb_shapes_add, 4, INTEGER_CONSTANT},
  {NULL, NULL, 0, 0}
};

#endif
