/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef RANGE_VB_H
#define RANGE_VB_H
#include "range.h"
#include "class.h"

#include "main.h"

extern obj vb_getrange (int narg, obj * arg);

extern obj vb_range_setvalue (int narg, obj * arg);
extern obj vb_range_getvalue (int narg, obj * arg);
extern obj vb_range_setobj (int narg, obj * arg);
extern obj vb_range_getobj (int narg, obj * arg);
extern obj vb_range_assign (int narg, obj * arg);

extern obj vb_range_select (int narg, obj * arg);
extern obj vb_range_print (int narg, obj * arg);

static Memberdata Rangedata[] = {
  {"castobj", VARIANT, &vb_range_setobj, &vb_range_getobj},
  {"value", VARIANT, &vb_range_setvalue, &vb_range_getvalue},
  {NULL, 0, NULL, NULL}
};

static Fct Rangefct[] = {
  {"=", &vb_range_assign, RANGEN, 2},
  {"select", &vb_range_select, 0, 1},
  {"PrintOut", &vb_range_print, 0, 1},
  {NULL, NULL, 0, 0}
};

#endif
