/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "chart_vb.h"
#include "application.h"
#include "libfct.h"

obj vb_get_tempchartobjects (int narg, obj * arg)
{
  obj o;
  o.type = CHARTOBJECTS;
  o.label = arrayclass[CHARTOBJECTS].name;
  o.rec.s = (char *) ActiveWorksheet;
  return o;
}

obj vb_chartobjects_add (int narg, obj * arg)
{
  obj o;
  int coord[4];
  Worksheet *w;

  o = arg[0];

  if (o.type == MEMBER)
    {
      obj *workobj = (obj *) o.rec.s;
      w = (Worksheet *) workobj->rec.s;
    }
  else
    w = ActiveWorksheet;

  if (narg == 5)
    {
      coord[0] = obj2int (arg[1]);
      coord[1] = obj2int (arg[2]);
      coord[2] = obj2int (arg[3]);
      coord[3] = obj2int (arg[4]);
    }

  o.type = CHARTOBJECT;
  o.label = arrayclass[CHARTOBJECT].name;
  o.rec.s = (char *) worksheet_addchart (w, coord, narg - 1);
  return o;
}

obj vb_chartobjects_delete (int narg, obj * arg)
{
  obj o;
  return o;
}

obj vb_chartobject_activate (int narg, obj * arg)
{
  obj o;
  o.type = CHARTOBJECT;
  o.label = arrayclass[CHARTOBJECT].name;
  o.rec.s = (char *) arg[0].rec.s;
  ActivateGraph ((Graph *) arg[0].rec.s);
  return o;
}

obj vb_chartobject_getchart (int narg, obj * arg)
{
  obj o;

  o.type = CHART;
  o.label = arrayclass[CHART].name;
  o.rec.s = arg[0].rec.s;
  return o;
}

obj vb_chartobject_setchart (int narg, obj * arg)
{
  obj o;

  return o;
}

obj vb_get_ActiveChart ()
{
  obj o;
  o.rec.s = (char *) ActiveGraph;
  o.type = CHART;
  o.label = arrayclass[CHART].name;
  return o;
}

obj vb_chart_getaxis (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  obj *chart = (obj *) arg[0].rec.s;
  o.rec.s = (char *) graph_getaxis ((Graph *) chart, obj2int (arg[1]));
  o.label = arrayclass[AXIS].name;
  o.type = AXIS;
  return o;
}

obj vb_chart_gettitle (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  Graph *gr = (Graph *) arg[0].rec.s;

  o.type = TITLE;
  o.label = arrayclass[TITLE].name;
  o.rec.s = (char *) &(gr->ChartTitle);
  return o;
}

obj vb_chart_settitle (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;

  return o;
}

obj vb_chart_setmaximumscale (int narg, obj * arg)
{
  obj o;
  int i;
  for (i = 0; i < narg; i++)
    printobj (arg[i]);

  return o;
}

obj vb_chart_getmaximumscale (int narg, obj * arg)
{
  obj o;

  return o;
}

obj vb_chart_setminimumscale (int narg, obj * arg)
{
  obj o;

  return o;
}

obj vb_chart_getminimumscale (int narg, obj * arg)
{
  obj o;

  return o;
}

obj vb_chart_setmajorunit (int narg, obj * arg)
{
  obj o;

  return o;
}

obj vb_chart_getmajorunit (int narg, obj * arg)
{
  obj o;

  return o;
}

obj vb_seriescollection_newserie (int narg, obj * arg)
{
  obj o;

  return o;
}

obj vb_chart_getserie (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  Graph *gr = (Graph *) arg[0].rec.s;
  int i = obj2int (arg[1]);

  o.type = SERIE;
  o.label = arrayclass[SERIE].name;
  o.rec.s = (char *) &(gr->SeriesCollections[i]);

  return o;
}

obj vb_serie_setxvalues (int narg, obj * arg)
{
  obj o;

  obj *xvalues = (obj *) arg[0].rec.s;
  Serie *serie = (Serie *) xvalues->rec.s;
  obj range = arg[1];

  if (range.type == STRING || range.type == RANGE
      || range.type == STRING_CONSTANT)
    {
      char *values = obj2string (arg[1]);
      o.rec.i = graph_setserievalues ((Graph *) serie->gr, 0, values);
    }
  else if (range.type == RANGEN)
    {
      Range *ran = (Range *) range.rec.s;
      o.rec.i = graph_setserierange ((Graph *) serie->gr, 0, ran);
    }

  o.type = INTEGER;
  o.label = NULL;
  return o;
}

obj vb_serie_getxvalues (int narg, obj * arg)
{
  obj o;

  return o;
}

obj vb_serie_setname (int narg, obj * arg)
{
  obj o;

  obj *seriename = (obj *) arg[0].rec.s;
  Serie *serie = (Serie *) seriename->rec.s;
  char *name = obj2string (arg[1]);
  o.rec.i = graph_setseriename ((Graph *) serie->gr, serie->num, name);
  o.type = INTEGER;
  o.label = NULL;
  return o;
}

obj vb_serie_getname (int narg, obj * arg)
{
  obj o;

  return o;
}

obj vb_serie_setvalues (int narg, obj * arg)
{
  obj o;

  obj *serievalues = (obj *) arg[0].rec.s;
  Serie *serie = (Serie *) serievalues->rec.s;
  obj range = arg[1];

  if (range.type == STRING || range.type == RANGE
      || range.type == STRING_CONSTANT)
    {
      char *values = obj2string (arg[1]);
      o.rec.i =
	graph_setserievalues ((Graph *) serie->gr, serie->num, values);
    }
  else if (range.type == RANGEN)
    {
      Range *ran = (Range *) range.rec.s;
      o.rec.i = graph_setserierange ((Graph *) serie->gr, serie->num, ran);
    }
  o.type = INTEGER;
  o.label = NULL;
  return o;
}

obj vb_serie_getvalues (int narg, obj * arg)
{
  obj o;

  return o;
}

obj vb_chart_sethastitle (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o = arg[0];

  return o;
}

obj vb_chart_gethastitle (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;

  return o;
}

obj vb_chart_setcharttype (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  obj *chart = (obj *) arg[0].rec.s;
  graph_settype ((Graph *) chart->rec.s, obj2int (arg[1]));
  return o;
}

obj vb_chart_getcharttype (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;

  return o;
}
