/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "button_vb.h"
#include "application.h"
#include "libfct.h"

obj vb_buttons_add (int narg, obj * arg)
{
  obj o;
  int coord[4];
  Worksheet *w;

  o = arg[0];

  if (o.type == MEMBER)
    {
      obj *workobj = (obj *) o.rec.s;
      w = (Worksheet *) workobj->rec.s;
    }
  else
    w = ActiveWorksheet;

  if (narg == 5)
    {
      coord[0] = obj2int (arg[1]);
      coord[1] = obj2int (arg[2]);
      coord[2] = obj2int (arg[3]);
      coord[3] = obj2int (arg[4]);
    }

  o.type = BUTTON;
  o.label = arrayclass[BUTTON].name;
  o.rec.s = (char *) worksheet_addbutton (w, coord, narg - 1);
  return o;
}

obj vb_button_getonaction (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  return o;
}

obj vb_button_setonaction (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  obj *base = (obj *) arg[0].rec.s;
  Button *btn = (Button *) base->rec.s;
  o.rec.i = button_setmacro (btn, obj2string (arg[1]));
  o.type = INTEGER;
  o.label = NULL;
  return o;
}

obj vb_button_gettext (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  return o;
}

obj vb_button_settext (narg, arg)
     int
       narg;
     obj *
       arg;
{
  obj o;
  obj *base = (obj *) arg[0].rec.s;
  Button *btn = (Button *) base->rec.s;
  o.rec.i = button_setlabel (btn, obj2string (arg[1]));
  o.type = INTEGER;
  o.label = NULL;
  return o;
}
