/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef WORKBOOK_H
#define WORKBOOK_H
#include "worksheet.h"
#include "project.h"

struct _Workbook
{
  Worksheet **Worksheets;
  int nbworksheet;
  Worksheet *activeworksheet;
  Style *style;
  int objnum;
  Project *project;
  char *name;
  int first_vis_wks;
};

typedef struct _Workbook Workbook;

extern Workbook *ActiveWorkbook;

extern Workbook *newworkbook ();
extern Workbook *newworkbook1 (int nbworksheet);
extern int freeworkbook ();

extern Workbook *workbook_open (char *filename);
extern int workbook_save (Workbook * doc, char *filename);

extern Workbook *ActivateWorkbook (Workbook * wb);
extern Worksheet *workbook_getsheet (Workbook * wb, char *name);
extern Worksheet *workbook_getsheet2 (Workbook * wb, int num);

extern Worksheet *workbook_addsheet (Workbook * wb, char *name);
extern Worksheet *workbook_delsheet (Workbook * wb, int num);
extern Worksheet *workbook_delactivesheet (Workbook * wb);

extern int workbook_setnormalstyle (Workbook * workbook);
extern int workbook_calculate (Workbook * workbook);

#endif
