/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "title.h"
#include "stdlib.h"
#include "memory.h"
#include <stdio.h>

int
title_settext (Title * t, char *buf)
{
  if (buf == NULL)
    return 1;
  if (strlen (buf) < 1)
    return 2;
  if (t == NULL)
    return 3;
  t->Text = (char *) absmalloc (strlen (buf) + 1, "title_settext:t->Text ");
  strcpy (t->Text, buf);
  return 0;
}

int
title_copy (t1, t2)
     Title *t1;
     Title *t2;
{
  if (t2 == NULL || t1 == NULL || (t1 == t2))
    return 1;

  if (t2->Text == NULL)
    {
      absfree (t1->Text, "title_copy:t1->Text");
      t1->Text = NULL;
      return 2;
    }
  if (strlen (t2->Text) < 1)
    {
      sprintf (t1->Text, " ");
      return 0;
    };

  t1->Text =
    (char *) absrealloc (t1->Text, strlen (t2->Text) + 1,
			 "title_copy:t1->Text");
  strcpy (t1->Text, t2->Text);

  return 0;
}

char *
title_gettext (Title t)
{
  return t.Text;
}

int
title_free (Title * t)
{
  if (t == NULL)
    return 1;
  absfree (t->Text, "title_free:t->Text ");
  t->Text = NULL;
  return 0;
}
