/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef RANGE_H
#define RANGE_H
#include "stdio.h"

typedef struct
{
  int r1, c1, r2, c2;
}
Plage;

struct _Range
{
  Plage *plage;
  int nplage;
};

typedef struct _Range Range;

extern Range *newrange (char *str);
extern Range *newrange2 (int r1, int c1, int r2, int c2);
extern int freerange (Range * ran);
extern int clearrange (Range * ran);
extern int printrange (Range * ran);
extern Range *addrange (Range * ran, char *str);
extern Range *addrange2 (Range * ran, int r1, int c1, int r2, int c2);
extern Range *modrange (Range * ran, char *str);
extern Range *modrange2 (Range * ran, int r1, int c1, int r2, int c2);
extern Range *range_copy (Range * copy, Range * org);

#endif
