/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "graph.h"
#include "memory.h"
#include "main.h"
#include "worksheet.h"

Graph *ActiveGraph;

static int ngraph = 1;

Graph *
newgraph ()
{
  int i;
  Graph *graph;
  graph = (Graph *) absmalloc (sizeof (Graph), "newgraph:graph ");

  graph->zoom = 100;
  graph->x = 10;
  graph->y = 10;
  graph->h = 100;
  graph->w = 300;
  graph->numrange = 0;
  graph->type = 0;
  graph->graphic_grid = grboth;
  graph->axe_cat_grid = 0;
  graph->axe_val_grid = 0;

  graph->Axes[xlCategory].HasMajorGridLines = 0;
  graph->Axes[xlCategory].MinimumScaleIsAuto = True;
  graph->Axes[xlCategory].MaximumScaleIsAuto = True;
  graph->Axes[xlCategory].MajorUnitIsAuto = True;
  graph->Axes[xlCategory].HasTitle = True;
  title_settext (&graph->Axes[xlCategory].AxisTitle, "'X axis");

  graph->Axes[xlValue].HasMajorGridLines = 0;
  graph->Axes[xlValue].MinimumScaleIsAuto = True;
  graph->Axes[xlValue].MaximumScaleIsAuto = True;
  graph->Axes[xlValue].MajorUnitIsAuto = True;
  graph->Axes[xlValue].HasTitle = True;
  title_settext (&graph->Axes[xlValue].AxisTitle, "'Y axis");

  for (i = 0; i < 10; i++)
    {
      sprintf ((graph->range[i]).name, "'Data%d", i);
      graph->graphic_format[i] = grboth;
      graph->SeriesCollections[i].gr = graph;
      graph->SeriesCollections[i].num = i;
    }

  graph->HasTitle = True;
  title_settext (&graph->ChartTitle, "'title");

  sprintf ((graph->range[0]).name, "'X axis");

  graph->objnum = ngraph++;

  graph->worksheet = NULL;
  graph->pixmap = 0;

  return graph;
}

Graph *
newgraph1 (gr)
     Graph *gr;
{
  Graph *graph = newgraph ();
  graph_copy (graph, gr);
  graph->objnum = ngraph++;
  return graph;
}

int
graph_copy (graph, gr)
     Graph *graph;
     Graph *gr;
{
  int i;
  if (graph == NULL || gr == NULL || (gr == graph))
    return 1;

  graph->zoom = gr->zoom;
  graph->x = gr->x;
  graph->y = gr->y;
  graph->h = gr->h;
  graph->w = gr->w;
  graph->numrange = gr->numrange;
  graph->type = gr->type;
  graph->graphic_grid = gr->graphic_grid;
  graph->axe_cat_grid = gr->axe_cat_grid;
  graph->Axes[xlCategory].HasMajorGridLines =
    gr->Axes[xlCategory].HasMajorGridLines;
  graph->Axes[xlCategory].MinimumScaleIsAuto =
    gr->Axes[xlCategory].MinimumScaleIsAuto;
  graph->Axes[xlCategory].MajorUnitIsAuto =
    gr->Axes[xlCategory].MajorUnitIsAuto;
  graph->Axes[xlCategory].HasTitle = gr->Axes[xlCategory].HasTitle;

  graph->Axes[xlValue].HasMajorGridLines =
    gr->Axes[xlValue].HasMajorGridLines;
  graph->Axes[xlValue].MinimumScaleIsAuto =
    gr->Axes[xlValue].MinimumScaleIsAuto;
  graph->Axes[xlValue].MajorUnitIsAuto = gr->Axes[xlValue].MajorUnitIsAuto;
  graph->Axes[xlValue].HasTitle = gr->Axes[xlValue].HasTitle;

  for (i = 0; i < 10; i++)
    {
      graph->range[i].i1 = gr->range[i].i1;
      graph->range[i].j1 = gr->range[i].j1;
      graph->range[i].i2 = gr->range[i].i2;
      graph->range[i].j2 = gr->range[i].j2;
      strcpy ((graph->range[i]).name, (gr->range[i]).name);
      graph->graphic_format[i] = gr->graphic_format[i];
      graph->SeriesCollections[i].gr = (char *) graph;
      graph->SeriesCollections[i].num = i;
    }

  graph->HasTitle = gr->HasTitle;

  return 0;
}

static int infreegraph = 0;

int
freegraph (gr)
     Graph *gr;
{
  if (infreegraph)
    return 0;
  infreegraph = 1;
  if (gr == NULL)
    {
      infreegraph = 0;
      return -1;
    }
  title_free (&gr->ChartTitle);
  title_free (&gr->Axes[xlCategory].AxisTitle);
  title_free (&gr->Axes[xlValue].AxisTitle);

  if (gr->worksheet != NULL)
    worksheet_delgraph (gr->worksheet, gr);
  absfree (gr, "freegraph:gr ");
  infreegraph = 0;
  return 0;
}

int
graph_write (Graph * gr, FILE * fp)
{
  char i1j1[16];
  char i2j2[16];
  int j;
  char *type;
  switch (gr->type)
    {
    case 0:
      type = "xlLine";
      break;
    case 1:
      type = "xlPie";
      break;
    case 2:
      type = "xlbarClustered";
      break;
    }

  fprintf (fp,
	   "Set objchart = ActiveWorksheet.ChartObjects.Add (%d,%d,%d,%d)\n",
	   gr->x, gr->y, gr->w, gr->h);
  fprintf (fp, "objchart.Activate\n");
  fprintf (fp, "ActiveChart.ChartType = %s\n", type);

  fprintf (fp, "ActiveChart.SeriesCollection.NewSerie\n");
  numtoalpha (i1j1, (gr->range[0]).i1, (gr->range[0]).j1);
  numtoalpha (i2j2, (gr->range[0]).i2, (gr->range[0]).j2);
  fprintf (fp, "ActiveChart.SeriesCollection(1).XValues = Range(\"%s:%s\")\n",
	   i1j1, i2j2);

  for (j = 1; j < gr->numrange; j++)
    {
      numtoalpha (i1j1, (gr->range[j]).i1, (gr->range[j]).j1);
      numtoalpha (i2j2, (gr->range[j]).i2, (gr->range[j]).j2);
      fprintf (fp, "ActiveChart.SeriesCollection(%d).Name = \"%s\"\n", j,
	       (gr->range[j]).name);
      fprintf (fp,
	       "ActiveChart.SeriesCollection(%d).Values = Range(\"%s:%s\")\n",
	       j, i1j1, i2j2);
    }

  if (gr->HasTitle)
    {
      fprintf (fp, "ActiveChart.HasTitle = True\n");
      fprintf (fp, "ActiveChart.ChartTitle.Text = \"%s\"\n",
	       gr->ChartTitle.Text);
    }

  if (gr->Axes[xlCategory].HasMajorGridLines)
    fprintf (fp, "ActiveChart.Axes(xlCategory).HasMajorGridlines = True\n");

  if (gr->Axes[xlCategory].HasTitle)
    {
      fprintf (fp, "ActiveChart.Axes(xlCategory).HasTitle = True\n");
      fprintf (fp, "ActiveChart.Axes(xlCategory).AxisTitle.Text = \"%s\"\n",
	       gr->Axes[xlCategory].AxisTitle.Text);
    }

  if (gr->Axes[xlValue].HasMajorGridLines)
    fprintf (fp, "ActiveChart.Axes(xlValue).HasMajorGridlines = True\n");

  if (gr->Axes[xlValue].HasTitle)
    {
      fprintf (fp, "ActiveChart.Axes(xlValue   ).HasTitle = True\n");
      fprintf (fp, "ActiveChart.Axes(xlValue   ).AxisTitle.Text = \"%s\"\n",
	       gr->Axes[xlValue].AxisTitle.Text);
    }
  if (!gr->Axes[xlValue].MinimumScaleIsAuto)
    {
      fprintf (fp, "ActiveChart.MinimumScale(xlValue   ) = %f\n",
	       gr->Axes[xlValue].MinimumScale);
    }
  if (!gr->Axes[xlValue].MaximumScaleIsAuto)
    {
      fprintf (fp, "ActiveChart.MaximumScale(xlValue   ) = %f\n",
	       gr->Axes[xlValue].MaximumScale);
    }
  if (!gr->Axes[xlValue].MajorUnitIsAuto)
    {
      fprintf (fp, "ActiveChart.MajorUnit(xlValue   ) = %f\n",
	       gr->Axes[xlValue].MajorUnit);
    }

  if (!gr->Axes[xlCategory].MinimumScaleIsAuto)
    {
      fprintf (fp, "ActiveChart.MinimumScale(xlCategory   ) = %f\n",
	       gr->Axes[xlCategory].MinimumScale);
    }
  if (!gr->Axes[xlCategory].MaximumScaleIsAuto)
    {
      fprintf (fp, "ActiveChart.MaximumScale(xlCategory   ) = %f\n",
	       gr->Axes[xlCategory].MaximumScale);
    }
  if (!gr->Axes[xlCategory].MajorUnitIsAuto)
    {
      fprintf (fp, "ActiveChart.MajorUnit(xlCategory   ) = %f\n",
	       gr->Axes[xlCategory].MajorUnit);
    }

  return 0;
}

Graph *
ActivateGraph (graph)
     Graph *graph;
{
  ActiveGraph = graph;

  return ActiveGraph;
}

int
graph_settype (graph, type)
     Graph *graph;
     int type;
{

  if (graph != NULL);
  graph->type = type;
  return 0;
}

int
graph_setseriename (graph, serie, name)
     Graph *graph;
     int serie;
     char *name;
{
  if (graph != NULL);
  sprintf ((graph->range[serie]).name, "%s", name);
  return 0;
}

int
graph_setserievalues (gr, serie, valuerange)
     Graph *gr;
     int serie;
     char *valuerange;
{

  char *i1j1;
  char *i2j2;
  char *separ;
  if (serie < 0 || serie >= 10)
    return 1;
  if (gr == NULL)
    return 2;

  if (serie > gr->numrange)
    gr->numrange = serie;

  if (valuerange[0] == '=')
    valuerange++;

  separ = strchr (valuerange, ':');
  i1j1 = valuerange;
  i2j2 = separ + 1;
  separ[0] = '\0';

  alphatonum (i1j1, &(gr->range[serie]).i1, &(gr->range[serie]).j1);
  alphatonum (i2j2, &(gr->range[serie]).i2, &(gr->range[serie]).j2);

  if (serie + 1 > gr->numrange)
    gr->numrange = serie + 1;

  return 0;
}

int
graph_setserierange (Graph * gr, int serie, Range * range)
{
  if (serie < 0 || serie >= 10)
    return 1;
  if (gr == NULL)
    return 2;
  if (range == NULL)
    return 3;
  if (range->nplage < 1)
    return 4;

  if (serie > gr->numrange)
    gr->numrange = serie;

  gr->range[serie].i1 = range->plage[0].r1;
  gr->range[serie].j1 = range->plage[0].c1;
  gr->range[serie].i2 = range->plage[0].r2;
  gr->range[serie].j2 = range->plage[0].c2;

  if (serie + 1 > gr->numrange)
    gr->numrange = serie + 1;

  return 0;
}

int
graph_setgrid (gr, axe, on)
     Graph *gr;
     int axe;
     int on;
{
  if (gr == NULL)
    return 1;
  if (axe == 1)
    gr->Axes[xlCategory].HasMajorGridLines = on;
  if (axe == 2)
    gr->Axes[xlValue].HasMajorGridLines = on;
  return 0;
}

int
graph_setaxistitle (gr, axe, buf)
     Graph *gr;
     int axe;
     char *buf;
{
  if (gr == NULL)
    return 1;
  if (axe == 1)
    title_settext (&gr->Axes[xlCategory].AxisTitle, buf);
  if (axe == 2)
    title_settext (&gr->Axes[xlValue].AxisTitle, buf);
  return 0;
}

Axis *
graph_getaxis (Graph * gr, int axe)
{
  if (gr == NULL)
    return NULL;
  if (axe == 1)
    return &(gr->Axes[xlCategory]);
  if (axe == 2)
    return &(gr->Axes[xlValue]);
  return &(gr->Axes[xlValue]);
}
