/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef DRAW_H
#define DRAW_H

#include "style.h"

#include "stdio.h"

typedef struct
{
  int x1;
  int y1;
  int x2;
  int y2;
  int type;
  struct Style *style;
  struct _Worksheet *worksheet;
}
Drawing;

extern Drawing *ActiveDrawing;

extern Drawing *newdrawing ();
extern Drawing *newdrawing1 (Drawing *);
extern int freedrawing (Drawing *);
extern Drawing *drawing_read (FILE * fp);
extern int drawing_write (Drawing * drawing, FILE * fp);
extern int drawing_copy (Drawing * drawing1, Drawing * drawing2);

extern int drawing_pointed (Drawing * drawing, int x, int y, int dx, int dy);
extern Drawing *ActivateDrawing (Drawing * drawing);

#endif
