/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef CELL_H
#define CELL_H
#include "style.h"
#include <stdio.h>
#include "object.h"
#include "node.h"

struct _Cell;
struct _Worksheet;

struct _Familly
{
  struct _Cell **parentlist;
  struct _Cell **childlist;
  int numpar;
  int numchi;
  int dimparlist;
  int dimchilist;
};

typedef struct _Familly Familly;

struct _Cell
{
  obj val;
  char *formula;
  int is_text;
  int r, c;
  Style *style;
  Familly *familly;
  struct _Worksheet *worksheet;
  int objnum;
  nodeType *tree;
};

typedef struct _Cell Cell;

extern Cell *currentcell;
extern Cell *ActiveCell;

extern Cell *cell_activate (Cell * cell);

extern Cell *newcell (int r, int c);
extern int freecell (Cell * cell);
extern int clear_cell (Cell * cell);
extern int cell_write (Cell * cell, FILE * fp);

extern int cell_setnumberformat (Cell * cell, char *buf);
extern int cell_setformula (Cell * cell, char *buf);
extern int cell_settext (Cell * cell, char *buf);
extern char *cell_getformula (Cell * cell);
extern char *cell_getnumberformat (Cell * cell);
extern char *cell_gettext (Cell * cell);
extern int cell_istext (Cell * cell);
extern double cell_getvalue (Cell * cell);
extern obj cell_getobj (Cell * cell);
extern double cell_setvalue (Cell * cell, double val);
extern obj cell_setobj (Cell * cell, obj o);
extern obj cell_setresval (Cell * cell, obj o);
extern double cell_setvalue2 (double val);

extern int cell_setborders (Cell * cell, int border, int type);
extern int cell_setfg (Cell * cell, int f);
extern int cell_getfg (Cell * cell);
extern int cell_setbg (Cell * cell, int f);
extern int cell_getbg (Cell * cell);

extern int cell_gettop (Cell * cell);
extern int cell_getbot (Cell * cell);
extern int cell_getrig (Cell * cell);
extern int cell_getlef (Cell * cell);
extern int cell_settop (Cell * cell, int f);
extern int cell_setbot (Cell * cell, int f);
extern int cell_setrig (Cell * cell, int f);
extern int cell_setlef (Cell * cell, int f);

extern int cell_setformat (Cell * cell, int format, int deci);
extern int cell_getformat (Cell * cell, int *format, int *deci);
extern int cell_setjust (Cell * cell, int j);
extern int cell_getjust (Cell * cell);
extern int cell_setfont (Cell * cell, int f, int w, int s);
extern int cell_getfont (Cell * cell);
extern int cell_getfontw (Cell * cell);
extern int cell_getfonts (Cell * cell);
extern int cell_fontname (Cell * cell, char *name);
extern int cell_fontsize (Cell * cell, int v);
extern int cell_fontbold (Cell * cell, int v);
extern int cell_fontitalic (Cell * cell, int v);

extern int cell_setborders (Cell * cell, int border, int type);
extern int cell_setborder (Cell * cell, int border);
extern int cell_getborder (Cell * cell);

extern int cell_isnew (Cell * cell);
extern int cell1isfcell2 (Cell * cell1, Cell * cell2);
extern int nupdate2 (Cell * cell, int redraw);

extern int StringInput ();
extern int macroparsing (char *buf);
extern char *textparsing (char *buf);

extern int copymod (int ii, int jj, int i, int j, int incr);
extern int copymod2 (Cell * cell1, Cell * cell2, int curi, int curj, int di,
		     int dj);
extern int copymod3 (Cell * cell1, Cell * cell2, int incr);

extern Cell *cell_cpy (Cell * cell1, Cell * cell2);
extern Cell *cell_stycpy (Cell * cell1, Cell * cell2);

extern int parsecell (Cell * cell);

int cell_chgwksname (Cell * cell, char *oldname, char *newname);
int cell_calculate (Cell * cell);

int cell_print (Cell * cell);
#endif
