/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef BUTTON_H
#define BUTTON_H
#include "stdio.h"

typedef struct
{
  int x1;
  int y1;
  int x2;
  int y2;
  char *label;
  char *macro;
}
Button;

extern Button *ActiveButton;

extern Button *newbutton ();
extern int freebutton (Button *);
extern int button_write (Button * button, FILE * fp);
extern int button_setlabel (Button * button, char *label);
extern char *button_getlabel (Button * button);
extern int button_setmacro (Button * button, char *macro);
extern char *button_getmacro (Button * button);

extern int button_click (Button * btn);

extern int button_pointed (Button * button, int x, int y, int dx, int dy);
extern Button *ActivateButton (Button * button);

#endif
