/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef APPLICATION_H
#define APPLICATION_H

#include <X11/Intrinsic.h>

#include "workbook.h"

#include "graph.h"
#include "draw.h"
#include "button.h"
#include "cell.h"

extern int application_quit ();
extern int application_calculate ();
extern int application_nbwb ();
extern Workbook *application_getworkbook (int i);
extern Workbook *application_addworkbook ();
extern Workbook *new_doc (char *filename);
extern int close_doc ();
extern int activate_doc (int n);
extern int application_changesheet (int sheet);
extern int Activate_workbook2 (char *filename);
extern void openfile (char *filename);
extern void savefile ();
extern void saveasfile (char *filename);
extern int init_application ();
extern Cell *applicationcell (int i, int j, int new);
extern Cell *applicationwkscell (char *wksname, int i, int j, int new);
extern char *get_text (int i, int j);
extern double get_value (int i, int j);
extern double get_value_wks (Worksheet * wks, int i, int j);
extern obj get_ovalue (int i, int j);
extern obj get_ovalue_wks (Worksheet * wks, int i, int j);
extern int set_value (int i, int j, double x);
extern int set_formula (int i, int j, char *buf);
extern int set_text (int i, int j, char *buf);
extern char *get_formula (int i, int j);
extern int set_fg (int i, int j, int f);
extern int get_fg (int i, int j);
extern int set_bg (int i, int j, int f);
extern int get_bg (int i, int j);
extern int set_format (int i, int j, int f, int l);
extern int get_format (int i, int j, int *f, int *l);
extern int set_border (int i, int j, int f);
extern int get_border (int i, int j);
extern int set_just (int i, int j, int f);
extern int get_just (int i, int j);
extern int set_font (int i, int j, int f, int g, int h);
extern int get_font (int i, int j);
extern int get_fonts (int i, int j);
extern int get_fontw (int i, int j);

extern Graph *newgra ();
extern Graph *getlastgra ();
extern int getnumgra ();
extern int setactivegra (int n);
extern Graph *getgra (int n);
extern int getactivegra ();
extern void getrange (int serie, char *buf, char *name);
extern void setrange (int serie, char *buf, char *name);
extern void setgraphtype (int type);
extern int gettype ();
extern int setgridh (Boolean on);
extern int setgridv (Boolean on);
extern void settitre1 (char *titre);
extern char *gettitre1 ();
extern void setXaxis (char *titre);
extern char *getXaxis ();
extern void setYaxis (char *titre);
extern char *getYaxis ();

extern int copygra ();
extern int cutgra ();
extern int pastegra ();

extern Drawing *newdra ();
extern Drawing *getlastdra ();
extern int getnumdra ();
extern int setactivedra (int n);
extern Drawing *getdra (int n);
extern int getactivedra ();

extern int copydra ();
extern int cutdra ();
extern int pastedra ();

extern Button *newbtn ();
extern Button *getlastbtn ();
extern int getnumbtn ();
extern int setactivebtn (int n);
extern Button *getbtn (int n);
extern int getactivebtn ();

extern int copybtn ();
extern int cutbtn ();
extern int pastebtn ();

#endif
