/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "textfct.h"
#include "stdlib.h"
#include "string.h"
#include "y.tab.h"
#include "typedef.h"
#include "memory.h"
#include "stdio.h"

Fct textarrayfct[] = {
  {"FIXED", &vb_FIXED, 1, 1, NULL, NULL}
  ,
  {"LEFT", &vb_LEFT, 1, 1, NULL, NULL}
  ,
  {"RIGHT", &vb_RIGHT, 1, 1, NULL, NULL}
  ,
  {"MID", &vb_MID, 1, 1, NULL, NULL}
  ,
  {"CONCATENATE", &vb_CONCATENATE, 1, 1, NULL, NULL}
  ,
  {"LEN", &vb_LEN, 1, 1, NULL, NULL}
  ,
  {"INSTR", &vb_INSTR, 1, 1, NULL, NULL}
  ,
  {"RTRIM", &vb_RTRIM, 1, 1, NULL, NULL}
  ,
  {"LTRIM", &vb_LTRIM, 1, 1, NULL, NULL}
  ,
  {"TRIM", &vb_TRIM, 1, 1, NULL, NULL}
  ,
  {"VALUE", &vb_VALUE, 1, 1, NULL, NULL}
  ,
  {NULL, NULL, 0, 0, NULL, NULL}
  ,
};

obj vb_LEFT (int narg, obj * arg)
{
  obj o;
  char *str = NULL;
  int n = 0;
  o.rec.s = NULL;
  if (narg == 2)
    {
      str = obj2string (arg[0]);
      n = obj2int (arg[1]);
      if (str != NULL && n > 0)
	{
	  o.rec.s = (char *) absmalloc (n + 1, "vb_left:o.rec.s");
	  strncpy (o.rec.s, str, n);
	  o.rec.s[n] = '\0';
	}
    }
  o.type = STRING;
  return o;
}

obj vb_RIGHT (int narg, obj * arg)
{
  obj o;
  char *str = NULL;
  int n = 0;
  o.rec.s = NULL;
  if (narg == 2)
    {
      str = obj2string (arg[0]);
      n = obj2int (arg[1]);
      if (str != NULL && n > 0)
	{
	  int len = strlen (str);
	  int start = len - n;
	  if (start < 0)
	    start = 0;
	  o.rec.s = (char *) absmalloc (n + 1, "vb_left:o.rec.s");
	  strncpy (o.rec.s, str + start, n);
	  o.rec.s[n] = '\0';
	}
    }
  o.type = STRING;
  return o;
}

obj vb_MID (int narg, obj * arg)
{
  obj o;
  char *str = NULL;
  int n = 0;
  int start = 0;
  o.rec.s = NULL;
  if (narg == 3)
    {
      str = obj2string (arg[0]);
      start = obj2int (arg[1]);
      n = obj2int (arg[2]);
      if (str != NULL && n > 0 && start > 0)
	{
	  int len = strlen (str);
	  if (len > 0 && start <= len)
	    o.rec.s = (char *) absmalloc (n + 1, "vb_left:o.rec.s");
	  strncpy (o.rec.s, str + start, n);
	  o.rec.s[n] = '\0';
	}
    }
  o.type = STRING;
  return o;
}

obj vb_CONCATENATE (int narg, obj * arg)
{

  obj o3;
  int len = 0;
  o3.rec.s = NULL;
  if (narg == 2)
    {
      char *str1 = obj2string (arg[0]);
      char *str2 = obj2string (arg[1]);
      if (str1 != NULL)
	len += strlen (str1);
      if (str2 != NULL)
	len += strlen (str2);
      o3.rec.s =
	(char *) absmalloc ((len + 1) * sizeof (char), "mkconcat:o3.rec.s");

      if (str1 != NULL)
	strcpy (o3.rec.s, str1);
      else
	o3.rec.s[0] = '\0';
      if (str2 != NULL)
	strcat (o3.rec.s, str2);
      o3.label = NULL;
    }
  o3.type = STRING;
  return o3;

}

obj vb_LEN (int narg, obj * arg)
{
  obj o;
  int len = 0;
  if (narg == 1)
    {
      char *str = obj2string (arg[0]);
      if (str != NULL)
	len = strlen (str);
    }
  o.rec.i = len;
  o.type = INTEGER;
  return o;
}

obj vb_INSTR (int narg, obj * arg)
{
  obj o;
  char *str1, *str2;
  int start = 0;
  int i = 0;
  int pos = 0;
  if (narg == 3)
    {
      start = obj2int (arg[0]);
      i = 1;
    }
  if (narg == 2 || narg == 3)
    {
      str1 = obj2string (arg[i]);
      str2 = obj2string (arg[i + 1]);
    }
  if (str1 != NULL && str2 != NULL)
    {
      if (strstr (str1 + start, str2) == NULL)
	{
	  pos = 0;
	}
      else
	{
	  pos = str1 + start - strstr (str1 + start, str2);
	}
    }
  o.rec.i = pos;
  o.type = INTEGER;
  return o;
}

obj vb_RTRIM (int narg, obj * arg)
{
  obj o;
  int len = 0;
  o.rec.s = NULL;
  if (narg == 1)
    {
      char *str = obj2string (arg[0]);
      if (str != NULL)
	len = strlen (str);
      while (len > 0 && str[len - 1] == ' ')
	len--;
      if (len >= 0)
	{
	  o.rec.s = absmalloc ((len + 1) * sizeof (char), "rtrim");
	  strncpy (o.rec.s, str, len);
	  o.rec.s[len] = '\0';
	}
    }
  o.type = STRING;
  return o;
}

obj vb_LTRIM (int narg, obj * arg)
{
  obj o;
  int len = 0;
  o.rec.s = NULL;
  if (narg == 1)
    {
      char *str = obj2string (arg[0]);
      if (str != NULL)
	while (str[0] == ' ' && str[0] != '\0')
	  str++;
      if (str != NULL)
	len = strlen (str);
      if (len > 0)
	{
	  o.rec.s = absmalloc ((len + 1) * sizeof (char), "rtrim");
	  strcpy (o.rec.s, str);
	}
    }
  o.type = STRING;
  return o;
}

obj vb_TRIM (int narg, obj * arg)
{
  obj o = vb_LTRIM (narg, arg);
  if (o.rec.s != NULL)
    {
      int len = strlen (o.rec.s);
      while (len > 0 && o.rec.s[len - 1] == ' ')
	len--;
      if (len >= 0)
	{
	  o.rec.s[len] = '\0';
	}
    }
  o.type = STRING;
  return o;
}

obj vb_VALUE (int narg, obj * arg)
{
  obj o;
  obj val;
  o.type = DOUBLE;
  o.rec.d = 0;
  val = arg[0];
  if (arg[0].type == CELL)
    {
      val = obj2val (arg[0]);
    }

  if (val.type == STRING_CONSTANT || val.type == STRING)
    {
      if (val.rec.s != NULL)
	{
	  sscanf (val.rec.s, "%lf", &o.rec.d);
	}
    }
  else
    {
      o.rec.d = obj2double (val);
    }

  return o;
}

obj vb_FIXED (int narg, obj * arg)
{

  obj o3;
  char result[128];
  char format[8];
  int copy = 0;
  o3.rec.s = NULL;
  switch (narg)
    {
    case 1:
      {
	sprintf (result, "%.2f", obj2double (arg[0]));
	copy = 1;
	break;
      }
    case 2:
      {
	int ndeci = obj2int (arg[1]);
	if (ndeci < 0)
	  ndeci = 0;
	if (ndeci > 50)
	  ndeci = 50;
	sprintf (format, "%%.%df", ndeci);
	sprintf (result, format, obj2double (arg[0]));
	copy = 1;
	break;
      }
    case 3:
      {
	int ndeci = obj2int (arg[1]);
	if (ndeci < 0)
	  ndeci = 0;
	if (ndeci > 50)
	  ndeci = 50;
	sprintf (format, "%%.%df", ndeci);
	sprintf (result, format, obj2double (arg[0]));
	copy = 1;
	break;
      }
    }

  if (copy)
    {
      o3.rec.s =
	(char *) absmalloc ((strlen (result) + 1) * sizeof (char),
			    "vb_FIXED:o3.rec.s");
      strcpy (o3.rec.s, result);
    }
  o3.type = STRING;
  return o3;

}
