/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#ifndef SYMBOLTABLE_H
#define SYMBOLTABLE_H

#include "string.h"
#include "stdlib.h"
#include "stdio.h"
#include "object.h"

typedef struct
{
  int nref;
  obj val;
  int protect;
}
Idval;

struct _name
{
  struct _name *next;
  char *label;
  Idval *idval;
  int type;
};

typedef struct _name name;

struct _bigitem
{
  struct _bigitem *next;
  char *label;
  int ref;
};

typedef struct _bigitem bigitem;

struct _Symboltable
{
  name **table;
};

typedef struct _Symboltable Symboltable;

extern char *biglook (const char *p, int ins);
extern Idval *look (const char *p, int ins);
extern Idval *insert (const char *s);
extern int newlocalidtable ();
extern int deletelocalidtable ();

extern Symboltable *new_symboltable ();
extern int freesymboltable (Symboltable * symboltable);
extern Symboltable *setmoduletable (Symboltable * symboltable);
extern Symboltable *setprocedurestatictable (Symboltable * symboltable);
extern int symbol_settype (int type, int new);

extern int setrefid (obj id);
extern int unsetrefid ();

extern int inittables ();
extern int initid (Idval * idval);
#endif
