/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/

#include "properties.h"
#include <stdlib.h>
#include "abv.h"
#include <string.h>

Property *properties = NULL;
static int numprop = 0;

int
property_add (char *name, int type, obj (*setfct) (), obj (*getfct) ())
{
  if (name == NULL)
    return -1;
  if (strlen (name) < 1)
    return -1;

  properties =
    (Property *) absrealloc (properties, sizeof (Property) * (2 + numprop),
			     "property_add:properties");

  properties[numprop].name = name;
  properties[numprop].type = type;
  properties[numprop].setfct = setfct;
  properties[numprop].getfct = getfct;
  numprop++;
  properties[numprop].name = NULL;
  properties[numprop].type = 0;
  properties[numprop].setfct = NULL;
  properties[numprop].getfct = NULL;

  return 0;
}

obj property2obj (obj o)
{
  obj ret;

  ret = (properties[o.rec.i].getfct) ();

  return ret;
}

obj check4property (obj o)
{
  int i = 0;
  obj ret = o;

  while (properties[i].name != NULL)
    {
      if (strcasecmp (o.label, properties[i].name) == 0)
	{
	  ret = (properties[i].getfct) ();
	}
      i++;
    }
  return ret;
}
