/********************************************************************
This file is part of the abs 0.8 distribution.  abs is a spreadsheet
with graphical user interface.

Copyright (C) 1998-2000  Andr Bertin (Andre.Bertin@pi.be) 

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version if in the same spirit as version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

Concact: abs@ping.be or abs@pi.be
         http://www.ping.be/bertin/abs.shtml
         http://www.pi.be/bertin/abs.shtml

*********************************************************************/


#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>

#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif

#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

#define YY_USE_PROTOS

#define YY_USE_CONST

#else

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif
#endif

#ifdef __TURBOC__
#pragma warn -rch
#pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

#define YY_NULL 0

#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

#define BEGIN yy_start = 1 + 2 *

#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

typedef unsigned int yy_size_t;

struct yy_buffer_state
{
  FILE *yy_input_file;

  char *yy_ch_buf;
  char *yy_buf_pos;

  yy_size_t yy_buf_size;

  int yy_n_chars;

  int yy_is_our_buffer;

  int yy_is_interactive;

  int yy_at_bol;

  int yy_fill_buffer;

  int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1

#define YY_BUFFER_EOF_PENDING 2
};

static YY_BUFFER_STATE yy_current_buffer = 0;

#define YY_CURRENT_BUFFER yy_current_buffer

static char yy_hold_char;

static int yy_n_chars;

int yyleng;

static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;
static int yy_start = 0;

static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO ((FILE * input_file));

void yy_switch_to_buffer YY_PROTO ((YY_BUFFER_STATE new_buffer));
void yy_load_buffer_state YY_PROTO ((void));
YY_BUFFER_STATE yy_create_buffer YY_PROTO ((FILE * file, int size));
void yy_delete_buffer YY_PROTO ((YY_BUFFER_STATE b));
void yy_init_buffer YY_PROTO ((YY_BUFFER_STATE b, FILE * file));
void yy_flush_buffer YY_PROTO ((YY_BUFFER_STATE b));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO ((char *base, yy_size_t size));
YY_BUFFER_STATE yy_scan_string YY_PROTO ((yyconst char *yy_str));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO ((yyconst char *bytes, int len));

static void *yy_flex_alloc YY_PROTO ((yy_size_t));
static void *yy_flex_realloc YY_PROTO ((void *, yy_size_t));
static void yy_flex_free YY_PROTO ((void *));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)

typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO ((void));
static yy_state_type yy_try_NUL_trans
YY_PROTO ((yy_state_type current_state));
static int yy_get_next_buffer YY_PROTO ((void));
static void yy_fatal_error YY_PROTO ((yyconst char msg[]));

#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 108
#define YY_END_OF_BUFFER 109
static yyconst short int yy_accept[333] = { 0,
  0, 0, 109, 107, 106, 104, 105, 88, 107, 62,
  96, 87, 107, 82, 83, 93, 92, 78, 91, 86,
  94, 68, 68, 79, 75, 97, 80, 99, 103, 84,
  95, 85, 101, 62, 62, 62, 62, 62, 62, 62,
  62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
  62, 76, 102, 77, 90, 0, 74, 0, 62, 0,
  0, 63, 72, 73, 66, 0, 68, 68, 0, 68,
  98, 89, 81, 100, 62, 62, 3, 62, 62, 62,
  62, 62, 62, 62, 62, 62, 62, 17, 62, 62,
  62, 62, 62, 62, 26, 27, 62, 62, 62, 62,

  62, 35, 62, 62, 62, 62, 62, 62, 62, 62,
  62, 62, 62, 44, 62, 62, 62, 62, 62, 62,
  70, 63, 0, 72, 72, 0, 73, 66, 66, 0,
  71, 68, 69, 64, 1, 62, 62, 62, 62, 62,
  62, 62, 62, 62, 62, 62, 62, 62, 16, 62,
  62, 62, 60, 62, 24, 62, 62, 62, 62, 62,
  40, 62, 62, 62, 62, 62, 62, 62, 62, 62,
  47, 62, 59, 62, 62, 62, 58, 42, 62, 62,
  62, 62, 62, 62, 62, 0, 72, 0, 72, 0,
  73, 66, 67, 71, 64, 64, 62, 62, 62, 62,

  62, 9, 62, 61, 11, 62, 62, 62, 15, 62,
  21, 22, 62, 23, 62, 62, 62, 30, 31, 41,
  62, 33, 62, 62, 62, 62, 62, 62, 62, 62,
  62, 50, 62, 43, 62, 62, 54, 62, 55, 62,
  0, 72, 64, 65, 62, 62, 62, 62, 8, 10,
  12, 13, 62, 62, 62, 62, 28, 62, 62, 62,
  62, 37, 62, 62, 62, 62, 62, 62, 62, 52,
  62, 56, 57, 2, 62, 6, 62, 62, 18, 62,
  62, 62, 32, 34, 36, 62, 39, 45, 46, 48,
  49, 51, 62, 62, 7, 62, 62, 62, 29, 38,

  53, 62, 14, 62, 62, 25, 62, 62, 62, 62,
  62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
  62, 62, 62, 62, 19, 62, 62, 20, 62, 4,
  5, 0
};

static yyconst int yy_ec[256] = { 0,
  1, 1, 1, 1, 1, 1, 1, 1, 2, 3,
  2, 2, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 4, 5, 6, 1, 7, 8, 9, 10, 11,
  12, 13, 14, 15, 16, 17, 18, 19, 20, 20,
  20, 20, 20, 20, 20, 20, 20, 21, 22, 23,
  24, 25, 26, 1, 32, 33, 34, 35, 36, 37,
  38, 39, 40, 41, 42, 43, 44, 45, 46, 47,
  42, 48, 49, 50, 51, 52, 53, 54, 55, 42,
  27, 28, 29, 30, 31, 1, 32, 33, 34, 35,

  36, 37, 38, 39, 40, 41, 42, 43, 44, 45,
  46, 47, 42, 48, 49, 50, 51, 52, 53, 54,
  55, 42, 56, 57, 58, 59, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,

  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1
};

static yyconst int yy_meta[60] = { 0,
  1, 1, 1, 1, 1, 1, 2, 1, 1, 3,
  1, 1, 1, 1, 1, 1, 1, 1, 4, 4,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  5, 4, 4, 4, 4, 4, 4, 2, 2, 2,
  2, 2, 4, 2, 2, 2, 2, 2, 2, 2,
  4, 2, 2, 2, 2, 1, 1, 1, 1
};

static yyconst short int yy_base[339] = { 0,
  0, 0, 410, 411, 411, 411, 411, 411, 54, 0,
  411, 411, 381, 411, 411, 411, 411, 411, 411, 42,
  411, 47, 51, 411, 411, 48, 384, 383, 411, 411,
  411, 411, 411, 29, 29, 45, 49, 54, 34, 55,
  360, 359, 368, 70, 56, 371, 69, 83, 357, 369,
  87, 411, 411, 411, 411, 100, 411, 397, 0, 83,
  121, 0, 94, 113, 119, 126, 348, 355, 131, 140,
  411, 411, 411, 411, 362, 349, 0, 357, 349, 347,
  121, 98, 346, 346, 342, 339, 344, 336, 352, 336,
  349, 343, 334, 336, 0, 111, 98, 345, 325, 337,

  98, 0, 327, 336, 342, 329, 129, 328, 338, 142,
  338, 337, 333, 0, 318, 319, 321, 325, 314, 323,
  411, 0, 161, 411, 165, 173, 411, 311, 318, 133,
  175, 411, 411, 145, 0, 324, 319, 326, 314, 320,
  319, 322, 310, 316, 302, 301, 301, 312, 0, 314,
  307, 309, 313, 293, 0, 308, 290, 304, 301, 291,
  0, 287, 300, 290, 294, 286, 152, 289, 296, 294,
  0, 291, 0, 278, 280, 286, 0, 0, 280, 284,
  283, 287, 278, 281, 269, 179, 183, 191, 411, 193,
  195, 411, 411, 411, 267, 274, 271, 270, 266, 277,

  275, 0, 268, 0, 0, 274, 259, 272, 0, 264,
  0, 0, 260, 0, 255, 254, 265, 0, 0, 0,
  268, 0, 255, 249, 249, 266, 257, 250, 261, 251,
  253, 0, 247, 0, 248, 258, 0, 253, 0, 252,
  197, 200, 411, 411, 252, 255, 230, 252, 0, 0,
  0, 0, 238, 246, 244, 240, 0, 243, 228, 232,
  226, 0, 225, 240, 229, 222, 235, 236, 231, 0,
  223, 0, 0, 0, 221, 0, 221, 231, 0, 233,
  216, 211, 0, 0, 0, 219, 0, 0, 0, 0,
  0, 0, 200, 205, 0, 186, 184, 195, 0, 0,

  0, 208, 0, 191, 190, 0, 185, 187, 199, 187,
  186, 187, 179, 179, 190, 173, 180, 165, 155, 157,
  150, 131, 111, 93, 0, 69, 74, 0, 47, 0,
  0, 411, 243, 247, 252, 256, 259, 59
};

static yyconst short int yy_def[339] = { 0,
  332, 1, 332, 332, 332, 332, 332, 332, 333, 334,
  332, 332, 335, 332, 332, 332, 332, 332, 332, 336,
  332, 332, 332, 332, 332, 332, 332, 332, 332, 332,
  332, 332, 332, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 332, 332, 332, 332, 333, 332, 333, 334, 335,
  335, 337, 332, 332, 332, 332, 332, 332, 332, 332,
  332, 332, 332, 332, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,

  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  332, 337, 332, 332, 332, 332, 332, 332, 332, 332,
  332, 332, 332, 338, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 332, 332, 332, 332, 332,
  332, 332, 332, 332, 332, 332, 334, 334, 334, 334,

  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  332, 332, 332, 332, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,

  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 334, 334, 334, 334, 334, 334, 334, 334, 334,
  334, 0, 332, 332, 332, 332, 332, 332
};

static yyconst short int yy_nxt[471] = { 0,
  4, 5, 6, 7, 8, 9, 10, 11, 12, 13,
  14, 15, 16, 17, 18, 19, 20, 21, 22, 23,
  24, 25, 26, 27, 28, 29, 30, 31, 32, 33,
  10, 34, 35, 36, 37, 38, 39, 10, 10, 40,
  10, 10, 41, 42, 43, 44, 45, 46, 47, 48,
  49, 50, 51, 10, 10, 52, 53, 54, 55, 57,
  63, 63, 134, 64, 78, 65, 65, 64, 79, 70,
  70, 71, 72, 75, 80, 76, 82, 77, 331, 93,
  86, 58, 66, 81, 94, 89, 66, 83, 87, 67,
  84, 95, 121, 67, 88, 85, 90, 68, 91, 96,

  69, 68, 100, 104, 107, 57, 105, 92, 108, 330,
  61, 329, 63, 63, 112, 109, 101, 102, 110, 111,
  103, 113, 117, 332, 328, 118, 119, 58, 114, 123,
  60, 125, 125, 164, 120, 64, 124, 65, 65, 130,
  143, 130, 159, 160, 131, 131, 144, 165, 126, 134,
  134, 131, 131, 327, 66, 127, 64, 157, 70, 70,
  158, 128, 134, 134, 134, 134, 134, 134, 140, 129,
  141, 170, 142, 174, 186, 66, 186, 175, 171, 187,
  187, 326, 67, 125, 125, 325, 190, 195, 190, 176,
  68, 191, 191, 131, 131, 196, 225, 187, 187, 324,

  188, 187, 187, 226, 241, 323, 241, 189, 322, 242,
  242, 191, 191, 191, 191, 242, 242, 194, 242, 242,
  304, 310, 321, 320, 319, 124, 318, 305, 311, 317,
  316, 315, 314, 313, 312, 309, 308, 127, 307, 306,
  303, 302, 189, 56, 56, 56, 56, 56, 59, 301,
  59, 59, 60, 60, 300, 60, 60, 62, 299, 62,
  122, 298, 122, 297, 296, 295, 294, 293, 292, 291,
  290, 289, 288, 287, 286, 285, 284, 283, 282, 281,
  280, 279, 278, 277, 276, 275, 274, 273, 272, 271,
  270, 269, 268, 267, 266, 265, 264, 263, 262, 261,

  260, 259, 258, 257, 256, 255, 254, 253, 252, 251,
  250, 249, 248, 247, 246, 245, 244, 243, 240, 239,
  238, 237, 236, 235, 234, 233, 232, 231, 230, 229,
  228, 227, 224, 223, 222, 221, 220, 219, 218, 217,
  216, 215, 214, 213, 212, 211, 210, 209, 208, 207,
  206, 205, 204, 203, 202, 201, 200, 199, 198, 197,
  193, 192, 185, 184, 183, 182, 181, 180, 179, 178,
  177, 173, 172, 169, 168, 167, 166, 163, 162, 161,
  156, 155, 154, 153, 152, 151, 150, 149, 148, 147,
  146, 145, 139, 138, 137, 136, 135, 133, 132, 332,

  116, 115, 106, 99, 98, 97, 74, 73, 61, 332,
  3, 332, 332, 332, 332, 332, 332, 332, 332, 332,
  332, 332, 332, 332, 332, 332, 332, 332, 332, 332,
  332, 332, 332, 332, 332, 332, 332, 332, 332, 332,
  332, 332, 332, 332, 332, 332, 332, 332, 332, 332,
  332, 332, 332, 332, 332, 332, 332, 332, 332, 332,
  332, 332, 332, 332, 332, 332, 332, 332, 332, 332
};

static yyconst short int yy_chk[471] = { 0,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 9,
  20, 20, 338, 22, 35, 22, 22, 23, 35, 23,
  23, 26, 26, 34, 35, 34, 36, 34, 329, 39,
  37, 9, 22, 35, 39, 38, 23, 36, 37, 22,
  36, 40, 60, 23, 37, 36, 38, 22, 38, 40,

  22, 23, 44, 45, 47, 56, 45, 38, 47, 327,
  60, 326, 63, 63, 48, 47, 44, 44, 47, 47,
  44, 48, 51, 61, 324, 51, 51, 56, 48, 63,
  61, 64, 64, 101, 51, 65, 63, 65, 65, 66,
  82, 66, 97, 97, 66, 66, 82, 101, 64, 69,
  69, 130, 130, 323, 65, 64, 70, 96, 70, 70,
  96, 65, 69, 69, 69, 69, 69, 69, 81, 65,
  81, 107, 81, 110, 123, 70, 123, 110, 107, 123,
  123, 322, 70, 125, 125, 321, 126, 134, 126, 110,
  70, 126, 126, 131, 131, 134, 167, 186, 186, 320,

  125, 187, 187, 167, 188, 319, 188, 125, 318, 188,
  188, 190, 190, 191, 191, 241, 241, 131, 242, 242,
  297, 307, 317, 316, 315, 187, 314, 297, 307, 313,
  312, 311, 310, 309, 308, 305, 304, 191, 302, 298,
  296, 294, 242, 333, 333, 333, 333, 333, 334, 293,
  334, 334, 335, 335, 286, 335, 335, 336, 282, 336,
  337, 281, 337, 280, 278, 277, 275, 271, 269, 268,
  267, 266, 265, 264, 263, 261, 260, 259, 258, 256,
  255, 254, 253, 248, 247, 246, 245, 240, 238, 236,
  235, 233, 231, 230, 229, 228, 227, 226, 225, 224,

  223, 221, 217, 216, 215, 213, 210, 208, 207, 206,
  203, 201, 200, 199, 198, 197, 196, 195, 185, 184,
  183, 182, 181, 180, 179, 176, 175, 174, 172, 170,
  169, 168, 166, 165, 164, 163, 162, 160, 159, 158,
  157, 156, 154, 153, 152, 151, 150, 148, 147, 146,
  145, 144, 143, 142, 141, 140, 139, 138, 137, 136,
  129, 128, 120, 119, 118, 117, 116, 115, 113, 112,
  111, 109, 108, 106, 105, 104, 103, 100, 99, 98,
  94, 93, 92, 91, 90, 89, 88, 87, 86, 85,
  84, 83, 80, 79, 78, 76, 75, 68, 67, 58,

  50, 49, 46, 43, 42, 41, 28, 27, 13, 3,
  332, 332, 332, 332, 332, 332, 332, 332, 332, 332,
  332, 332, 332, 332, 332, 332, 332, 332, 332, 332,
  332, 332, 332, 332, 332, 332, 332, 332, 332, 332,
  332, 332, 332, 332, 332, 332, 332, 332, 332, 332,
  332, 332, 332, 332, 332, 332, 332, 332, 332, 332,
  332, 332, 332, 332, 332, 332, 332, 332, 332, 332
};

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "parser.l"
#define INITIAL 0
#line 12 "parser.l"
#include <stdio.h>
#include "y.tab.h"
#include "parser_ext.h"
#include "gram_ext.h"

#ifdef MYLEXDEBUG
#define LEXRETURN(x) printf("Lex: %d (%s)\n", (x), yytext); return (x)
#else
#define LEXRETURN(x) return(x)
#endif

static int eqisboolean = 0;
int
seteqboolean ()
{
  eqisboolean = 1;
  return 0;
}

int
unseteqboolean ()
{
  eqisboolean = 0;
  return 0;
}
extern int yylval;

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO ((void));
#else
extern int yywrap YY_PROTO ((void));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO ((int c, char *buf_ptr));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO ((char *, yyconst char *, int));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO ((yyconst char *));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO ((void));
#else
static int input YY_PROTO ((void));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO ((int new_state));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO ((void));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO ((void));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else

#endif
#endif

#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

#ifndef ECHO

#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

YY_DECL
{
  register yy_state_type yy_current_state;
  register char *yy_cp, *yy_bp;
  register int yy_act;

#line 30 "parser.l"

  if (yy_init)
    {
      yy_init = 0;

#ifdef YY_USER_INIT
      YY_USER_INIT;
#endif

      if (!yy_start)
	yy_start = 1;

      if (!yyin)
	yyin = stdin;

      if (!yyout)
	yyout = stdout;

      if (!yy_current_buffer)
	yy_current_buffer = yy_create_buffer (yyin, YY_BUF_SIZE);

      yy_load_buffer_state ();
    }

  while (1)
    {
      yy_cp = yy_c_buf_p;

      *yy_cp = yy_hold_char;

      yy_bp = yy_cp;

      yy_current_state = yy_start;
    yy_match:
      do
	{
	  register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI (*yy_cp)];
	  if (yy_accept[yy_current_state])
	    {
	      yy_last_accepting_state = yy_current_state;
	      yy_last_accepting_cpos = yy_cp;
	    }
	  while (yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state)
	    {
	      yy_current_state = (int) yy_def[yy_current_state];
	      if (yy_current_state >= 333)
		yy_c = yy_meta[(unsigned int) yy_c];
	    }
	  yy_current_state =
	    yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	  ++yy_cp;
	}
      while (yy_base[yy_current_state] != 411);

    yy_find_action:
      yy_act = yy_accept[yy_current_state];
      if (yy_act == 0)
	{
	  yy_cp = yy_last_accepting_cpos;
	  yy_current_state = yy_last_accepting_state;
	  yy_act = yy_accept[yy_current_state];
	}

      YY_DO_BEFORE_ACTION;

    do_action:

      switch (yy_act)
	{
	case 0:

	  *yy_cp = yy_hold_char;
	  yy_cp = yy_last_accepting_cpos;
	  yy_current_state = yy_last_accepting_state;
	  goto yy_find_action;

	case 1:
	  YY_RULE_SETUP
#line 31 "parser.l"
	  {
	    LEXRETURN (AND);
	  }
	YY_BREAK case 2:
	  YY_RULE_SETUP
#line 32 "parser.l"
	  {
	    LEXRETURN (APPEND);
	  }
	YY_BREAK case 3:
	  YY_RULE_SETUP
#line 33 "parser.l"
	  {
	    LEXRETURN (AS);
	  }
	YY_BREAK case 4:
	  YY_RULE_SETUP
#line 34 "parser.l"
	  {
	    LEXRETURN (BEGIN_OF_MODULE);
	  }
	YY_BREAK case 5:
	  YY_RULE_SETUP
#line 35 "parser.l"
	  {
	    LEXRETURN (BEGIN_OF_FORMULA);
	  }
	YY_BREAK case 6:
	  YY_RULE_SETUP
#line 36 "parser.l"
	  {
	    LEXRETURN (BINARY);
	  }
	YY_BREAK case 7:
	  YY_RULE_SETUP
#line 37 "parser.l"
	  {
	    LEXRETURN (BOOLEAN);
	  }
	YY_BREAK case 8:
	  YY_RULE_SETUP
#line 38 "parser.l"
	  {
	    LEXRETURN (BYREF);
	  }
	YY_BREAK case 9:
	  YY_RULE_SETUP
#line 39 "parser.l"
	  {
	    LEXRETURN (BYTE);
	  }
	YY_BREAK case 10:
	  YY_RULE_SETUP
#line 40 "parser.l"
	  {
	    LEXRETURN (BYVAL);
	  }
	YY_BREAK case 11:
	  YY_RULE_SETUP
#line 41 "parser.l"
	  {
	    LEXRETURN (CASE);
	  }
	YY_BREAK case 12:
	  YY_RULE_SETUP
#line 42 "parser.l"
	  {
	    LEXRETURN (CLOSE);
	  }
	YY_BREAK case 13:
	  YY_RULE_SETUP
#line 43 "parser.l"
	  {
	    LEXRETURN (CONST);
	  }
	YY_BREAK case 14:
	  YY_RULE_SETUP
#line 44 "parser.l"
	  {
	    LEXRETURN (CURRENCY);
	  }
	YY_BREAK case 15:
	  YY_RULE_SETUP
#line 45 "parser.l"
	  {
	    LEXRETURN (DATE);
	  }
	YY_BREAK case 16:
	  YY_RULE_SETUP
#line 46 "parser.l"
	  {
	    LEXRETURN (DIM);
	  }
	YY_BREAK case 17:
	  YY_RULE_SETUP
#line 47 "parser.l"
	  {
	    LEXRETURN (DO);
	  }
	YY_BREAK case 18:
	  YY_RULE_SETUP
#line 48 "parser.l"
	  {
	    LEXRETURN (DOUBLE);
	  }
	YY_BREAK case 19:
	  YY_RULE_SETUP
#line 49 "parser.l"
	  {
	    LEXRETURN (END_OF_MODULE);
	  }
	YY_BREAK case 20:
	  YY_RULE_SETUP
#line 50 "parser.l"
	  {
	    LEXRETURN (END_OF_FORMULA);
	  }
	YY_BREAK case 21:
	  YY_RULE_SETUP
#line 51 "parser.l"
	  {
	    LEXRETURN (EACH);
	  }
	YY_BREAK case 22:
	  YY_RULE_SETUP
#line 52 "parser.l"
	  {
	    LEXRETURN (ELSE);
	  }
	YY_BREAK case 23:
	  YY_RULE_SETUP
#line 53 "parser.l"
	  {
	    LEXRETURN (EXIT);
	  }
	YY_BREAK case 24:
	  YY_RULE_SETUP
#line 54 "parser.l"
	  {
	    LEXRETURN (FOR);
	  }
	YY_BREAK case 25:
	  YY_RULE_SETUP
#line 55 "parser.l"
	  {
	    LEXRETURN (FUNCTION);
	  }
	YY_BREAK case 26:
	  YY_RULE_SETUP
#line 56 "parser.l"
	  {
	    eqisboolean = 1;
	    LEXRETURN (IF);
	  }
	YY_BREAK case 27:
	  YY_RULE_SETUP
#line 57 "parser.l"
	  {
	    LEXRETURN (IN);
	  }
	YY_BREAK case 28:
	  YY_RULE_SETUP
#line 58 "parser.l"
	  {
	    LEXRETURN (INPUT);
	  }
	YY_BREAK case 29:
	  YY_RULE_SETUP
#line 59 "parser.l"
	  {
	    LEXRETURN (INTEGER);
	  }
	YY_BREAK case 30:
	  YY_RULE_SETUP
#line 60 "parser.l"
	  {
	    LEXRETURN (LONG);
	  }
	YY_BREAK case 31:
	  YY_RULE_SETUP
#line 61 "parser.l"
	  {
	    LEXRETURN (LOOP);
	  }
	YY_BREAK case 32:
	  YY_RULE_SETUP
#line 62 "parser.l"
	  {
	    LEXRETURN (OBJECT);
	  }
	YY_BREAK case 33:
	  YY_RULE_SETUP
#line 63 "parser.l"
	  {
	    LEXRETURN (OPEN);
	  }
	YY_BREAK case 34:
	  YY_RULE_SETUP
#line 64 "parser.l"
	  {
	    LEXRETURN (OPTION);
	  }
	YY_BREAK case 35:
	  YY_RULE_SETUP
#line 65 "parser.l"
	  {
	    LEXRETURN (OR);
	  }
	YY_BREAK case 36:
	  YY_RULE_SETUP
#line 66 "parser.l"
	  {
	    LEXRETURN (OUTPUT);
	  }
	YY_BREAK case 37:
	  YY_RULE_SETUP
#line 67 "parser.l"
	  {
	    LEXRETURN (PRINT);
	  }
	YY_BREAK case 38:
	  YY_RULE_SETUP
#line 68 "parser.l"
	  {
	    LEXRETURN (PRIVATE);
	  }
	YY_BREAK case 39:
	  YY_RULE_SETUP
#line 69 "parser.l"
	  {
	    LEXRETURN (PUBLIC);
	  }
	YY_BREAK case 40:
	  YY_RULE_SETUP
#line 70 "parser.l"
	  {
	    LEXRETURN (MOD);
	  }
	YY_BREAK case 41:
	  YY_RULE_SETUP
#line 71 "parser.l"
	  {
	    LEXRETURN (NEXT);
	  }
	YY_BREAK case 42:
	  YY_RULE_SETUP
#line 72 "parser.l"
	  {
	    LEXRETURN (TAB);
	  }
	YY_BREAK case 43:
	  YY_RULE_SETUP
#line 73 "parser.l"
	  {
	    eqisboolean = 0;
	    LEXRETURN (THEN);
	  }
	YY_BREAK case 44:
	  YY_RULE_SETUP
#line 74 "parser.l"
	  {
	    LEXRETURN (TO);
	  }
	YY_BREAK case 45:
	  YY_RULE_SETUP
#line 75 "parser.l"
	  {
	    LEXRETURN (RANDOM);
	  }
	YY_BREAK case 46:
	  YY_RULE_SETUP
#line 76 "parser.l"
	  {
	    LEXRETURN (SELECT);
	  }
	YY_BREAK case 47:
	  YY_RULE_SETUP
#line 77 "parser.l"
	  {
	    LEXRETURN (SET);
	  }
	YY_BREAK case 48:
	  YY_RULE_SETUP
#line 78 "parser.l"
	  {
	    LEXRETURN (SINGLE);
	  }
	YY_BREAK case 49:
	  YY_RULE_SETUP
#line 79 "parser.l"
	  {
	    LEXRETURN (STATIC);
	  }
	YY_BREAK case 50:
	  YY_RULE_SETUP
#line 80 "parser.l"
	  {
	    LEXRETURN (STEP);
	  }
	YY_BREAK case 51:
	  YY_RULE_SETUP
#line 81 "parser.l"
	  {
	    LEXRETURN (STRING);
	  }
	YY_BREAK case 52:
	  YY_RULE_SETUP
#line 82 "parser.l"
	  {
	    LEXRETURN (UNTIL);
	  }
	YY_BREAK case 53:
	  YY_RULE_SETUP
#line 83 "parser.l"
	  {
	    LEXRETURN (VARIANT);
	  }
	YY_BREAK case 54:
	  YY_RULE_SETUP
#line 84 "parser.l"
	  {
	    LEXRETURN (WEND);
	  }
	YY_BREAK case 55:
	  YY_RULE_SETUP
#line 85 "parser.l"
	  {
	    LEXRETURN (WITH);
	  }
	YY_BREAK case 56:
	  YY_RULE_SETUP
#line 86 "parser.l"
	  {
	    eqisboolean = 1;
	    LEXRETURN (WHILE);
	  }
	YY_BREAK case 57:
	  YY_RULE_SETUP
#line 87 "parser.l"
	  {
	    LEXRETURN (WRITE);
	  }
	YY_BREAK case 58:
	  YY_RULE_SETUP
#line 88 "parser.l"
	  {
	    LEXRETURN (SUB);
	  }
	YY_BREAK case 59:
	  YY_RULE_SETUP
#line 89 "parser.l"
	  {
	    LEXRETURN (SPC);
	  }
	YY_BREAK case 60:
	  YY_RULE_SETUP
#line 90 "parser.l"
	  {
	    LEXRETURN (END);
	  }
	YY_BREAK case 61:
	  YY_RULE_SETUP
#line 91 "parser.l"
	  {
	    LEXRETURN (CALL);
	  }
	YY_BREAK case 62:
	  YY_RULE_SETUP
#line 93 "parser.l"
	  {
	    int t;
	    FillTokenBuf (yytext);
	    t = check_type ();
	    LEXRETURN (t);
	  }
	YY_BREAK case 63:
	  YY_RULE_SETUP
#line 94 "parser.l"
	  {
	    int t;
	    FillTokenBuf (yytext);
	    t = check_member ();
	    LEXRETURN (t);
	  }
	YY_BREAK case 64:
	  YY_RULE_SETUP
#line 96 "parser.l"
	  {
	    FillTokenBuf (yytext);
	    LEXRETURN (INTEGER_CONSTANT);
	  }
	YY_BREAK case 65:
	  YY_RULE_SETUP
#line 97 "parser.l"
	  {
	    FillTokenBuf (yytext);
	    LEXRETURN (INTEGER_CONSTANT);
	  }
	YY_BREAK case 66:
	  YY_RULE_SETUP
#line 98 "parser.l"
	  {
	    FillTokenBuf (yytext);
	    LEXRETURN (INTEGER_CONSTANT);
	  }
	YY_BREAK case 67:
	  YY_RULE_SETUP
#line 99 "parser.l"
	  {
	    FillTokenBuf (yytext);
	    LEXRETURN (INTEGER_CONSTANT);
	  }
	YY_BREAK case 68:
	  YY_RULE_SETUP
#line 100 "parser.l"
	  {
	    FillTokenBuf (yytext);
	    LEXRETURN (INTEGER_CONSTANT);
	  }
	YY_BREAK case 69:
	  YY_RULE_SETUP
#line 101 "parser.l"
	  {
	    FillTokenBuf (yytext);
	    LEXRETURN (INTEGER_CONSTANT);
	  }
	YY_BREAK case 70:
	  YY_RULE_SETUP
#line 103 "parser.l"
	  {
	    FillTokenBuf (yytext);
	    LEXRETURN (CHARACTER_CONSTANT);
	  }
	YY_BREAK case 71:
	  YY_RULE_SETUP
#line 105 "parser.l"
	  {
	    FillTokenBuf (yytext);
	    LEXRETURN (FLOATING_CONSTANT);
	  }
	YY_BREAK case 72:
	  YY_RULE_SETUP
#line 106 "parser.l"
	  {
	    FillTokenBuf (yytext);
	    LEXRETURN (FLOATING_CONSTANT);
	  }
	YY_BREAK case 73:
	  YY_RULE_SETUP
#line 107 "parser.l"
	  {
	    FillTokenBuf (yytext);
	    LEXRETURN (FLOATING_CONSTANT);
	  }
	YY_BREAK case 74:
	  YY_RULE_SETUP
#line 109 "parser.l"
	  {
	    FillTokenBuf (yytext);
	    LEXRETURN (STRING_CONSTANT);
	  }
	YY_BREAK case 75:
	  YY_RULE_SETUP
#line 112 "parser.l"
	  {
	    LEXRETURN (';');
	  }
	YY_BREAK case 76:
	  YY_RULE_SETUP
#line 113 "parser.l"
	  {
	    LEXRETURN ('{');
	  }
	YY_BREAK case 77:
	  YY_RULE_SETUP
#line 114 "parser.l"
	  {
	    LEXRETURN ('}');
	  }
	YY_BREAK case 78:
	  YY_RULE_SETUP
#line 115 "parser.l"
	  {
	    LEXRETURN (',');
	  }
	YY_BREAK case 79:
	  YY_RULE_SETUP
#line 116 "parser.l"
	  {
	    LEXRETURN (':');
	  }
	YY_BREAK case 80:
	  YY_RULE_SETUP
#line 117 "parser.l"
	  {
	    if (eqisboolean)
	      LEXRETURN (EQ);
	    LEXRETURN ('=');
	  }
	YY_BREAK case 81:
	  YY_RULE_SETUP
#line 119 "parser.l"
	  {
	    LEXRETURN (EQ);
	  }
	YY_BREAK case 82:
	  YY_RULE_SETUP
#line 120 "parser.l"
	  {
	    LEXRETURN ('(');
	  }
	YY_BREAK case 83:
	  YY_RULE_SETUP
#line 121 "parser.l"
	  {
	    LEXRETURN (')');
	  }
	YY_BREAK case 84:
	  YY_RULE_SETUP
#line 122 "parser.l"
	  {
	    LEXRETURN ('[');
	  }
	YY_BREAK case 85:
	  YY_RULE_SETUP
#line 123 "parser.l"
	  {
	    LEXRETURN (']');
	  }
	YY_BREAK case 86:
	  YY_RULE_SETUP
#line 124 "parser.l"
	  {
	    LEXRETURN ('.');
	  }
	YY_BREAK case 87:
	  YY_RULE_SETUP
#line 125 "parser.l"
	  {
	    LEXRETURN ('&');
	  }
	YY_BREAK case 88:
	  YY_RULE_SETUP
#line 126 "parser.l"
	  {
	    LEXRETURN ('!');
	  }
	YY_BREAK case 89:
	  YY_RULE_SETUP
#line 127 "parser.l"
	  {
	    LEXRETURN (NE);
	  }
	YY_BREAK case 90:
	  YY_RULE_SETUP
#line 128 "parser.l"
	  {
	    LEXRETURN ('~');
	  }
	YY_BREAK case 91:
	  YY_RULE_SETUP
#line 129 "parser.l"
	  {
	    LEXRETURN ('-');
	  }
	YY_BREAK case 92:
	  YY_RULE_SETUP
#line 130 "parser.l"
	  {
	    LEXRETURN ('+');
	  }
	YY_BREAK case 93:
	  YY_RULE_SETUP
#line 131 "parser.l"
	  {
	    LEXRETURN ('*');
	  }
	YY_BREAK case 94:
	  YY_RULE_SETUP
#line 132 "parser.l"
	  {
	    LEXRETURN ('/');
	  }
	YY_BREAK case 95:
	  YY_RULE_SETUP
#line 133 "parser.l"
	  {
	    LEXRETURN ('\\');
	  }
	YY_BREAK case 96:
	  YY_RULE_SETUP
#line 134 "parser.l"
	  {
	    LEXRETURN ('%');
	  }
	YY_BREAK case 97:
	  YY_RULE_SETUP
#line 135 "parser.l"
	  {
	    LEXRETURN (LT);
	  }
	YY_BREAK case 98:
	  YY_RULE_SETUP
#line 136 "parser.l"
	  {
	    LEXRETURN (LE);
	  }
	YY_BREAK case 99:
	  YY_RULE_SETUP
#line 137 "parser.l"
	  {
	    LEXRETURN (GT);
	  }
	YY_BREAK case 100:
	  YY_RULE_SETUP
#line 138 "parser.l"
	  {
	    LEXRETURN (GE);
	  }
	YY_BREAK case 101:
	  YY_RULE_SETUP
#line 139 "parser.l"
	  {
	    LEXRETURN ('^');
	  }
	YY_BREAK case 102:
	  YY_RULE_SETUP
#line 140 "parser.l"
	  {
	    LEXRETURN ('|');
	  }
	YY_BREAK case 103:
	  YY_RULE_SETUP
#line 141 "parser.l"
	  {
	    LEXRETURN ('?');
	  }
	YY_BREAK case 104:
	  YY_RULE_SETUP
#line 143 "parser.l"
	  {
	    eqisboolean = 0;
	    LEXRETURN (NEWLINE);
	  }
	YY_BREAK case 105:
	  YY_RULE_SETUP
#line 144 "parser.l"
	  {
	  }
	YY_BREAK case 106:
	  YY_RULE_SETUP
#line 146 "parser.l"
	  {
	  }
	YY_BREAK case 107:
	  YY_RULE_SETUP
#line 148 "parser.l"
	  {
	  }
	YY_BREAK case 108:
	  YY_RULE_SETUP
#line 150 "parser.l"
	    ECHO;
	YY_BREAK case YY_STATE_EOF (INITIAL):
	  yyterminate ();

	case YY_END_OF_BUFFER:
	  {

	    int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

	    *yy_cp = yy_hold_char;
	    YY_RESTORE_YY_MORE_OFFSET
	      if (yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW)
	      {

		yy_n_chars = yy_current_buffer->yy_n_chars;
		yy_current_buffer->yy_input_file = yyin;
		yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
	      }

	    if (yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars])
	      {
		yy_state_type yy_next_state;

		yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

		yy_current_state = yy_get_previous_state ();

		yy_next_state = yy_try_NUL_trans (yy_current_state);

		yy_bp = yytext_ptr + YY_MORE_ADJ;

		if (yy_next_state)
		  {

		    yy_cp = ++yy_c_buf_p;
		    yy_current_state = yy_next_state;
		    goto yy_match;
		  }

		else
		  {
		    yy_cp = yy_c_buf_p;
		    goto yy_find_action;
		  }
	      }

	    else
	      switch (yy_get_next_buffer ())
		{
		case EOB_ACT_END_OF_FILE:
		  {
		    yy_did_buffer_switch_on_eof = 0;

		    if (yywrap ())
		      {

			yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

			yy_act = YY_STATE_EOF (YY_START);
			goto do_action;
		      }

		    else
		      {
			if (!yy_did_buffer_switch_on_eof)
			  YY_NEW_FILE;
		      }
		    break;
		  }

		case EOB_ACT_CONTINUE_SCAN:
		  yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

		  yy_current_state = yy_get_previous_state ();

		  yy_cp = yy_c_buf_p;
		  yy_bp = yytext_ptr + YY_MORE_ADJ;
		  goto yy_match;

		case EOB_ACT_LAST_MATCH:
		  yy_c_buf_p = &yy_current_buffer->yy_ch_buf[yy_n_chars];

		  yy_current_state = yy_get_previous_state ();

		  yy_cp = yy_c_buf_p;
		  yy_bp = yytext_ptr + YY_MORE_ADJ;
		  goto yy_find_action;
		}
	    break;
	  }

	default:
	  YY_FATAL_ERROR
	    ("fatal flex scanner internal error--no action found");
	}
    }
}

static int
yy_get_next_buffer ()
{
  register char *dest = yy_current_buffer->yy_ch_buf;
  register char *source = yytext_ptr;
  register int number_to_move, i;
  int ret_val;

  if (yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1])
    YY_FATAL_ERROR
      ("fatal flex scanner internal error--end of buffer missed");

  if (yy_current_buffer->yy_fill_buffer == 0)
    {
      if (yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1)
	{

	  return EOB_ACT_END_OF_FILE;
	}

      else
	{

	  return EOB_ACT_LAST_MATCH;
	}
    }

  number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

  for (i = 0; i < number_to_move; ++i)
    *(dest++) = *(source++);

  if (yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING)

    yy_current_buffer->yy_n_chars = yy_n_chars = 0;

  else
    {
      int num_to_read = yy_current_buffer->yy_buf_size - number_to_move - 1;

      while (num_to_read <= 0)
	{
#ifdef YY_USES_REJECT
	  YY_FATAL_ERROR
	    ("input buffer overflow, can't enlarge buffer because scanner uses REJECT");
#else

	  YY_BUFFER_STATE b = yy_current_buffer;

	  int yy_c_buf_p_offset = (int) (yy_c_buf_p - b->yy_ch_buf);

	  if (b->yy_is_our_buffer)
	    {
	      int new_size = b->yy_buf_size * 2;

	      if (new_size <= 0)
		b->yy_buf_size += b->yy_buf_size / 8;
	      else
		b->yy_buf_size *= 2;

	      b->yy_ch_buf = (char *)
		yy_flex_realloc ((void *) b->yy_ch_buf, b->yy_buf_size + 2);
	    }
	  else

	    b->yy_ch_buf = 0;

	  if (!b->yy_ch_buf)
	    YY_FATAL_ERROR ("fatal error - scanner input buffer overflow");

	  yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

	  num_to_read = yy_current_buffer->yy_buf_size - number_to_move - 1;
#endif
	}

      if (num_to_read > YY_READ_BUF_SIZE)
	num_to_read = YY_READ_BUF_SIZE;

      YY_INPUT ((&yy_current_buffer->yy_ch_buf[number_to_move]),
		yy_n_chars, num_to_read);

      yy_current_buffer->yy_n_chars = yy_n_chars;
    }

  if (yy_n_chars == 0)
    {
      if (number_to_move == YY_MORE_ADJ)
	{
	  ret_val = EOB_ACT_END_OF_FILE;
	  yyrestart (yyin);
	}

      else
	{
	  ret_val = EOB_ACT_LAST_MATCH;
	  yy_current_buffer->yy_buffer_status = YY_BUFFER_EOF_PENDING;
	}
    }

  else
    ret_val = EOB_ACT_CONTINUE_SCAN;

  yy_n_chars += number_to_move;
  yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
  yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

  yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

  return ret_val;
}

static yy_state_type
yy_get_previous_state ()
{
  register yy_state_type yy_current_state;
  register char *yy_cp;

  yy_current_state = yy_start;

  for (yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp)
    {
      register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI (*yy_cp)] : 1);
      if (yy_accept[yy_current_state])
	{
	  yy_last_accepting_state = yy_current_state;
	  yy_last_accepting_cpos = yy_cp;
	}
      while (yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state)
	{
	  yy_current_state = (int) yy_def[yy_current_state];
	  if (yy_current_state >= 333)
	    yy_c = yy_meta[(unsigned int) yy_c];
	}
      yy_current_state =
	yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
    }

  return yy_current_state;
}

#ifdef YY_USE_PROTOS
static yy_state_type
yy_try_NUL_trans (yy_state_type yy_current_state)
#else
static yy_state_type
yy_try_NUL_trans (yy_current_state)
     yy_state_type yy_current_state;
#endif
{
  register int yy_is_jam;
  register char *yy_cp = yy_c_buf_p;

  register YY_CHAR yy_c = 1;
  if (yy_accept[yy_current_state])
    {
      yy_last_accepting_state = yy_current_state;
      yy_last_accepting_cpos = yy_cp;
    }
  while (yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state)
    {
      yy_current_state = (int) yy_def[yy_current_state];
      if (yy_current_state >= 333)
	yy_c = yy_meta[(unsigned int) yy_c];
    }
  yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
  yy_is_jam = (yy_current_state == 332);

  return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void
yyunput (int c, register char *yy_bp)
#else
static void
yyunput (c, yy_bp)
     int c;
     register char *yy_bp;
#endif
{
  register char *yy_cp = yy_c_buf_p;

  *yy_cp = yy_hold_char;

  if (yy_cp < yy_current_buffer->yy_ch_buf + 2)
    {

      register int number_to_move = yy_n_chars + 2;
      register char *dest =
	&yy_current_buffer->yy_ch_buf[yy_current_buffer->yy_buf_size + 2];
      register char *source = &yy_current_buffer->yy_ch_buf[number_to_move];

      while (source > yy_current_buffer->yy_ch_buf)
	*--dest = *--source;

      yy_cp += (int) (dest - source);
      yy_bp += (int) (dest - source);
      yy_current_buffer->yy_n_chars =
	yy_n_chars = yy_current_buffer->yy_buf_size;

      if (yy_cp < yy_current_buffer->yy_ch_buf + 2)
	YY_FATAL_ERROR ("flex scanner push-back overflow");
    }

  *--yy_cp = (char) c;

  yytext_ptr = yy_bp;
  yy_hold_char = *yy_cp;
  yy_c_buf_p = yy_cp;
}
#endif

#ifdef __cplusplus
static int
yyinput ()
#else
static int
input ()
#endif
{
  int c;

  *yy_c_buf_p = yy_hold_char;

  if (*yy_c_buf_p == YY_END_OF_BUFFER_CHAR)
    {

      if (yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars])

	*yy_c_buf_p = '\0';

      else
	{
	  int offset = yy_c_buf_p - yytext_ptr;
	  ++yy_c_buf_p;

	  switch (yy_get_next_buffer ())
	    {
	    case EOB_ACT_LAST_MATCH:

	      yyrestart (yyin);

	    case EOB_ACT_END_OF_FILE:
	      {
		if (yywrap ())
		  return EOF;

		if (!yy_did_buffer_switch_on_eof)
		  YY_NEW_FILE;
#ifdef __cplusplus
		return yyinput ();
#else
		return input ();
#endif
	      }

	    case EOB_ACT_CONTINUE_SCAN:
	      yy_c_buf_p = yytext_ptr + offset;
	      break;
	    }
	}
    }

  c = *(unsigned char *) yy_c_buf_p;
  *yy_c_buf_p = '\0';
  yy_hold_char = *++yy_c_buf_p;

  return c;
}

#ifdef YY_USE_PROTOS
void
yyrestart (FILE * input_file)
#else
void
yyrestart (input_file)
     FILE *input_file;
#endif
{
  if (!yy_current_buffer)
    yy_current_buffer = yy_create_buffer (yyin, YY_BUF_SIZE);

  yy_init_buffer (yy_current_buffer, input_file);
  yy_load_buffer_state ();
}

#ifdef YY_USE_PROTOS
void
yy_switch_to_buffer (YY_BUFFER_STATE new_buffer)
#else
void
yy_switch_to_buffer (new_buffer)
     YY_BUFFER_STATE new_buffer;
#endif
{
  if (yy_current_buffer == new_buffer)
    return;

  if (yy_current_buffer)
    {

      *yy_c_buf_p = yy_hold_char;
      yy_current_buffer->yy_buf_pos = yy_c_buf_p;
      yy_current_buffer->yy_n_chars = yy_n_chars;
    }

  yy_current_buffer = new_buffer;
  yy_load_buffer_state ();

  yy_did_buffer_switch_on_eof = 1;
}

#ifdef YY_USE_PROTOS
void
yy_load_buffer_state (void)
#else
void
yy_load_buffer_state ()
#endif
{
  yy_n_chars = yy_current_buffer->yy_n_chars;
  yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
  yyin = yy_current_buffer->yy_input_file;
  yy_hold_char = *yy_c_buf_p;
}

#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer (FILE * file, int size)
#else
YY_BUFFER_STATE yy_create_buffer (file, size)
     FILE *
       file;
     int
       size;
#endif
{
  YY_BUFFER_STATE b;

  b = (YY_BUFFER_STATE) yy_flex_alloc (sizeof (struct yy_buffer_state));
  if (!b)
    YY_FATAL_ERROR ("out of dynamic memory in yy_create_buffer()");

  b->yy_buf_size = size;

  b->yy_ch_buf = (char *) yy_flex_alloc (b->yy_buf_size + 2);
  if (!b->yy_ch_buf)
    YY_FATAL_ERROR ("out of dynamic memory in yy_create_buffer()");

  b->yy_is_our_buffer = 1;

  yy_init_buffer (b, file);

  return b;
}

#ifdef YY_USE_PROTOS
void
yy_delete_buffer (YY_BUFFER_STATE b)
#else
void
yy_delete_buffer (b)
     YY_BUFFER_STATE b;
#endif
{
  if (!b)
    return;

  if (b == yy_current_buffer)
    yy_current_buffer = (YY_BUFFER_STATE) 0;

  if (b->yy_is_our_buffer)
    yy_flex_free ((void *) b->yy_ch_buf);

  yy_flex_free ((void *) b);
}

#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO ((int));
#endif
#endif

#ifdef YY_USE_PROTOS
void
yy_init_buffer (YY_BUFFER_STATE b, FILE * file)
#else
void
yy_init_buffer (b, file)
     YY_BUFFER_STATE b;
     FILE *file;
#endif

{
  yy_flush_buffer (b);

  b->yy_input_file = file;
  b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
  b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
  b->yy_is_interactive = 0;
#else
  b->yy_is_interactive = file ? (isatty (fileno (file)) > 0) : 0;
#endif
#endif
}

#ifdef YY_USE_PROTOS
void
yy_flush_buffer (YY_BUFFER_STATE b)
#else
void
yy_flush_buffer (b)
     YY_BUFFER_STATE b;
#endif

{
  if (!b)
    return;

  b->yy_n_chars = 0;

  b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
  b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

  b->yy_buf_pos = &b->yy_ch_buf[0];

  b->yy_at_bol = 1;
  b->yy_buffer_status = YY_BUFFER_NEW;

  if (b == yy_current_buffer)
    yy_load_buffer_state ();
}

#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer (char *base, yy_size_t size)
#else
YY_BUFFER_STATE yy_scan_buffer (base, size)
     char *
       base;
     yy_size_t
       size;
#endif
{
  YY_BUFFER_STATE b;

  if (size < 2 ||
      base[size - 2] != YY_END_OF_BUFFER_CHAR ||
      base[size - 1] != YY_END_OF_BUFFER_CHAR)

    return 0;

  b = (YY_BUFFER_STATE) yy_flex_alloc (sizeof (struct yy_buffer_state));
  if (!b)
    YY_FATAL_ERROR ("out of dynamic memory in yy_scan_buffer()");

  b->yy_buf_size = size - 2;
  b->yy_buf_pos = b->yy_ch_buf = base;
  b->yy_is_our_buffer = 0;
  b->yy_input_file = 0;
  b->yy_n_chars = b->yy_buf_size;
  b->yy_is_interactive = 0;
  b->yy_at_bol = 1;
  b->yy_fill_buffer = 0;
  b->yy_buffer_status = YY_BUFFER_NEW;

  yy_switch_to_buffer (b);

  return b;
}
#endif

#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str)
#else
YY_BUFFER_STATE yy_scan_string (yy_str)
     yyconst char *
       yy_str;
#endif
{
  int len;
  for (len = 0; yy_str[len]; ++len)
    ;

  return yy_scan_bytes (yy_str, len);
}
#endif

#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes, int len)
#else
YY_BUFFER_STATE yy_scan_bytes (bytes, len)
     yyconst char *
       bytes;
     int
       len;
#endif
{
  YY_BUFFER_STATE b;
  char *buf;
  yy_size_t n;
  int i;

  n = len + 2;
  buf = (char *) yy_flex_alloc (n);
  if (!buf)
    YY_FATAL_ERROR ("out of dynamic memory in yy_scan_bytes()");

  for (i = 0; i < len; ++i)
    buf[i] = bytes[i];

  buf[len] = buf[len + 1] = YY_END_OF_BUFFER_CHAR;

  b = yy_scan_buffer (buf, n);
  if (!b)
    YY_FATAL_ERROR ("bad buffer in yy_scan_bytes()");

  b->yy_is_our_buffer = 1;

  return b;
}
#endif

#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void
yy_push_state (int new_state)
#else
static void
yy_push_state (new_state)
     int new_state;
#endif
{
  if (yy_start_stack_ptr >= yy_start_stack_depth)
    {
      yy_size_t new_size;

      yy_start_stack_depth += YY_START_STACK_INCR;
      new_size = yy_start_stack_depth * sizeof (int);

      if (!yy_start_stack)
	yy_start_stack = (int *) yy_flex_alloc (new_size);

      else
	yy_start_stack = (int *) yy_flex_realloc (
						  (void *) yy_start_stack,
						  new_size);

      if (!yy_start_stack)
	YY_FATAL_ERROR ("out of memory expanding start-condition stack");
    }

  yy_start_stack[yy_start_stack_ptr++] = YY_START;

  BEGIN (new_state);
}
#endif

#ifndef YY_NO_POP_STATE
static void
yy_pop_state ()
{
  if (--yy_start_stack_ptr < 0)
    YY_FATAL_ERROR ("start-condition stack underflow");

  BEGIN (yy_start_stack[yy_start_stack_ptr]);
}
#endif

#ifndef YY_NO_TOP_STATE
static int
yy_top_state ()
{
  return yy_start_stack[yy_start_stack_ptr - 1];
}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void
yy_fatal_error (yyconst char msg[])
#else
static void
yy_fatal_error (msg)
     char msg[];
#endif
{
  (void) fprintf (stderr, "%s\n", msg);
  exit (YY_EXIT_FAILURE);
}

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void
yy_flex_strncpy (char *s1, yyconst char *s2, int n)
#else
static void
yy_flex_strncpy (s1, s2, n)
     char *s1;
     yyconst char *s2;
     int n;
#endif
{
  register int i;
  for (i = 0; i < n; ++i)
    s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int
yy_flex_strlen (yyconst char *s)
#else
static int
yy_flex_strlen (s)
     yyconst char *s;
#endif
{
  register int n;
  for (n = 0; s[n]; ++n)
    ;

  return n;
}
#endif

#ifdef YY_USE_PROTOS
static void *
yy_flex_alloc (yy_size_t size)
#else
static void *
yy_flex_alloc (size)
     yy_size_t size;
#endif
{
  return (void *) malloc (size);
}

#ifdef YY_USE_PROTOS
static void *
yy_flex_realloc (void *ptr, yy_size_t size)
#else
static void *
yy_flex_realloc (ptr, size)
     void *ptr;
     yy_size_t size;
#endif
{

  return (void *) realloc ((char *) ptr, size);
}

#ifdef YY_USE_PROTOS
static void
yy_flex_free (void *ptr)
#else
static void
yy_flex_free (ptr)
     void *ptr;
#endif
{
  free (ptr);
}

#if YY_MAIN
int
main ()
{
  yylex ();
  return 0;
}
#endif
#line 150 "parser.l"
