
/*
 *
 *  conff.h by JH <jheinonen@bigfoot.com>
 *
 *  Copyright (C) Jaakko Heinonen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _CONFF_H
#define _CONFF_H

#include <stdlib.h>

typedef struct {
	char *key;
	char *value;
} confline;

typedef struct {
	confline *data;
	int    items;
} conffile;

conffile	conff_new();
void		conff_free(conffile *file);
void		conff_free2(conffile *file);
int		conff_add_section(conffile *file, char *section);
int		conff_find_section(conffile file, char *section);
int		conff_find_section_end(conffile file, char *section);
int		conff_add_key(conffile *file, char *section, char *key, char *value);
int		conff_add_key2(conffile *file, char *section, char *key, char *value);
int		conff_add_key_noreplace(conffile *file, char *section, char *key, char *value);
int		conff_remove_section(conffile *file, char *section);
void		conff_remove_items(conffile *file);
int		conff_get_value(conffile file, char *section, char *key, char **value);
int		conff_remove_key(conffile *file, char *section, char *key);
int		conff_save_file(conffile file, char *filename);
int		conff_add_comment(conffile *file, char *comment);
int             conff_add_comment2(conffile *file, char *comment);
int		conff_load_config(conffile *file, char *filename, const int flags);


#define conff_set_value(file, section, key, value) \
	conff_add_key(file, section, key, value)

#define conff_set_value2(file, section, key, value) \
	conff_add_key2(file, section, key, value)


#define CONFF_LOAD_DEFAULTS		0
#define CONFF_LOAD_COMMENTS		1
#define CONFF_LOAD_NOREPLACE		2

#endif
