
/*
 * options.c
 * by JH <jheinonen@bigfoot.com>
 *
 * Copyright (C) Jaakko Heinonen
 */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <unistd.h>
#include "abook_curses.h"
#include "abook.h"
#include "options.h"
#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif

conffile abook_config;

static int	rcfile_exist();
static void	default_options();

extern char *rcfile;

static char *
abook_opt_conff_get_val(char *section, char *key)
{
	int tried;
	char *value = NULL;

	for(tried = 0; tried < 2; ) {
		if( conff_get_value(abook_config, section, key, &value) < 0 ) {
			tried ++;
			default_options(); /* try with defaults */
		} else
			return value;
	}
	return NULL;
}

int
options_get_int(char *section, char *key)
{
	char *value;
	int ret;
	
	if( ( value = abook_opt_conff_get_val(section, key) )
			== NULL)
		return 1;

	if( !strcasecmp(value, "true") )
		ret = 1;
	else
	if( !strcasecmp(value, "false") )
		ret = 0;
	else
		ret = safe_atoi(value);
	
	free(value);

	return ret;
}
	
char *
options_get_str(char *section, char *key)
{
	return abook_opt_conff_get_val(section, key); 
}
		
void
init_options()
{
	abook_config = conff_new();

	if( rcfile_exist() )
		load_options();
	else
		default_options();
}

void
close_config()
{
	save_options();

	conff_free(&abook_config);
}

void
edit_options()
{
	/*
	 * not yet implemented
	 * edit your ~/.abook.conf manually
	 */
}

static int
rcfile_exist()
{
	return ( (0 == access(SYSWIDE_RCFILE, F_OK)) ||
			(0 == access(rcfile, F_OK)) );
}

void
load_options()
{
	int ret;
	
        if( (ret = conff_load_config(&abook_config, rcfile,
				CONFF_LOAD_DEFAULTS)) > 0) {
		fprintf(stderr, "%s: parse error at line %d\n", rcfile, ret);
		exit(1);
	}

	if( (ret = conff_load_config(&abook_config, SYSWIDE_RCFILE,
					CONFF_LOAD_NOREPLACE )) > 0) {
		fprintf(stderr, "%s: parse error at line %d\n",
				SYSWIDE_RCFILE, ret);
		exit(1);
	}
}

void
save_options()
{
	if( rcfile_exist() ) /* don't overwrite existing config */
		return;

	conff_save_file(abook_config, rcfile);
}

static void
default_options()
{
	conff_add_comment(&abook_config, "# " PACKAGE " configuration file");
	conff_add_comment(&abook_config, "# created by " PACKAGE " v " VERSION);

	conff_add_section(&abook_config, "datafile");
	conff_add_key_noreplace(&abook_config, "datafile", "autosave", "1");

	conff_add_section(&abook_config, "list");
	conff_add_key_noreplace(&abook_config, "list", "show_all_emails", "1");
	conff_add_key_noreplace(&abook_config, "list", "emailpos", "25");
	conff_add_key_noreplace(&abook_config, "list", "extra_column", "7");
	conff_add_key_noreplace(&abook_config, "list", "extrapos", "65");

	conff_add_section(&abook_config, "mutt");
	conff_add_key_noreplace(&abook_config, "mutt", "command", "mutt");
	conff_add_key_noreplace(&abook_config, "mutt", "return_all_emails", "1");
	conff_add_section(&abook_config, "print");
	conff_add_key_noreplace(&abook_config, "print", "command", "lpr");

	conff_add_section(&abook_config, "filesel");
	conff_add_key_noreplace(&abook_config, "filesel", "sort", "0");

	conff_add_section(&abook_config, "www");
	conff_add_key_noreplace(&abook_config, "www", "command", "lynx");

	conff_add_section(&abook_config, "address");
	conff_add_key_noreplace(&abook_config, "address", "style", "eu");
}
