/* AbiSource
 * 
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef _OD_XMLRECORDER_H_
#define _OD_XMLRECORDER_H_

// AbiWord includes
#include <ut_vector.h>


/**
 * Records XML data into data structures.
 * 
 * Useful for "replaying" a XML element, for example.
 */
class OD_XMLRecorder {
    
public:
    
    ~OD_XMLRecorder();
    
    void startElement (const XML_Char* pName, const XML_Char** ppAtts);
    void endElement (const XML_Char* pName);
    void charData (const XML_Char* pBuffer, int length);

    OD_XMLRecorder& operator=(const OD_XMLRecorder& rXMLRecorder);
    
    enum XMLCallType {
        XMLCallType_StartElement,
        XMLCallType_EndElement,
        XMLCallType_CharData
    };

    class XMLCall {
        public:
        XMLCall(XMLCallType type) : m_type(type) {}
        virtual ~XMLCall() {}
        
        XMLCallType getType() const {return m_type;}
        
        protected:
        XMLCallType m_type; // startElement, endElement or charData
    };
    
    class StartElementCall : public XMLCall {
        public:
        StartElementCall() : XMLCall(XMLCallType_StartElement) {}
        
        ~StartElementCall()
        {
            delete []m_pName;
            UT_uint32 i=0;
            while (m_ppAtts[i]!=0) {
                delete [](m_ppAtts[i]);
                i++;
            }
            delete [](m_ppAtts[i]);
            delete []m_ppAtts;
        }
        
        XML_Char* m_pName;
        XML_Char** m_ppAtts;
    };
    
    
    class EndElementCall : public XMLCall {
        public:
        EndElementCall() : XMLCall(XMLCallType_EndElement) {}
        
        ~EndElementCall() { delete []m_pName; }
        
        XML_Char* m_pName;
    };
    
    class CharDataCall : public XMLCall {
        public:
        
        CharDataCall() : XMLCall(XMLCallType_CharData) {}
        ~CharDataCall() { delete []m_pBuffer; }
        
        XML_Char* m_pBuffer;
        int m_length;
    };

    const XMLCall* getCall(UT_sint32 index) const {return m_XMLCalls[index];}
    UT_uint32 getCallCount() const {return m_XMLCalls.getItemCount(); }
    
    void clear();
private:

    UT_GenericVector<XMLCall*> m_XMLCalls;
    
};

#endif //_OD_XMLRECORDER_H_
