##############################################################################
# 
# Zope Public License (ZPL) Version 1.0
# -------------------------------------
# 
# Copyright (c) Digital Creations.  All rights reserved.
# 
# This license has been certified as Open Source(tm).
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# 1. Redistributions in source code must retain the above copyright
#    notice, this list of conditions, and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions, and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 
# 3. Digital Creations requests that attribution be given to Zope
#    in any manner possible. Zope includes a "Powered by Zope"
#    button that is installed by default. While it is not a license
#    violation to remove this button, it is requested that the
#    attribution remain. A significant investment has been put
#    into Zope, and this effort will continue if the Zope community
#    continues to grow. This is one way to assure that growth.
# 
# 4. All advertising materials and documentation mentioning
#    features derived from or use of this software must display
#    the following acknowledgement:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    In the event that the product being advertised includes an
#    intact Zope distribution (with copyright and license included)
#    then this clause is waived.
# 
# 5. Names associated with Zope or Digital Creations must not be used to
#    endorse or promote products derived from this software without
#    prior written permission from Digital Creations.
# 
# 6. Modified redistributions of any form whatsoever must retain
#    the following acknowledgment:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    Intact (re-)distributions of any official Zope release do not
#    require an external acknowledgement.
# 
# 7. Modifications are encouraged but must be packaged separately as
#    patches to official Zope releases.  Distributions that do not
#    clearly separate the patches from the original work must be clearly
#    labeled as unofficial distributions.  Modifications which do not
#    carry the name Zope may be packaged in any form, as long as they
#    conform to all of the clauses above.
# 
# 
# Disclaimer
# 
#   THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS ``AS IS'' AND ANY
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL CREATIONS OR ITS
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#   SUCH DAMAGE.
# 
# 
# This software consists of contributions made by Digital Creations and
# many individuals on behalf of Digital Creations.  Specific
# attributions are listed in the accompanying credits file.
# 
##############################################################################

def manage_addImage(id, file, title='', precondition='', content_type=''):
    """

    Add a new Image object.

    Creates a new Image object 'id' with the contents of 'file'.

    """



class Image:
    """
    An Image is a Zope object that contains image content.  An Image
    object can be used to upload or download image information with
    Zope.

    Image objects have two properties the define their dimension,
    'height' and 'width'. These are calculated when the image is
    uploaded. For image types that Zope does not understand, these
    properties may be undefined.

    Using a Image object in Zope is easy.  The most common usage is
    to display the contents of an image object in a web page.  This
    is done by simply referencing the object from DTML::

      <dtml-var standard_html_header>
        <dtml-var ImageObject>
      <dtml-var standard_html_footer>

    This will generate an HTML IMG tag referencing the URL to the
    Image. This is equivalent to::

      <dtml-var standard_html_header>
        <dtml-with ImageObject>
          <img src="<dtml-var absolute_url>">
        </dtml-with>
      <dtml-var standard_html_footer>

    You can control the image display more precisely with the 'tag'
    method. For example::

      <dtml-var "ImageObject.tag(border='5', align='left')">
    
    """

    __constructor__=manage_addImage

    __extends__=('OFSP.File.File',)

    def tag(height=None, width=None, alt=None,
            scale=0, xscale=0, yscale=0, **args):
        """
        This method returns a string which contains an HTML IMG tag
        reference to the image.
        
        Optionally, the 'height', 'width', 'alt', 'scale', 'xscale'
        and 'yscale' arguments can be provided which are turned into
        HTML IMG tag attributes. Note, 'height' and 'width' are
        provided by default, and 'alt' comes from the 'title_or_id'
        method.
        
        Keyword arguments may be provided to support other or future IMG
        tag attributes.  The one exception to this is the HTML Cascading
        Style Sheet tag 'class'.  Because the word 'class' is a reserved
        keyword in Python, you must instead use the keyword argument
        'css_class'.  This will be turned into a 'class' HTML tag attribute
        on the rendered 'img' tag.

        Permission -- 'View'
        """







