##############################################################################
# 
# Zope Public License (ZPL) Version 1.0
# -------------------------------------
# 
# Copyright (c) Digital Creations.  All rights reserved.
# 
# This license has been certified as Open Source(tm).
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# 1. Redistributions in source code must retain the above copyright
#    notice, this list of conditions, and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions, and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 
# 3. Digital Creations requests that attribution be given to Zope
#    in any manner possible. Zope includes a "Powered by Zope"
#    button that is installed by default. While it is not a license
#    violation to remove this button, it is requested that the
#    attribution remain. A significant investment has been put
#    into Zope, and this effort will continue if the Zope community
#    continues to grow. This is one way to assure that growth.
# 
# 4. All advertising materials and documentation mentioning
#    features derived from or use of this software must display
#    the following acknowledgement:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    In the event that the product being advertised includes an
#    intact Zope distribution (with copyright and license included)
#    then this clause is waived.
# 
# 5. Names associated with Zope or Digital Creations must not be used to
#    endorse or promote products derived from this software without
#    prior written permission from Digital Creations.
# 
# 6. Modified redistributions of any form whatsoever must retain
#    the following acknowledgment:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    Intact (re-)distributions of any official Zope release do not
#    require an external acknowledgement.
# 
# 7. Modifications are encouraged but must be packaged separately as
#    patches to official Zope releases.  Distributions that do not
#    clearly separate the patches from the original work must be clearly
#    labeled as unofficial distributions.  Modifications which do not
#    carry the name Zope may be packaged in any form, as long as they
#    conform to all of the clauses above.
# 
# 
# Disclaimer
# 
#   THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS ``AS IS'' AND ANY
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL CREATIONS OR ITS
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#   SUCH DAMAGE.
# 
# 
# This software consists of contributions made by Digital Creations and
# many individuals on behalf of Digital Creations.  Specific
# attributions are listed in the accompanying credits file.
# 
##############################################################################
"""Provide a Main application for the Zope framework

The Job of this module is to:

 - Configure and open the database

 - Establish the top-level object for ZPublisher

 - Perform very high-level configuration tasks

"""

# We import BoboPOS before importing any other application
# modules.  This is needed to assure that the right
# versions of Persistent etc get registered.
from BoboPOS import SimpleDB, TJar, SingleThreadedTransaction

import sys, os, string, Globals, OFS.Application
Globals.BobobaseName = os.path.join(Globals.data_dir, 'Data.bbb')
Globals.DatabaseVersion='2'

# Setup support for broken objects:
import OFS.Uninstalled, BoboPOS.PickleJar
BoboPOS.PickleJar.PickleJar.Broken=OFS.Uninstalled.Broken

# Open the application database
OFS.Application.import_products()
revision=read_only=None
if os.environ.has_key('ZOPE_READ_ONLY'):
    read_only=1
    try: 
        from DateTime import DateTime
        revision=DateTime(os.environ['ZOPE_READ_ONLY']).timeTime()
    except: pass
        
Bobobase=Globals.Bobobase=BoboPOS.PickleDictionary(
    Globals.BobobaseName, read_only=read_only, revision=revision)
Globals.opened.append(Bobobase)
VersionBase=Globals.VersionBase=TJar.TM(Bobobase)
Globals.opened.append(VersionBase)

try: app=Bobobase['Application']
except KeyError:
    app=OFS.Application.Application()
    Bobobase['Application']=app
    get_transaction().note('created Application object')
    get_transaction().commit()

bobo_application=app

OFS.Application.initialize(app)

if os.environ.has_key('ZOPE_DATABASE_QUOTA'):
    quota=string.atoi(os.environ['ZOPE_DATABASE_QUOTA'])
    Bobobase._jar.db.set_quota(
        lambda x, quota=quota, otherdb=VersionBase.TDB:
        x + otherdb.pos > quota)
    VersionBase.TDB.set_quota(
        lambda x, quota=quota, otherdb=Bobobase._jar.db:
        x + otherdb.pos > quota)

SingleThreadedTransaction.Transaction.commit=VersionBase.committer()

__bobo_debug_mode__=Globals.DevelopmentMode
