import os, sys
if __name__ == '__main__': execfile(os.path.join(sys.path[0], 'framework.py'))
from Testing import ZopeTestCase
from support import *
ZopeTestCase.installProduct('ZCatalog')
ZopeTestCase.installProduct('ZWiki')

def setupPageHierarchy(self):
    # set up some hierarchy
    self.page.create('RootPage')
    self.wiki.RootPage.reparent(REQUEST=self.request)
    self.wiki.RootPage.create('ChildPage')
    self.wiki.ChildPage.create('GrandChildPage')
    self.page.create('SingletonPage')
    self.wiki.SingletonPage.reparent(REQUEST=self.request)

class ParentsTests(ZopeTestCase.ZopeTestCase):
    def afterSetUp(self):
        zwikiAfterSetUp(self)
        setupPageHierarchy(self)
        
    def test_context(self):
        self.assertEquals(self.wiki.RootPage.context(),
                          '&nbsp;') # XXX should be as below I think
        self.assertEquals(self.wiki.RootPage.context(with_siblings=1),
                          '<small><ul>\n <li><a href="http://nohost/test_folder_1_/wiki/RootPage" name="RootPage">RootPage</a> <b><-- You are here.</b> ...\n</ul>\n</small>'
                          )
        self.assertEquals(self.wiki.ChildPage.context(),
                          '<small><ul>\n <li><a href="http://nohost/test_folder_1_/wiki/RootPage" name="RootPage">RootPage</a>\n<ul>\n <li><a href="http://nohost/test_folder_1_/wiki/ChildPage" name="ChildPage">ChildPage</a> <b><-- You are here.</b>\n</ul>\n</ul>\n</small>'
                          )
        self.assertEquals(self.wiki.ChildPage.context(with_siblings=1),
                          '<small><ul>\n <li><a href="http://nohost/test_folder_1_/wiki/RootPage" name="RootPage">RootPage</a>\n<ul>\n  <li><a href="http://nohost/test_folder_1_/wiki/ChildPage" name="ChildPage">ChildPage</a> <b><-- You are here.</b>\n<ul>\n  <li><a href="http://nohost/test_folder_1_/wiki/GrandChildPage" name="GrandChildPage">GrandChildPage</a>\n</ul>\n</ul>\n</ul>\n</small>'
                          )
        
    def test_reparent(self):
        p = self.wiki.SingletonPage
        self.wiki.RootPage.create('Parent Page')
        self.wiki.RootPage.create('Parent Page 2')
        self.wiki.RootPage.create('Parent Page 3')
        # no args clears parents
        p.parents = ['old']
        p.reparent(REQUEST=self.request)
        self.assertEquals(p.parents,[])
        # invalid page names are stripped
        p.reparent(parents=['nosuchpage'],REQUEST=self.request)
        self.assertEquals(p.parents,[])
        # reparent by id, leaves title in parents
        p.reparent(parents=['ParentPage'],REQUEST=self.request)
        self.assertEquals(p.parents,['Parent Page'])
        # reparent by fuzzy name
        p.reparent(parents=[' Parent page 2..'],REQUEST=self.request)
        self.assertEquals(p.parents,['Parent Page 2'])
        # reparent by freeform name, as string
        p.reparent(parents='Parent Page 3',REQUEST=self.request)
        self.assertEquals(p.parents,['Parent Page 3'])
        # duplicates are removed
        p.reparent(parents=['ParentPage','Parent Page','parent-page'],
                   REQUEST=self.request)
        self.assertEquals(p.parents,['Parent Page'])

    def test_getWikiParentInfo(self):
        wpi = self.wiki.TestPage.getWikiParentInfo()
        parentmap,childmap,roots = wpi.parentmap,wpi.childmap,wpi.roots
        wpi2 = self.wiki.ChildPage.getWikiParentInfo()
        parentmap2,childmap2,roots2 = wpi2.parentmap,wpi2.childmap,wpi2.roots
        self.assertEquals(parentmap,parentmap2)
        self.assertEquals(childmap,childmap2)
        self.assertEquals(roots,roots2)
        self.assertEquals(len(parentmap.keys()),5)
        self.assertEquals(parentmap['TestPage'],[])
        self.assertEquals(parentmap['RootPage'],[])
        self.assertEquals(parentmap['ChildPage'],['RootPage'])
        self.assertEquals(parentmap['GrandChildPage'],['ChildPage'])
        self.assertEquals(parentmap['SingletonPage'],[])
        self.assertEquals(len(childmap.keys()),5)
        self.assertEquals(childmap['TestPage'],[])
        self.assertEquals(childmap['RootPage'],['ChildPage'])
        self.assertEquals(childmap['ChildPage'],['GrandChildPage'])
        self.assertEquals(childmap['GrandChildPage'],[])
        self.assertEquals(childmap['SingletonPage'],[])
        self.assertEquals(len(roots.keys()),3)
        self.assert_(roots.has_key('TestPage'))
        self.assert_(roots.has_key('RootPage'))
        self.assert_(roots.has_key('SingletonPage'))

    def test_offspringIdsAsList(self):
        self.assertEquals(self.wiki.RootPage.offspringIdsAsList(),
                          ['ChildPage','GrandChildPage'])
        self.assertEquals(self.wiki.ChildPage.offspringIdsAsList(),
                          ['GrandChildPage'])
        self.assertEquals(self.wiki.GrandChildPage.offspringIdsAsList(),
                          [])

if __name__ == '__main__':
    framework(descriptions=1, verbosity=2)
else:
    import unittest
    def test_suite():
        suite = unittest.TestSuite()
        suite.addTest(unittest.makeSuite(ParentsTests))
        return suite
