/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.datatype.NOTATIONDatatypeValidator;
import org.apache.xerces.validators.datatype.UnionDatatypeValidator;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SchemaMessageProvider;
import org.apache.xerces.validators.schema.XUtil;
import org.apache.xerces.validators.schema.identity.Field;
import org.apache.xerces.validators.schema.identity.IdentityConstraint;
import org.apache.xerces.validators.schema.identity.Key;
import org.apache.xerces.validators.schema.identity.KeyRef;
import org.apache.xerces.validators.schema.identity.Selector;
import org.apache.xerces.validators.schema.identity.Unique;
import org.apache.xerces.validators.schema.identity.XPath;
import org.apache.xerces.validators.schema.identity.XPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class TraverseSchema
implements NamespacesScope.NamespacesHandler {
    private static final int TOP_LEVEL_SCOPE = -1;
    private static final String[] IDENTITY_CONSTRAINTS = new String[]{"unique", "key", "keyref"};
    private static final String redefIdentifier = "#redefined";
    private static final boolean DEBUGGING = false;
    private static final boolean DEBUG_IDENTITY_CONSTRAINTS = false;
    private static final boolean DEBUG_IC_DATATYPES = false;
    private static final boolean DEBUG_UNION = false;
    private static final boolean CR_IMPL = true;
    private XMLErrorReporter fErrorReporter = null;
    private StringPool fStringPool = null;
    private GrammarResolver fGrammarResolver = null;
    private SchemaGrammar fSchemaGrammar = null;
    private Element fSchemaRootElement;
    private SchemaInfo fSchemaInfoListRoot = null;
    private SchemaInfo fCurrentSchemaInfo = null;
    private boolean fRedefineSucceeded;
    private DatatypeValidatorFactoryImpl fDatatypeRegistry = null;
    private Hashtable fComplexTypeRegistry = new Hashtable();
    private Hashtable fAttributeDeclRegistry = new Hashtable();
    private Hashtable fGroupNameRegistry = new Hashtable();
    private Hashtable fNotationRegistry = new Hashtable();
    private Vector fIncludeLocations = new Vector();
    private Vector fImportLocations = new Vector();
    private Hashtable fRedefineLocations = new Hashtable();
    private Vector fTraversedRedefineElements = new Vector();
    private int fAnonTypeCount = 0;
    private int fScopeCount = 0;
    private int fCurrentScope = -1;
    private int fSimpleTypeAnonCount = 0;
    private Stack fCurrentTypeNameStack = new Stack();
    private Hashtable fElementRecurseComplex = new Hashtable();
    private boolean fElementDefaultQualified = false;
    private boolean fAttributeDefaultQualified = false;
    private int fTargetNSURI;
    private String fTargetNSURIString = "";
    private NamespacesScope fNamespacesScope = null;
    private String fCurrentSchemaURL = "";
    private XMLAttributeDecl fTempAttributeDecl = new XMLAttributeDecl();
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    private EntityResolver fEntityResolver = null;
    private Hashtable fIdentityConstraints = new Hashtable();
    public static final String SchemaForSchemaURI = "http://www.w3.org/TR-1/Schema";

    private TraverseSchema() {
    }

    public TraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver) throws Exception {
        this.doTraverseSchema(element, stringPool, schemaGrammar, grammarResolver);
    }

    public TraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver, XMLErrorReporter xMLErrorReporter, String string) throws Exception {
        this.fErrorReporter = xMLErrorReporter;
        this.fCurrentSchemaURL = string;
        this.doTraverseSchema(element, stringPool, schemaGrammar, grammarResolver);
    }

    public TraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver, XMLErrorReporter xMLErrorReporter, String string, EntityResolver entityResolver) throws Exception {
        this.fErrorReporter = xMLErrorReporter;
        this.fCurrentSchemaURL = string;
        this.fEntityResolver = entityResolver;
        this.doTraverseSchema(element, stringPool, schemaGrammar, grammarResolver);
    }

    static /* synthetic */ Element access$8(TraverseSchema traverseSchema) {
        return traverseSchema.fSchemaRootElement;
    }

    private int addAttributeDeclFromAnotherSchema(String string, String string2, ComplexTypeInfo complexTypeInfo) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #addAttributeDeclFromAnotherSchema, schema uri : " + string2);
            return -1;
        }
        Hashtable hashtable = schemaGrammar.getAttirubteDeclRegistry();
        if (hashtable == null) {
            this.reportGenericSchemaError("no attribute was defined in schema : " + string2);
            return -1;
        }
        XMLAttributeDecl xMLAttributeDecl = (XMLAttributeDecl)hashtable.get(string);
        if (xMLAttributeDecl == null) {
            this.reportGenericSchemaError("no attribute named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        if (complexTypeInfo != null) {
            this.fSchemaGrammar.addAttDef(complexTypeInfo.templateElementIndex, xMLAttributeDecl.name, xMLAttributeDecl.type, -1, xMLAttributeDecl.defaultType, xMLAttributeDecl.defaultValue, xMLAttributeDecl.datatypeValidator, xMLAttributeDecl.list);
        }
        return 0;
    }

    private int allCalc(int[] nArray, int n, int n2, int n3, int[] nArray2, int n4) throws Exception {
        if (nArray.length - n2 - n == 1) {
            int[] nArray3 = new int[n2 + n];
            int n5 = n;
            while (n5 < nArray.length) {
                this.arrayProducer(nArray, n5, nArray3, nArray2, n3);
                int n6 = this.allCalcWrapper(nArray3, nArray3.length);
                int n7 = this.allCalcWrapper(nArray2, nArray2.length);
                int n8 = this.fSchemaGrammar.addContentSpecNode(5, n6, n7, false);
                n4 = n4 != -2 ? this.fSchemaGrammar.addContentSpecNode(4, n4, n8, false) : n8;
                ++n5;
            }
            return n4;
        }
        int n9 = n;
        while (n9 < nArray.length) {
            int[] nArray4 = new int[nArray.length - 1];
            this.arrayProducer(nArray, n9, nArray4, nArray2, n3);
            n4 = this.allCalc(nArray4, n, n2, n3 + 1, nArray2, n4);
            ++n;
            --n2;
            ++n9;
        }
        return n4;
    }

    private int allCalcWrapper(int[] nArray, int n) throws Exception {
        int n2 = n / 2;
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        if (nArray2.length == 1) {
            return nArray2[0];
        }
        if (nArray2.length < 1) {
            return -2;
        }
        if (n2 > nArray2.length) {
            this.reportGenericSchemaError("The size of the permutations " + n2 + " cannot be greater than the length of the array to be permuted; error in processing of <all>!");
            return -2;
        }
        if (nArray2.length <= 3) {
            return this.allCombo(nArray2);
        }
        return this.allCalc(nArray2, 0, n2, 0, new int[nArray2.length - n2], -2);
    }

    private int allCombo(int[] nArray) throws Exception {
        if (nArray.length == 2) {
            int[] nArray2 = new int[]{nArray[0], nArray[1]};
            int[] nArray3 = new int[]{nArray[1], nArray[0]};
            int n = this.createSeq(nArray2);
            int n2 = this.createSeq(nArray3);
            return this.fSchemaGrammar.addContentSpecNode(4, n, n2, false);
        }
        if (nArray.length == 3) {
            int[] nArray4 = new int[]{nArray[0], nArray[1], nArray[2]};
            int[] nArray5 = new int[]{nArray[0], nArray[2], nArray[1]};
            int[] nArray6 = new int[]{nArray[1], nArray[0], nArray[2]};
            int[] nArray7 = new int[]{nArray[1], nArray[2], nArray[0]};
            int[] nArray8 = new int[]{nArray[2], nArray[1], nArray[0]};
            int[] nArray9 = new int[]{nArray[2], nArray[0], nArray[1]};
            int n = this.createSeq(nArray4);
            int n3 = this.createSeq(nArray5);
            int n4 = this.createSeq(nArray6);
            int n5 = this.createSeq(nArray7);
            int n6 = this.createSeq(nArray8);
            int n7 = this.createSeq(nArray9);
            int n8 = this.fSchemaGrammar.addContentSpecNode(4, n, n3, false);
            n8 = this.fSchemaGrammar.addContentSpecNode(4, n8, n4, false);
            n8 = this.fSchemaGrammar.addContentSpecNode(4, n8, n5, false);
            n8 = this.fSchemaGrammar.addContentSpecNode(4, n8, n6, false);
            return this.fSchemaGrammar.addContentSpecNode(4, n8, n7, false);
        }
        return -2;
    }

    private void arrayProducer(int[] nArray, int n, int[] nArray2, int[] nArray3, int n2) {
        nArray3[n2] = nArray[n];
        if (n > 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        if (n < nArray.length - 1) {
            System.arraycopy(nArray, n + 1, nArray2, n, nArray.length - n - 1);
        }
    }

    private boolean baseFromAnotherSchema(QName qName) throws Exception {
        String string = this.fStringPool.toString(qName.uri);
        return !string.equals(this.fTargetNSURIString) && !string.equals("http://www.w3.org/2000/10/XMLSchema") && string.length() != 0;
    }

    private int changeRedefineGroup(QName qName, String string, String string2, Element element) throws Exception {
        int n = 0;
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string3 = element2.getLocalName();
            if (!string3.equals(string)) {
                n += this.changeRedefineGroup(qName, string, string2, element2);
            } else {
                String string4 = element2.getAttribute("ref");
                if (!string4.equals("")) {
                    String string5 = "";
                    String string6 = string4;
                    int n2 = string4.indexOf(":");
                    if (n2 > 0) {
                        string5 = string4.substring(0, n2);
                        string6 = string4.substring(n2 + 1);
                    }
                    String string7 = this.resolvePrefixToURI(string5);
                    if (qName.equals(new QName(-1, this.fStringPool.addSymbol(string6), this.fStringPool.addSymbol(string6), this.fStringPool.addSymbol(string7)))) {
                        if (string5.equals("")) {
                            element2.setAttribute("ref", string2);
                        } else {
                            element2.setAttribute("ref", String.valueOf(string5) + ":" + string2);
                        }
                        ++n;
                    }
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        return n;
    }

    private Element checkContent(Element element, Element element2, boolean bl) throws Exception {
        if (element2 == null) {
            if (!bl) {
                this.reportSchemaError(25, new Object[]{element.getAttribute("name")});
            }
            return null;
        }
        if (element2.getLocalName().equals("annotation")) {
            this.traverseAnnotationDecl(element2);
            element2 = XUtil.getNextSiblingElement(element2);
            if (element2 == null) {
                if (!bl) {
                    this.reportSchemaError(25, new Object[]{element.getAttribute("name")});
                }
                return null;
            }
            if (element2.getLocalName().equals("annotation")) {
                this.reportSchemaError(26, new Object[]{element.getAttribute("name")});
                return null;
            }
        }
        return element2;
    }

    private void checkParticleDerivationOK(Element element, Element element2) {
    }

    private void checkRecursingComplexType() throws Exception {
        if (this.fCurrentTypeNameStack.empty() && !this.fElementRecurseComplex.isEmpty()) {
            Enumeration enumeration = this.fElementRecurseComplex.keys();
            while (enumeration.hasMoreElements()) {
                QName qName = (QName)enumeration.nextElement();
                String string = (String)this.fElementRecurseComplex.get(qName);
                int n = qName.uri;
                int n2 = qName.localpart;
                int n3 = qName.prefix;
                ComplexTypeInfo complexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(String.valueOf(this.fTargetNSURIString) + "," + string);
                if (complexTypeInfo == null) {
                    throw new Exception("Internal Error in void checkRecursingComplexType(). ");
                }
                int n4 = this.fSchemaGrammar.addElementDecl(new QName(-1, n2, n2, n), n3, complexTypeInfo.scopeDefined, complexTypeInfo.contentType, complexTypeInfo.contentSpecHandle, complexTypeInfo.attlistHead, complexTypeInfo.datatypeValidator);
                this.fSchemaGrammar.setElementComplexTypeInfo(n4, complexTypeInfo);
            }
            this.fElementRecurseComplex.clear();
        }
    }

    private void checkSubstitutionGroupOK(Element element, Element element2) {
    }

    private void checkTopLevelDuplicateNames(Element element) {
    }

    private int createSeq(int[] nArray) throws Exception {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = 2;
        while (n3 < nArray.length) {
            n = this.fSchemaGrammar.addContentSpecNode(5, n, n2, false);
            n2 = nArray[n3];
            ++n3;
        }
        return this.fSchemaGrammar.addContentSpecNode(5, n, n2, false);
    }

    public void doTraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.fNamespacesScope = new NamespacesScope(this);
        this.fSchemaRootElement = element;
        this.fStringPool = stringPool;
        this.fSchemaGrammar = schemaGrammar;
        this.fGrammarResolver = grammarResolver;
        this.fDatatypeRegistry = (DatatypeValidatorFactoryImpl)this.fGrammarResolver.getDatatypeRegistry();
        this.fDatatypeRegistry.expandRegistryToFullSchemaSet();
        if (element == null) {
            return;
        }
        String string = element.getPrefix();
        if ((string == null || string.length() == 0) && ((String)(object4 = element.getAttribute("xmlns"))).length() == 0) {
            element.setAttribute("xmlns", "http://www.w3.org/2000/10/XMLSchema");
        }
        this.fTargetNSURIString = element.getAttribute("targetNamespace");
        if (this.fTargetNSURIString == null) {
            this.fTargetNSURIString = "";
        }
        this.fTargetNSURI = this.fStringPool.addSymbol(this.fTargetNSURIString);
        if (this.fGrammarResolver == null) {
            this.reportGenericSchemaError("Internal error: don't have a GrammarResolver for TraverseSchema");
        } else {
            if (this.fSchemaGrammar.getComplexTypeRegistry() == null) {
                this.fSchemaGrammar.setComplexTypeRegistry(this.fComplexTypeRegistry);
            } else {
                this.fComplexTypeRegistry = this.fSchemaGrammar.getComplexTypeRegistry();
            }
            if (this.fSchemaGrammar.getAttirubteDeclRegistry() == null) {
                this.fSchemaGrammar.setAttributeDeclRegistry(this.fAttributeDeclRegistry);
            } else {
                this.fAttributeDeclRegistry = this.fSchemaGrammar.getAttirubteDeclRegistry();
            }
            if (this.fSchemaGrammar.getNamespacesScope() == null) {
                this.fSchemaGrammar.setNamespacesScope(this.fNamespacesScope);
            } else {
                this.fNamespacesScope = this.fSchemaGrammar.getNamespacesScope();
            }
            this.fSchemaGrammar.setDatatypeRegistry(this.fDatatypeRegistry);
            this.fSchemaGrammar.setTargetNamespaceURI(this.fTargetNSURIString);
            this.fGrammarResolver.putGrammar(this.fTargetNSURIString, this.fSchemaGrammar);
        }
        object4 = element.getAttributes();
        int n = 0;
        Attr attr = null;
        boolean bl = false;
        while ((attr = (Attr)object4.item(n++)) != null) {
            object3 = attr.getName();
            if (((String)object3).startsWith("xmlns:")) {
                object2 = attr.getValue();
                object = ((String)object3).substring(((String)object3).indexOf(":") + 1);
                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol((String)object), this.fStringPool.addSymbol((String)object2));
            }
            if (!((String)object3).equals("xmlns")) continue;
            object2 = attr.getValue();
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol((String)object2));
            bl = true;
        }
        if (!bl && this.fTargetNSURIString.length() == 0) {
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(""));
        }
        this.fElementDefaultQualified = element.getAttribute("elementFormDefault").equals("qualified");
        this.fAttributeDefaultQualified = element.getAttribute("attributeFormDefault").equals("qualified");
        this.fCurrentScope = -1;
        this.checkTopLevelDuplicateNames(element);
        this.extractTopLevel3Components(element);
        object3 = XUtil.getFirstChildElement(element);
        while (object3 != null) {
            object2 = object3.getLocalName();
            if (((String)object2).equals("annotation")) {
                this.traverseAnnotationDecl((Element)object3);
            } else if (((String)object2).equals("include")) {
                this.traverseInclude((Element)object3);
            } else if (((String)object2).equals("import")) {
                this.traverseImport((Element)object3);
            } else {
                if (!((String)object2).equals("redefine")) break;
                this.fRedefineSucceeded = true;
                this.traverseRedefine((Element)object3);
            }
            object3 = XUtil.getNextSiblingElement((Node)object3);
        }
        while (object3 != null) {
            object2 = object3.getLocalName();
            if (((String)object2).equals("annotation")) {
                this.traverseAnnotationDecl((Element)object3);
            } else if (((String)object2).equals("simpleType")) {
                this.traverseSimpleTypeDecl((Element)object3);
            } else if (((String)object2).equals("complexType")) {
                this.traverseComplexTypeDecl((Element)object3);
            } else if (((String)object2).equals("element")) {
                this.traverseElementDecl((Element)object3);
            } else if (((String)object2).equals("attributeGroup")) {
                this.traverseAttributeGroupDecl((Element)object3, null, null);
            } else if (((String)object2).equals("attribute")) {
                this.traverseAttributeDecl((Element)object3, null, false);
            } else if (((String)object2).equals("group")) {
                this.traverseGroupDecl((Element)object3);
            } else if (((String)object2).equals("notation")) {
                this.traverseNotationDecl((Element)object3);
            } else {
                this.reportGenericSchemaError("error in content of <schema> element information item");
            }
            object3 = XUtil.getNextSiblingElement((Node)object3);
        }
        object2 = this.fIdentityConstraints.keys();
        while (object2.hasMoreElements()) {
            object = (Integer)object2.nextElement();
            Vector vector = (Vector)this.fIdentityConstraints.get(object);
            if (vector == null) continue;
            int n2 = (Integer)object;
            this.traverseIdentityConstraintsFor(n2, vector);
        }
    }

    public void endNamespaceDeclScope(int n) {
    }

    private int expandContentModel(int n, Element element) throws Exception {
        block21: {
            String string = element.getAttribute("minOccurs").trim();
            String string2 = element.getAttribute("maxOccurs").trim();
            int n2 = 1;
            int n3 = 1;
            if (string.equals("0") && string2.equals("0")) {
                return -2;
            }
            if (string.equals("")) {
                string = "1";
            }
            if (string2.equals("")) {
                string2 = "1";
            }
            int n4 = n;
            if (string.equals("1") && string2.equals("1")) break block21;
            if (string.equals("0") && string2.equals("1")) {
                n = this.fSchemaGrammar.addContentSpecNode(1, n, -1, false);
            } else if (string.equals("0") && string2.equals("unbounded")) {
                n = this.fSchemaGrammar.addContentSpecNode(2, n, -1, false);
            } else if (string.equals("1") && string2.equals("unbounded")) {
                n = this.fSchemaGrammar.addContentSpecNode(3, n, -1, false);
            } else if (string2.equals("unbounded")) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    this.reportSchemaError(23, new Object[]{"illegal value for minOccurs : '" + exception.getMessage() + "' "});
                }
                n = this.fSchemaGrammar.addContentSpecNode(3, n, -1, false);
                int n5 = 0;
                while (n5 < n2 - 1) {
                    n = this.fSchemaGrammar.addContentSpecNode(5, n4, n, false);
                    ++n5;
                }
            } else {
                try {
                    n2 = Integer.parseInt(string);
                    n3 = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    this.reportSchemaError(23, new Object[]{"illegal value for minOccurs or maxOccurs : '" + exception.getMessage() + "' "});
                }
                if (n2 == 0) {
                    int n6;
                    n = n6 = this.fSchemaGrammar.addContentSpecNode(1, n4, -1, false);
                    int n7 = 0;
                    while (n7 < n3 - n2 - 1) {
                        n = this.fSchemaGrammar.addContentSpecNode(5, n, n6, false);
                        ++n7;
                    }
                } else {
                    int n8 = 0;
                    while (n8 < n2 - 1) {
                        n = this.fSchemaGrammar.addContentSpecNode(5, n, n4, false);
                        ++n8;
                    }
                    int n9 = this.fSchemaGrammar.addContentSpecNode(1, n4, -1, false);
                    int n10 = 0;
                    while (n10 < n3 - n2) {
                        n = this.fSchemaGrammar.addContentSpecNode(5, n, n9, false);
                        ++n10;
                    }
                }
            }
        }
        return n;
    }

    private String expandSystemId(String string, String string2) throws Exception {
        URL uRL;
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            return string;
        }
        try {
            uRL = new URL(string3);
            if (uRL != null) {
                return string;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        string3 = TraverseSchema.fixURI(string3);
        uRL = null;
        URL uRL2 = null;
        try {
            if (string2 == null) {
                String string4;
                try {
                    string4 = TraverseSchema.fixURI(System.getProperty("user.dir"));
                }
                catch (SecurityException securityException) {
                    string4 = "";
                }
                if (!string4.endsWith("/")) {
                    string4 = String.valueOf(string4) + "/";
                }
                uRL = new URL("file", "", string4);
            } else {
                uRL = new URL(string2);
            }
            uRL2 = new URL(uRL, string3);
        }
        catch (Exception exception) {}
        if (uRL2 == null) {
            return string;
        }
        return uRL2.toString();
    }

    private void extractTopLevel3Components(Element element) {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string = element2.getLocalName();
            String string2 = element2.getAttribute("name");
            if (string.equals("attributeGroup")) {
                this.fSchemaGrammar.topLevelAttrGrpDecls.put(string2, element2);
            } else if (string.equals("attribute")) {
                this.fSchemaGrammar.topLevelAttrDecls.put(string2, element2);
            } else if (string.equals("group")) {
                this.fSchemaGrammar.topLevelGroupDecls.put(string2, element2);
            } else if (string.equals("notation")) {
                this.fSchemaGrammar.topLevelNotationDecls.put(string2, element2);
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
    }

    private Element findAttributeSimpleType(Element element) throws Exception {
        Element element2 = XUtil.getFirstChildElement(element);
        if (element2 == null) {
            return null;
        }
        if (element2.getLocalName().equals("simpleType")) {
            return element2;
        }
        if (element2.getLocalName().equals("annotation")) {
            this.traverseAnnotationDecl(element2);
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (element2 == null) {
            return null;
        }
        if (element2.getLocalName().equals("simpleType") && XUtil.getNextSiblingElement(element2) == null) {
            return element2;
        }
        this.reportGenericSchemaError("An attribute declaration must contain at most one annotation preceding at most one simpleType");
        return null;
    }

    private DatatypeValidator findDTValidator(Element element, String string) throws Exception {
        Element element2;
        String string2;
        int n = this.fStringPool.addSymbol(string);
        String string3 = "";
        DatatypeValidator datatypeValidator = null;
        String string4 = string;
        int n2 = string.indexOf(":");
        if (n2 > 0) {
            string3 = string.substring(0, n2);
            string4 = string.substring(n2 + 1);
        }
        if ((datatypeValidator = this.getDatatypeValidator(string2 = this.resolvePrefixToURI(string3), string4)) == null && (element2 = this.getTopLevelComponentByName("simpleType", string4)) != null) {
            this.traverseSimpleTypeDecl(element2);
            datatypeValidator = this.getDatatypeValidator(string2, string4);
        }
        if (datatypeValidator == null) {
            this.reportSchemaError(15, new Object[]{element.getAttribute("base"), element.getAttribute("name")});
        }
        return datatypeValidator;
    }

    private void fixRedefinedSchema(String string, String string2, String string3, Element element, SchemaInfo schemaInfo) throws Exception {
        boolean bl = false;
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            Object object;
            String string4 = element2.getLocalName();
            if (string4.equals("redefine")) {
                object = XUtil.getFirstChildElement(element2);
                while (object != null) {
                    String string5;
                    String string6 = object.getLocalName();
                    if (string6.equals(string) && (string5 = object.getAttribute("name")).equals(string2)) {
                        bl = true;
                        this.openRedefinedSchema(element2, schemaInfo);
                        if (!this.fRedefineSucceeded) {
                            return;
                        }
                        if (this.validateRedefineNameChange(string, string2, String.valueOf(string3) + redefIdentifier, (Element)object) && schemaInfo.getNext() != null) {
                            this.fixRedefinedSchema(string, string2, String.valueOf(string3) + redefIdentifier, this.fSchemaRootElement, schemaInfo.getNext());
                        }
                        object.setAttribute("name", string3);
                        this.fTraversedRedefineElements.addElement(string3);
                        schemaInfo.restore();
                        this.fCurrentSchemaInfo = schemaInfo;
                        break;
                    }
                    object = XUtil.getNextSiblingElement((Node)object);
                }
                if (bl) {
                    break;
                }
            } else if (string4.equals(string) && ((String)(object = element2.getAttribute("name"))).equals(string2)) {
                bl = true;
                element2.setAttribute("name", string3);
                break;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (!bl) {
            this.fRedefineSucceeded = false;
            this.reportGenericSchemaError("could not find a declaration in the schema to be redefined corresponding to " + string2);
        }
    }

    private static String fixURI(String string) {
        char c;
        char c2;
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2 && (c2 = string.charAt(1)) == ':' && (c = Character.toUpperCase(string.charAt(0))) >= 'A' && c <= 'Z') {
            string = "/" + string;
        }
        return string;
    }

    private String genAnonTypeName(Element element) throws Exception {
        String string;
        if (this.fCurrentTypeNameStack.empty()) {
            string = "#" + this.fAnonTypeCount++;
        } else {
            int n;
            String string2 = ((Element)element.getParentNode()).getAttribute("name");
            string = String.valueOf(string2) + "_AnonType";
            int n2 = n = this.fCurrentTypeNameStack.size() - 1;
            while (n2 > -1) {
                String string3 = (String)this.fCurrentTypeNameStack.elementAt(n2);
                string = String.valueOf(string3) + "_" + string;
                if (!string3.startsWith("#")) break;
                --n2;
            }
            string = "#" + string;
        }
        return string;
    }

    public DatatypeValidator getDatatypeValidator(String string, String string2) {
        DatatypeValidator datatypeValidator = null;
        datatypeValidator = string.length() == 0 || string.equals("http://www.w3.org/2000/10/XMLSchema") ? this.fDatatypeRegistry.getDatatypeValidator(string2) : this.fDatatypeRegistry.getDatatypeValidator(String.valueOf(string) + "," + string2);
        return datatypeValidator;
    }

    private DatatypeValidator getDatatypeValidatorFor(Element element, Selector.XPath xPath, Field.XPath xPath2) throws Exception {
        Object object;
        Cloneable cloneable;
        String string = element.getAttribute("name");
        int n = this.fStringPool.addSymbol(string);
        String string2 = this.fSchemaRootElement.getAttribute("targetNamespace");
        int n2 = this.fStringPool.addSymbol(string2);
        int n3 = this.fSchemaGrammar.getElementDeclIndex(n2, n, -1);
        XPath.LocationPath locationPath = xPath.getLocationPath();
        XPath.Step[] stepArray = locationPath.steps;
        int n4 = 0;
        while (n4 < stepArray.length) {
            cloneable = stepArray[n4];
            object = ((XPath.Step)cloneable).axis;
            XPath.NodeTest nodeTest = ((XPath.Step)cloneable).nodeTest;
            switch (object.type) {
                case 2: {
                    this.reportGenericSchemaError("not allowed to select attribute");
                    return null;
                }
                case 1: {
                    int n5 = this.fSchemaGrammar.getElementDeclIndex(nodeTest.name, n3);
                    if (n5 == -1) {
                        n5 = this.fSchemaGrammar.getElementDeclIndex(nodeTest.name, -1);
                    }
                    if (n5 == -1) {
                        this.reportGenericSchemaError("no such element \"" + this.fStringPool.toString(nodeTest.name.rawname) + '\"');
                        return null;
                    }
                    n3 = n5;
                    break;
                }
                default: {
                    this.reportGenericSchemaError("invalid selector axis");
                    return null;
                }
                case 3: 
            }
            ++n4;
        }
        cloneable = xPath2.getLocationPath();
        object = cloneable.steps;
        int n6 = 0;
        while (n6 < ((XPath.Step[])object).length) {
            XPath.Step step = object[n6];
            XPath.Axis axis = step.axis;
            XPath.NodeTest nodeTest = step.nodeTest;
            switch (axis.type) {
                case 2: {
                    if (n6 != ((XPath.Step[])object).length - 1) {
                        this.reportGenericSchemaError("attribute must be last step");
                        return null;
                    }
                    int n7 = this.fSchemaGrammar.getAttributeDeclIndex(n3, nodeTest.name);
                    if (n7 == -1) {
                        this.reportGenericSchemaError("no such attribute \"" + this.fStringPool.toString(nodeTest.name.rawname) + '\"');
                    }
                    XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
                    this.fSchemaGrammar.getAttributeDecl(n7, xMLAttributeDecl);
                    DatatypeValidator datatypeValidator = xMLAttributeDecl.datatypeValidator;
                    return datatypeValidator;
                }
                case 1: {
                    int n7 = this.fSchemaGrammar.getElementDeclIndex(nodeTest.name, n3);
                    if (n7 == -1) {
                        n7 = this.fSchemaGrammar.getElementDeclIndex(nodeTest.name, -1);
                    }
                    if (n7 == -1) {
                        this.reportGenericSchemaError("no such element \"" + this.fStringPool.toString(nodeTest.name.rawname) + '\"');
                        return null;
                    }
                    n3 = n7;
                    if (n6 < ((XPath.Step[])object).length - 1) break;
                }
                case 3: {
                    if (n6 != ((XPath.Step[])object).length - 1) break;
                    XMLElementDecl xMLElementDecl = new XMLElementDecl();
                    this.fSchemaGrammar.getElementDecl(n3, xMLElementDecl);
                    if (xMLElementDecl.type != 4) {
                        this.reportGenericSchemaError("selected element is not of simple type");
                        return null;
                    }
                    DatatypeValidator datatypeValidator = xMLElementDecl.datatypeValidator;
                    return datatypeValidator;
                }
                default: {
                    this.reportGenericSchemaError("invalid selector axis");
                    return null;
                }
            }
            ++n6;
        }
        this.reportGenericSchemaError("No datatype validator for field " + xPath2 + " of element " + string);
        return null;
    }

    ComplexTypeInfo getElementDeclTypeInfoFromNS(String string, String string2) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            int n = schemaGrammar.getElementDeclIndex(this.fStringPool.addSymbol(string), this.fStringPool.addSymbol(string2), -1);
            ComplexTypeInfo complexTypeInfo = null;
            if (n > -1) {
                complexTypeInfo = schemaGrammar.getElementComplexTypeInfo(n);
            } else {
                this.reportGenericSchemaError("could not find global element : '" + string2 + " in the SchemaGrammar " + string);
            }
            return complexTypeInfo;
        }
        this.reportGenericSchemaError("could not resolve URI : " + string + " to a SchemaGrammar in getElementDeclTypeInfoFromNS");
        return null;
    }

    DatatypeValidator getElementDeclTypeValidatorFromNS(String string, String string2) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            int n = schemaGrammar.getElementDeclIndex(this.fStringPool.addSymbol(string), this.fStringPool.addSymbol(string2), -1);
            DatatypeValidator datatypeValidator = null;
            if (n > -1) {
                schemaGrammar.getElementDecl(n, this.fTempElementDecl);
                datatypeValidator = this.fTempElementDecl.datatypeValidator;
            } else {
                this.reportGenericSchemaError("could not find global element : '" + string2 + " in the SchemaGrammar " + string);
            }
            return datatypeValidator;
        }
        this.reportGenericSchemaError("could not resolve URI : " + string + " to a SchemaGrammar in getELementDeclTypeValidatorFromNS");
        return null;
    }

    private String getElementNameFor(Element element) {
        Element element2 = (Element)element.getParentNode();
        String string = element2.getAttribute("name");
        if (string.length() == 0) {
            string = element2.getAttribute("ref");
        }
        return string;
    }

    String getLocalPart(String string) {
        int n = string.indexOf(":");
        String string2 = string;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    int getLocalPartIndex(String string) {
        int n = string.indexOf(":");
        String string2 = string;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        return this.fStringPool.addSymbol(string2);
    }

    String getPrefix(String string) {
        int n = string.indexOf(":");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    int getPrefixIndex(String string) {
        int n = string.indexOf(":");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return this.fStringPool.addSymbol(string2);
    }

    /*
     * Unable to fully structure code
     */
    private Element getTopLevelComponentByName(String var1_1, String var2_2) throws Exception {
        var3_3 = null;
        var4_4 = this.fSchemaInfoListRoot;
        while (var4_4 != null || var4_4 == this.fSchemaInfoListRoot) {
            block17: {
                if (var4_4 != null) {
                    var4_4.restore();
                }
                if (var1_1.equals("group")) {
                    var3_3 = (Element)this.fSchemaGrammar.topLevelGroupDecls.get(var2_2);
                } else if (var1_1.equals("attributeGroup")) {
                    var3_3 = (Element)this.fSchemaGrammar.topLevelAttrGrpDecls.get(var2_2);
                } else if (var1_1.equals("attribute")) {
                    var3_3 = (Element)this.fSchemaGrammar.topLevelAttrDecls.get(var2_2);
                }
                if (var3_3 != null) break;
                var3_3 = XUtil.getFirstChildElement(this.fSchemaRootElement);
                if (var3_3 != null) ** GOTO lbl32
                break block17;
lbl-1000:
                // 1 sources

                {
                    if (var3_3.getLocalName().equals(var1_1)) {
                        if (var3_3.getAttribute("name").equals(var2_2)) {
                            break;
                        }
                    } else if (this.fRedefineSucceeded && var3_3.getLocalName().equals("redefine")) {
                        var5_5 = XUtil.getFirstChildElement(var3_3);
                        while (var5_5 != null) {
                            if (var5_5.getLocalName().equals(var1_1) && var5_5.getAttribute("name").equals(var2_2)) break;
                            var5_5 = XUtil.getNextSiblingElement(var5_5);
                        }
                        if (var5_5 != null) {
                            var3_3 = var5_5;
                            break;
                        }
                    }
                    var3_3 = XUtil.getNextSiblingElement(var3_3);
lbl32:
                    // 2 sources

                    ** while (var3_3 != null)
                }
lbl33:
                // 3 sources

                if (var3_3 != null || this.fSchemaInfoListRoot == null) break;
            }
            var4_4 = var4_4.getNext();
        }
        if (var4_4 != null) {
            var4_4.restore();
        } else if (this.fSchemaInfoListRoot != null) {
            this.fSchemaInfoListRoot.restore();
        }
        return var3_3;
    }

    ComplexTypeInfo getTypeInfoFromNS(String string, String string2) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            ComplexTypeInfo complexTypeInfo = (ComplexTypeInfo)schemaGrammar.getComplexTypeRegistry().get(String.valueOf(string) + "," + string2);
            return complexTypeInfo;
        }
        this.reportGenericSchemaError("could not resolve URI : " + string + " to a SchemaGrammar in getTypeInfoFromNS");
        return null;
    }

    DatatypeValidator getTypeValidatorFromNS(String string, String string2) throws Exception {
        return this.getDatatypeValidator(string, string2);
    }

    private void handleComplexTypeError(String string, int n, ComplexTypeInfo complexTypeInfo) throws Exception {
        String string2 = this.fStringPool.toString(n);
        if (string != null) {
            if (string2.startsWith("#")) {
                this.reportGenericSchemaError("Anonymous complexType: " + string);
            } else {
                this.reportGenericSchemaError("ComplexType '" + string2 + "': " + string);
            }
        }
        complexTypeInfo.contentType = 1;
        complexTypeInfo.contentSpecHandle = -1;
        complexTypeInfo.derivedBy = 0;
        complexTypeInfo.datatypeValidator = null;
        complexTypeInfo.attlistHead = -1;
        int n2 = this.fStringPool.addSymbol("$" + string2);
        complexTypeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, n2, n, this.fTargetNSURI), this.fTargetNSURI == 0 ? 0 : this.fCurrentScope, complexTypeInfo.scopeDefined, complexTypeInfo.contentType, complexTypeInfo.contentSpecHandle, -1, complexTypeInfo.datatypeValidator);
    }

    private int importContentSpec(SchemaGrammar schemaGrammar, int n) throws Exception {
        XMLContentSpec xMLContentSpec = new XMLContentSpec();
        schemaGrammar.getContentSpec(n, xMLContentSpec);
        int n2 = -1;
        int n3 = -1;
        if (xMLContentSpec.type == 0 || (xMLContentSpec.type & 0xF) == 6 || (xMLContentSpec.type & 0xF) == 8 || (xMLContentSpec.type & 0xF) == 7) {
            return this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, xMLContentSpec.value, xMLContentSpec.otherValue, false);
        }
        if (xMLContentSpec.type == -1) {
            return -2;
        }
        n2 = xMLContentSpec.value == -1 ? -1 : this.importContentSpec(schemaGrammar, xMLContentSpec.value);
        n3 = xMLContentSpec.otherValue == -1 ? -1 : this.importContentSpec(schemaGrammar, xMLContentSpec.otherValue);
        return this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, n2, n3, false);
    }

    int[] intersect2sets(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length > nArray2.length ? nArray.length : nArray2.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = 0;
            while (n3 < nArray2.length) {
                if (nArray[n2] == nArray2[n3]) {
                    nArray3[n++] = nArray[n2];
                }
                ++n3;
            }
            ++n2;
        }
        int[] nArray4 = new int[n];
        System.arraycopy(nArray3, 0, nArray4, 0, n);
        return nArray4;
    }

    private boolean isAttrOrAttrGroup(Element element) {
        String string = element.getLocalName();
        return string.equals("attribute") || string.equals("attributeGroup") || string.equals("anyAttribute");
    }

    private boolean isTopLevel(Element element) {
        String string = element.getParentNode().getLocalName();
        return string.endsWith("schema") || string.endsWith("redefine");
    }

    private XMLAttributeDecl mergeTwoAnyAttribute(XMLAttributeDecl xMLAttributeDecl, XMLAttributeDecl xMLAttributeDecl2) {
        if (xMLAttributeDecl.type == -1) {
            return xMLAttributeDecl;
        }
        if (xMLAttributeDecl2.type == -1) {
            return xMLAttributeDecl2;
        }
        if (xMLAttributeDecl.type == 8) {
            return xMLAttributeDecl2;
        }
        if (xMLAttributeDecl2.type == 8) {
            return xMLAttributeDecl;
        }
        if (xMLAttributeDecl.type == 9) {
            if (xMLAttributeDecl2.type == 9) {
                if (xMLAttributeDecl2.name.uri == xMLAttributeDecl.name.uri) {
                    return xMLAttributeDecl;
                }
                xMLAttributeDecl.type = -1;
                return xMLAttributeDecl;
            }
            if (xMLAttributeDecl2.type == 10) {
                return xMLAttributeDecl2;
            }
            if (xMLAttributeDecl2.type == 11) {
                if (!this.fStringPool.stringInList(xMLAttributeDecl2.enumeration, xMLAttributeDecl.name.uri)) {
                    return xMLAttributeDecl2;
                }
                int[] nArray = this.fStringPool.stringListAsIntArray(xMLAttributeDecl2.enumeration);
                int n = this.fStringPool.startStringList();
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] != xMLAttributeDecl.name.uri) {
                        this.fStringPool.addStringToList(n, nArray[n2]);
                    }
                    ++n2;
                }
                this.fStringPool.finishStringList(n);
                xMLAttributeDecl2.enumeration = n;
                return xMLAttributeDecl2;
            }
        }
        if (xMLAttributeDecl.type == 10) {
            if (xMLAttributeDecl2.type == 9 || xMLAttributeDecl2.type == 10) {
                return xMLAttributeDecl;
            }
            if (xMLAttributeDecl2.type == 11) {
                xMLAttributeDecl.type = -1;
                return xMLAttributeDecl;
            }
        }
        if (xMLAttributeDecl.type == 11) {
            if (xMLAttributeDecl2.type == 9) {
                if (!this.fStringPool.stringInList(xMLAttributeDecl.enumeration, xMLAttributeDecl2.name.uri)) {
                    return xMLAttributeDecl;
                }
                int[] nArray = this.fStringPool.stringListAsIntArray(xMLAttributeDecl.enumeration);
                int n = this.fStringPool.startStringList();
                int n3 = 0;
                while (n3 < nArray.length) {
                    if (nArray[n3] != xMLAttributeDecl2.name.uri) {
                        this.fStringPool.addStringToList(n, nArray[n3]);
                    }
                    ++n3;
                }
                this.fStringPool.finishStringList(n);
                xMLAttributeDecl.enumeration = n;
                return xMLAttributeDecl;
            }
            if (xMLAttributeDecl2.type == 10) {
                xMLAttributeDecl.type = -1;
                return xMLAttributeDecl;
            }
            if (xMLAttributeDecl2.type == 11) {
                int[] nArray = this.intersect2sets(this.fStringPool.stringListAsIntArray(xMLAttributeDecl.enumeration), this.fStringPool.stringListAsIntArray(xMLAttributeDecl2.enumeration));
                int n = this.fStringPool.startStringList();
                int n4 = 0;
                while (n4 < nArray.length) {
                    this.fStringPool.addStringToList(n, nArray[n4]);
                    ++n4;
                }
                this.fStringPool.finishStringList(n);
                xMLAttributeDecl.enumeration = n;
                return xMLAttributeDecl;
            }
        }
        return xMLAttributeDecl;
    }

    private void openRedefinedSchema(Element element, SchemaInfo schemaInfo) throws Exception {
        Attr attr = element.getAttributeNode("schemaLocation");
        if (attr == null) {
            this.fRedefineSucceeded = false;
            this.reportGenericSchemaError("a schemaLocation attribute must be specified on a <redefine> element");
            return;
        }
        String string = attr.getValue();
        InputSource inputSource = null;
        if (this.fEntityResolver != null) {
            inputSource = this.fEntityResolver.resolveEntity("", string);
        }
        if (inputSource == null) {
            string = this.expandSystemId(string, this.fCurrentSchemaURL);
            inputSource = new InputSource(string);
        } else {
            if (inputSource.getPublicId() != null) {
                string = inputSource.getPublicId();
            }
            string = String.valueOf(string) + ',' + inputSource.getSystemId();
        }
        if (this.fRedefineLocations.get(string) != null) {
            this.fCurrentSchemaInfo = (SchemaInfo)this.fRedefineLocations.get(string);
            this.fCurrentSchemaInfo.restore();
            return;
        }
        IgnoreWhitespaceParser ignoreWhitespaceParser = new IgnoreWhitespaceParser();
        ignoreWhitespaceParser.setEntityResolver(new Resolver());
        ignoreWhitespaceParser.setErrorHandler(new ErrorHandler());
        try {
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/validation", false);
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/namespaces", true);
            ignoreWhitespaceParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            ignoreWhitespaceParser.parse(inputSource);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {}
        Document document = ignoreWhitespaceParser.getDocument();
        Element element2 = null;
        if (document != null) {
            element2 = document.getDocumentElement();
        }
        if (element2 == null) {
            this.fRedefineSucceeded = false;
            return;
        }
        String string2 = element2.getAttribute("targetNamespace");
        if (string2.length() > 0 && !string2.equals(this.fTargetNSURIString)) {
            this.fRedefineSucceeded = false;
            this.reportGenericSchemaError("redefined schema '" + string + "' has a different targetNameSpace '" + string2 + "' from the original schema");
        } else {
            this.fSchemaRootElement = element2;
            this.fCurrentSchemaURL = string;
            this.traverseIncludedSchemaHeader(element2);
            schemaInfo.setNext(new SchemaInfo(this.fElementDefaultQualified, this.fAttributeDefaultQualified, this.fCurrentScope, this.fCurrentSchemaURL, this.fSchemaRootElement, null, schemaInfo));
            schemaInfo.getNext().setPrev(schemaInfo);
            this.fCurrentSchemaInfo = schemaInfo.getNext();
            this.fRedefineLocations.put(string, schemaInfo.getNext());
        }
    }

    private QName parseBase(String string) throws Exception {
        String string2 = "";
        String string3 = string;
        int n = string.indexOf(":");
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        int n2 = this.fStringPool.addSymbol(string);
        int n3 = this.fStringPool.addSymbol(string2);
        int n4 = this.fStringPool.addSymbol(string3);
        int n5 = this.fStringPool.addSymbol(this.resolvePrefixToURI(string2));
        return new QName(n3, n4, n2, n5);
    }

    private int parseBlockSet(String string) throws Exception {
        if (string.equals("#all")) {
            return 47;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("substitutionGroup")) {
                if (n == 0) {
                    n = 32;
                    continue;
                }
                this.reportGenericSchemaError("'substitutionGroup' already in set");
                continue;
            }
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (string2.equals("list")) {
                if (n == 0) {
                    n = 8;
                    continue;
                }
                this.reportGenericSchemaError("'list' already in set");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        return n + n2 + n3;
    }

    private int parseComplexContent(String string) throws Exception {
        if (string.equals("empty")) {
            return 0;
        }
        if (string.equals("elementOnly")) {
            return 3;
        }
        if (string.equals("textOnly")) {
            return 4;
        }
        if (string.equals("mixed")) {
            return 2;
        }
        this.reportGenericSchemaError("Invalid value for content");
        return -1;
    }

    private int parseDerivationSet(String string) throws Exception {
        if (string.equals("#all")) {
            return 7;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        return n + n2 + n3;
    }

    private int parseFinalSet(String string) throws Exception {
        if (string.equals("#all")) {
            return 47;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("substitutionGroup")) {
                if (n == 0) {
                    n = 32;
                    continue;
                }
                this.reportGenericSchemaError("'substitutionGroup' already in set");
                continue;
            }
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (string2.equals("list")) {
                if (n == 0) {
                    n = 8;
                    continue;
                }
                this.reportGenericSchemaError("'list' already in set");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        return n + n2 + n3;
    }

    private int parseInt(String string) throws Exception {
        if (string.equals("*")) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    private int parseSimpleFinal(String string) throws Exception {
        if (string.equals("#all")) {
            return 30;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction in set twice");
                continue;
            }
            if (string2.equals("list")) {
                if (n3 == 0) {
                    n3 = 8;
                    continue;
                }
                this.reportGenericSchemaError("list in set twice");
                continue;
            }
            this.reportGenericSchemaError("Invalid value (" + string + ")");
        }
        return n + n2 + n3 + n4;
    }

    private void processAttributes(Element element, QName qName, ComplexTypeInfo complexTypeInfo) throws Exception {
        int n;
        Object object;
        XMLAttributeDecl xMLAttributeDecl = null;
        Vector vector = new Vector();
        Element element2 = element;
        while (element2 != null) {
            object = element2.getLocalName();
            if (((String)object).equals("attribute")) {
                this.traverseAttributeDecl(element2, complexTypeInfo, false);
            } else if (((String)object).equals("attributeGroup")) {
                this.traverseAttributeGroupDecl(element2, complexTypeInfo, vector);
            } else if (((String)object).equals("anyAttribute")) {
                xMLAttributeDecl = this.traverseAnyAttribute(element2);
            } else {
                throw new ComplexTypeRecoverableError("Invalid child among the children of the complexType definition");
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (xMLAttributeDecl != null) {
            object = null;
            int n2 = vector.size();
            if (n2 > 0) {
                object = (XMLAttributeDecl)vector.elementAt(0);
                n = 1;
                while (n < n2) {
                    object = this.mergeTwoAnyAttribute((XMLAttributeDecl)object, (XMLAttributeDecl)vector.elementAt(n));
                    ++n;
                }
            }
            if (object != null) {
                n = xMLAttributeDecl.defaultType;
                xMLAttributeDecl = this.mergeTwoAnyAttribute(xMLAttributeDecl, (XMLAttributeDecl)object);
                xMLAttributeDecl.defaultType = n;
            }
        } else if (vector.size() > 0) {
            xMLAttributeDecl = (XMLAttributeDecl)vector.elementAt(0);
        }
        object = null;
        ComplexTypeInfo complexTypeInfo2 = complexTypeInfo.baseComplexTypeInfo;
        if (complexTypeInfo2 != null && complexTypeInfo2.attlistHead > -1) {
            String string;
            n = complexTypeInfo2.attlistHead;
            SchemaGrammar schemaGrammar = this.fSchemaGrammar;
            String string2 = string = this.baseFromAnotherSchema(qName) ? this.fStringPool.toString(qName.uri) : null;
            if (string != null) {
                schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string);
            }
            if (schemaGrammar != null) {
                while (n > -1) {
                    this.fTempAttributeDecl.clear();
                    schemaGrammar.getAttributeDecl(n, this.fTempAttributeDecl);
                    if (this.fTempAttributeDecl.type == 8 || this.fTempAttributeDecl.type == 11 || this.fTempAttributeDecl.type == 10 || this.fTempAttributeDecl.type == 9) {
                        if (xMLAttributeDecl == null) {
                            object = this.fTempAttributeDecl;
                        }
                        n = schemaGrammar.getNextAttributeDeclIndex(n);
                        continue;
                    }
                    int n3 = this.fSchemaGrammar.getAttributeDeclIndex(complexTypeInfo.templateElementIndex, this.fTempAttributeDecl.name);
                    if (n3 > -1 && complexTypeInfo.derivedBy == 2) {
                        n = this.fSchemaGrammar.getNextAttributeDeclIndex(n);
                        continue;
                    }
                    this.fSchemaGrammar.addAttDef(complexTypeInfo.templateElementIndex, this.fTempAttributeDecl.name, this.fTempAttributeDecl.type, this.fTempAttributeDecl.enumeration, this.fTempAttributeDecl.defaultType, this.fTempAttributeDecl.defaultValue, this.fTempAttributeDecl.datatypeValidator, this.fTempAttributeDecl.list);
                    n = schemaGrammar.getNextAttributeDeclIndex(n);
                }
            }
        }
        if (xMLAttributeDecl != null) {
            if (xMLAttributeDecl.type != -1) {
                this.fSchemaGrammar.addAttDef(complexTypeInfo.templateElementIndex, xMLAttributeDecl.name, xMLAttributeDecl.type, xMLAttributeDecl.enumeration, xMLAttributeDecl.defaultType, xMLAttributeDecl.defaultValue, xMLAttributeDecl.datatypeValidator, xMLAttributeDecl.list);
            }
        } else if (object != null) {
            this.fSchemaGrammar.addAttDef(complexTypeInfo.templateElementIndex, ((XMLAttributeDecl)object).name, ((XMLAttributeDecl)object).type, ((XMLAttributeDecl)object).enumeration, ((XMLAttributeDecl)object).defaultType, ((XMLAttributeDecl)object).defaultValue, ((XMLAttributeDecl)object).datatypeValidator, ((XMLAttributeDecl)object).list);
        }
        complexTypeInfo.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(complexTypeInfo.templateElementIndex);
    }

    private void processBaseTypeInfo(QName qName, ComplexTypeInfo complexTypeInfo) throws Exception {
        ComplexTypeInfo complexTypeInfo2 = null;
        DatatypeValidator datatypeValidator = null;
        String string = this.fStringPool.toString(qName.uri);
        String string2 = this.fStringPool.toString(qName.localpart);
        String string3 = this.fStringPool.toString(qName.rawname);
        if (this.baseFromAnotherSchema(qName)) {
            complexTypeInfo2 = this.getTypeInfoFromNS(string, string2);
            if (complexTypeInfo2 == null && (datatypeValidator = this.getTypeValidatorFromNS(string, string2)) == null) {
                throw new ComplexTypeRecoverableError("Could not find base type " + string2 + " in schema " + string);
            }
        } else {
            String string4 = String.valueOf(string) + "," + string2;
            complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(string4);
            if (complexTypeInfo2 == null && (datatypeValidator = this.getDatatypeValidator(string, string2)) == null) {
                Element element = this.getTopLevelComponentByName("complexType", string2);
                if (element != null) {
                    int n = this.traverseComplexTypeDecl(element);
                    complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n));
                } else {
                    element = this.getTopLevelComponentByName("simpleType", string2);
                    if (element != null) {
                        int n = this.traverseSimpleTypeDecl(element);
                        datatypeValidator = this.getDatatypeValidator(string, string2);
                    } else {
                        throw new ComplexTypeRecoverableError("Base type could not be found : " + string3);
                    }
                }
            }
        }
        complexTypeInfo.baseComplexTypeInfo = complexTypeInfo2;
        complexTypeInfo.baseDataTypeValidator = datatypeValidator;
    }

    private void processComplexContent(int n, Element element, ComplexTypeInfo complexTypeInfo, QName qName, boolean bl) throws Exception {
        Element element2 = null;
        int n2 = -2;
        if (element != null) {
            String string = element.getLocalName();
            if (string.equals("group")) {
                n2 = this.expandContentModel(this.traverseGroupDecl(element), element);
                element2 = XUtil.getNextSiblingElement(element);
            } else if (string.equals("sequence")) {
                n2 = this.expandContentModel(this.traverseSequence(element), element);
                element2 = XUtil.getNextSiblingElement(element);
            } else if (string.equals("choice")) {
                n2 = this.expandContentModel(this.traverseChoice(element), element);
                element2 = XUtil.getNextSiblingElement(element);
            } else if (string.equals("all")) {
                n2 = this.expandContentModel(this.traverseAll(element), element);
                element2 = XUtil.getNextSiblingElement(element);
            } else if (this.isAttrOrAttrGroup(element)) {
                complexTypeInfo.contentType = 1;
                element2 = element;
            } else {
                throw new ComplexTypeRecoverableError("Invalid child '" + string + "' in the complex type");
            }
        }
        if (bl) {
            int n3 = this.fSchemaGrammar.addContentSpecNode(0, -1, -1, false);
            n2 = n2 != -2 ? this.fSchemaGrammar.addContentSpecNode(4, n3, n2, false) : n3;
        }
        complexTypeInfo.contentSpecHandle = n2;
        if (complexTypeInfo.baseComplexTypeInfo != null) {
            int n4 = complexTypeInfo.baseComplexTypeInfo.contentSpecHandle;
            if (complexTypeInfo.derivedBy != 2) {
                if (this.baseFromAnotherSchema(qName)) {
                    String string = this.fStringPool.toString(qName.uri);
                    SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string);
                    n4 = this.importContentSpec(schemaGrammar, n4);
                }
                if (complexTypeInfo.contentSpecHandle == -2) {
                    complexTypeInfo.contentSpecHandle = n4;
                } else if (n4 > -1) {
                    complexTypeInfo.contentSpecHandle = this.fSchemaGrammar.addContentSpecNode(5, n4, complexTypeInfo.contentSpecHandle, false);
                }
            }
        } else {
            complexTypeInfo.derivedBy = 0;
        }
        complexTypeInfo.contentType = bl ? 2 : (complexTypeInfo.contentSpecHandle == -2 ? 0 : 3);
        String string = this.fStringPool.toString(n);
        int n5 = this.fStringPool.addSymbol("$" + string);
        complexTypeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, n5, n, this.fTargetNSURI), this.fTargetNSURI == 0 ? 0 : this.fCurrentScope, complexTypeInfo.scopeDefined, complexTypeInfo.contentType, complexTypeInfo.contentSpecHandle, -1, complexTypeInfo.datatypeValidator);
        complexTypeInfo.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(complexTypeInfo.templateElementIndex);
        if (element2 != null) {
            if (!this.isAttrOrAttrGroup(element2)) {
                throw new ComplexTypeRecoverableError("Invalid child " + element2.getLocalName() + " in the complexType or complexContent");
            }
            this.processAttributes(element2, qName, complexTypeInfo);
        } else if (complexTypeInfo.baseComplexTypeInfo != null) {
            this.processAttributes(null, qName, complexTypeInfo);
        }
    }

    private void renameRedefinedComponents(Element element, Element element2, SchemaInfo schemaInfo) throws Exception {
        Element element3 = XUtil.getFirstChildElement(element);
        while (element3 != null) {
            String string = element3.getLocalName();
            if (!string.equals("annotation")) {
                String string2;
                if (string.equals("simpleType")) {
                    string2 = element3.getAttribute("name");
                    if (!this.fTraversedRedefineElements.contains(string2) && this.validateRedefineNameChange("simpleType", string2, String.valueOf(string2) + redefIdentifier, element3)) {
                        this.fixRedefinedSchema("simpleType", string2, String.valueOf(string2) + redefIdentifier, element2, schemaInfo);
                    }
                } else if (string.equals("complexType")) {
                    string2 = element3.getAttribute("name");
                    if (!this.fTraversedRedefineElements.contains(string2) && this.validateRedefineNameChange("complexType", string2, String.valueOf(string2) + redefIdentifier, element3)) {
                        this.fixRedefinedSchema("complexType", string2, String.valueOf(string2) + redefIdentifier, element2, schemaInfo);
                    }
                } else if (string.equals("attributeGroup")) {
                    string2 = element3.getAttribute("name");
                    if (!this.fTraversedRedefineElements.contains(string2) && this.validateRedefineNameChange("attributeGroup", string2, String.valueOf(string2) + redefIdentifier, element3)) {
                        this.fixRedefinedSchema("attributeGroup", string2, String.valueOf(string2) + redefIdentifier, element2, schemaInfo);
                    }
                } else if (string.equals("group")) {
                    string2 = element3.getAttribute("name");
                    if (!this.fTraversedRedefineElements.contains(string2) && this.validateRedefineNameChange("group", string2, String.valueOf(string2) + redefIdentifier, element3)) {
                        this.fixRedefinedSchema("group", string2, String.valueOf(string2) + redefIdentifier, element2, schemaInfo);
                    }
                } else {
                    this.fRedefineSucceeded = false;
                    this.reportGenericSchemaError("invalid top-level content for <redefine>");
                    return;
                }
            }
            element3 = XUtil.getNextSiblingElement(element3);
        }
    }

    private void reportGenericSchemaError(String string) throws Exception {
        if (this.fErrorReporter == null) {
            System.err.println("__TraverseSchemaError__ : " + string);
        } else {
            this.reportSchemaError(23, new Object[]{string});
        }
    }

    private void reportSchemaError(int n, Object[] objectArray) throws Exception {
        if (this.fErrorReporter == null) {
            System.out.println("__TraverseSchemaError__ : " + SchemaMessageProvider.fgMessageKeys[n]);
            int n2 = 0;
            while (n2 < objectArray.length) {
                System.out.println((String)objectArray[n2]);
                ++n2;
            }
        } else {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", n, 0, objectArray, 1);
        }
    }

    private String resolvePrefixToURI(String string) throws Exception {
        String string2 = this.fStringPool.toString(this.fNamespacesScope.getNamespaceForPrefix(this.fStringPool.addSymbol(string)));
        if (string2 == null) {
            this.reportGenericSchemaError("prefix : [" + string + "] can not be resolved to a URI");
            return "";
        }
        if (string.length() == 0 && string2.equals("http://www.w3.org/2000/10/XMLSchema") && this.fTargetNSURIString.length() == 0) {
            string2 = "";
        }
        return string2;
    }

    public void setGrammarResolver(GrammarResolver grammarResolver) {
        this.fGrammarResolver = grammarResolver;
    }

    public void startNamespaceDeclScope(int n, int n2) {
    }

    int traverseAll(Element element) throws Exception {
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        if (element2 == null) {
            return -2;
        }
        int[] nArray = null;
        int n = 0;
        int n2 = -2;
        while (element2 != null) {
            int n3 = -2;
            boolean bl = false;
            String string = element2.getLocalName();
            if (!string.equals("element")) {
                this.reportGenericSchemaError("Content of all group is restricted to elements only.  '" + string + "' was seen and is being ignored");
                break;
            }
            Object object = this.traverseElementDecl(element2);
            n3 = this.fSchemaGrammar.addContentSpecNode(0, ((QName)object).localpart, ((QName)object).uri, false);
            bl = true;
            if (bl) {
                n3 = this.expandContentModel(n3, element2);
            }
            if (n3 != -2) {
                try {
                    nArray[n] = n3;
                }
                catch (NullPointerException nullPointerException) {
                    nArray = new int[32];
                    nArray[n] = n3;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    object = new int[nArray.length * 2];
                    System.arraycopy(nArray, 0, object, 0, nArray.length);
                    nArray[n] = n3;
                }
                ++n;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (n == 0) {
            return n2;
        }
        try {
            n2 = this.allCalcWrapper(nArray, n);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.reportGenericSchemaError("The size of the <all> declaration in your schema is too large for this parser and elements using it will not validate correctly.");
        }
        return n2;
    }

    private void traverseAnnotationDecl(Element element) throws Exception {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string = element2.getLocalName();
            if (!string.equals("appinfo") && !string.equals("documentation")) {
                this.reportGenericSchemaError("an <annotation> can only contain <appinfo> and <documentation> elements");
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
    }

    private int traverseAny(Element element) throws Exception {
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        if (element2 != null) {
            this.reportGenericSchemaError("<any> elements can contain at most one <annotation> element in their children");
        }
        int n = -1;
        String string = element.getAttribute("namespace").trim();
        String string2 = element.getAttribute("processContents").trim();
        int n2 = 6;
        int n3 = 7;
        int n4 = 8;
        if (string2.length() > 0 && !string2.equals("strict")) {
            if (string2.equals("lax")) {
                n2 = 22;
                n3 = 23;
                n4 = 24;
            } else if (string2.equals("skip")) {
                n2 = 38;
                n3 = 39;
                n4 = 40;
            }
        }
        if (string.length() == 0 || string.equals("##any")) {
            String string3 = this.fTargetNSURIString;
            int n5 = this.fStringPool.addSymbol(string3);
            n = this.fSchemaGrammar.addContentSpecNode(n2, -1, n5, false);
        } else if (string.equals("##other")) {
            String string4 = this.fTargetNSURIString;
            int n6 = this.fStringPool.addSymbol(string4);
            n = this.fSchemaGrammar.addContentSpecNode(n3, -1, n6, false);
        } else if (string.equals("##local")) {
            n = this.fSchemaGrammar.addContentSpecNode(n4, -1, 0, false);
        } else if (string.length() > 0) {
            int n7;
            String string5;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreElements()) {
                string5 = stringTokenizer.nextToken();
                if (string5.equals("##targetNamespace")) {
                    string5 = this.fTargetNSURIString;
                }
                vector.addElement(string5);
            }
            string5 = (String)vector.elementAt(0);
            int n8 = this.fStringPool.addSymbol(string5);
            int n9 = n7 = this.fSchemaGrammar.addContentSpecNode(n2, -1, n8, false);
            int n10 = vector.size();
            if (n10 > 1) {
                string5 = (String)vector.elementAt(1);
                n8 = this.fStringPool.addSymbol(string5);
                int n11 = n7 = this.fSchemaGrammar.addContentSpecNode(n2, -1, n8, false);
                int n12 = this.fSchemaGrammar.addContentSpecNode(4, n9, n11, false);
                int n13 = 2;
                while (n13 < n10) {
                    string5 = (String)vector.elementAt(n13);
                    n8 = this.fStringPool.addSymbol(string5);
                    n11 = n7 = this.fSchemaGrammar.addContentSpecNode(n2, -1, n8, false);
                    n12 = this.fSchemaGrammar.addContentSpecNode(4, n12, n11, false);
                    ++n13;
                }
                n = n12;
            } else {
                n = n7;
            }
        } else {
            this.reportGenericSchemaError("Empty namespace attribute for any element");
        }
        return n;
    }

    private XMLAttributeDecl traverseAnyAttribute(Element element) throws Exception {
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        if (element2 != null) {
            this.reportGenericSchemaError("<anyAttribute> elements can contain at most one <annotation> element in their children");
        }
        XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
        String string = element.getAttribute("processContents").trim();
        String string2 = element.getAttribute("namespace").trim();
        String string3 = this.fTargetNSURIString;
        if (string2.length() == 0 || string2.equals("##any")) {
            xMLAttributeDecl.type = 8;
        } else if (string2.equals("##other")) {
            xMLAttributeDecl.type = 9;
            xMLAttributeDecl.name.uri = this.fStringPool.addSymbol(string3);
        } else if (string2.equals("##local")) {
            xMLAttributeDecl.type = 10;
        } else if (string2.length() > 0) {
            xMLAttributeDecl.type = 11;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n = this.fStringPool.startStringList();
            Vector vector = new Vector();
            while (stringTokenizer.hasMoreElements()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("##targetNamespace")) {
                    string4 = string3;
                }
                if (this.fStringPool.addStringToList(n, this.fStringPool.addSymbol(string4))) continue;
                this.reportGenericSchemaError("Internal StringPool error when reading the namespace attribute for anyattribute declaration");
            }
            this.fStringPool.finishStringList(n);
            xMLAttributeDecl.enumeration = n;
        } else {
            this.reportGenericSchemaError("Empty namespace attribute for anyattribute declaration");
        }
        xMLAttributeDecl.defaultType = 4;
        if (string.equals("skip")) {
            xMLAttributeDecl.defaultType = 6;
        } else if (string.equals("lax")) {
            xMLAttributeDecl.defaultType = 5;
        }
        return xMLAttributeDecl;
    }

    private int traverseAttributeDecl(Element element, ComplexTypeInfo complexTypeInfo, boolean bl) throws Exception {
        String string;
        int n;
        String string2 = element.getAttribute("name");
        int n2 = this.fStringPool.addSymbol(string2);
        String string3 = element.getAttribute("form");
        boolean bl2 = this.isTopLevel(element);
        DatatypeValidator datatypeValidator = null;
        int n3 = -1;
        boolean bl3 = false;
        int n4 = -1;
        String string4 = element.getAttribute("ref");
        String string5 = element.getAttribute("type");
        if (!string4.equals("")) {
            if (bl2) {
                this.reportGenericSchemaError("An attribute with \"ref\" present must not have <schema> as its parent");
            }
            if (!string2.equals("")) {
                this.reportGenericSchemaError("Attribute " + string2 + " cannot refer to another attribute, but it refers to " + string4);
            }
            if (!string5.equals("")) {
                this.reportGenericSchemaError("Attribute with reference " + string4 + " cannot also contain a type");
            }
            if (!element.getAttribute("form").equals("")) {
                this.reportGenericSchemaError("Attribute with reference " + string4 + " cannot also contain a \"form\" property");
            }
            if (!element.getAttribute("value").equals("")) {
                this.reportGenericSchemaError("Attribute with reference " + string4 + " cannot also contain a value");
            }
        }
        Element element2 = this.findAttributeSimpleType(element);
        String string6 = null;
        String string7 = element.getAttribute("use");
        boolean bl4 = string7.equals("prohibited");
        boolean bl5 = string7.equals("required");
        if (!string4.equals("")) {
            String string8;
            if (element2 != null) {
                this.reportGenericSchemaError("an attribute with ref present cannot contain a simpleType");
            }
            String string9 = "";
            string6 = string4;
            int n5 = string4.indexOf(":");
            if (n5 > 0) {
                string9 = string4.substring(0, n5);
                string6 = string4.substring(n5 + 1);
            }
            if (!(string8 = this.resolvePrefixToURI(string9)).equals(this.fTargetNSURIString)) {
                this.addAttributeDeclFromAnotherSchema(string6, string8, complexTypeInfo);
                return -1;
            }
            Element element3 = this.getTopLevelComponentByName("attribute", string6);
            if (element3 != null) {
                if (complexTypeInfo != null) {
                    this.traverseAttributeDecl(element3, complexTypeInfo, true);
                    int n6 = this.fStringPool.addSymbol(element3.getAttribute("name"));
                    int n7 = 0;
                    if (this.fTargetNSURIString.length() > 0) {
                        n7 = this.fTargetNSURI;
                    }
                    QName qName = new QName(-1, n6, n6, n7);
                    if (bl4) {
                        int n8 = this.fSchemaGrammar.getAttributeDeclIndex(complexTypeInfo.templateElementIndex, qName);
                        XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
                        this.fSchemaGrammar.getAttributeDecl(n8, xMLAttributeDecl);
                        xMLAttributeDecl.defaultType = 7;
                        this.fSchemaGrammar.setAttributeDecl(complexTypeInfo.templateElementIndex, n8, xMLAttributeDecl);
                    } else if (bl5) {
                        int n9 = this.fSchemaGrammar.getAttributeDeclIndex(complexTypeInfo.templateElementIndex, qName);
                        XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
                        this.fSchemaGrammar.getAttributeDecl(n9, xMLAttributeDecl);
                        xMLAttributeDecl.defaultType = xMLAttributeDecl.defaultType == 1 ? 8 : 2;
                        this.fSchemaGrammar.setAttributeDecl(complexTypeInfo.templateElementIndex, n9, xMLAttributeDecl);
                    }
                }
            } else if (this.fAttributeDeclRegistry.get(string6) != null) {
                this.addAttributeDeclFromAnotherSchema(string6, string8, complexTypeInfo);
            } else {
                this.reportGenericSchemaError("Couldn't find top level attribute " + string4);
            }
            return -1;
        }
        if (string2.equals("")) {
            this.reportGenericSchemaError("An attribute must have a ref or a name!");
        }
        if (string5.equals("")) {
            if (element2 != null) {
                n3 = 7;
                n4 = this.traverseSimpleTypeDecl(element2);
                string6 = this.fStringPool.toString(n4);
            } else {
                n3 = 7;
                string6 = "string";
                n4 = this.fStringPool.addSymbol(string6);
            }
            string6 = this.fStringPool.toString(n4);
            datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(string6);
        } else {
            Element element4;
            if (element2 != null && !bl) {
                this.reportGenericSchemaError("Attribute declarations may not contain both a type and a simpleType declaration");
            }
            String string10 = "";
            string6 = string5;
            n4 = this.fStringPool.addSymbol(string6);
            n = string5.indexOf(":");
            if (n > 0) {
                string10 = string5.substring(0, n);
                string6 = string5.substring(n + 1);
            }
            if ((string = this.resolvePrefixToURI(string10)).equals("http://www.w3.org/2000/10/XMLSchema") || string.length() == 0) {
                datatypeValidator = this.getDatatypeValidator("", string6);
                if (string6.equals("ID")) {
                    n3 = 3;
                } else if (string6.equals("IDREF")) {
                    n3 = 4;
                } else if (string6.equals("IDREFS")) {
                    n3 = 4;
                    bl3 = true;
                } else if (string6.equals("ENTITY")) {
                    n3 = 1;
                } else if (string6.equals("ENTITIES")) {
                    n3 = 1;
                    bl3 = true;
                } else if (string6.equals("NMTOKEN")) {
                    n3 = 5;
                } else if (string6.equals("NMTOKENS")) {
                    n3 = 5;
                    bl3 = true;
                } else if (string6.equals("notation")) {
                    n3 = 6;
                } else {
                    n3 = 7;
                    if (datatypeValidator == null && string.length() == 0) {
                        element4 = this.getTopLevelComponentByName("simpleType", string6);
                        if (element4 != null) {
                            this.traverseSimpleTypeDecl(element4);
                            datatypeValidator = this.getDatatypeValidator(string, string6);
                        } else if (!bl) {
                            this.reportGenericSchemaError("simpleType not found : (" + string + ":" + string6 + ")");
                        }
                    }
                }
            } else {
                datatypeValidator = this.getDatatypeValidator(string, string6);
                if (datatypeValidator == null && string.equals(this.fTargetNSURIString)) {
                    element4 = this.getTopLevelComponentByName("simpleType", string6);
                    if (element4 != null) {
                        this.traverseSimpleTypeDecl(element4);
                        datatypeValidator = this.getDatatypeValidator(string, string6);
                    } else if (!bl) {
                        this.reportGenericSchemaError("simpleType not found : (" + string + ":" + string6 + ")");
                    }
                }
                n3 = 7;
            }
        }
        int n10 = -1;
        n = -1;
        if (datatypeValidator == null && !bl) {
            this.reportGenericSchemaError("could not resolve the type or get a null validator for datatype : " + this.fStringPool.toString(n4));
        }
        string = element.getAttribute("value");
        if (bl2) {
            if (!string.equals("")) {
                if ((bl5 || bl4 || string7.equals("optional")) && !bl) {
                    this.reportGenericSchemaError("Globally-declared attributes containing values must have \"use\" set to \"FIXED\" or \"DEFAULT\", not " + string7);
                } else if (string7.equals("") && !bl) {
                    this.reportGenericSchemaError("Globally-declared attributes containing values MUST have \"use\" present and set to \"FIXED\" or \"DEFAULT\"");
                } else if (string7.equals("fixed")) {
                    n10 = 1;
                    n = this.fStringPool.addString(string);
                } else {
                    n10 = 3;
                    n = this.fStringPool.addString(string);
                }
            } else if (!string7.equals("") && !bl) {
                this.reportGenericSchemaError("Globally-declared attributes containing no value may not have \"use\" present");
            } else {
                n10 = 0;
            }
        } else if (!string.equals("")) {
            if (bl5 || bl4 || string7.equals("optional")) {
                this.reportGenericSchemaError("Locally-declared attributes containing values must have \"use\" set to \"FIXED\" or \"DEFAULT\", not " + string7);
            } else if (string7.equals("")) {
                this.reportGenericSchemaError("Locally-declared attributes containing values MUST have \"use\" present and set to \"FIXED\" or \"DEFAULT\"");
            } else if (string7.equals("fixed")) {
                n10 = 1;
                n = this.fStringPool.addString(string);
            } else {
                n10 = 3;
                n = this.fStringPool.addString(string);
            }
        } else {
            n10 = bl5 ? 2 : (bl4 ? 7 : 0);
        }
        if (n3 == 7 && n != -1) {
            try {
                if (datatypeValidator != null) {
                    datatypeValidator.validate(this.fStringPool.toString(n), null);
                } else if (!bl) {
                    this.reportSchemaError(2, new Object[]{string5});
                }
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                if (!bl) {
                    this.reportSchemaError(18, new Object[]{element.getAttribute("name"), invalidDatatypeValueException.getMessage()});
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("Internal error in attribute datatype validation");
            }
        }
        int n11 = 0;
        if (this.fTargetNSURIString.length() > 0 && (bl2 || !string3.equals("unqualified") && (string3.equals("qualified") || this.fAttributeDefaultQualified))) {
            n11 = this.fTargetNSURI;
        }
        QName qName = new QName(-1, n2, n2, n11);
        if (bl2) {
            this.fTempAttributeDecl.datatypeValidator = datatypeValidator;
            this.fTempAttributeDecl.name.setValues(qName);
            this.fTempAttributeDecl.type = n3;
            this.fTempAttributeDecl.defaultType = n10;
            this.fTempAttributeDecl.list = bl3;
            if (n != -1) {
                this.fTempAttributeDecl.defaultValue = new String(this.fStringPool.toString(n));
            }
            this.fAttributeDeclRegistry.put(string2, new XMLAttributeDecl(this.fTempAttributeDecl));
        }
        if (complexTypeInfo != null) {
            this.fSchemaGrammar.addAttDef(complexTypeInfo.templateElementIndex, qName, n3, n4, n10, this.fStringPool.toString(n), datatypeValidator, bl3);
        }
        return -1;
    }

    private int traverseAttributeGroupDecl(Element element, ComplexTypeInfo complexTypeInfo, Vector vector) throws Exception {
        String string = element.getAttribute("name");
        int n = this.fStringPool.addSymbol(string);
        String string2 = element.getAttribute("ref");
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        if (!string2.equals("")) {
            String string3;
            if (this.isTopLevel(element)) {
                this.reportGenericSchemaError("An attributeGroup with \"ref\" present must not have <schema> or <redefine> as its parent");
            }
            if (!string.equals("")) {
                this.reportGenericSchemaError("attributeGroup " + string + " cannot refer to another attributeGroup, but it refers to " + string2);
            }
            String string4 = "";
            String string5 = string2;
            int n2 = string2.indexOf(":");
            if (n2 > 0) {
                string4 = string2.substring(0, n2);
                string5 = string2.substring(n2 + 1);
            }
            if (!(string3 = this.resolvePrefixToURI(string4)).equals(this.fTargetNSURIString)) {
                this.traverseAttributeGroupDeclFromAnotherSchema(string5, string3, complexTypeInfo, vector);
                return -1;
            }
            if (complexTypeInfo != null) {
                Element element3 = this.getTopLevelComponentByName("attributeGroup", string5);
                if (element3 != null) {
                    this.traverseAttributeGroupDecl(element3, complexTypeInfo, vector);
                } else {
                    this.reportGenericSchemaError("Couldn't find top level attributeGroup " + string2);
                }
                return -1;
            }
        } else if (string.equals("")) {
            this.reportGenericSchemaError("an attributeGroup must have a name or a ref attribute present");
        }
        while (element2 != null) {
            if (element2.getLocalName().equals("attribute")) {
                this.traverseAttributeDecl(element2, complexTypeInfo, false);
            } else {
                if (!element2.getLocalName().equals("attributeGroup")) break;
                if (complexTypeInfo != null) {
                    this.traverseAttributeGroupDecl(element2, complexTypeInfo, vector);
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (element2 != null) {
            if (element2.getLocalName().equals("anyAttribute")) {
                if (vector != null) {
                    vector.addElement(this.traverseAnyAttribute(element2));
                }
                if (XUtil.getNextSiblingElement(element2) != null) {
                    this.reportGenericSchemaError("An attributeGroup declaration cannot have any children after an anyAttribute declaration");
                }
                return -1;
            }
            this.reportGenericSchemaError("An attributeGroup declaration must only contain attribute, attributeGroup and anyAttribute elements");
        }
        return -1;
    }

    private int traverseAttributeGroupDeclFromAnotherSchema(String string, String string2, ComplexTypeInfo complexTypeInfo, Vector vector) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || schemaGrammar == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #traverseAttributeGroupDeclFromAnotherSchema, schema uri : " + string2);
            return -1;
        }
        Element element = (Element)schemaGrammar.topLevelAttrGrpDecls.get(string);
        if (element == null) {
            this.reportGenericSchemaError("no attribute group named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        NamespacesScope namespacesScope = this.fNamespacesScope;
        int n = this.fTargetNSURI;
        this.fTargetNSURI = this.fStringPool.addSymbol(schemaGrammar.getTargetNamespaceURI());
        this.fNamespacesScope = schemaGrammar.getNamespacesScope();
        int n2 = -1;
        int n3 = -1;
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        while (element2 != null) {
            if (element2.getLocalName().equals("attribute")) {
                String string3 = element2.getAttribute("name");
                if (string3.length() > 0) {
                    Hashtable hashtable = schemaGrammar.getAttirubteDeclRegistry();
                    if (hashtable != null && hashtable.get(string3) != null) {
                        this.addAttributeDeclFromAnotherSchema(string3, string2, complexTypeInfo);
                        return -1;
                    }
                } else {
                    this.traverseAttributeDecl(element2, complexTypeInfo, false);
                }
            } else if (element2.getLocalName().equals("attributeGroup")) {
                this.traverseAttributeGroupDecl(element2, complexTypeInfo, vector);
            } else {
                if (element2.getLocalName().equals("anyAttribute")) {
                    vector.addElement(this.traverseAnyAttribute(element2));
                    break;
                }
                this.reportGenericSchemaError("Invalid content for attributeGroup");
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        this.fNamespacesScope = namespacesScope;
        this.fTargetNSURI = n;
        if (element2 != null) {
            this.reportGenericSchemaError("Invalid content for attributeGroup");
        }
        return -1;
    }

    int traverseChoice(Element element) throws Exception {
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        int n = 0;
        int n2 = 0;
        n2 = 4;
        n = 3;
        int n3 = -2;
        int n4 = -2;
        boolean bl = false;
        while (element2 != null) {
            block16: {
                boolean bl2;
                int n5;
                block14: {
                    String string;
                    block15: {
                        block13: {
                            n5 = -2;
                            bl = true;
                            bl2 = false;
                            string = element2.getLocalName();
                            if (!string.equals("element")) break block13;
                            QName qName = this.traverseElementDecl(element2);
                            n5 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                            bl2 = true;
                            break block14;
                        }
                        if (!string.equals("group")) break block15;
                        n5 = this.traverseGroupDecl(element2);
                        if (n5 == -1) break block16;
                        bl2 = true;
                        break block14;
                    }
                    if (string.equals("choice")) {
                        n5 = this.traverseChoice(element2);
                        bl2 = true;
                    } else if (string.equals("sequence")) {
                        n5 = this.traverseSequence(element2);
                        bl2 = true;
                    } else if (string.equals("any")) {
                        n5 = this.traverseAny(element2);
                        bl2 = true;
                    } else {
                        this.reportSchemaError(14, new Object[]{"group", string});
                    }
                }
                if (bl2) {
                    n5 = this.expandContentModel(n5, element2);
                }
                if (n3 == -2) {
                    n3 = n5;
                } else if (n4 == -2) {
                    n4 = n5;
                } else {
                    n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
                    n4 = n5;
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl && n4 != -2) {
            n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
        }
        return n3;
    }

    private void traverseComplexContentDecl(int n, Element element, ComplexTypeInfo complexTypeInfo, boolean bl) throws Exception {
        String string = this.fStringPool.toString(n);
        String string2 = element.getAttribute("ID");
        String string3 = element.getAttribute("mixed");
        boolean bl2 = bl;
        if (string3.equals("true")) {
            bl2 = true;
        } else if (string3.equals("false")) {
            bl2 = false;
        }
        complexTypeInfo.datatypeValidator = null;
        complexTypeInfo.baseDataTypeValidator = null;
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), false);
        if (element2 == null) {
            throw new ComplexTypeRecoverableError();
        }
        String string4 = element2.getLocalName();
        if (string4.equals("restriction")) {
            complexTypeInfo.derivedBy = 2;
        } else if (string4.equals("extension")) {
            complexTypeInfo.derivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("The content of the complexContent element is invalid. The content must be RESTRICTION or EXTENSION");
        }
        String string5 = element2.getAttribute("base");
        String string6 = element2.getAttribute("ID");
        Element element3 = this.checkContent(element2, XUtil.getFirstChildElement(element2), true);
        if (string5.length() == 0) {
            throw new ComplexTypeRecoverableError("The BASE attribute must be specified for the RESTRICTION or EXTENSION element");
        }
        QName qName = this.parseBase(string5);
        String string7 = this.fStringPool.toString(qName.uri);
        String string8 = this.fStringPool.toString(qName.localpart);
        if (!string7.equals("http://www.w3.org/2000/10/XMLSchema") || !string8.equals("anyType")) {
            this.processBaseTypeInfo(qName, complexTypeInfo);
            if (complexTypeInfo.baseComplexTypeInfo == null) {
                throw new ComplexTypeRecoverableError("The base type specified in the complexContent element must be a complexType");
            }
        }
        this.processComplexContent(n, element3, complexTypeInfo, qName, bl2);
        if (XUtil.getNextSiblingElement(element2) != null) {
            throw new ComplexTypeRecoverableError("Invalid child following the RESTRICTION or EXTENSION element in the complex type definition");
        }
    }

    private int traverseComplexTypeDecl(Element element) throws Exception {
        String string;
        ComplexTypeInfo complexTypeInfo;
        String string2 = element.getAttribute("abstract");
        String string3 = element.getAttribute("block");
        String string4 = element.getAttribute("final");
        String string5 = element.getAttribute("ID");
        String string6 = element.getAttribute("name");
        String string7 = element.getAttribute("mixed");
        boolean bl = false;
        if (string6.equals("")) {
            string6 = this.genAnonTypeName(element);
        }
        this.fCurrentTypeNameStack.push(string6);
        int n = this.fStringPool.addSymbol(string6);
        if (this.isTopLevel(element) && (complexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(string = String.valueOf(this.fTargetNSURIString) + "," + string6)) != null) {
            return this.fStringPool.addSymbol(string);
        }
        int n2 = this.fScopeCount++;
        int n3 = this.fCurrentScope;
        this.fCurrentScope = n2;
        Element element2 = null;
        ComplexTypeInfo complexTypeInfo2 = new ComplexTypeInfo();
        try {
            element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
            if (element2 == null) {
                this.processComplexContent(n, element2, complexTypeInfo2, null, false);
            } else {
                String string8 = element2.getLocalName();
                int n4 = -2;
                if (string8.equals("simpleContent")) {
                    this.traverseSimpleContentDecl(n, element2, complexTypeInfo2);
                    if (XUtil.getNextSiblingElement(element2) != null) {
                        throw new ComplexTypeRecoverableError("Invalid child following the simpleContent child in the complexType");
                    }
                } else if (string8.equals("complexContent")) {
                    this.traverseComplexContentDecl(n, element2, complexTypeInfo2, string7.equals("true"));
                    if (XUtil.getNextSiblingElement(element2) != null) {
                        throw new ComplexTypeRecoverableError("Invalid child following the complexContent child in the complexType");
                    }
                } else {
                    this.processComplexContent(n, element2, complexTypeInfo2, null, string7.equals("true"));
                }
            }
        }
        catch (ComplexTypeRecoverableError complexTypeRecoverableError) {
            String string9 = complexTypeRecoverableError.getMessage();
            this.handleComplexTypeError(string9, n, complexTypeInfo2);
        }
        complexTypeInfo2.scopeDefined = n2;
        complexTypeInfo2.blockSet = this.parseBlockSet(string3);
        complexTypeInfo2.finalSet = this.parseFinalSet(string4);
        complexTypeInfo2.isAbstract = string2.equals("true");
        string6 = String.valueOf(this.fTargetNSURIString) + "," + string6;
        complexTypeInfo2.typeName = new String(string6);
        this.fComplexTypeRegistry.put(string6, complexTypeInfo2);
        this.fCurrentScope = n3;
        this.fCurrentTypeNameStack.pop();
        this.checkRecursingComplexType();
        this.fSchemaGrammar.setElementComplexTypeInfo(complexTypeInfo2.templateElementIndex, complexTypeInfo2);
        n = this.fStringPool.addSymbol(string6);
        return n;
    }

    private QName traverseElementDecl(Element element) throws Exception {
        Object object;
        int n;
        int n2;
        String string;
        String string2;
        int n3;
        int n4;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -2;
        DatatypeValidator datatypeValidator = null;
        String string3 = element.getAttribute("name");
        String string4 = element.getAttribute("ref");
        String string5 = element.getAttribute("type");
        String string6 = element.getAttribute("minOccurs");
        String string7 = element.getAttribute("maxOccurs");
        String string8 = element.getAttribute("default");
        String string9 = element.getAttribute("fixed");
        if (!string8.equals("") && !string9.equals("")) {
            this.reportGenericSchemaError("an element cannot have both \"fixed\" and \"default\" present at the same time");
        }
        String string10 = element.getAttribute("substitutionGroup");
        String string11 = element.getAttribute("form");
        String string12 = null;
        if (this.isTopLevel(element)) {
            if (string3.equals("")) {
                this.reportGenericSchemaError("globally-declared element must have a name");
            } else if (!string4.equals("")) {
                this.reportGenericSchemaError("globally-declared element " + string3 + " cannot have a ref attribute");
            }
            n4 = this.fStringPool.addSymbol(string3);
            n3 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, n4, -1);
            if (n3 > -1) {
                return new QName(-1, n4, n4, this.fTargetNSURI);
            }
        }
        n4 = this.parseBlockSet(element.getAttribute("block"));
        n3 = this.parseFinalSet(element.getAttribute("final"));
        boolean bl = element.getAttribute("nullable").equals("true");
        boolean bl2 = element.getAttribute("abstract").equals("true");
        int n9 = 0;
        if (bl) {
            ++n9;
        }
        if (bl2) {
            n9 += 2;
        }
        if (!string4.equals("")) {
            Element element2;
            Element element3;
            if (!(string5.equals("") && n9 <= 0 && n3 <= 0 && n4 <= 0 && string8.equals("") && string9.equals(""))) {
                this.reportSchemaError(16, null);
            }
            if (!string3.equals("")) {
                this.reportGenericSchemaError("element " + string3 + " cannot also have a ref attribute");
            }
            if ((element3 = XUtil.getFirstChildElement(element)) != null && element3.getLocalName().equals("annotation")) {
                if (XUtil.getNextSiblingElement(element3) != null) {
                    this.reportSchemaError(17, null);
                } else {
                    this.traverseAnnotationDecl(element3);
                }
            } else if (element3 != null) {
                this.reportSchemaError(17, null);
            }
            String string13 = "";
            String string14 = string4;
            int n10 = string4.indexOf(":");
            if (n10 > 0) {
                string13 = string4.substring(0, n10);
                string14 = string4.substring(n10 + 1);
            }
            int n11 = this.fStringPool.addSymbol(string14);
            String string15 = this.resolvePrefixToURI(string13);
            QName qName = new QName(string13 != null ? this.fStringPool.addSymbol(string13) : -1, n11, this.fStringPool.addSymbol(string4), string15 != null ? this.fStringPool.addSymbol(string15) : 0);
            if (!string15.equals(this.fTargetNSURIString)) {
                return qName;
            }
            int n12 = this.fSchemaGrammar.getElementDeclIndex(qName, -1);
            if (n12 == -1 && (element2 = this.getTopLevelComponentByName("element", string14)) == null) {
                this.reportGenericSchemaError("Element " + string14 + " not found in the Schema");
                return qName;
            }
            return qName;
        }
        if (string3.equals("")) {
            this.reportGenericSchemaError("a local element must have a name or a ref attribute present");
        }
        Element element4 = null;
        int n13 = -1;
        boolean bl3 = true;
        String string16 = null;
        String string17 = null;
        String string18 = null;
        ComplexTypeInfo complexTypeInfo = null;
        DatatypeValidator datatypeValidator2 = null;
        if (string10.length() > 0) {
            if (!string4.equals("")) {
                this.reportGenericSchemaError("a local element cannot have a substitutionGroup");
            }
            string16 = this.resolvePrefixToURI(this.getPrefix(string10));
            string17 = this.getLocalPart(string10);
            string18 = String.valueOf(string16) + "," + string17;
            if (!string16.equals(this.fTargetNSURIString)) {
                complexTypeInfo = this.getElementDeclTypeInfoFromNS(string16, string17);
                if (complexTypeInfo == null && (datatypeValidator2 = this.getElementDeclTypeValidatorFromNS(string16, string17)) == null) {
                    bl3 = false;
                    this.reportGenericSchemaError("Could not find type for element '" + string17 + "' in schema '" + string16 + "'");
                }
            } else {
                element4 = this.getTopLevelComponentByName("element", string17);
                if (element4 == null) {
                    n13 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(string10), -1);
                    if (n13 == -1) {
                        bl3 = false;
                        this.reportGenericSchemaError("substitutionGroup affiliation element " + string10 + " in element declaration " + string3);
                    }
                } else {
                    n13 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(string10), -1);
                    if (n13 == -1) {
                        this.traverseElementDecl(element4);
                        n13 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(string10), -1);
                    }
                }
                if (n13 != -1 && (complexTypeInfo = this.fSchemaGrammar.getElementComplexTypeInfo(n13)) == null) {
                    this.fSchemaGrammar.getElementDecl(n13, this.fTempElementDecl);
                    datatypeValidator2 = this.fTempElementDecl.datatypeValidator;
                    if (datatypeValidator2 == null) {
                        bl3 = false;
                        this.reportGenericSchemaError("Could not find type for element '" + string17 + "' in schema '" + string16 + "'");
                    }
                }
            }
        }
        ComplexTypeInfo complexTypeInfo2 = null;
        Element element5 = XUtil.getFirstChildElement(element);
        if (element5 != null && element5.getLocalName().equals("annotation")) {
            this.traverseAnnotationDecl(element5);
            element5 = XUtil.getNextSiblingElement(element5);
        }
        if (element5 != null && element5.getLocalName().equals("annotation")) {
            this.reportGenericSchemaError("element declarations can contain at most one annotation Element Information Item");
        }
        boolean bl4 = false;
        if (element5 != null) {
            string2 = element5.getLocalName();
            if (string2.equals("complexType")) {
                if (element5.getAttribute("name").length() > 0) {
                    bl3 = false;
                    this.reportGenericSchemaError("anonymous complexType in element '" + string3 + "' has a name attribute");
                } else {
                    string = this.genAnonTypeName(element5);
                    if (this.fCurrentTypeNameStack.search(string) > -1) {
                        int n14 = 0;
                        if (string11.equals("qualified") || this.fElementDefaultQualified) {
                            n14 = this.fTargetNSURI;
                        }
                        int n15 = this.fStringPool.addSymbol(string3);
                        QName qName = new QName(this.fCurrentScope, n15, n15, n14);
                        this.fElementRecurseComplex.put(qName, string);
                        return new QName(-1, n15, n15, n14);
                    }
                    n7 = this.traverseComplexTypeDecl(element5);
                    if (n7 != -1) {
                        complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n7));
                    } else {
                        bl3 = false;
                        this.reportGenericSchemaError("traverse complexType error in element '" + string3 + "'");
                    }
                }
                bl4 = true;
                element5 = XUtil.getNextSiblingElement(element5);
            } else if (string2.equals("simpleType")) {
                if (element5.getAttribute("name").length() > 0) {
                    bl3 = false;
                    this.reportGenericSchemaError("anonymous simpleType in element '" + string3 + "' has a name attribute");
                } else {
                    n7 = this.traverseSimpleTypeDecl(element5);
                }
                if (n7 != -1) {
                    datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(n7));
                } else {
                    bl3 = false;
                    this.reportGenericSchemaError("traverse simpleType error in element '" + string3 + "'");
                }
                n5 = 4;
                bl4 = true;
                element5 = XUtil.getNextSiblingElement(element5);
            } else if (string5.equals("")) {
                n5 = 1;
                n6 = -1;
            }
            if (element5 != null) {
                string2 = element5.getLocalName();
            }
            while (element5 != null && (string2.equals("key") || string2.equals("keyref") || string2.equals("unique"))) {
                if ((element5 = XUtil.getNextSiblingElement(element5)) == null) continue;
                string2 = element5.getLocalName();
            }
            if (element5 != null) {
                bl3 = false;
                this.reportGenericSchemaError("the content of an element information item must match (annotation?, (simpleType | complexType)?, (unique | key | keyref)*)");
            }
        }
        if (bl4 && string5.length() > 0) {
            bl3 = false;
            this.reportGenericSchemaError("Element '" + string3 + "' have both a type attribute and a annoymous type child");
        } else if (!string5.equals("")) {
            String string19;
            if (element4 != null) {
                this.checkSubstitutionGroupOK(element, element4);
            }
            string2 = "";
            string = string5;
            n2 = string5.indexOf(":");
            if (n2 > 0) {
                string2 = string5.substring(0, n2);
                string = string5.substring(n2 + 1);
            }
            if (!(string19 = this.resolvePrefixToURI(string2)).equals(this.fTargetNSURIString) && !string19.equals("http://www.w3.org/2000/10/XMLSchema") && string19.length() != 0) {
                string12 = string19;
                complexTypeInfo2 = this.getTypeInfoFromNS(string19, string);
                if (complexTypeInfo2 == null && (datatypeValidator = this.getTypeValidatorFromNS(string19, string)) == null) {
                    bl3 = false;
                    this.reportGenericSchemaError("Could not find type " + string + " in schema " + string19);
                }
            } else {
                complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(String.valueOf(string19) + "," + string);
                if (complexTypeInfo2 == null && (datatypeValidator = this.getDatatypeValidator(string19, string)) == null) {
                    if (string19.equals("http://www.w3.org/2000/10/XMLSchema") && !this.fTargetNSURIString.equals("http://www.w3.org/2000/10/XMLSchema")) {
                        bl3 = false;
                        this.reportGenericSchemaError("type not found : " + string19 + ":" + string);
                    } else {
                        Element element6 = this.getTopLevelComponentByName("complexType", string);
                        if (element6 != null) {
                            if (this.fCurrentTypeNameStack.search(string) > -1) {
                                int n16 = 0;
                                if (string11.equals("qualified") || this.fElementDefaultQualified) {
                                    n16 = this.fTargetNSURI;
                                }
                                int n17 = this.fStringPool.addSymbol(string3);
                                QName qName = new QName(this.fCurrentScope, n17, n17, n16);
                                this.fElementRecurseComplex.put(qName, string);
                                return new QName(-1, n17, n17, n16);
                            }
                            n7 = this.traverseComplexTypeDecl(element6);
                            complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n7));
                        } else {
                            element6 = this.getTopLevelComponentByName("simpleType", string);
                            if (element6 != null) {
                                n7 = this.traverseSimpleTypeDecl(element6);
                                datatypeValidator = this.getDatatypeValidator(string19, string);
                            } else {
                                bl3 = false;
                                this.reportGenericSchemaError("type not found : " + string19 + ":" + string);
                            }
                        }
                    }
                }
            }
        } else if (bl4) {
            if (element4 != null) {
                this.checkSubstitutionGroupOK(element, element4);
            }
        } else if (complexTypeInfo2 == null && datatypeValidator == null) {
            complexTypeInfo2 = complexTypeInfo;
            datatypeValidator = datatypeValidator2;
        }
        if (complexTypeInfo2 == null && datatypeValidator == null) {
            if (bl3) {
                n5 = 1;
            } else {
                bl3 = false;
                this.reportGenericSchemaError("untyped element : " + string3);
            }
        }
        if (complexTypeInfo2 != null) {
            n6 = complexTypeInfo2.contentSpecHandle;
            n5 = complexTypeInfo2.contentType;
            n8 = complexTypeInfo2.scopeDefined;
            datatypeValidator = complexTypeInfo2.datatypeValidator;
        }
        if (datatypeValidator != null) {
            n5 = 4;
            if (complexTypeInfo2 == null) {
                string12 = null;
            }
        }
        int n18 = n = this.fStringPool.addSymbol(string3);
        n2 = 0;
        int n19 = this.fCurrentScope;
        if (this.isTopLevel(element)) {
            n2 = this.fTargetNSURI;
            n19 = -1;
        } else if (!string11.equals("unqualified") && (string11.equals("qualified") || this.fElementDefaultQualified)) {
            n2 = this.fTargetNSURI;
        }
        int n20 = this.fSchemaGrammar.getElementDeclIndex(n2, n18, n19);
        if (n20 > -1) {
            this.fSchemaGrammar.getElementDecl(n20, this.fTempElementDecl);
            object = this.fTempElementDecl.datatypeValidator;
            ComplexTypeInfo complexTypeInfo3 = this.fSchemaGrammar.getElementComplexTypeInfo(n20);
            if (complexTypeInfo3 != null && complexTypeInfo3 != complexTypeInfo2 || object != null && object != datatypeValidator) {
                bl3 = false;
                this.reportGenericSchemaError("duplicate element decl in the same scope : " + this.fStringPool.toString(n18));
            }
        }
        object = new QName(-1, n18, n, n2);
        int n21 = -1;
        if (complexTypeInfo2 != null) {
            n21 = complexTypeInfo2.attlistHead;
        }
        int n22 = this.fSchemaGrammar.addElementDecl((QName)object, n19, n8, n5, n6, n21, datatypeValidator);
        this.fSchemaGrammar.setElementComplexTypeInfo(n22, complexTypeInfo2);
        this.fSchemaGrammar.setElementFromAnotherSchemaURI(n22, string12);
        this.fSchemaGrammar.setElementDeclBlockSet(n22, n4);
        this.fSchemaGrammar.setElementDeclFinalSet(n22, n3);
        this.fSchemaGrammar.setElementDeclMiscFlags(n22, n9);
        this.fSchemaGrammar.setElementDeclSubstitutionGroupElementFullName(n22, string18);
        Element element7 = XUtil.getFirstChildElement((Node)element, IDENTITY_CONSTRAINTS);
        if (element7 != null) {
            Integer n23 = new Integer(n22);
            Vector<Element> vector = (Vector<Element>)this.fIdentityConstraints.get(n23);
            if (vector == null) {
                vector = new Vector<Element>();
                this.fIdentityConstraints.put(n23, vector);
            }
            while (element7 != null) {
                vector.addElement(element7);
                element7 = XUtil.getNextSiblingElement((Node)element7, IDENTITY_CONSTRAINTS);
            }
        }
        return object;
    }

    private int traverseGroupDecl(Element element) throws Exception {
        String string;
        String string2;
        Object object;
        String string3 = element.getAttribute("name");
        String string4 = element.getAttribute("ref");
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        if (!string4.equals("")) {
            if (this.isTopLevel(element)) {
                this.reportGenericSchemaError("A group with \"ref\" present must not have <schema> or <redefine> as its parent");
            }
            if (!string3.equals("")) {
                this.reportGenericSchemaError("group " + string3 + " cannot refer to another group, but it refers to " + string4);
            }
            String string5 = "";
            String string6 = string4;
            int n = string4.indexOf(":");
            if (n > 0) {
                string5 = string4.substring(0, n);
                string6 = string4.substring(n + 1);
            }
            int n2 = this.fStringPool.addSymbol(string6);
            String string7 = this.resolvePrefixToURI(string5);
            if (!string7.equals(this.fTargetNSURIString)) {
                return this.traverseGroupDeclFromAnotherSchema(string6, string7);
            }
            Object v = this.fGroupNameRegistry.get(String.valueOf(string7) + "," + string6);
            if (v != null) {
                return (Integer)v;
            }
            int n3 = -1;
            Element element3 = this.getTopLevelComponentByName("group", string6);
            if (element3 == null) {
                this.reportGenericSchemaError("Group " + string6 + " not found in the Schema");
            } else {
                n3 = this.traverseGroupDecl(element3);
            }
            return n3;
        }
        if (string3.equals("")) {
            this.reportGenericSchemaError("a <group> must have a name or a ref present");
        }
        if ((object = this.fGroupNameRegistry.get(string2 = String.valueOf(this.fTargetNSURIString) + "," + string3)) != null) {
            return (Integer)object;
        }
        int n = -2;
        boolean bl = false;
        String string8 = string = element2 != null ? element2.getLocalName() : "";
        if (string.equals("all")) {
            n = this.traverseAll(element2);
        } else if (string.equals("choice")) {
            n = this.traverseChoice(element2);
        } else if (string.equals("sequence")) {
            n = this.traverseSequence(element2);
        } else if (!string.equals("") || element2 != null && XUtil.getNextSiblingElement(element2) != null) {
            bl = true;
            this.reportSchemaError(14, new Object[]{"group", string});
        }
        if (element2 != null && XUtil.getNextSiblingElement(element2) != null) {
            bl = true;
            this.reportSchemaError(14, new Object[]{"group", string});
        }
        if (!bl && element2 != null) {
            n = this.expandContentModel(n, element2);
        }
        object = new Integer(n);
        this.fGroupNameRegistry.put(string2, object);
        return n;
    }

    private int traverseGroupDeclFromAnotherSchema(String string, String string2) throws Exception {
        String string3;
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || schemaGrammar == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #traverseGroupDeclFromAnotherSchema, schema uri: " + string2 + ", groupName: " + string);
            return -1;
        }
        Element element = (Element)schemaGrammar.topLevelGroupDecls.get(string);
        if (element == null) {
            this.reportGenericSchemaError("no group named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        NamespacesScope namespacesScope = this.fNamespacesScope;
        int n = this.fTargetNSURI;
        this.fTargetNSURI = this.fStringPool.addSymbol(schemaGrammar.getTargetNamespaceURI());
        this.fNamespacesScope = schemaGrammar.getNamespacesScope();
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        String string4 = String.valueOf(this.fTargetNSURIString) + "," + string;
        Object object = this.fGroupNameRegistry.get(string4);
        if (object != null) {
            return (Integer)object;
        }
        int n2 = -2;
        boolean bl = false;
        String string5 = string3 = element2 != null ? element2.getLocalName() : "";
        if (string3.equals("all")) {
            n2 = this.traverseAll(element2);
        } else if (string3.equals("choice")) {
            n2 = this.traverseChoice(element2);
        } else if (string3.equals("sequence")) {
            n2 = this.traverseSequence(element2);
        } else if (!string3.equals("") || element2 != null && XUtil.getNextSiblingElement(element2) != null) {
            bl = true;
            this.reportSchemaError(14, new Object[]{"group", string3});
        }
        if (!bl && element2 != null) {
            n2 = this.expandContentModel(n2, element2);
        }
        object = new Integer(n2);
        this.fGroupNameRegistry.put(string4, object);
        this.fNamespacesScope = namespacesScope;
        this.fTargetNSURI = n;
        return n2;
    }

    private void traverseIdentityConstraint(IdentityConstraint identityConstraint, Element element) throws Exception {
        Object object;
        Element element2 = XUtil.getFirstChildElement((Node)element, "selector");
        String string = element2.getAttribute("xpath");
        string = string.trim();
        Selector.XPath xPath = null;
        try {
            xPath = new Selector.XPath(string, this.fStringPool, this.fNamespacesScope);
            object = new Selector(xPath, identityConstraint);
            identityConstraint.setSelector((Selector)object);
        }
        catch (XPathException xPathException) {
            this.reportGenericSchemaError(xPathException.getMessage());
            return;
        }
        object = (Element)element.getParentNode();
        Element element3 = XUtil.getNextSiblingElement((Node)element2, "field");
        while (element3 != null) {
            String string2 = element3.getAttribute("xpath");
            string2 = string2.trim();
            try {
                Field.XPath xPath2 = new Field.XPath(string2, this.fStringPool, this.fNamespacesScope);
                DatatypeValidator datatypeValidator = this.getDatatypeValidatorFor((Element)object, xPath, xPath2);
                Field field = new Field(xPath2, datatypeValidator, identityConstraint);
                identityConstraint.addField(field);
            }
            catch (XPathException xPathException) {
                this.reportGenericSchemaError(xPathException.getMessage());
                return;
            }
            element3 = XUtil.getNextSiblingElement((Node)element3, "field");
        }
    }

    private void traverseIdentityConstraintsFor(int n, Vector vector) throws Exception {
        int n2;
        int n3 = n2 = vector != null ? vector.size() : 0;
        if (n2 > 0) {
            XMLElementDecl xMLElementDecl = new XMLElementDecl();
            this.fSchemaGrammar.getElementDecl(n, xMLElementDecl);
            int n4 = 0;
            while (n4 < n2) {
                Element element = (Element)vector.elementAt(n4);
                String string = element.getLocalName();
                if (string.equals("key")) {
                    this.traverseKey(element, xMLElementDecl);
                } else if (string.equals("keyref")) {
                    this.traverseKeyRef(element, xMLElementDecl);
                } else if (string.equals("unique")) {
                    this.traverseUnique(element, xMLElementDecl);
                } else {
                    throw new RuntimeException("identity constraint must be one of \"unique\", \"key\", or \"keyref\"");
                }
                this.fSchemaGrammar.setElementDecl(n, xMLElementDecl);
                ++n4;
            }
        }
    }

    private void traverseImport(Element element) throws Exception {
        String string = element.getAttribute("schemaLocation");
        InputSource inputSource = null;
        if (this.fEntityResolver != null) {
            inputSource = this.fEntityResolver.resolveEntity("", string);
        }
        if (inputSource == null) {
            string = this.expandSystemId(string, this.fCurrentSchemaURL);
            inputSource = new InputSource(string);
        } else {
            if (inputSource.getPublicId() != null) {
                string = inputSource.getPublicId();
            }
            string = String.valueOf(string) + ',' + inputSource.getSystemId();
        }
        if (this.fImportLocations.contains(string)) {
            return;
        }
        this.fImportLocations.addElement(string);
        String string2 = element.getAttribute("namespace");
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (schemaGrammar == null) {
            schemaGrammar = new SchemaGrammar();
        }
        IgnoreWhitespaceParser ignoreWhitespaceParser = new IgnoreWhitespaceParser();
        ignoreWhitespaceParser.setEntityResolver(new Resolver());
        ignoreWhitespaceParser.setErrorHandler(new ErrorHandler());
        try {
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/validation", false);
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/namespaces", true);
            ignoreWhitespaceParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            ignoreWhitespaceParser.parse(inputSource);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        Document document = ignoreWhitespaceParser.getDocument();
        Element element2 = null;
        if (document != null) {
            element2 = document.getDocumentElement();
        }
        if (element2 != null) {
            String string3 = element2.getAttribute("targetNamespace");
            if (!string3.equals(string2)) {
                this.reportGenericSchemaError("imported schema '" + string + "' has a different targetNameSpace '" + string3 + "' from what is declared '" + string2 + "'.");
            } else {
                new TraverseSchema(element2, this.fStringPool, schemaGrammar, this.fGrammarResolver, this.fErrorReporter, string, this.fEntityResolver);
            }
        } else {
            this.reportGenericSchemaError("Could not get the doc root for imported Schema file: " + string);
        }
    }

    private void traverseInclude(Element element) throws Exception {
        Attr attr = element.getAttributeNode("schemaLocation");
        if (attr == null) {
            this.reportGenericSchemaError("a schemaLocation attribute must be specified on an <include> element");
            return;
        }
        String string = attr.getValue();
        InputSource inputSource = null;
        if (this.fEntityResolver != null) {
            inputSource = this.fEntityResolver.resolveEntity("", string);
        }
        if (inputSource == null) {
            string = this.expandSystemId(string, this.fCurrentSchemaURL);
            inputSource = new InputSource(string);
        } else {
            if (inputSource.getPublicId() != null) {
                string = inputSource.getPublicId();
            }
            string = String.valueOf(string) + ',' + inputSource.getSystemId();
        }
        if (this.fIncludeLocations.contains(string)) {
            return;
        }
        this.fIncludeLocations.addElement(string);
        IgnoreWhitespaceParser ignoreWhitespaceParser = new IgnoreWhitespaceParser();
        ignoreWhitespaceParser.setEntityResolver(new Resolver());
        ignoreWhitespaceParser.setErrorHandler(new ErrorHandler());
        try {
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/validation", false);
            ignoreWhitespaceParser.setFeature("http://xml.org/sax/features/namespaces", true);
            ignoreWhitespaceParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            ignoreWhitespaceParser.parse(inputSource);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {}
        Document document = ignoreWhitespaceParser.getDocument();
        Element element2 = null;
        if (document != null) {
            element2 = document.getDocumentElement();
        }
        if (element2 != null) {
            String string2 = element2.getAttribute("targetNamespace");
            if (string2.length() > 0 && !string2.equals(this.fTargetNSURIString)) {
                this.reportGenericSchemaError("included schema '" + string + "' has a different targetNameSpace '" + string2 + "'");
            } else {
                if (this.fSchemaInfoListRoot == null) {
                    this.fCurrentSchemaInfo = this.fSchemaInfoListRoot = new SchemaInfo(this.fElementDefaultQualified, this.fAttributeDefaultQualified, this.fCurrentScope, this.fCurrentSchemaURL, this.fSchemaRootElement, null, null);
                }
                this.fSchemaRootElement = element2;
                this.fCurrentSchemaURL = string;
                this.traverseIncludedSchemaHeader(element2);
                this.fCurrentSchemaInfo = new SchemaInfo(this.fElementDefaultQualified, this.fAttributeDefaultQualified, this.fCurrentScope, this.fCurrentSchemaURL, this.fSchemaRootElement, this.fCurrentSchemaInfo.getNext(), this.fCurrentSchemaInfo);
                this.fCurrentSchemaInfo.getPrev().setNext(this.fCurrentSchemaInfo);
                this.traverseIncludedSchema(element2);
                this.fCurrentSchemaInfo = this.fCurrentSchemaInfo.getPrev();
                this.fCurrentSchemaInfo.restore();
            }
        }
    }

    private void traverseIncludedSchema(Element element) throws Exception {
        String string;
        this.checkTopLevelDuplicateNames(element);
        this.extractTopLevel3Components(element);
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            string = element2.getLocalName();
            if (string.equals("annotation")) {
                this.traverseAnnotationDecl(element2);
            } else if (string.equals("include")) {
                this.traverseInclude(element2);
            } else if (string.equals("import")) {
                this.traverseImport(element2);
            } else {
                if (!string.equals("redefine")) break;
                this.fRedefineSucceeded = true;
                this.traverseRedefine(element2);
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        while (element2 != null) {
            string = element2.getLocalName();
            if (string.equals("annotation")) {
                this.traverseAnnotationDecl(element2);
            } else if (string.equals("simpleType")) {
                this.traverseSimpleTypeDecl(element2);
            } else if (string.equals("complexType")) {
                this.traverseComplexTypeDecl(element2);
            } else if (string.equals("element")) {
                this.traverseElementDecl(element2);
            } else if (string.equals("attributeGroup")) {
                this.traverseAttributeGroupDecl(element2, null, null);
            } else if (string.equals("attribute")) {
                this.traverseAttributeDecl(element2, null, false);
            } else if (string.equals("group")) {
                this.traverseGroupDecl(element2);
            } else if (string.equals("notation")) {
                this.traverseNotationDecl(element2);
            } else {
                this.reportGenericSchemaError("error in content of included <schema> element information item");
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
    }

    private void traverseIncludedSchemaHeader(Element element) throws Exception {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        Attr attr = null;
        boolean bl = false;
        while ((attr = (Attr)namedNodeMap.item(n++)) != null) {
            String string;
            String string2 = attr.getName();
            if (string2.startsWith("xmlns:")) {
                string = attr.getValue();
                String string3 = string2.substring(string2.indexOf(":") + 1);
                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(string3), this.fStringPool.addSymbol(string));
            }
            if (!string2.equals("xmlns")) continue;
            string = attr.getValue();
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(string));
            bl = true;
        }
        if (!bl && this.fTargetNSURIString.length() == 0) {
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(""));
        }
        this.fElementDefaultQualified = element.getAttribute("elementFormDefault").equals("qualified");
        this.fAttributeDefaultQualified = element.getAttribute("attributeFormDefault").equals("qualified");
        if (this.fTargetNSURI == 0) {
            this.fElementDefaultQualified = true;
        }
        this.fCurrentScope = -1;
    }

    private void traverseKey(Element element, XMLElementDecl xMLElementDecl) throws Exception {
        String string = element.getAttribute("name");
        String string2 = this.getElementNameFor(element);
        Key key = new Key(string, string2);
        this.traverseIdentityConstraint(key, element);
        xMLElementDecl.key.addElement(key);
    }

    private void traverseKeyRef(Element element, XMLElementDecl xMLElementDecl) throws Exception {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("refer");
        Element element2 = (Element)element.getParentNode();
        Element element3 = XUtil.getFirstChildElement(element2, "key", "name", string2);
        if (element3 == null) {
            this.reportSchemaError(37, new Object[]{string, string2});
            return;
        }
        String string3 = this.getElementNameFor(element);
        KeyRef keyRef = new KeyRef(string, string2, string3);
        this.traverseIdentityConstraint(keyRef, element);
        xMLElementDecl.keyRef.addElement(keyRef);
    }

    private String traverseNotationDecl(Element element) throws Exception {
        String string;
        String string2 = string = element.getAttribute("name");
        if (this.fTargetNSURIString.length() != 0) {
            string2 = String.valueOf(this.fTargetNSURIString) + ":" + string;
        }
        if (this.fNotationRegistry.get(string2) != null) {
            return string;
        }
        String string3 = element.getAttribute("public");
        String string4 = element.getAttribute("system");
        if (string3.equals("") && string4.equals("")) {
            this.reportGenericSchemaError("<notation> declaration is invalid");
        }
        if (string.equals("")) {
            this.reportGenericSchemaError("<notation> declaration does not have a name");
        }
        this.fNotationRegistry.put(string2, string);
        this.checkContent(element, XUtil.getFirstChildElement(element), true);
        return string;
    }

    private String traverseNotationFromAnotherSchema(String string, String string2) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || schemaGrammar == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #traverseNotationDeclFromAnotherSchema, schema uri: " + string2 + ", groupName: " + string);
            return "";
        }
        String string3 = this.fTargetNSURIString;
        this.fTargetNSURIString = this.fStringPool.toString(this.fStringPool.addSymbol(schemaGrammar.getTargetNamespaceURI()));
        String string4 = String.valueOf(this.fTargetNSURIString) + ":" + string;
        String string5 = (String)this.fNotationRegistry.get(string4);
        if (string5 != null) {
            return string5;
        }
        Element element = (Element)schemaGrammar.topLevelNotationDecls.get(string);
        if (element == null) {
            this.reportGenericSchemaError("no notation named \"" + string + "\" was defined in schema : " + string2);
            return "";
        }
        string5 = this.traverseNotationDecl(element);
        this.fTargetNSURIString = string3;
        return string5;
    }

    private void traverseRedefine(Element element) throws Exception {
        Object object;
        if (this.fSchemaInfoListRoot == null) {
            this.fSchemaInfoListRoot = new SchemaInfo(this.fElementDefaultQualified, this.fAttributeDefaultQualified, this.fCurrentScope, this.fCurrentSchemaURL, this.fSchemaRootElement, null, null);
            this.openRedefinedSchema(element, this.fSchemaInfoListRoot);
            if (!this.fRedefineSucceeded) {
                return;
            }
            this.fCurrentSchemaInfo = this.fSchemaInfoListRoot.getNext();
            this.renameRedefinedComponents(element, this.fSchemaInfoListRoot.getNext().getRoot(), this.fSchemaInfoListRoot.getNext());
        } else {
            object = this.fSchemaInfoListRoot;
            while (((SchemaInfo)object).getNext() != null) {
                object = ((SchemaInfo)object).getNext();
            }
            this.fCurrentSchemaInfo = object;
            this.fCurrentSchemaInfo.restore();
            this.openRedefinedSchema(element, this.fCurrentSchemaInfo);
            if (!this.fRedefineSucceeded) {
                return;
            }
            this.renameRedefinedComponents(element, this.fCurrentSchemaInfo.getRoot(), this.fCurrentSchemaInfo);
        }
        this.traverseIncludedSchema(this.fSchemaRootElement);
        object = XUtil.getFirstChildElement(element);
        while (object != null) {
            String string = object.getLocalName();
            if (string.equals("annotation")) {
                this.traverseAnnotationDecl((Element)object);
            } else if (string.equals("simpleType")) {
                this.traverseSimpleTypeDecl((Element)object);
            } else if (string.equals("complexType")) {
                this.traverseComplexTypeDecl((Element)object);
            } else if (string.equals("group")) {
                this.traverseGroupDecl((Element)object);
            } else if (string.equals("attributeGroup")) {
                this.traverseAttributeGroupDecl((Element)object, null, null);
            }
            object = XUtil.getNextSiblingElement((Node)object);
        }
        this.fCurrentSchemaInfo = this.fCurrentSchemaInfo.getPrev();
        this.fCurrentSchemaInfo.restore();
    }

    int traverseSequence(Element element) throws Exception {
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), true);
        int n = 0;
        int n2 = 0;
        n2 = 5;
        n = 3;
        int n3 = -2;
        int n4 = -2;
        boolean bl = false;
        while (element2 != null) {
            block16: {
                boolean bl2;
                int n5;
                block14: {
                    String string;
                    block15: {
                        block13: {
                            n5 = -2;
                            bl = true;
                            bl2 = false;
                            string = element2.getLocalName();
                            if (!string.equals("element")) break block13;
                            QName qName = this.traverseElementDecl(element2);
                            n5 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                            bl2 = true;
                            break block14;
                        }
                        if (!string.equals("group")) break block15;
                        n5 = this.traverseGroupDecl(element2);
                        if (n5 == -1) break block16;
                        bl2 = true;
                        break block14;
                    }
                    if (string.equals("choice")) {
                        n5 = this.traverseChoice(element2);
                        bl2 = true;
                    } else if (string.equals("sequence")) {
                        n5 = this.traverseSequence(element2);
                        bl2 = true;
                    } else if (string.equals("any")) {
                        n5 = this.traverseAny(element2);
                        bl2 = true;
                    } else {
                        this.reportSchemaError(14, new Object[]{"group", string});
                    }
                }
                if (bl2) {
                    n5 = this.expandContentModel(n5, element2);
                }
                if (n3 == -2) {
                    n3 = n5;
                } else if (n4 == -2) {
                    n4 = n5;
                } else {
                    n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
                    n4 = n5;
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl && n4 != -2) {
            n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
        }
        return n3;
    }

    private void traverseSimpleContentDecl(int n, Element element, ComplexTypeInfo complexTypeInfo) throws Exception {
        int n2;
        String string = this.fStringPool.toString(n);
        String string2 = element.getAttribute("ID");
        complexTypeInfo.contentType = 4;
        complexTypeInfo.contentSpecHandle = -1;
        Element element2 = this.checkContent(element, XUtil.getFirstChildElement(element), false);
        if (element2 == null) {
            throw new ComplexTypeRecoverableError();
        }
        String string3 = element2.getLocalName();
        if (string3.equals("restriction")) {
            complexTypeInfo.derivedBy = 2;
        } else if (string3.equals("extension")) {
            complexTypeInfo.derivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("The content of the simpleContent element is invalid.  The content must be RESTRICTION or EXTENSION");
        }
        String string4 = element2.getAttribute("base");
        String string5 = element2.getAttribute("ID");
        Element element3 = this.checkContent(element2, XUtil.getFirstChildElement(element2), true);
        if (string4.length() == 0) {
            throw new ComplexTypeRecoverableError("The BASE attribute must be specified for the RESTRICTION or EXTENSION element");
        }
        QName qName = this.parseBase(string4);
        this.processBaseTypeInfo(qName, complexTypeInfo);
        if (complexTypeInfo.baseComplexTypeInfo != null && complexTypeInfo.baseComplexTypeInfo.contentSpecHandle > -1) {
            throw new ComplexTypeRecoverableError("The type '" + string4 + "' specified as the " + "base in the simpleContent element must not have complexContent");
        }
        Element element4 = null;
        if (complexTypeInfo.derivedBy == 2) {
            if (complexTypeInfo.baseDataTypeValidator != null) {
                throw new ComplexTypeRecoverableError("The type '" + string4 + "' is a simple type.  It cannot be used in a " + "derivation by RESTRICTION for a complexType");
            }
            complexTypeInfo.baseDataTypeValidator = complexTypeInfo.baseComplexTypeInfo.datatypeValidator;
            if (element3.getLocalName().equals("simpleType")) {
                n2 = this.traverseSimpleTypeDecl(element3);
                if (n2 != -1) {
                    complexTypeInfo.baseDataTypeValidator = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(n2));
                    element3 = XUtil.getNextSiblingElement(element3);
                } else {
                    throw new ComplexTypeRecoverableError();
                }
            }
            n2 = 0;
            int n3 = 0;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Vector<String> vector = new Vector<String>();
            Element element5 = element3;
            while (element5 != null && (element5.getLocalName().equals("minExclusive") || element5.getLocalName().equals("minInclusive") || element5.getLocalName().equals("maxExclusive") || element5.getLocalName().equals("maxInclusive") || element5.getLocalName().equals("precision") || element5.getLocalName().equals("scale") || element5.getLocalName().equals("length") || element5.getLocalName().equals("minLength") || element5.getLocalName().equals("maxLength") || element5.getLocalName().equals("encoding") || element5.getLocalName().equals("period") || element5.getLocalName().equals("duration") || element5.getLocalName().equals("enumeration") || element5.getLocalName().equals("pattern") || element5.getLocalName().equals("annotation"))) {
                if (element5.getNodeType() == 1) {
                    Element element6 = element5;
                    ++n3;
                    if (element6.getLocalName().equals("enumeration")) {
                        ++n2;
                        vector.addElement(element6.getAttribute("value"));
                        Element element7 = XUtil.getFirstChildElement(element6);
                        if (element7 != null && element7.getLocalName().equals("annotation")) {
                            this.traverseAnnotationDecl(element5);
                        }
                    } else {
                        hashtable.put(element6.getLocalName(), element6.getAttribute("value"));
                    }
                }
                element5 = XUtil.getNextSiblingElement(element5);
            }
            if (n2 > 0) {
                hashtable.put("enumeration", vector);
            }
            complexTypeInfo.datatypeValidator = n3 > 0 ? this.fDatatypeRegistry.createDatatypeValidator(string, complexTypeInfo.baseDataTypeValidator, hashtable, false) : complexTypeInfo.baseDataTypeValidator;
            if (element5 != null) {
                if (!this.isAttrOrAttrGroup(element5)) {
                    throw new ComplexTypeRecoverableError("Invalid child in the RESTRICTION element of simpleContent");
                }
                element4 = element5;
            }
        } else {
            if (complexTypeInfo.baseComplexTypeInfo != null) {
                complexTypeInfo.baseDataTypeValidator = complexTypeInfo.baseComplexTypeInfo.datatypeValidator;
            }
            complexTypeInfo.datatypeValidator = complexTypeInfo.baseDataTypeValidator;
            if (element3 != null) {
                if (!this.isAttrOrAttrGroup(element3)) {
                    throw new ComplexTypeRecoverableError("Only annotations and attributes are allowed in the content of an EXTENSION element for a complexType with simpleContent");
                }
                element4 = element3;
            }
        }
        n2 = this.fStringPool.addSymbol("$" + string);
        complexTypeInfo.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, n2, n, this.fTargetNSURI), this.fTargetNSURI == 0 ? 0 : this.fCurrentScope, complexTypeInfo.scopeDefined, complexTypeInfo.contentType, complexTypeInfo.contentSpecHandle, -1, complexTypeInfo.datatypeValidator);
        complexTypeInfo.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(complexTypeInfo.templateElementIndex);
        this.processAttributes(element4, qName, complexTypeInfo);
        if (XUtil.getNextSiblingElement(element2) != null) {
            throw new ComplexTypeRecoverableError("Invalid child following the RESTRICTION or EXTENSION element in the complex type definition");
        }
    }

    /*
     * Unable to fully structure code
     */
    private int traverseSimpleTypeDecl(Element var1_1) throws Exception {
        var3_3 = var2_2 = var1_1.getAttribute("name");
        if (this.fTargetNSURIString.length() != 0) {
            var3_3 = String.valueOf(this.fTargetNSURIString) + "," + var2_2;
        }
        if (this.fDatatypeRegistry.getDatatypeValidator(var3_3) != null) {
            return this.fStringPool.addSymbol(var3_3);
        }
        var4_4 = false;
        var5_5 = false;
        var6_6 = false;
        var7_7 = -1;
        var7_7 = var2_2.equals("") != false ? this.fStringPool.addSymbol("#S#" + this.fSimpleTypeAnonCount++) : this.fStringPool.addSymbol(var2_2);
        var8_8 = XUtil.getFirstChildElement(var1_1);
        if ((var8_8 = this.checkContent(var1_1, var8_8, false)) == null) {
            return -1;
        }
        var9_9 = var8_8.getLocalName();
        var10_10 = null;
        var11_11 = null;
        var12_12 = 0;
        var13_13 = null;
        var14_14 = 0;
        if (var9_9.equals("list")) {
            var10_10 = var8_8.getAttribute("itemType");
            var4_4 = true;
        } else if (var9_9.equals("restriction")) {
            var10_10 = var8_8.getAttribute("base");
            var6_6 = true;
        } else if (var9_9.equals("union")) {
            var5_5 = true;
            var10_10 = var8_8.getAttribute("memberTypes");
            if (!var10_10.equals("")) {
                var13_13 = new StringTokenizer(var10_10);
                var12_12 = var13_13.countTokens();
            } else {
                var12_12 = 1;
            }
            var11_11 = new Vector<DatatypeValidator>(var12_12, 2);
        } else {
            this.reportSchemaError(7, new Object[]{var9_9});
            return -1;
        }
        if (XUtil.getNextSiblingElement(var8_8) != null) {
            this.reportGenericSchemaError("error in content of simpleType");
        }
        var16_15 = null;
        if (!var10_10.equals("")) ** GOTO lbl57
        var8_8 = XUtil.getFirstChildElement(var8_8);
        if ((var8_8 = this.checkContent(var1_1, var8_8, false)) == null) {
            return -1;
        }
        if (var8_8.getLocalName().equals("simpleType")) {
            var15_16 = this.traverseSimpleTypeDecl(var8_8);
            if (var15_16 != -1 && (var16_15 = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(var15_16))) != null && var5_5) {
                var11_11.addElement(var16_15);
            }
            if (var15_16 == -1 || var16_15 == null) {
                this.reportSchemaError(15, new Object[]{var8_8.getAttribute("base"), var8_8.getAttribute("name")});
                return -1;
            }
        } else {
            this.reportSchemaError(27, new Object[]{var1_1.getAttribute("name")});
            return -1;
lbl57:
            // 1 sources

            var14_14 = 1;
            if (var5_5) {
                var14_14 = var12_12;
            }
            var17_17 = 0;
            while (var17_17 < var14_14) {
                if (var5_5) {
                    var10_10 = var13_13.nextToken();
                }
                if ((var16_15 = this.findDTValidator(var1_1, var10_10)) == null) {
                    return -1;
                }
                if (var5_5) {
                    var11_11.addElement(var16_15);
                }
                if (var4_4 && var16_15 instanceof UnionDatatypeValidator) {
                    this.reportSchemaError(15, new Object[]{var1_1.getAttribute("base"), var1_1.getAttribute("name")});
                    return -1;
                }
                ++var17_17;
            }
        }
        var8_8 = var10_10.equals("") != false ? XUtil.getNextSiblingElement(var8_8) : XUtil.getFirstChildElement(var8_8);
        if (var5_5) {
            var17_17 = var12_12;
            if (!var10_10.equals("")) {
                var8_8 = this.checkContent(var1_1, var8_8, true);
            }
            while (var8_8 != null) {
                var15_16 = this.traverseSimpleTypeDecl(var8_8);
                if (var15_16 != -1 && (var16_15 = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(var15_16))) != null) {
                    var11_11.addElement(var16_15);
                }
                if (var16_15 == null || var15_16 == -1) {
                    this.reportSchemaError(15, new Object[]{var1_1.getAttribute("base"), var1_1.getAttribute("name")});
                    return -1;
                }
                var8_8 = XUtil.getNextSiblingElement(var8_8);
            }
        }
        var17_18 = null;
        var18_19 = 0;
        var17_18 = new Hashtable<String, Object>();
        if (var6_6 && var8_8 != null) {
            var19_20 = 0;
            var20_23 = new Vector<String>();
            var8_8 = this.checkContent(var1_1, var8_8, true);
            var21_24 = null;
            while (var8_8 != null) {
                if (var8_8.getNodeType() == 1) {
                    ++var18_19;
                    var22_25 = var8_8.getLocalName();
                    if (var22_25.equals("enumeration")) {
                        ++var19_20;
                        var23_26 = var8_8.getAttribute("value");
                        if (var16_15 instanceof NOTATIONDatatypeValidator) {
                            var25_28 = "";
                            var26_29 = var23_26;
                            var27_30 = var23_26.indexOf(":");
                            if (var27_30 > 0) {
                                var25_28 = var23_26.substring(0, var27_30);
                                var26_29 = var23_26.substring(var27_30 + 1);
                            }
                            var28_31 = var25_28.equals("") == false ? this.resolvePrefixToURI(var25_28) : this.fTargetNSURIString;
                            var3_3 = String.valueOf(var28_31) + ":" + var26_29;
                            var24_27 = (String)this.fNotationRegistry.get(var3_3);
                            if (var24_27 == null && (var24_27 = this.traverseNotationFromAnotherSchema(var26_29, var28_31)) == null) {
                                this.reportGenericSchemaError("Notation '" + var26_29 + "' not found in the grammar " + var28_31);
                            }
                            var23_26 = var3_3;
                        }
                        var20_23.addElement(var23_26);
                        this.checkContent(var1_1, XUtil.getFirstChildElement(var8_8), true);
                    } else if (var22_25.equals("annotation")) {
                        this.reportSchemaError(25, new Object[]{var1_1.getAttribute("name")});
                    } else if (var22_25.equals("pattern")) {
                        if (var21_24 == null) {
                            var21_24 = new StringBuffer(var8_8.getAttribute("value"));
                        } else {
                            var21_24.append("|");
                            var21_24.append(var8_8.getAttribute("value"));
                            this.checkContent(var1_1, XUtil.getFirstChildElement(var8_8), true);
                        }
                    } else {
                        var17_18.put(var22_25, var8_8.getAttribute("value"));
                        this.checkContent(var1_1, XUtil.getFirstChildElement(var8_8), true);
                    }
                }
                var8_8 = XUtil.getNextSiblingElement(var8_8);
            }
            if (var19_20 > 0) {
                var17_18.put("enumeration", var20_23);
            }
            if (var21_24 != null) {
                var17_18.put("pattern", var21_24.toString());
            }
        } else if (var4_4 && var8_8 != null) {
            if (!var10_10.equals("")) {
                var8_8 = this.checkContent(var1_1, var8_8, true);
            } else {
                this.reportSchemaError(27, new Object[]{var1_1.getAttribute("name")});
            }
        } else if (var5_5 && var8_8 != null) {
            if (!var10_10.equals("")) {
                var8_8 = this.checkContent(var1_1, var8_8, true);
            } else {
                this.reportSchemaError(27, new Object[]{var1_1.getAttribute("name")});
            }
        }
        var3_3 = this.fStringPool.toString(var7_7);
        if (this.fTargetNSURIString.length() != 0) {
            var3_3 = String.valueOf(this.fTargetNSURIString) + "," + var3_3;
        }
        try {
            var19_21 = this.fDatatypeRegistry.getDatatypeValidator(var3_3);
            if (var19_21 == null) {
                if (var4_4) {
                    this.fDatatypeRegistry.createDatatypeValidator(var3_3, var16_15, var17_18, true);
                } else if (var6_6) {
                    this.fDatatypeRegistry.createDatatypeValidator(var3_3, var16_15, var17_18, false);
                } else {
                    this.fDatatypeRegistry.createDatatypeValidator(var3_3, var11_11);
                }
            }
        }
        catch (Exception var19_22) {
            this.reportSchemaError(21, new Object[]{var19_22.getMessage()});
        }
        return this.fStringPool.addSymbol(var3_3);
    }

    private void traverseUnique(Element element, XMLElementDecl xMLElementDecl) throws Exception {
        String string = element.getAttribute("name");
        String string2 = this.getElementNameFor(element);
        Unique unique = new Unique(string, string2);
        this.traverseIdentityConstraint(unique, element);
        xMLElementDecl.unique.addElement(unique);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean validateRedefineNameChange(String string, String string2, String string3, Element element) throws Exception {
        if (string.equals("simpleType")) {
            QName qName = new QName(-1, this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string2), this.fTargetNSURI);
            Element element2 = XUtil.getFirstChildElement(element);
            if (element2 == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a simpleType child of a <redefine> must have a restriction element as a child");
                return false;
            }
            String string4 = element2.getLocalName();
            if (string4.equals("annotation")) {
                element2 = XUtil.getNextSiblingElement(element2);
                string4 = element2.getLocalName();
            }
            if (element2 == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a simpleType child of a <redefine> must have a restriction element as a child");
                return false;
            }
            if (!string4.equals("restriction")) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a simpleType child of a <redefine> must have a restriction element as a child");
                return false;
            }
            String string5 = element2.getAttribute("base");
            QName qName2 = this.parseBase(string5);
            if (!qName.equals(qName2)) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("the base attribute of the restriction child of a simpleType child of a redefine must have the same value as the simpleType's type attribute");
                return false;
            }
            String string6 = "";
            int n = string5.indexOf(":");
            if (n > 0) {
                string6 = String.valueOf(string5.substring(0, n)) + ":";
            }
            element2.setAttribute("base", String.valueOf(string6) + string3);
            return true;
        }
        if (string.equals("complexType")) {
            QName qName = new QName(-1, this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string2), this.fTargetNSURI);
            Element element3 = XUtil.getFirstChildElement(element);
            if (element3 == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            if (element3.getLocalName().equals("annotation")) {
                element3 = XUtil.getNextSiblingElement(element3);
            }
            if (element3 == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            Element element4 = XUtil.getFirstChildElement(element3);
            if (element4 == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            String string7 = element4.getLocalName();
            if (string7.equals("annotation")) {
                element4 = XUtil.getNextSiblingElement(element4);
                string7 = element4.getLocalName();
            }
            if (element4 == null) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            if (!string7.equals("restriction") && !string7.equals("extension")) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("a complexType child of a <redefine> must have a restriction or extension element as a grandchild");
                return false;
            }
            String string8 = element4.getAttribute("base");
            QName qName3 = this.parseBase(string8);
            if (!qName.equals(qName3)) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("the base attribute of the restriction or extension grandchild of a complexType child of a redefine must have the same value as the complexType's type attribute");
                return false;
            }
            String string9 = "";
            int n = string8.indexOf(":");
            if (n > 0) {
                string9 = String.valueOf(string8.substring(0, n)) + ":";
            }
            element4.setAttribute("base", String.valueOf(string9) + string3);
            return true;
        }
        if (string.equals("attributeGroup")) {
            QName qName = new QName(-1, this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string2), this.fTargetNSURI);
            int n = this.changeRedefineGroup(qName, string, string3, element);
            if (n > 1) {
                this.fRedefineSucceeded = false;
                this.reportGenericSchemaError("if an attributeGroup child of a <redefine> element contains an attributeGroup ref'ing itself, it must have exactly 1; this one has " + n);
                return false;
            }
            if (n == 1) {
                return true;
            }
            this.reportGenericSchemaError("an attributeGroup in a <redefine> must have exactly one ref attribute to itself in schema CR");
            return false;
        }
        if (!string.equals("group")) {
            this.fRedefineSucceeded = false;
            this.reportGenericSchemaError("internal Xerces error; please submit a bug with schema as testcase");
            return false;
        }
        QName qName = new QName(-1, this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string2), this.fTargetNSURI);
        int n = this.changeRedefineGroup(qName, string, string3, element);
        if (n > 1) {
            this.fRedefineSucceeded = false;
            this.reportGenericSchemaError("if a group child of a <redefine> element contains a group ref'ing itself, it must have exactly 1; this one has " + n);
            return false;
        }
        if (n == 1) {
            return true;
        }
        this.reportGenericSchemaError("a group in a <redefine> must have exactly one ref attribute to itself in schema CR");
        return false;
    }

    public class ComplexTypeInfo {
        public String typeName;
        public DatatypeValidator baseDataTypeValidator;
        public ComplexTypeInfo baseComplexTypeInfo;
        public int derivedBy = 0;
        public int blockSet = 0;
        public int finalSet = 0;
        public boolean isAbstract = false;
        public int scopeDefined = -1;
        public int contentType;
        public int contentSpecHandle = -1;
        public int templateElementIndex = -1;
        public int attlistHead = -1;
        public DatatypeValidator datatypeValidator;
    }

    private class ComplexTypeRecoverableError
    extends Exception {
        ComplexTypeRecoverableError() {
        }

        ComplexTypeRecoverableError(String string) {
            super(string);
        }
    }

    static class Resolver
    implements EntityResolver {
        private static final String[] SYSTEM = new String[]{"http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/structures.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/datatypes.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/versionInfo.ent"};
        private static final String[] PATH = new String[]{"structures.dtd", "datatypes.dtd", "versionInfo.ent"};

        Resolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws IOException {
            int n = 0;
            while (n < SYSTEM.length) {
                if (string2.equals(SYSTEM[n])) {
                    InputSource inputSource = new InputSource(this.getClass().getResourceAsStream(PATH[n]));
                    inputSource.setPublicId(string);
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
                ++n;
            }
            return null;
        }
    }

    static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        ErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) {
            System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
            throw sAXParseException;
        }

        private String getLocationString(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sAXParseException.getSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getColumnNumber());
            return stringBuffer.toString();
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }
    }

    static class IgnoreWhitespaceParser
    extends DOMParser {
        IgnoreWhitespaceParser() {
        }

        public void ignorableWhitespace(int n) {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }
    }

    public class SchemaInfo {
        private Element saveRoot;
        private boolean saveElementDefaultQualified;
        private boolean saveAttributeDefaultQualified;
        private int saveScope;
        private String savedSchemaURL;
        private SchemaInfo nextRoot;
        private SchemaInfo prevRoot;

        public SchemaInfo(boolean bl, boolean bl2, int n, String string, Element element, SchemaInfo schemaInfo, SchemaInfo schemaInfo2) {
            this.saveElementDefaultQualified = TraverseSchema.this.fElementDefaultQualified;
            this.saveAttributeDefaultQualified = TraverseSchema.this.fAttributeDefaultQualified;
            this.saveScope = TraverseSchema.this.fCurrentScope;
            this.savedSchemaURL = TraverseSchema.this.fCurrentSchemaURL;
            this.saveElementDefaultQualified = bl;
            this.saveAttributeDefaultQualified = bl2;
            this.saveScope = n;
            this.savedSchemaURL = string;
            this.saveRoot = element;
            this.nextRoot = schemaInfo;
            this.prevRoot = schemaInfo2;
        }

        public String getCurrentSchemaURL() {
            return this.savedSchemaURL;
        }

        public SchemaInfo getNext() {
            return this.nextRoot;
        }

        public SchemaInfo getPrev() {
            return this.prevRoot;
        }

        public Element getRoot() {
            return this.saveRoot;
        }

        public void restore() {
            TraverseSchema.this.fCurrentSchemaURL = this.savedSchemaURL;
            TraverseSchema.this.fCurrentScope = this.saveScope;
            TraverseSchema.this.fElementDefaultQualified = this.saveElementDefaultQualified;
            TraverseSchema.this.fAttributeDefaultQualified = this.saveAttributeDefaultQualified;
            TraverseSchema.this.fSchemaRootElement = this.saveRoot;
        }

        public void setNext(SchemaInfo schemaInfo) {
            this.nextRoot = schemaInfo;
        }

        public void setPrev(SchemaInfo schemaInfo) {
            this.prevRoot = schemaInfo;
        }
    }
}

