/*
 * Decompiled with CFR 0.152.
 */
package dom;

import dom.DOMParserWrapper;
import org.apache.xerces.dom.TextImpl;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import util.Arguments;

public class DOMCount {
    private static final String DEFAULT_PARSER_NAME = "dom.wrappers.DOMParser";
    private static boolean setValidation = false;
    private static boolean setNameSpaces = true;
    private static boolean setSchemaSupport = true;
    private static boolean setDeferredDOM = true;
    private long elements;
    private long attributes;
    private long characters;
    private long ignorableWhitespace;

    public static void count(String string, String string2) {
        try {
            DOMParserWrapper dOMParserWrapper = (DOMParserWrapper)Class.forName(string).newInstance();
            DOMCount dOMCount = new DOMCount();
            long l = System.currentTimeMillis();
            dOMParserWrapper.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", setDeferredDOM);
            dOMParserWrapper.setFeature("http://xml.org/sax/features/validation", setValidation);
            dOMParserWrapper.setFeature("http://xml.org/sax/features/namespaces", setNameSpaces);
            dOMParserWrapper.setFeature("http://apache.org/xml/features/validation/schema", setSchemaSupport);
            Document document = dOMParserWrapper.parse(string2);
            dOMCount.traverse(document);
            long l2 = System.currentTimeMillis();
            dOMCount.printResults(string2, l2 - l);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                sAXException.getException().printStackTrace(System.err);
            } else {
                sAXException.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        block16: {
            var1_1 = new Arguments();
            var1_1.setUsage(new String[]{"usage: java dom.DOMCount (options) uri ...", "", "options:", "  -p name  Specify DOM parser wrapper by name.", "  -n | -N  Turn on/off namespace [default=on]", "  -v | -V  Turn on/off validation [default=off]", "  -s | -S  Turn on/off Schema support [default=on]", "  -d | -D  Turn on/off deferred DOM [default=on]", "  -h       This help screen."});
            if (var0.length == 0) {
                var1_1.printUsage();
                System.exit(1);
            }
            var2_2 = "dom.wrappers.DOMParser";
            var1_1.parseArgumentTokens(var0, new char[]{'p'});
            var4_3 = null;
            break block16;
            {
                switch (var3_4) {
                    case 118: {
                        DOMCount.setValidation = true;
                        ** GOTO lbl41
                    }
                    case 86: {
                        DOMCount.setValidation = false;
                        ** GOTO lbl41
                    }
                    case 78: {
                        DOMCount.setNameSpaces = false;
                        ** GOTO lbl41
                    }
                    case 110: {
                        DOMCount.setNameSpaces = true;
                        ** GOTO lbl41
                    }
                    case 112: {
                        var2_2 = var1_1.getStringParameter();
                        ** GOTO lbl41
                    }
                    case 100: {
                        DOMCount.setDeferredDOM = true;
                        ** GOTO lbl41
                    }
                    case 68: {
                        DOMCount.setDeferredDOM = false;
                        ** GOTO lbl41
                    }
                    case 115: {
                        DOMCount.setSchemaSupport = true;
                        ** GOTO lbl41
                    }
                    case 83: {
                        DOMCount.setSchemaSupport = false;
                        ** GOTO lbl41
                    }
                    case 45: 
                    case 63: 
                    case 104: {
                        var1_1.printUsage();
                        System.exit(1);
                    }
lbl41:
                    // 11 sources

                    default: lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if ((var3_4 = var1_1.getArguments()) != -1) continue block13;
                            break;
                        }
                    }
                    case -1: 
                }
            }
            DOMCount.count(var2_2, var4_3);
        }
        ** while ((var4_3 = var1_1.getlistFiles()) != null)
lbl48:
        // 1 sources

    }

    public void printResults(String string, long l) {
        System.out.print(string);
        System.out.print(": ");
        System.out.print(l);
        System.out.print(" ms (");
        System.out.print(this.elements);
        System.out.print(" elems, ");
        System.out.print(this.attributes);
        System.out.print(" attrs, ");
        System.out.print(this.ignorableWhitespace);
        System.out.print(" spaces, ");
        System.out.print(this.characters);
        System.out.print(" chars)");
        System.out.println();
    }

    public void traverse(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.elements = 0L;
                this.attributes = 0L;
                this.characters = 0L;
                this.ignorableWhitespace = 0L;
                this.traverse(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                NodeList nodeList;
                ++this.elements;
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    this.attributes += (long)namedNodeMap.getLength();
                }
                if ((nodeList = node.getChildNodes()) == null) break;
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    this.traverse(nodeList.item(n2));
                    ++n2;
                }
                break;
            }
            case 5: {
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                int n3 = 0;
                while (n3 < n) {
                    this.traverse(nodeList.item(n3));
                    ++n3;
                }
                break;
            }
            case 4: {
                this.characters += (long)node.getNodeValue().length();
                break;
            }
            case 3: {
                if (node instanceof TextImpl) {
                    if (((TextImpl)node).isIgnorableWhitespace()) {
                        this.ignorableWhitespace += (long)node.getNodeValue().length();
                        break;
                    }
                    this.characters += (long)node.getNodeValue().length();
                    break;
                }
                this.characters += (long)node.getNodeValue().length();
                break;
            }
        }
    }
}

