/*
 * Decompiled with CFR 0.152.
 */
package sax;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserFactory;
import sax.helpers.AttributeListImpl;
import util.Arguments;

public class SAXWriter
extends HandlerBase {
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private static boolean setValidation = false;
    private static boolean setNameSpaces = true;
    private static boolean setSchemaSupport = true;
    protected PrintWriter out;
    protected boolean canonical;

    public SAXWriter(boolean bl) throws UnsupportedEncodingException {
        this(null, bl);
    }

    protected SAXWriter(String string, boolean bl) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, string));
        this.canonical = bl;
    }

    public static void print(String string, String string2, boolean bl) {
        try {
            SAXWriter sAXWriter = new SAXWriter(bl);
            Parser parser = ParserFactory.makeParser(string);
            if (parser instanceof XMLReader) {
                ((XMLReader)((Object)parser)).setFeature("http://xml.org/sax/features/validation", setValidation);
                ((XMLReader)((Object)parser)).setFeature("http://xml.org/sax/features/namespaces", setNameSpaces);
                ((XMLReader)((Object)parser)).setFeature("http://apache.org/xml/features/validation/schema", setSchemaSupport);
            }
            parser.setDocumentHandler(sAXWriter);
            parser.setErrorHandler(sAXWriter);
            parser.parse(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void processingInstruction(String string, String string2) {
        this.out.print("<?");
        this.out.print(string);
        if (string2 != null && string2.length() > 0) {
            this.out.print(' ');
            this.out.print(string2);
        }
        this.out.print("?>");
    }

    public void startDocument() {
        if (!this.canonical) {
            this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
    }

    public void startElement(String string, AttributeList attributeList) {
        this.out.print('<');
        this.out.print(string);
        if (attributeList != null) {
            attributeList = this.sortAttributes(attributeList);
            int n = attributeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.out.print(' ');
                this.out.print(attributeList.getName(n2));
                this.out.print("=\"");
                this.out.print(this.normalize(attributeList.getValue(n2)));
                this.out.print('\"');
                ++n2;
            }
        }
        this.out.print('>');
    }

    public void characters(char[] cArray, int n, int n2) {
        this.out.print(this.normalize(new String(cArray, n, n2)));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.characters(cArray, n, n2);
    }

    public void endElement(String string) {
        this.out.print("</");
        this.out.print(string);
        this.out.print('>');
    }

    public void endDocument() {
        this.out.flush();
    }

    public void warning(SAXParseException sAXParseException) {
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    protected String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        stringBuffer.append("&#");
                        stringBuffer.append(Integer.toString(c));
                        stringBuffer.append(';');
                        break;
                    }
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected AttributeList sortAttributes(AttributeList attributeList) {
        AttributeListImpl attributeListImpl = new AttributeListImpl();
        int n = attributeList != null ? attributeList.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            String string = attributeList.getName(n2);
            int n3 = attributeListImpl.getLength();
            int n4 = 0;
            while (n4 < n3) {
                if (string.compareTo(attributeListImpl.getName(n4)) < 0) break;
                ++n4;
            }
            attributeListImpl.insertAttributeAt(n4, string, attributeList.getType(n2), attributeList.getValue(n2));
            ++n2;
        }
        return attributeListImpl;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public static void main(String[] var0) {
        var1_1 = new Arguments();
        var1_1.setUsage(new String[]{"usage: java sax.SAXWriter (options) uri ...", "", "options:", "  -n | -N  Turn on/off namespace [default=on]", "  -v | -V  Turn on/off validation [default=off]", "  -s | -S  Turn on/off Schema support [default=on]", "  -c       Canonical XML output.", "  -h       This help screen."});
        if (var0.length == 0) {
            var1_1.printUsage();
            System.exit(1);
        }
        var2_2 = false;
        var3_3 = "org.apache.xerces.parsers.SAXParser";
        var1_1.parseArgumentTokens(var0, new char[]{'p'});
        var5_4 = null;
        ** GOTO lbl49
        {
            switch (var4_5) {
                case 99: {
                    var2_2 = true;
                    break;
                }
                case 67: {
                    var2_2 = false;
                    break;
                }
                case 118: {
                    SAXWriter.setValidation = true;
                    break;
                }
                case 86: {
                    SAXWriter.setValidation = false;
                    break;
                }
                case 78: {
                    SAXWriter.setNameSpaces = false;
                    break;
                }
                case 110: {
                    SAXWriter.setNameSpaces = true;
                    break;
                }
                case 112: {
                    var3_3 = var1_1.getStringParameter();
                    break;
                }
                case 115: {
                    SAXWriter.setSchemaSupport = true;
                    break;
                }
                case 83: {
                    SAXWriter.setSchemaSupport = false;
                    break;
                }
                case 45: 
                case 63: 
                case 104: {
                    var1_1.printUsage();
                    System.exit(1);
                    break;
                }
                case -1: {
                    ** GOTO lbl47
                }
            }
            do {
                if ((var4_5 = var1_1.getArguments()) != -1) continue block13;
lbl47:
                // 2 sources

                System.err.println(var5_4 + ':');
                SAXWriter.print(var3_3, var5_4, var2_2);
lbl49:
                // 2 sources

            } while ((var5_4 = var1_1.getlistFiles()) != null);
        }
    }
}

