/*
 * Decompiled with CFR 0.152.
 */
package sax;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentTracer
extends DefaultHandler
implements ContentHandler,
DTDHandler,
ErrorHandler,
DeclHandler,
LexicalHandler {
    protected SAXParser fSAXParser;
    protected int fIndent;

    public void setDocumentLocator(Locator locator) {
        this.printIndent();
        System.out.println("setDocumentLocator(" + locator + ')');
    }

    public void startDocument() throws SAXException {
        this.fIndent = 0;
        this.printIndent();
        System.out.println("startDocument()");
        ++this.fIndent;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.printIndent();
        System.out.print("processingInstruction(");
        System.out.print("target=" + DocumentTracer.quoteString(string));
        System.out.print(',');
        System.out.print("data=" + DocumentTracer.quoteString(string2));
        System.out.println(')');
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.printIndent();
        System.out.print("startPrefixMapping(");
        System.out.print("prefix=" + DocumentTracer.quoteString(string));
        System.out.print(',');
        System.out.print("uri=" + DocumentTracer.quoteString(string2));
        System.out.println(')');
        ++this.fIndent;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.printIndent();
        System.out.print("startElement(");
        System.out.print("element={" + string + ',' + string2 + ',' + string3 + '}');
        System.out.print(',');
        System.out.print("attributes=");
        if (attributes == null) {
            System.out.println("null");
        } else {
            System.out.print('{');
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    System.out.print(',');
                }
                String string4 = attributes.getURI(n2);
                String string5 = attributes.getLocalName(n2);
                String string6 = attributes.getQName(n2);
                System.out.print('{' + string4 + ',' + string5 + ',' + string6 + "}=");
                System.out.print(DocumentTracer.quoteString(attributes.getValue(n2)));
                ++n2;
            }
            System.out.print('}');
        }
        System.out.println(')');
        ++this.fIndent;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.printIndent();
        System.out.print("characters(");
        System.out.print("text=" + DocumentTracer.quoteString(new String(cArray, n, n2)));
        System.out.println(')');
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.printIndent();
        System.out.print("ignorableWhitespace(");
        System.out.print("text=" + DocumentTracer.quoteString(new String(cArray, n, n2)));
        System.out.println(')');
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.fIndent;
        this.printIndent();
        System.out.print("endElement(");
        System.out.print("element={" + string + ',' + string2 + ',' + string3 + '}');
        System.out.println("})");
    }

    public void endPrefixMapping(String string) throws SAXException {
        --this.fIndent;
        this.printIndent();
        System.out.print("endPrefixMapping(");
        System.out.print("prefix=" + DocumentTracer.quoteString(string));
        System.out.println(')');
    }

    public void skippedEntity(String string) throws SAXException {
        this.printIndent();
        System.out.print("skippedEntity(");
        System.out.print("name=" + DocumentTracer.quoteString(string));
        System.out.println(')');
    }

    public void endDocument() throws SAXException {
        --this.fIndent;
        this.printIndent();
        System.out.println("endDocument()");
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
        this.printIndent();
        System.out.print("notationDecl(");
        System.out.print("name=" + DocumentTracer.quoteString(string));
        System.out.print(',');
        System.out.print("publicId=" + DocumentTracer.quoteString(string2));
        System.out.print(',');
        System.out.print("systemId=" + DocumentTracer.quoteString(string3));
        System.out.println(')');
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        this.printIndent();
        System.out.print("unparsedEntityDecl(");
        System.out.print("name=" + DocumentTracer.quoteString(string));
        System.out.print(',');
        System.out.print("publicId=" + DocumentTracer.quoteString(string2));
        System.out.print(',');
        System.out.print("systemId=" + DocumentTracer.quoteString(string3));
        System.out.print(',');
        System.out.print("notationName=" + DocumentTracer.quoteString(string4));
        System.out.println(')');
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.printIndent();
        System.out.print("startDTD(");
        System.out.print("name=" + DocumentTracer.quoteString(string));
        System.out.print(',');
        System.out.print("publicId=" + DocumentTracer.quoteString(string2));
        System.out.print(',');
        System.out.print("systemId=" + DocumentTracer.quoteString(string3));
        System.out.println(')');
        ++this.fIndent;
    }

    public void startEntity(String string) throws SAXException {
        this.printIndent();
        System.out.print("startEntity(");
        System.out.print("name=" + DocumentTracer.quoteString(string));
        System.out.println(')');
        ++this.fIndent;
    }

    public void startCDATA() throws SAXException {
        this.printIndent();
        System.out.println("startCDATA()");
        ++this.fIndent;
    }

    public void endCDATA() throws SAXException {
        --this.fIndent;
        this.printIndent();
        System.out.println("endCDATA()");
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.printIndent();
        System.out.print("comment(");
        System.out.print("text=" + DocumentTracer.quoteString(new String(cArray, n, n2)));
        System.out.println(')');
    }

    public void endEntity(String string) throws SAXException {
        --this.fIndent;
        this.printIndent();
        System.out.print("endEntity(");
        System.out.print("name=" + DocumentTracer.quoteString(string));
        System.out.println(')');
    }

    public void endDTD() throws SAXException {
        --this.fIndent;
        this.printIndent();
        System.out.println("endDTD()");
    }

    public void elementDecl(String string, String string2) throws SAXException {
        this.printIndent();
        System.out.print("elementDecl(");
        System.out.print("name=" + DocumentTracer.quoteString(string));
        System.out.print(',');
        System.out.print("contentModel=" + DocumentTracer.quoteString(string2));
        System.out.println(')');
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        this.printIndent();
        System.out.print("attributeDecl(");
        System.out.print("elementName=" + DocumentTracer.quoteString(string));
        System.out.print(',');
        System.out.print("attributeName=" + DocumentTracer.quoteString(string2));
        System.out.print(',');
        System.out.print("type=" + DocumentTracer.quoteString(string3));
        System.out.print(',');
        System.out.print("defaultValue=" + DocumentTracer.quoteString(string4));
        System.out.print(',');
        System.out.print("defaultType=" + DocumentTracer.quoteString(string5));
        System.out.println(')');
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
        this.printIndent();
        System.out.print("internalEntityDecl(");
        System.out.print("name=" + DocumentTracer.quoteString(string));
        System.out.print(',');
        System.out.print("text=" + DocumentTracer.quoteString(string2));
        System.out.println(')');
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        this.printIndent();
        System.out.print("externalEntityDecl(");
        System.out.print("name=" + DocumentTracer.quoteString(string));
        System.out.print(',');
        System.out.print("publicId=" + DocumentTracer.quoteString(string2));
        System.out.print(',');
        System.out.print("systemId=" + DocumentTracer.quoteString(string3));
        System.out.println(')');
    }

    public void warning(SAXParseException sAXParseException) {
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    public static String quoteString(String string) {
        if (string == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private void printIndent() {
        int n = 0;
        while (n < this.fIndent) {
            System.out.print(' ');
            ++n;
        }
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        DocumentTracer documentTracer = new DocumentTracer();
        SAXParser sAXParser = new SAXParser();
        try {
            sAXParser.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(System.err);
        }
        try {
            sAXParser.setFeature("http://xml.org/sax/features/validation", true);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(System.err);
        }
        sAXParser.setContentHandler(documentTracer);
        sAXParser.setDTDHandler(documentTracer);
        sAXParser.setErrorHandler(documentTracer);
        try {
            sAXParser.setProperty("http://xml.org/sax/properties/declaration-handler", documentTracer);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(System.err);
        }
        try {
            sAXParser.setProperty("http://xml.org/sax/properties/lexical-handler", documentTracer);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(System.err);
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            System.err.println("# argv[" + n + "]: " + string);
            try {
                sAXParser.parse(string);
            }
            catch (SAXException sAXException) {
                Exception exception = sAXException.getException();
                throw exception != null ? exception : sAXException;
            }
            ++n;
        }
    }

    private static void print(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        int n = -1;
        while ((n = ((InputStream)fileInputStream).read()) != -1) {
            System.out.print((char)n);
        }
        System.out.println();
        ((InputStream)fileInputStream).close();
    }
}

