/*
 *      msacm.h   -       Declarations for MSACM
 */

#ifndef __WINE_MSACM_H
#define __WINE_MSACM_H

#include "wintypes.h"
#include "driver.h"
#include "mmsystem.h"
#include "mmreg.h"

/***********************************************************************
 * Types
 */

/* FIXME: Move to wintypes.h */
#define DECLARE_HANDLE(a) \
typedef HANDLE16 a##16; \
typedef HANDLE32 a##32; \
typedef a##16 *P##a##16; \
typedef a##16 *NP##a##16; \
typedef a##16 *LP##a##16; \
typedef a##32 *P##a##32;

DECLARE_HANDLE(HACMDRIVERID)
DECLARE_HANDLE(HACMDRIVER)
DECLARE_HANDLE(HACMSTREAM)
DECLARE_HANDLE(HACMOBJ)

/* FIXME: Remove when define moved to wintypes.h */
#undef DECLARE_HANDLE

/***********************************************************************
 * Defines/Enums
 */

#define ACMERR_BASE        512
#define ACMERR_NOTPOSSIBLE (ACMERR_BASE + 0)
#define ACMERR_BUSY        (ACMERR_BASE + 1)
#define ACMERR_UNPREPARED  (ACMERR_BASE + 2)
#define ACMERR_CANCELED    (ACMERR_BASE + 3)

#define MM_ACM_OPEN  MM_STREAM_OPEN
#define MM_ACM_CLOSE MM_STREAM_CLOSE
#define MM_ACM_DONE  MM_STREAM_DONE

#define ACM_DRIVERADDF_FUNCTION   0x00000003L
#define ACM_DRIVERADDF_NOTIFYHWND 0x00000004L
#define ACM_DRIVERADDF_TYPEMASK   0x00000007L
#define ACM_DRIVERADDF_LOCAL      0x00000000L
#define ACM_DRIVERADDF_GLOBAL     0x00000008L

#define ACMDRIVERDETAILS_SHORTNAME_CHARS  32
#define ACMDRIVERDETAILS_LONGNAME_CHARS  128
#define ACMDRIVERDETAILS_COPYRIGHT_CHARS  80
#define ACMDRIVERDETAILS_LICENSING_CHARS 128
#define ACMDRIVERDETAILS_FEATURES_CHARS  512

#define ACMDRIVERDETAILS_FCCTYPE_AUDIOCODEC mmioFOURCC('a', 'u', 'd', 'c')
#define ACMDRIVERDETAILS_FCCCOMP_UNDEFINED  mmioFOURCC('\0', '\0', '\0', '\0')

#define ACMDRIVERDETAILS_SUPPORTF_CODEC     0x00000001L
#define ACMDRIVERDETAILS_SUPPORTF_CONVERTER 0x00000002L
#define ACMDRIVERDETAILS_SUPPORTF_FILTER    0x00000004L
#define ACMDRIVERDETAILS_SUPPORTF_HARDWARE  0x00000008L
#define ACMDRIVERDETAILS_SUPPORTF_ASYNC     0x00000010L
#define ACMDRIVERDETAILS_SUPPORTF_LOCAL     0x40000000L
#define ACMDRIVERDETAILS_SUPPORTF_DISABLED  0x80000000L

#define ACM_DRIVERENUMF_NOLOCAL  0x40000000L
#define ACM_DRIVERENUMF_DISABLED 0x80000000L

#define ACM_DRIVERPRIORITYF_ENABLE    0x00000001L
#define ACM_DRIVERPRIORITYF_DISABLE   0x00000002L
#define ACM_DRIVERPRIORITYF_ABLEMASK  0x00000003L
#define ACM_DRIVERPRIORITYF_BEGIN     0x00010000L
#define ACM_DRIVERPRIORITYF_END       0x00020000L
#define ACM_DRIVERPRIORITYF_DEFERMASK 0x00030000L

#define MM_ACM_FILTERCHOOSE 0x8000

#define FILTERCHOOSE_MESSAGE          0
#define FILTERCHOOSE_FILTERTAG_VERIFY (FILTERCHOOSE_MESSAGE+0)
#define FILTERCHOOSE_FILTER_VERIFY    (FILTERCHOOSE_MESSAGE+1)
#define FILTERCHOOSE_CUSTOM_VERIFY    (FILTERCHOOSE_MESSAGE+2)

#define ACMFILTERCHOOSE_STYLEF_SHOWHELP             0x00000004L
#define ACMFILTERCHOOSE_STYLEF_ENABLEHOOK           0x00000008L
#define ACMFILTERCHOOSE_STYLEF_ENABLETEMPLATE       0x00000010L
#define ACMFILTERCHOOSE_STYLEF_ENABLETEMPLATEHANDLE 0x00000020L
#define ACMFILTERCHOOSE_STYLEF_INITTOFILTERSTRUCT   0x00000040L
#define ACMFILTERCHOOSE_STYLEF_CONTEXTHELP          0x00000080L

#define ACMFILTERDETAILS_FILTER_CHARS 128

#define ACM_FILTERDETAILSF_INDEX     0x00000000L
#define ACM_FILTERDETAILSF_FILTER    0x00000001L
#define ACM_FILTERDETAILSF_QUERYMASK 0x0000000FL

#define ACMFILTERTAGDETAILS_FILTERTAG_CHARS 48

#define ACM_FILTERTAGDETAILSF_INDEX       0x00000000L
#define ACM_FILTERTAGDETAILSF_FILTERTAG   0x00000001L
#define ACM_FILTERTAGDETAILSF_LARGESTSIZE 0x00000002L
#define ACM_FILTERTAGDETAILSF_QUERYMASK   0x0000000FL

#define ACM_FILTERENUMF_DWFILTERTAG 0x00010000L

#define ACMHELPMSGSTRING32A       "acmchoose_help"
#define ACMHELPMSGSTRING32W       L"acmchoose_help"
#define ACMHELPMSGSTRING16       "acmchoose_help"

#define ACMHELPMSGCONTEXTMENU32A  "acmchoose_contextmenu"
#define ACMHELPMSGCONTEXTMENU32W  L"acmchoose_contextmenu"
#define ACMHELPMSGCONTEXTMENU16   "acmchoose_contextmenu"

#define ACMHELPMSGCONTEXTHELP32A  "acmchoose_contexthelp"
#define ACMHELPMSGCONTEXTHELP32W  L"acmchoose_contexthelp"
#define ACMHELPMSGCONTEXTHELP16   "acmchoose_contexthelp"

#define MM_ACM_FORMATCHOOSE 0x8000

#define FORMATCHOOSE_MESSAGE          0
#define FORMATCHOOSE_FORMATTAG_VERIFY (FORMATCHOOSE_MESSAGE+0)
#define FORMATCHOOSE_FORMAT_VERIFY    (FORMATCHOOSE_MESSAGE+1)
#define FORMATCHOOSE_CUSTOM_VERIFY    (FORMATCHOOSE_MESSAGE+2)

#define ACMFORMATCHOOSE_STYLEF_SHOWHELP             0x00000004L
#define ACMFORMATCHOOSE_STYLEF_ENABLEHOOK           0x00000008L
#define ACMFORMATCHOOSE_STYLEF_ENABLETEMPLATE       0x00000010L
#define ACMFORMATCHOOSE_STYLEF_ENABLETEMPLATEHANDLE 0x00000020L
#define ACMFORMATCHOOSE_STYLEF_INITTOWFXSTRUCT      0x00000040L
#define ACMFORMATCHOOSE_STYLEF_CONTEXTHELP          0x00000080L

#define ACMFORMATDETAILS_FORMAT_CHARS   128

#define ACM_FORMATDETAILSF_INDEX     0x00000000L
#define ACM_FORMATDETAILSF_FORMAT    0x00000001L
#define ACM_FORMATDETAILSF_QUERYMASK 0x0000000FL

#define ACM_FORMATENUMF_WFORMATTAG     0x00010000L
#define ACM_FORMATENUMF_NCHANNELS      0x00020000L
#define ACM_FORMATENUMF_NSAMPLESPERSEC 0x00040000L
#define ACM_FORMATENUMF_WBITSPERSAMPLE 0x00080000L
#define ACM_FORMATENUMF_CONVERT        0x00100000L
#define ACM_FORMATENUMF_SUGGEST        0x00200000L
#define ACM_FORMATENUMF_HARDWARE       0x00400000L
#define ACM_FORMATENUMF_INPUT          0x00800000L
#define ACM_FORMATENUMF_OUTPUT         0x01000000L

#define ACM_FORMATSUGGESTF_WFORMATTAG     0x00010000L
#define ACM_FORMATSUGGESTF_NCHANNELS      0x00020000L
#define ACM_FORMATSUGGESTF_NSAMPLESPERSEC 0x00040000L
#define ACM_FORMATSUGGESTF_WBITSPERSAMPLE 0x00080000L
#define ACM_FORMATSUGGESTF_TYPEMASK       0x00FF0000L

#define ACMFORMATTAGDETAILS_FORMATTAG_CHARS 48

#define ACM_FORMATTAGDETAILSF_INDEX       0x00000000L
#define ACM_FORMATTAGDETAILSF_FORMATTAG   0x00000001L
#define ACM_FORMATTAGDETAILSF_LARGESTSIZE 0x00000002L
#define ACM_FORMATTAGDETAILSF_QUERYMASK   0x0000000FL

#define ACM_METRIC_COUNT_DRIVERS            1
#define ACM_METRIC_COUNT_CODECS             2
#define ACM_METRIC_COUNT_CONVERTERS         3
#define ACM_METRIC_COUNT_FILTERS            4
#define ACM_METRIC_COUNT_DISABLED           5
#define ACM_METRIC_COUNT_HARDWARE           6
#define ACM_METRIC_COUNT_LOCAL_DRIVERS     20
#define ACM_METRIC_COUNT_LOCAL_CODECS      21
#define ACM_METRIC_COUNT_LOCAL_CONVERTERS  22
#define ACM_METRIC_COUNT_LOCAL_FILTERS     23
#define ACM_METRIC_COUNT_LOCAL_DISABLED    24
#define ACM_METRIC_HARDWARE_WAVE_INPUT     30
#define ACM_METRIC_HARDWARE_WAVE_OUTPUT    31
#define ACM_METRIC_MAX_SIZE_FORMAT         50
#define ACM_METRIC_MAX_SIZE_FILTER         51
#define ACM_METRIC_DRIVER_SUPPORT         100
#define ACM_METRIC_DRIVER_PRIORITY        101

#define ACM_STREAMCONVERTF_BLOCKALIGN 0x00000004
#define ACM_STREAMCONVERTF_START      0x00000010
#define ACM_STREAMCONVERTF_END        0x00000020

#define ACMSTREAMHEADER_STATUSF_DONE     0x00010000L
#define ACMSTREAMHEADER_STATUSF_PREPARED 0x00020000L
#define ACMSTREAMHEADER_STATUSF_INQUEUE  0x00100000L

#define ACM_STREAMOPENF_QUERY       0x00000001
#define ACM_STREAMOPENF_ASYNC       0x00000002
#define ACM_STREAMOPENF_NONREALTIME 0x00000004

#define ACM_STREAMSIZEF_SOURCE      0x00000000L
#define ACM_STREAMSIZEF_DESTINATION 0x00000001L
#define ACM_STREAMSIZEF_QUERYMASK   0x0000000FL

#define ACMDM_USER                  (DRV_USER + 0x0000)
#define ACMDM_RESERVED_LOW          (DRV_USER + 0x2000)
#define ACMDM_RESERVED_HIGH         (DRV_USER + 0x2FFF)

#define ACMDM_BASE                  ACMDM_RESERVED_LOW

#define ACMDM_DRIVER_ABOUT          (ACMDM_BASE + 11)

/***********************************************************************
 * Callbacks
 */

typedef BOOL32 (CALLBACK *ACMDRIVERENUMCB32)(
  HACMDRIVERID32 hadid, DWORD dwInstance, DWORD fdwSupport
);

typedef BOOL16 (CALLBACK *ACMDRIVERENUMCB16)(
  HACMDRIVERID16 hadid, DWORD dwInstance, DWORD fdwSupport
);

typedef UINT32 (CALLBACK *ACMFILTERCHOOSEHOOKPROC32A)(
  HWND32 hwnd, UINT32 uMsg, WPARAM32 wParam, LPARAM lParam
);

typedef UINT32 (CALLBACK *ACMFILTERCHOOSEHOOKPROC32W)(
  HWND32 hwnd, UINT32 uMsg, WPARAM32 wParam, LPARAM lParam
);

typedef UINT32 (CALLBACK *ACMFILTERCHOOSEHOOKPROC16)(
  HWND32 hwnd, UINT32 uMsg, WPARAM32 wParam, LPARAM lParam
);

typedef UINT32 (CALLBACK *ACMFORMATCHOOSEHOOKPROC32A)(
  HWND32 hwnd, UINT32 uMsg, WPARAM32 wParam, LPARAM lParam
);

typedef UINT32 (CALLBACK *ACMFORMATCHOOSEHOOKPROC32W)(
  HWND32 hwnd, UINT32 uMsg, WPARAM32 wParam, LPARAM lParam
);

typedef UINT16 (CALLBACK *ACMFORMATCHOOSEHOOKPROC16)(
  HWND16 hwnd, UINT16 uMsg, WPARAM16 wParam, LPARAM lParam
);

/***********************************************************************
 * Structures
 */

typedef struct _ACMDRIVERDETAILS32A
{
  DWORD    cbStruct;

  FOURCC   fccType;
  FOURCC   fccComp;

  WORD     wMid;
  WORD     wPid;

  DWORD    vdwACM;
  DWORD    vdwDriver;

  DWORD    fdwSupport;
  DWORD    cFormatTags;
  DWORD    cFilterTags;

  HICON32  hicon;

  CHAR     szShortName[ACMDRIVERDETAILS_SHORTNAME_CHARS];
  CHAR     szLongName[ACMDRIVERDETAILS_LONGNAME_CHARS];
  CHAR     szCopyright[ACMDRIVERDETAILS_COPYRIGHT_CHARS];
  CHAR     szLicensing[ACMDRIVERDETAILS_LICENSING_CHARS];
  CHAR     szFeatures[ACMDRIVERDETAILS_FEATURES_CHARS];
} ACMDRIVERDETAILS32A, *PACMDRIVERDETAILS32A;

typedef struct _ACMDRIVERDETAILS32W
{
  DWORD    cbStruct;

  FOURCC   fccType;
  FOURCC   fccComp;

  WORD     wMid;
  WORD     wPid;

  DWORD    vdwACM;
  DWORD    vdwDriver;

  DWORD    fdwSupport;
  DWORD    cFormatTags;
  DWORD    cFilterTags;

  HICON32  hicon;

  WCHAR    szShortName[ACMDRIVERDETAILS_SHORTNAME_CHARS];
  WCHAR    szLongName[ACMDRIVERDETAILS_LONGNAME_CHARS];
  WCHAR    szCopyright[ACMDRIVERDETAILS_COPYRIGHT_CHARS];
  WCHAR    szLicensing[ACMDRIVERDETAILS_LICENSING_CHARS];
  WCHAR    szFeatures[ACMDRIVERDETAILS_FEATURES_CHARS];
} ACMDRIVERDETAILS32W, *PACMDRIVERDETAILS32W;

typedef struct _ACMDRIVERDETAILS16
{
  DWORD   cbStruct;

  FOURCC  fccType;
  FOURCC  fccComp;

  WORD    wMid;
  WORD    wPid;

  DWORD   vdwACM;
  DWORD   vdwDriver;

  DWORD   fdwSupport;
  DWORD   cFormatTags;
  DWORD   cFilterTags;

  HICON16 hicon;

  CHAR    szShortName[ACMDRIVERDETAILS_SHORTNAME_CHARS];
  CHAR    szLongName[ACMDRIVERDETAILS_LONGNAME_CHARS];
  CHAR    szCopyright[ACMDRIVERDETAILS_COPYRIGHT_CHARS];
  CHAR    szLicensing[ACMDRIVERDETAILS_LICENSING_CHARS];
  CHAR    szFeatures[ACMDRIVERDETAILS_FEATURES_CHARS];
} ACMDRIVERDETAILS16, *NPACMDRIVERDETAILS16, *LPACMDRIVERDETAILS16;

typedef struct _ACMFILTERCHOOSE32A
{
  DWORD         cbStruct;
  DWORD         fdwStyle;

  HWND32        hwndOwner;

  PWAVEFILTER   pwfltr;
  DWORD         cbwfltr;

  LPCSTR        pszTitle;

  CHAR          szFilterTag[ACMFILTERTAGDETAILS_FILTERTAG_CHARS];
  CHAR          szFilter[ACMFILTERDETAILS_FILTER_CHARS];
  LPSTR         pszName;
  DWORD         cchName;

  DWORD         fdwEnum;
  PWAVEFILTER   pwfltrEnum;
    
  HINSTANCE32   hInstance;
  LPCSTR        pszTemplateName;
  LPARAM        lCustData;
  ACMFILTERCHOOSEHOOKPROC32A pfnHook;
} ACMFILTERCHOOSE32A, *PACMFILTERCHOOSE32A;

typedef struct _ACMFILTERCHOOSE32W
{
  DWORD         cbStruct;
  DWORD         fdwStyle;

  HWND32        hwndOwner;

  PWAVEFILTER   pwfltr;
  DWORD         cbwfltr;

  LPCWSTR       pszTitle;

  WCHAR         szFilterTag[ACMFILTERTAGDETAILS_FILTERTAG_CHARS];
  WCHAR         szFilter[ACMFILTERDETAILS_FILTER_CHARS];
  LPWSTR        pszName;
  DWORD         cchName;

  DWORD         fdwEnum;
  PWAVEFILTER   pwfltrEnum;
    
  HINSTANCE32   hInstance;
  LPCWSTR       pszTemplateName;
  LPARAM        lCustData;
  ACMFILTERCHOOSEHOOKPROC32W pfnHook;
} ACMFILTERCHOOSE32W, *PACMFILTERCHOOSE32W;

typedef struct _ACMFILTERCHOOSE16
{
  DWORD          cbStruct;
  DWORD          fdwStyle;

  HWND16         hwndOwner;

  LPWAVEFILTER   pwfltr;
  DWORD          cbwfltr;

  LPCSTR         pszTitle;

  char           szFilterTag[ACMFILTERTAGDETAILS_FILTERTAG_CHARS];
  char           szFilter[ACMFILTERDETAILS_FILTER_CHARS];
  LPSTR          pszName;
  DWORD          cchName;

  DWORD          fdwEnum;
  LPWAVEFILTER   pwfltrEnum;
    
  HINSTANCE16    hInstance;
  LPCSTR         pszTemplateName;
  LPARAM         lCustData;
  ACMFILTERCHOOSEHOOKPROC16 pfnHook;
} ACMFILTERCHOOSE16, *NPACMFILTERCHOOSE16, *LPACMFILTERCHOOSE16;

typedef struct _ACMFILTERDETAILS32A
{
  DWORD           cbStruct;
  DWORD           dwFilterIndex;
  DWORD           dwFilterTag;
  DWORD           fdwSupport;
  PWAVEFILTER     pwfltr;
  DWORD           cbwfltr;
  CHAR            szFilter[ACMFILTERDETAILS_FILTER_CHARS];
} ACMFILTERDETAILS32A, *PACMFILTERDETAILS32A;

typedef struct _ACMFILTERDETAILS32W
{
  DWORD          cbStruct;
  DWORD          dwFilterIndex;
  DWORD          dwFilterTag;
  DWORD          fdwSupport;
  PWAVEFILTER    pwfltr;
  DWORD          cbwfltr;
  WCHAR          szFilter[ACMFILTERDETAILS_FILTER_CHARS];
} ACMFILTERDETAILS32W, *PACMFILTERDETAILS32W;

typedef struct _ACMFILTERDETAILS16
{
  DWORD          cbStruct;
  DWORD          dwFilterIndex;
  DWORD          dwFilterTag;
  DWORD          fdwSupport;
  LPWAVEFILTER   pwfltr;
  DWORD          cbwfltr;
  CHAR           szFilter[ACMFILTERDETAILS_FILTER_CHARS];
} ACMFILTERDETAILS16, *NPACMFILTERDETAILS16, *LPACMFILTERDETAILS16;

typedef struct _ACMFILTERTAGDETAILS32A
{
  DWORD cbStruct;
  DWORD dwFilterTagIndex;
  DWORD dwFilterTag;
  DWORD cbFilterSize;
  DWORD fdwSupport;
  DWORD cStandardFilters;
  CHAR  szFilterTag[ACMFILTERTAGDETAILS_FILTERTAG_CHARS];
} ACMFILTERTAGDETAILS32A, *PACMFILTERTAGDETAILS32A;

typedef struct _ACMFILTERTAGDETAILS32W
{
  DWORD cbStruct;
  DWORD dwFilterTagIndex;
  DWORD dwFilterTag;
  DWORD cbFilterSize;
  DWORD fdwSupport;
  DWORD cStandardFilters;
  WCHAR szFilterTag[ACMFILTERTAGDETAILS_FILTERTAG_CHARS];
} ACMFILTERTAGDETAILS32W, *PACMFILTERTAGDETAILS32W;

typedef struct _ACMFILTERTAGDETAILS16
{
  DWORD cbStruct;
  DWORD dwFilterTagIndex;
  DWORD dwFilterTag;
  DWORD cbFilterSize;
  DWORD fdwSupport;
  DWORD cStandardFilters;
  CHAR  szFilterTag[ACMFILTERTAGDETAILS_FILTERTAG_CHARS];
} ACMFILTERTAGDETAILS16, *NPACMFILTERTAGDETAILS16, *LPACMFILTERTAGDETAILS16;

typedef struct _ACMFORMATCHOOSE32A
{
  DWORD           cbStruct;
  DWORD           fdwStyle;
 
  HWND32          hwndOwner;

  PWAVEFORMATEX   pwfx;
  DWORD           cbwfx;
  LPCSTR          pszTitle;
    
  CHAR            szFormatTag[ACMFORMATTAGDETAILS_FORMATTAG_CHARS];
  CHAR            szFormat[ACMFORMATDETAILS_FORMAT_CHARS];    

  LPSTR           pszName;
  DWORD           cchName;

  DWORD           fdwEnum;
  PWAVEFORMATEX   pwfxEnum;
    
  HINSTANCE32     hInstance;
  LPCSTR          pszTemplateName;
  LPARAM          lCustData;
  ACMFORMATCHOOSEHOOKPROC32A pfnHook;
} ACMFORMATCHOOSE32A, *PACMFORMATCHOOSE32A;

typedef struct _ACMFORMATCHOOSE32W
{
  DWORD           cbStruct;
  DWORD           fdwStyle;
    
  HWND32          hwndOwner;

  PWAVEFORMATEX   pwfx;
  DWORD           cbwfx;
  LPCWSTR         pszTitle;
    
  WCHAR           szFormatTag[ACMFORMATTAGDETAILS_FORMATTAG_CHARS];
  WCHAR           szFormat[ACMFORMATDETAILS_FORMAT_CHARS];    

  LPWSTR          pszName;
  DWORD           cchName;

  DWORD           fdwEnum;
  LPWAVEFORMATEX  pwfxEnum;
    
  HINSTANCE32     hInstance;
  LPCWSTR         pszTemplateName;
  LPARAM          lCustData;
  ACMFORMATCHOOSEHOOKPROC32W pfnHook;
} ACMFORMATCHOOSE32W, *PACMFORMATCHOOSE32W;

typedef struct _ACMFORMATCHOOSE16
{
  DWORD            cbStruct;
  DWORD            fdwStyle;
    
  HWND16           hwndOwner;

  LPWAVEFORMATEX   pwfx;
  DWORD            cbwfx;
  LPCSTR           pszTitle;
    
  CHAR             szFormatTag[ACMFORMATTAGDETAILS_FORMATTAG_CHARS];
  CHAR             szFormat[ACMFORMATDETAILS_FORMAT_CHARS];    

  LPSTR            pszName;
  DWORD            cchName;

  DWORD            fdwEnum;
  LPWAVEFORMATEX   pwfxEnum;
    
  HINSTANCE16      hInstance;
  LPCSTR           pszTemplateName;
  LPARAM           lCustData;
  ACMFORMATCHOOSEHOOKPROC16 pfnHook;
} ACMFORMATCHOOSE16, *NPACMFORMATCHOOSE16, *LPACMFORMATCHOOSE16;

typedef struct _ACMFORMATDETAILS32A
{
  DWORD           cbStruct;
  DWORD           dwFormatIndex;
  DWORD           dwFormatTag;
  DWORD           fdwSupport;
  PWAVEFORMATEX   pwfx;
  DWORD           cbwfx;
  CHAR            szFormat[ACMFORMATDETAILS_FORMAT_CHARS];
} ACMFORMATDETAILS32A, *PACMFORMATDETAILS32A;

typedef struct _ACMFORMATDETAILS32W
{
    DWORD           cbStruct;
    DWORD           dwFormatIndex;
    DWORD           dwFormatTag;
    DWORD           fdwSupport;
    PWAVEFORMATEX   pwfx;
    DWORD           cbwfx;
    WCHAR           szFormat[ACMFORMATDETAILS_FORMAT_CHARS];
} ACMFORMATDETAILS32W, *PACMFORMATDETAILS32W;

typedef struct _ACMFORMATDETAILS16
{
    DWORD            cbStruct;
    DWORD            dwFormatIndex;
    DWORD            dwFormatTag;
    DWORD            fdwSupport;
    LPWAVEFORMATEX   pwfx;
    DWORD            cbwfx;
    CHAR             szFormat[ACMFORMATDETAILS_FORMAT_CHARS];
} ACMFORMATDETAILS16, *NPACMFORMATDETAILS16, *LPACMFORMATDETAILS16;

typedef struct _ACMFORMATTAGDETAILS32A
{
  DWORD cbStruct;
  DWORD dwFormatTagIndex;
  DWORD dwFormatTag;
  DWORD cbFormatSize;
  DWORD fdwSupport;
  DWORD cStandardFormats;
  CHAR  szFormatTag[ACMFORMATTAGDETAILS_FORMATTAG_CHARS];
} ACMFORMATTAGDETAILS32A, *PACMFORMATTAGDETAILS32A;

typedef struct _ACMFORMATTAGDETAILS32W
{
  DWORD cbStruct;
  DWORD dwFormatTagIndex;
  DWORD dwFormatTag;
  DWORD cbFormatSize;
  DWORD fdwSupport;
  DWORD cStandardFormats;
  WCHAR szFormatTag[ACMFORMATTAGDETAILS_FORMATTAG_CHARS];
} ACMFORMATTAGDETAILS32W, *PACMFORMATTAGDETAILS32W;

typedef struct _ACMFORMATTAGDETAILS16
{
  DWORD cbStruct;
  DWORD dwFormatTagIndex;
  DWORD dwFormatTag;
  DWORD cbFormatSize;
  DWORD fdwSupport;
  DWORD cStandardFormats;
  CHAR  szFormatTag[ACMFORMATTAGDETAILS_FORMATTAG_CHARS];
} ACMFORMATTAGDETAILS16, *NPACMFORMATTAGDETAILS16, *LPACMFORMATTAGDETAILS16;

typedef struct _ACMSTREAMHEADER
{
  DWORD  cbStruct;
  DWORD  fdwStatus;
  DWORD  dwUser;
  LPBYTE pbSrc;
  DWORD  cbSrcLength;
  DWORD  cbSrcLengthUsed;
  DWORD  dwSrcUser;
  LPBYTE pbDst;
  DWORD  cbDstLength;
  DWORD  cbDstLengthUsed;
  DWORD  dwDstUser;
  DWORD  dwReservedDriver[10];
} ACMSTREAMHEADER16, *NPACMSTREAMHEADER16, *LPACMSTREAMHEADER16,
  ACMSTREAMHEADER32, *PACMSTREAMHEADER32;

/***********************************************************************
 * Callbacks 2
 */

typedef BOOL32 (CALLBACK *ACMFILTERENUMCB32A)(
  HACMDRIVERID32 hadid, PACMFILTERDETAILS32A pafd,
  DWORD dwInstance, DWORD fdwSupport
);

typedef BOOL32 (CALLBACK *ACMFILTERENUMCB32W)(
  HACMDRIVERID32 hadid, PACMFILTERDETAILS32W pafd,
  DWORD dwInstance, DWORD fdwSupport
);

typedef BOOL16 (CALLBACK *ACMFILTERENUMCB16)(
 HACMDRIVERID16 hadid, LPACMFILTERDETAILS16 pafd,
 DWORD dwInstance, DWORD fdwSupport
);

typedef BOOL32 (CALLBACK *ACMFILTERTAGENUMCB32A)(
  HACMDRIVERID32 hadid, PACMFILTERTAGDETAILS32A paftd,
  DWORD dwInstance, DWORD fdwSupport
);

typedef BOOL32 (CALLBACK *ACMFILTERTAGENUMCB32W)(
  HACMDRIVERID32 hadid, PACMFILTERTAGDETAILS32W paftd,
  DWORD dwInstance, DWORD fdwSupport
);

typedef BOOL16 (CALLBACK *ACMFILTERTAGENUMCB16)(
  HACMDRIVERID16 hadid, LPACMFILTERTAGDETAILS16 paftd,
  DWORD dwInstance, DWORD fdwSupport
);

typedef BOOL32 (CALLBACK *ACMFORMATENUMCB32A)(
  HACMDRIVERID32 hadid, PACMFORMATDETAILS32A pafd,
  DWORD dwInstance, DWORD fdwSupport
);

typedef BOOL32 (CALLBACK *ACMFORMATENUMCB32W)(
  HACMDRIVERID32 hadid, PACMFORMATDETAILS32W pafd,
  DWORD dwInstance, DWORD fdwSupport
);

typedef BOOL16 (CALLBACK *ACMFORMATENUMCB16)(
  HACMDRIVERID16 hadid, LPACMFORMATDETAILS16 pafd,
  DWORD dwInstance, DWORD fdwSupport
);

typedef BOOL32 (CALLBACK *ACMFORMATTAGENUMCB32A)(
  HACMDRIVERID32 hadid, PACMFORMATTAGDETAILS32A paftd,
  DWORD dwInstance, DWORD fdwSupport
);

typedef BOOL32 (CALLBACK *ACMFORMATTAGENUMCB32W)(
  HACMDRIVERID32 hadid, PACMFORMATTAGDETAILS32W paftd,
  DWORD dwInstance, DWORD fdwSupport
);

typedef BOOL16 (CALLBACK *ACMFORMATTAGENUMCB16)(
  HACMDRIVERID16 hadid, LPACMFORMATTAGDETAILS16 paftd,
  DWORD dwInstance, DWORD fdwSupport
);

/***********************************************************************
 * Functions - Win16
 */

DWORD WINAPI acmGetVersion16(
);
MMRESULT16 WINAPI acmMetrics16(
  HACMOBJ16 hao, UINT16 uMetric, LPVOID pMetric
);
MMRESULT16 WINAPI acmDriverEnum16(
  ACMDRIVERENUMCB16 fnCallback, DWORD dwInstance, DWORD fdwEnum
);
MMRESULT16 WINAPI acmDriverDetails16(
  HACMDRIVERID16 hadid, LPACMDRIVERDETAILS16 padd, DWORD fdwDetails
);
MMRESULT16 WINAPI acmDriverAdd16(
  LPHACMDRIVERID16 phadid, HINSTANCE16 hinstModule,
  LPARAM lParam, DWORD dwPriority, DWORD fdwAdd
);
MMRESULT16 WINAPI acmDriverRemove16(
  HACMDRIVERID16 hadid, DWORD fdwRemove
);
MMRESULT16 WINAPI acmDriverOpen16(
  LPHACMDRIVER16 phad, HACMDRIVERID16 hadid, DWORD fdwOpen
);
MMRESULT16 WINAPI acmDriverClose16(
  HACMDRIVER16 had, DWORD fdwClose
);
LRESULT WINAPI acmDriverMessage16(
  HACMDRIVER16 had, UINT16 uMsg, LPARAM lParam1, LPARAM lParam2
);
MMRESULT16 WINAPI acmDriverID16(
  HACMOBJ16 hao, LPHACMDRIVERID16 phadid, DWORD fdwDriverID
);
MMRESULT16 WINAPI acmDriverPriority16(
 HACMDRIVERID16 hadid, DWORD dwPriority, DWORD fdwPriority
);
MMRESULT16 WINAPI acmFormatTagDetails16(
  HACMDRIVER16 had, LPACMFORMATTAGDETAILS16 paftd, DWORD fdwDetails
);
MMRESULT16 WINAPI acmFormatTagEnum16(
  HACMDRIVER16 had, LPACMFORMATTAGDETAILS16 paftd,
  ACMFORMATTAGENUMCB16 fnCallback, DWORD dwInstance, DWORD fdwEnum
);
MMRESULT16 WINAPI acmFormatChoose16(
  LPACMFORMATCHOOSE16 pafmtc
);
MMRESULT16 WINAPI acmFormatDetails16(
  HACMDRIVER16 had, LPACMFORMATDETAILS16 pafd, DWORD fdwDetails
);
MMRESULT16 WINAPI acmFormatEnum16(
  HACMDRIVER16 had, LPACMFORMATDETAILS16 pafd,
  ACMFORMATENUMCB16 fnCallback, DWORD dwInstance, DWORD fdwEnum
);
MMRESULT16 WINAPI acmFormatSuggest16(
  HACMDRIVER16 had, LPWAVEFORMATEX pwfxSrc, 
  LPWAVEFORMATEX pwfxDst, DWORD cbwfxDst, DWORD fdwSuggest
);
MMRESULT16 WINAPI acmFilterTagDetails16(
  HACMDRIVER16 had, LPACMFILTERTAGDETAILS16 paftd, DWORD fdwDetails
);
MMRESULT16 WINAPI acmFilterTagEnum16(
  HACMDRIVER16 had, LPACMFILTERTAGDETAILS16 paftd,
  ACMFILTERTAGENUMCB16 fnCallback, DWORD dwInstance, DWORD fdwEnum
);
MMRESULT16 WINAPI acmFilterChoose16(
  LPACMFILTERCHOOSE16 pafltrc
);
MMRESULT16 WINAPI acmFilterDetails16(
  HACMDRIVER16 had, LPACMFILTERDETAILS16 pafd, DWORD fdwDetails
);
MMRESULT16 WINAPI acmFilterEnum16(
  HACMDRIVER16 had, LPACMFILTERDETAILS16 pafd,
  ACMFILTERENUMCB16 fnCallback, DWORD dwInstance, DWORD fdwEnum
);
MMRESULT16 WINAPI acmStreamOpen16(
  LPHACMSTREAM16 phas, HACMDRIVER16 had,
  LPWAVEFORMATEX pwfxSrc, LPWAVEFORMATEX pwfxDst,
  LPWAVEFILTER pwfltr, DWORD dwCallback,
  DWORD dwInstance, DWORD fdwOpen
);
MMRESULT16 WINAPI acmStreamClose16(
  HACMSTREAM16 has, DWORD fdwClose
);
MMRESULT16 WINAPI acmStreamSize16(
  HACMSTREAM16 has, DWORD cbInput, 
  LPDWORD pdwOutputBytes, DWORD fdwSize
);
MMRESULT16 WINAPI acmStreamConvert16(
  HACMSTREAM16 has, LPACMSTREAMHEADER16 pash, DWORD fdwConvert
);
MMRESULT16 WINAPI acmStreamReset16(
  HACMSTREAM16 has, DWORD fdwReset
);
MMRESULT16 WINAPI acmStreamPrepareHeader16(
  HACMSTREAM16 has, LPACMSTREAMHEADER16 pash, DWORD fdwPrepare
);
MMRESULT16 WINAPI acmStreamUnprepareHeader16(
  HACMSTREAM16 has, LPACMSTREAMHEADER16 pash, DWORD fdwUnprepare
);

/***********************************************************************
 * Functions - Win32
 */

MMRESULT32 WINAPI acmDriverAdd32A(
  PHACMDRIVERID32 phadid, HINSTANCE32 hinstModule,
  LPARAM lParam, DWORD dwPriority, DWORD fdwAdd
);
MMRESULT32 WINAPI acmDriverAdd32W(
  PHACMDRIVERID32 phadid, HINSTANCE32 hinstModule,
  LPARAM lParam, DWORD dwPriority, DWORD fdwAdd
);
MMRESULT32 WINAPI acmDriverClose32(
  HACMDRIVER32 had, DWORD fdwClose
);
MMRESULT32 WINAPI acmDriverDetails32A(
  HACMDRIVERID32 hadid, PACMDRIVERDETAILS32A padd, DWORD fdwDetails
);
MMRESULT32 WINAPI acmDriverDetails32W(
  HACMDRIVERID32 hadid, PACMDRIVERDETAILS32W padd, DWORD fdwDetails
);
MMRESULT32 WINAPI acmDriverEnum32(
  ACMDRIVERENUMCB32 fnCallback, DWORD dwInstance, DWORD fdwEnum
);
MMRESULT32 WINAPI acmDriverID32(
  HACMOBJ32 hao, PHACMDRIVERID32 phadid, DWORD fdwDriverID
);
LRESULT WINAPI acmDriverMessage32(
  HACMDRIVER32 had, UINT32 uMsg, LPARAM lParam1, LPARAM lParam2
);
MMRESULT32 WINAPI acmDriverOpen32(
  PHACMDRIVER32 phad, HACMDRIVERID32 hadid, DWORD fdwOpen
);
MMRESULT32 WINAPI acmDriverPriority32(
  HACMDRIVERID32 hadid, DWORD dwPriority, DWORD fdwPriority
);
MMRESULT32 WINAPI acmDriverRemove32(
  HACMDRIVERID32 hadid, DWORD fdwRemove
);
MMRESULT32 WINAPI acmFilterChoose32A(
  PACMFILTERCHOOSE32A pafltrc
);
MMRESULT32 WINAPI acmFilterChoose32W(
  PACMFILTERCHOOSE32W pafltrc
);
MMRESULT32 WINAPI acmFilterDetails32A(
  HACMDRIVER32 had, PACMFILTERDETAILS32A pafd, DWORD fdwDetails
);
MMRESULT32 WINAPI acmFilterDetails32W(
  HACMDRIVER32 had, PACMFILTERDETAILS32W pafd, DWORD fdwDetails
);
MMRESULT32 WINAPI acmFilterEnum32A(
  HACMDRIVER32 had, PACMFILTERDETAILS32A pafd, 
  ACMFILTERENUMCB32A fnCallback, DWORD dwInstance, DWORD fdwEnum
);
MMRESULT32 WINAPI acmFilterEnum32W(
  HACMDRIVER32 had, PACMFILTERDETAILS32W pafd, 
  ACMFILTERENUMCB32W fnCallback, DWORD dwInstance, DWORD fdwEnum
);
MMRESULT32 WINAPI acmFilterTagDetails32A(
  HACMDRIVER32 had, PACMFILTERTAGDETAILS32A paftd, DWORD fdwDetails
);
MMRESULT32 WINAPI acmFilterTagDetails32W(
  HACMDRIVER32 had, PACMFILTERTAGDETAILS32W paftd, DWORD fdwDetails
);
MMRESULT32 WINAPI acmFilterTagEnum32A(
  HACMDRIVER32 had, PACMFILTERTAGDETAILS32A paftd,
  ACMFILTERTAGENUMCB32A fnCallback, DWORD dwInstance, DWORD fdwEnum
);
MMRESULT32 WINAPI acmFilterTagEnum32W(
  HACMDRIVER32 had, PACMFILTERTAGDETAILS32W paftd,
  ACMFILTERTAGENUMCB32W fnCallback, DWORD dwInstance, DWORD fdwEnum
);
MMRESULT32 WINAPI acmFormatChoose32A(
  PACMFORMATCHOOSE32A pafmtc
);
MMRESULT32 WINAPI acmFormatChoose32W(
  PACMFORMATCHOOSE32W pafmtc
);
MMRESULT32 WINAPI acmFormatDetails32A(
  HACMDRIVER32 had, PACMFORMATDETAILS32A pafd, DWORD fdwDetails
);
MMRESULT32 WINAPI acmFormatDetails32W(
  HACMDRIVER32 had, PACMFORMATDETAILS32W pafd, DWORD fdwDetails
);
MMRESULT32 WINAPI acmFormatEnum32A(
  HACMDRIVER32 had, PACMFORMATDETAILS32A pafd,
  ACMFORMATENUMCB32A fnCallback, DWORD dwInstance, DWORD fdwEnum
);
MMRESULT32 WINAPI acmFormatEnum32W(
  HACMDRIVER32 had, PACMFORMATDETAILS32W pafd,
  ACMFORMATENUMCB32W fnCallback, DWORD dwInstance,  DWORD fdwEnum
);
MMRESULT32 WINAPI acmFormatSuggest32(
  HACMDRIVER32 had, PWAVEFORMATEX pwfxSrc, PWAVEFORMATEX pwfxDst,
  DWORD cbwfxDst, DWORD fdwSuggest
);
MMRESULT32 WINAPI acmFormatTagDetails32A(
  HACMDRIVER32 had, PACMFORMATTAGDETAILS32A paftd, DWORD fdwDetails
);
MMRESULT32 WINAPI acmFormatTagDetails32W(
  HACMDRIVER32 had, PACMFORMATTAGDETAILS32W paftd, DWORD fdwDetails
);
MMRESULT32 WINAPI acmFormatTagEnum32A(
  HACMDRIVER32 had, PACMFORMATTAGDETAILS32A paftd,
  ACMFORMATTAGENUMCB32A fnCallback, DWORD dwInstance, DWORD fdwEnum
);
MMRESULT32 WINAPI acmFormatTagEnum32W(
  HACMDRIVER32 had, PACMFORMATTAGDETAILS32W paftd,
  ACMFORMATTAGENUMCB32W fnCallback, DWORD dwInstance, DWORD fdwEnum
);
DWORD WINAPI acmGetVersion32(
);
MMRESULT32 WINAPI acmMetrics32(
  HACMOBJ32 hao, UINT32  uMetric, LPVOID  pMetric
);
MMRESULT32 WINAPI acmStreamClose32(
  HACMSTREAM32 has, DWORD fdwClose
);
MMRESULT32 WINAPI acmStreamConvert32(
  HACMSTREAM32 has, PACMSTREAMHEADER32 pash, DWORD fdwConvert
);
MMRESULT32 WINAPI acmStreamMessage32(
  HACMSTREAM32 has, UINT32 uMsg, LPARAM lParam1, LPARAM lParam2
);
MMRESULT32 WINAPI acmStreamOpen32(
  PHACMSTREAM32 phas, HACMDRIVER32 had, PWAVEFORMATEX pwfxSrc,
  PWAVEFORMATEX pwfxDst, PWAVEFILTER pwfltr, DWORD dwCallback,
  DWORD dwInstance, DWORD fdwOpen
);
MMRESULT32 WINAPI acmStreamPrepareHeader32(
  HACMSTREAM32 has, PACMSTREAMHEADER32 pash, DWORD fdwPrepare
);
MMRESULT32 WINAPI acmStreamReset32(
  HACMSTREAM32 has, DWORD fdwReset
);
MMRESULT32 WINAPI acmStreamSize32(
  HACMSTREAM32 has, DWORD cbInput, 
  LPDWORD pdwOutputBytes, DWORD fdwSize
);
MMRESULT32 WINAPI acmStreamUnprepareHeader32(
  HACMSTREAM32 has, PACMSTREAMHEADER32 pash, DWORD fdwUnprepare
);

/***********************************************************************
 * Wine specific - Win32
 */
typedef struct _WINE_ACMBUILTINDRIVER32
{
  LPSTR        pszDriverAlias;
  DRIVERPROC32 pfnDriverProc;
} WINE_ACMBUILTINDRIVER32, *PWINE_ACMBUILTINDRIVER32;

typedef struct _WINE_ACMLOCALDRIVER32
{
  DRIVERPROC32 pfnDriverProc;
} WINE_ACMLOCALDRIVER32, *PWINE_ACMLOCALDRIVER32;

typedef struct _WINE_ACMDRIVERID32 *PWINE_ACMDRIVERID32;

typedef struct _WINE_ACMOBJ32
{
  PWINE_ACMDRIVERID32 pACMDriverID;
} WINE_ACMOBJ32, *PWINE_ACMOBJ32;

typedef struct _WINE_ACMDRIVER32
{
  WINE_ACMOBJ32  obj;
  HDRVR32        hDrvr;
} WINE_ACMDRIVER32, *PWINE_ACMDRIVER32;

typedef struct _WINE_ACMSTREAM32
{
  WINE_ACMOBJ32  obj;
  /* FIME: More fields needed */
} WINE_ACMSTREAM32, *PWINE_ACMSTREAM32;

typedef struct _WINE_ACMDRIVERID32
{
  LPSTR                    pszDriverAlias;
  LPSTR                    pszFileName;
  PWINE_ACMLOCALDRIVER32   pACMLocalDriver;
  BOOL32                   bEnabled;
  PWINE_ACMDRIVER32        pACMDriver;           /* NULL if not open */
  PWINE_ACMDRIVERID32      pNextACMDriverID;
  PWINE_ACMDRIVERID32      pPreviousACMDriverID;
} WINE_ACMDRIVERID32;

/* From builtin.c */
extern WINE_ACMBUILTINDRIVER32 MSACM_BuiltinDrivers32[];

/* From interal.c */
extern HANDLE32 MSACM_hHeap32;
extern PWINE_ACMDRIVERID32 MSACM_pFirstACMDriverID32;
extern PWINE_ACMDRIVERID32 MSACM_pLastACMDriverID32;
PWINE_ACMDRIVERID32 MSACM_RegisterDriver32(
  LPSTR pszDriverAlias, LPSTR pszFileName,
  PWINE_ACMLOCALDRIVER32 pLocalDriver);
void MSACM_RegisterAllDrivers32();
PWINE_ACMDRIVERID32 MSACM_UnregisterDriver32(PWINE_ACMDRIVERID32 p);
void MSACM_UnregisterAllDrivers32();
PWINE_ACMDRIVERID32 MSACM_GetDriverID32(HACMDRIVERID32 hDriverID);
PWINE_ACMDRIVER32 MSACM_GetDriver32(HACMDRIVER32 hDriver);
PWINE_ACMOBJ32 MSACM_GetObj32(HACMOBJ32 hObj);
HDRVR32 MSACM_OpenDriverProc32(DRIVERPROC32 pfnDriverProc);

#endif  /* __WINE_MSACM_H */


