<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: set_admin_permissions.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'global.inc.php');
require_once( dirname(__FILE__) . DIRECTORY_SEPARATOR .'..'. DIRECTORY_SEPARATOR .'includes'. DIRECTORY_SEPARATOR .'CLI.inc.php');

//
/*
 Proceedure to Convert MySQL to PostgreSQL:

 1. Upgrade to latest version of TimeTrex still using MySQL.

 2. Run: convert_mysql_to_postgresql.php sequence > update_sequences.sql
 3. Run: convert_mysql_to_postgresql.php truncate > delete_all_data.sql

 4. Dump MySQL database with the following command:
	mysqldump -t --skip-add-locks --compatible=postgresql --complete-insert <TimeTrex_Database_Name> > timetrex_mysql.sql

 5. Install a fresh copy of TimeTrex on PostgreSQL, make sure its the latest version of TimeTrex and it matches the version
	currently installed and running on MySQL.

 6. Run: psql <TimeTrex_Database_Name> < delete_all_data.sql
 7. Run: psql <TimeTrex_Database_Name> < timetrex_mysql.sql.
		- There will be a few errors because it will try to update non-existant *_seq tables.
			This is fine because the next step handles this.
 8. Run: psql <TimeTrex_Database_Name> < update_sequences.sql

 9. Done!

*/


if ( $argc < 2 OR in_array ($argv[1], array('--help', '-help', '-h', '-?') ) ) {
	$help_output = "Usage: convert_mysql_to_postgresql.php [data]\n";
	$help_output .= " [data] = 'sequence' or 'truncate'\n";
	echo $help_output;
} else {
	//Handle command line arguments
	$last_arg = count($argv)-1;

	if ( isset($db) AND is_object($db) AND $db->dataProvider != 'mysql' ) {
		echo "This script must be run on MySQL only!";
		exit;
	}

	if ( isset($argv[$last_arg]) AND $argv[$last_arg] != '' ) {
		$type = trim(strtolower($argv[$last_arg]));

		$dict = NewDataDictionary($db);
		$tables = $dict->MetaTables();

		$sequence_modifier = 1000;

		$out = NULL;
		foreach( $tables as $table ) {
			if ( strpos($table, '_seq') !== FALSE ) {
				if ( $type == 'sequence' ) {
					//echo "Found Sequence Table: ". $table ."<br>\n";
					$query = 'select id from '. $table;
					$last_sequence_value = $db->GetOne($query) + $sequence_modifier;
					echo 'ALTER SEQUENCE '. $table .' RESTART WITH '. $last_sequence_value .';'."\n";
				}
			} else {
				if ( $type == 'truncate' ) {
					echo 'TRUNCATE '. $table .';'."\n";
				}
			}
		}
	}
}

//echo "WARNING: Clear TimeTrex cache after running this.\n";

//Debug::Display();
?>
