<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1414 $
 * $Id: EditExceptionPolicyControl.php 1414 2007-11-14 18:50:05Z ipso $
 * $Date: 2007-11-14 10:50:05 -0800 (Wed, 14 Nov 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

//Debug::setVerbosity(11);

if ( !$permission->Check('exception_policy','enabled')
		OR !( $permission->Check('exception_policy','edit') OR $permission->Check('exception_policy','edit_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Exception Policy')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'data'
												) ) );

if ( isset($data['exceptions'])) {
	foreach( $data['exceptions'] as $code => $exception ) {

		if ( isset($exception['grace']) AND $exception['grace'] != '') {
			Debug::Text('Grace: '. $exception['grace'] , __FILE__, __LINE__, __METHOD__,10);
			$data['exceptions'][$code]['grace'] = TTDate::parseTimeUnit( $exception['grace'] );
		}
		if ( isset($exception['watch_window']) AND $exception['watch_window'] != '') {
			$data['exceptions'][$code]['watch_window'] = TTDate::parseTimeUnit( $exception['watch_window'] );
		}
	}
}

$epf = new ExceptionPolicyFactory();
$epcf = new ExceptionPolicyControlFactory();

$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$epcf->setId( $data['id'] );
		$epcf->setCompany( $current_company->getId() );
		$epcf->setName( $data['name'] );

		if ( $epcf->isValid() ) {
			$epc_id = $epcf->Save();

			Debug::Text('aException Policy Control ID: '. $epc_id , __FILE__, __LINE__, __METHOD__,10);

			if ( $epc_id === TRUE ) {
				$epc_id = $data['id'];
			}

			Debug::Text('bException Policy Control ID: '. $epc_id , __FILE__, __LINE__, __METHOD__,10);

			if ( count($data['exceptions']) > 0 ) {
				foreach ($data['exceptions'] as $code => $exception_data) {
					Debug::Text('Looping Code: '. $code .' ID: '. $exception_data['id'], __FILE__, __LINE__, __METHOD__,10);

					if ( $exception_data['id'] != '' AND $exception_data['id'] > 0 ) {
						$epf->setId( $exception_data['id'] );
					}
					$epf->setExceptionPolicyControl( $epc_id );
					if ( isset($exception_data['active'])  ) {
						$epf->setActive( TRUE );
					} else {
						$epf->setActive( FALSE );
					}
					$epf->setType( $code );
					$epf->setSeverity( $exception_data['severity_id'] );
					$epf->setEmailNotification( $exception_data['email_notification_id'] );
					if ( isset($exception_data['demerit']) AND $exception_data['demerit'] != '') {
						$epf->setDemerit( $exception_data['demerit'] );
					}
					if ( isset($exception_data['grace']) AND $exception_data['grace'] != '' ) {
						$epf->setGrace( $exception_data['grace'] );
					}
					if ( isset($exception_data['watch_window']) AND $exception_data['watch_window'] != '' ) {
						$epf->setWatchWindow( $exception_data['watch_window'] );
					}
					if ( $epf->isValid() ) {
						$epf->Save();
					}
				}
			}

			Redirect::Page( URLBuilder::getURL( NULL, 'ExceptionPolicyControlList.php') );

			break;
		}

	default:
		$type_options = $epf->getTypeOptions( $current_company->getProductEdition() );

		if ( isset($id) AND $id != '' ) {
			BreadCrumb::setCrumb($title);

			$epclf = new ExceptionPolicyControlListFactory();
			$epclf->getById($id);

			foreach ($epclf as $epc_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$eplf = new ExceptionPolicyListFactory();
				$eplf->getByExceptionPolicyControlID( $id );
				if ( $eplf->getRecordCount() > 0 ) {
					foreach( $eplf as $ep_obj ) {
						if ( isset($type_options[$ep_obj->getType()]) ) {
							$exceptions[$ep_obj->getType()] = array(
																	'id' => $ep_obj->getId(),
																	'active' => $ep_obj->getActive(),
																	'type_id' => $ep_obj->getType(),
																	'name' => Option::getByKey( $ep_obj->getType(), $type_options ),
																	'severity_id' => $ep_obj->getSeverity(),
																	'email_notification_id' => $ep_obj->getEmailNotification(),
																	'demerit' => $ep_obj->getDemerit(),
																	'grace' => (int)$ep_obj->getGrace(),
																	'is_enabled_grace' => $ep_obj->isEnabledGrace( $ep_obj->getType() ),
																	'watch_window' => (int)$ep_obj->getWatchWindow(),
																	'is_enabled_watch_window' => $ep_obj->isEnabledWatchWindow( $ep_obj->getType() )
																	);
						} else {
							//Delete exceptions that aren't part of the product.
							Debug::Text('Deleting exception outside product edition: '. $ep_obj->getID(), __FILE__, __LINE__, __METHOD__,10);

							$ep_obj->setDeleted(TRUE);
							if ( $ep_obj->isValid() ) {
								$ep_obj->Save();
							}
						}

					}
				} else {
					$exceptions = array();
				}

				//Populate default values.
				$default_exceptions = $epf->getExceptionTypeDefaultValues( array_keys($exceptions), $current_company->getProductEdition() );
				$exceptions = array_merge( $exceptions, $default_exceptions );

				$data = array(
									'id' => $epc_obj->getId(),
									'name' => $epc_obj->getName(),
									'exceptions' => $exceptions,
									'created_date' => $epc_obj->getCreatedDate(),
									'created_by' => $epc_obj->getCreatedBy(),
									'updated_date' => $epc_obj->getUpdatedDate(),
									'updated_by' => $epc_obj->getUpdatedBy(),
									'deleted_date' => $epc_obj->getDeletedDate(),
									'deleted_by' => $epc_obj->getDeletedBy()
								);
			}
		} elseif ( $action != 'submit' ) {
			//Populate default values.
			$exceptions = $epf->getExceptionTypeDefaultValues( NULL, $current_company->getProductEdition() );

			$data = array( 'exceptions' => $exceptions );
		}
		//print_r($data);

		//Select box options;
		$data['severity_options'] = $epf->getOptions('severity');
		$data['email_notification_options'] = $epf->getOptions('email_notification');

		$smarty->assign_by_ref('data', $data);

		break;
}

$smarty->assign_by_ref('epf', $epf);
$smarty->assign_by_ref('epcf', $epcf);

$smarty->display('policy/EditExceptionPolicyControl.tpl');
?>