<?php

/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2389 $
 * $Id: Database.inc.php 2389 2009-01-23 20:56:32Z ipso $
 * $Date: 2009-01-23 12:56:32 -0800 (Fri, 23 Jan 2009) $
 */
require_once( Environment::getBasePath() .'classes'. DIRECTORY_SEPARATOR .'adodb'. DIRECTORY_SEPARATOR .'adodb.inc.php');
require_once( Environment::getBasePath() .'classes'. DIRECTORY_SEPARATOR .'adodb'. DIRECTORY_SEPARATOR .'adodb-exceptions.inc.php');

//Use overloading to abstract $db and have calls directly to ADODB
if ( !isset($disable_database_connection) ) {
	try {
		if ( $config_vars['cache']['enable'] == TRUE ) {
			$ADODB_CACHE_DIR = $config_vars['cache']['dir'] . DIRECTORY_SEPARATOR;
		}

		$ADODB_GETONE_EOF = FALSE; //Make sure GetOne returns FALSE rather then NULL.

		$db = ADONewConnection( $config_vars['database']['type'] );
		$db->SetFetchMode(ADODB_FETCH_ASSOC);
		if ( isset($config_vars['database']['persistent_connections']) AND $config_vars['database']['persistent_connections'] == TRUE ) {
			$db->PConnect( $config_vars['database']['host'], $config_vars['database']['user'], $config_vars['database']['password'], $config_vars['database']['database_name']);
		} else {
			$db->Connect( $config_vars['database']['host'], $config_vars['database']['user'], $config_vars['database']['password'], $config_vars['database']['database_name']);
		}
		/*
		//Use ADODB performance monitor to aid in optimization.
		$db->LogSQL();
		CREATE TABLE adodb_logsql (
		  created timestamp NOT NULL,
		  sql0 varchar(250) NOT NULL,
		  sql1 text NOT NULL,
		  params text NOT NULL,
		  tracer text NOT NULL,
		  timer decimal(16,6) NOT NULL
		)
		*/
		if (Debug::getVerbosity() == 11) {
			$db->debug=TRUE;
		}

		//Make sure when inserting times we always include the timezone.
		//UNLESS we're using MySQL, because MySQL can't store time stamps with time zones.
		if ( strncmp($db->databaseType,'mysql',5) == 0 ) {
			$db->fmtTimeStamp = "'Y-m-d H:i:s'";

			//Put MySQL into ANSI mode
			$db->Execute('SET SESSION sql_mode=\'ansi\'');
			//READ COMMITTED mode is what PGSQL defaults to.
			//This should hopefully fix odd issues like hierarchy trees becoming corrupt.
			$db->Execute('SET TRANSACTION ISOLATION LEVEL READ COMMITTED');
		} else {
			//Use long timezone format because PostgreSQL 8.1 doesn't support some short names, like SGT,IST
			//Using "e" for the timezone fixes the Asia/Calcutta & IST bug where the two were getting confused.
			$db->fmtTimeStamp = "'Y-m-d H:i:s e'";
		}
	} catch (Exception $e) {
		Debug::Text( 'Error connecting to the database!', __FILE__, __LINE__, __METHOD__,1);
		throw new DBError($e);
	}

	//Global options for FastTree class.
	$fast_tree_options = array( 'db' => $db, 'table' => 'hierarchy_tree' );
	$fast_tree_user_group_options = array( 'db' => $db, 'table' => 'user_group_tree' );
	$fast_tree_job_group_options = array( 'db' => $db, 'table' => 'job_group_tree' );
	$fast_tree_job_item_group_options = array( 'db' => $db, 'table' => 'job_item_group_tree' );
	$fast_tree_client_group_options = array( 'db' => $db, 'table' => 'client_group_tree' );
	$fast_tree_product_group_options = array( 'db' => $db, 'table' => 'product_group_tree' );
	$fast_tree_document_group_options = array( 'db' => $db, 'table' => 'document_group_tree' );
}

//Set timezone to system local timezone by default. This is so we sync up all timezones
//in the database (specifically MySQL) and PHP. This fixes timezone bugs
//mainly in maintenance scripts. We used to default this to just GMT, but that can cause additional problems in threaded environments.
//This must be run AFTER the database connection has been made to work properly.
if ( !isset($config_vars['other']['system_timezone']) OR ( isset($config_vars['other']['system_timezone']) AND $config_vars['other']['system_timezone'] == '' ) ) {
	$config_vars['other']['system_timezone'] = date('e');
}
TTDate::setTimeZone( $config_vars['other']['system_timezone'] );
?>
