<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2073 $
 * $Id: Login.php 2073 2008-08-22 18:41:21Z ipso $
 * $Date: 2008-08-22 11:41:21 -0700 (Fri, 22 Aug 2008) $
 */
require_once('../includes/global.inc.php');

$authenticate=FALSE;
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

$smarty->assign('title', TTi18n::gettext('Secure Login'));

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'user_name',
												'password',
												'password_reset',
												'language',
												) ) );

$validator = new Validator();

$action = Misc::findSubmitButton();
switch ($action) {
	case 'submit':
		//Debug::setVerbosity( 11 );
		Debug::Text('User Name: '. $user_name, __FILE__, __LINE__, __METHOD__,10);

		if ( $authentication->Login($user_name, $password) ) {
			$authentication->Check();

			Debug::text('Login Language: '. $language, __FILE__, __LINE__, __METHOD__, 10);

			TTi18n::setCountry( TTi18n::getCountryFromLocale() );
			TTi18n::setLanguage( $language );
			TTi18n::setLocale();
			TTi18n::setLocaleCookie();

			Debug::text('Locale: '. TTi18n::getLocale(), __FILE__, __LINE__, __METHOD__, 10);

			$clf = new CompanyListFactory();
			$clf->getByID( $authentication->getObject()->getCompany() );
			$current_company = $clf->getCurrent();
			unset($clf);

			$create_new_station = FALSE;
			//If this is a new station, insert it now.
			if ( isset( $_COOKIE['StationID'] ) ) {
				Debug::text('Station ID Cookie found! '. $_COOKIE['StationID'], __FILE__, __LINE__, __METHOD__, 10);

				$slf = new StationListFactory();
				$slf->getByStationIdandCompanyId( $_COOKIE['StationID'], $current_company->getId() );
				$current_station = $slf->getCurrent();
				unset($slf);

				if ( $current_station->isNew() ) {
					Debug::text('Station ID is NOT IN DB!! '. $_COOKIE['StationID'], __FILE__, __LINE__, __METHOD__, 10);
					$create_new_station = TRUE;
				}
			} else {
				$create_new_station = TRUE;
			}

			if ( $create_new_station == TRUE ) {
				//Insert new station
				$sf = new StationFactory();

				$sf->setCompany( $current_company->getId() );
				$sf->setStatus( 'ENABLED' );
				$sf->setType( 'PC' );
				$sf->setSource( $_SERVER['REMOTE_ADDR'] );
				$sf->setStation();
				$sf->setDescription( substr( $_SERVER['HTTP_USER_AGENT'], 0, 250) );
				if ( $sf->Save(FALSE) ) {
					$sf->setCookie();
				}
			}

			Redirect::Page( URLBuilder::getURL( NULL, 'index.php' ) );
		} else {
			$error_message = TTi18n::gettext('User Name or Password is incorrect');

			//Get company status from user_name, so we can display messages for ONHOLD/Cancelled accounts.
			$clf = new CompanyListFactory();
			$clf->getByUserName( $user_name );
			if ( $clf->getRecordCount() > 0 ) {
				$c_obj = $clf->getCurrent();
				if ( $c_obj->getStatus() == 20 ) {
					$error_message = TTi18n::gettext('Sorry, your company\'s account has been placed ON HOLD, please contact customer support immediately');
				} elseif ( $c_obj->getStatus() == 30 ) {
					$error_message = TTi18n::gettext('Sorry, your company\'s account has been CANCELLED, please contact customer support if you believe this is an error');
				}
			}

			$validator->isTrue('user_name',FALSE, $error_message );
		}

		break;
	default:
		break;
}

$smarty->assign_by_ref('user_name', $user_name);
$smarty->assign_by_ref('password', $password);
$smarty->assign_by_ref('password_reset', $password_reset);

$smarty->assign('language_options', TTi18n::getLanguageArray() );

if ( $language == '' ) {
	$language = TTi18n::getLanguageFromLocale();
} elseif ( strlen($language) >= 4) {
	$language = TTi18n::getLanguageFromLocale( $language );
}

$smarty->assign('language', $language );

$smarty->assign_by_ref('validator', $validator);

$smarty->display('Login.tpl');
?>