<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 2158 $
 * $Id: CA.class.php 2158 2008-09-15 23:26:15Z ipso $
 * $Date: 2008-09-15 16:26:15 -0700 (Mon, 15 Sep 2008) $
 */

/**
 * @package PayrollDeduction
 */
class PayrollDeduction_US_CA extends PayrollDeduction_US {
/*
														10 => 'Single',
														20 => 'Married - Spouse Works',
														30 => 'Married - Spouse does not Work',
														40 => 'Head of Household',
*/

	var $state_options = array(
								1199174400 => array(
													'standard_deduction' => array(
																				//First entry is 0,1 allowance, second is for 2 or more.
																				'10' => array(3516.00, 3516.00),
																				'20' => array(3516.00, 3516.00),
																				'30' => array(3516.00, 7032.00),
																				'40' => array(7032.00, 7032.00),
																				),
													'allowance' => array(
																				'10' => 94.00,
																				'20' => 94.00,
																				'30' => 94.00,
																				'40' => 94.00,
																				),
													),
								1167638400 => array(
													'standard_deduction' => array(
																				//First entry is 0,1 allowance, second is for 2 or more.
																				'10' => array(3410.00, 3410.00),
																				'20' => array(3410.00, 3410.00),
																				'30' => array(3410.00, 6820.00),
																				'40' => array(6820.00, 6820.00),
																				),
													'allowance' => array(
																				'10' => 91.00,
																				'20' => 91.00,
																				'30' => 91.00,
																				'40' => 91.00,
																				),
													),
								1136102400 => array(
													'standard_deduction' => array(
																				//First entry is 0,1 allowance, second is for 2 or more.
																				'10' => array(3254.00, 3254.00),
																				'20' => array(3254.00, 3254.00),
																				'30' => array(3254.00, 6508.00),
																				'40' => array(6508.00, 6508.00),
																				),
													'allowance' => array(
																				'10' => 87.00,
																				'20' => 87.00,
																				'30' => 87.00,
																				'40' => 87.00,
																				),
													)
								);

	function getStatePayPeriodDeductions() {
		return bcdiv($this->getStateTaxPayable(), $this->getAnnualPayPeriods() );
	}

	function getStateAnnualTaxableIncome() {
		return bcsub( $this->getAnnualTaxableIncome(), $this->getStateStandardDeduction() );
	}

	function getStateStandardDeduction() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->state_options);
		if ( $retarr == FALSE ) {
			return FALSE;

		}

		$deduction_arr = $retarr['standard_deduction'][$this->getStateFilingStatus()];

		if ( $this->getStateAllowance() == 0 OR $this->getStateAllowance() == 1 ) {
			$deduction = $deduction_arr[0];
		} elseif ( $this->getStateAllowance() >= 2 ) {
			$deduction = $deduction_arr[1];
		}
		Debug::text('Standard Deduction: '. $deduction .' Allowances: '. $this->getStateAllowance() .' Filing Status: '. $this->getStateFilingStatus() , __FILE__, __LINE__, __METHOD__,10);

		return $deduction;
	}

	function getStateAllowanceAmount() {
		$retarr = $this->getDataFromRateArray($this->getDate(), $this->state_options);
		if ( $retarr == FALSE ) {
			return FALSE;
		}

		$allowance = $retarr['allowance'][$this->getStateFilingStatus()];

		$retval = 0;
		if ( $this->getStateAllowance() == 0 ) {
			$retval = 0;
		} elseif ( $this->getStateAllowance() >= 1 ) {
			$retval = bcmul($allowance, $this->getStateAllowance() );
		}

		Debug::text('State Allowance Amount: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		return $retval;
	}

	function getStateTaxPayable() {
		$annual_income = $this->getStateAnnualTaxableIncome();

		$retval = 0;
		if ( $annual_income > 0 ) {
			$rate = $this->getData()->getStateRate($annual_income);
			$prev_income = $this->getData()->getStateRatePreviousIncome($annual_income);
			$state_constant = $this->getData()->getStateConstant($annual_income);

			$retval = bcsub( bcadd( bcmul( bcsub( $annual_income, $prev_income ), $rate ), $state_constant ), $this->getStateAllowanceAmount() );
		}

		Debug::text('State Annual Tax Payable: '. $retval, __FILE__, __LINE__, __METHOD__,10);

		if ( $retval < 0 ) {
			$retval = 0;
		}

		return $retval;
	}

	function getStateEmployerUI() {
		if ( $this->getUIExempt() == TRUE ) {
			return 0;
		}

		$pay_period_income = $this->getGrossPayPeriodIncome();
		$rate = bcdiv( $this->getStateUIRate(), 100 );
		$maximum_contribution = bcmul( $this->getStateUIWageBase(), $rate );
		$ytd_contribution = $this->getYearToDateStateUIContribution();

		Debug::text('Rate: '. $rate .' YTD Contribution: '. $ytd_contribution .' Maximum: '. $maximum_contribution, __FILE__, __LINE__, __METHOD__,10);

		$amount = bcmul( $pay_period_income, $rate );
		$max_amount = bcsub( $maximum_contribution, $ytd_contribution );

		if ( $amount > $max_amount ) {
			$retval = $max_amount;
		} else {
			$retval = $amount;
		}

		return $retval;
	}

}
?>
