<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditPayPeriod.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('pay_period_schedule','enabled')
		OR !( $permission->Check('pay_period_schedule','edit') OR $permission->Check('pay_period_schedule','edit_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'Edit Pay Period')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'pay_period_schedule_id',
												'data'
												) ) );

if ( isset($data) ) {
	if ( isset($data['start_date']) ) {
		$data['start_date'] = TTDate::parseDateTime( $data['start_date'] );
	}
	if ( isset($data['end_date']) ) {
		$data['end_date'] = TTDate::parseDateTime( $data['end_date'] );
	}
	if ( isset($data['transaction_date']) ) {
		$data['transaction_date'] = TTDate::parseDateTime( $data['transaction_date'] );
	}
	if ( isset($data['advance_end_date']) ) {
		$data['advance_end_date'] = TTDate::parseDateTime( $data['advance_end_date'] );
	}
	if ( isset($data['advance_transaction_date']) ) {
		$data['advance_transaction_date'] = TTDate::parseDateTime( $data['advance_transaction_date'] );
	}
}

$ppf = new PayPeriodFactory();

$action = Misc::findSubmitButton();
$action = strtolower($action);
switch ($action) {
	case 'submit':
		//Debug::setVerbosity(11);
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$ppf->StartTransaction();

		if ( $data['id'] == '' ) {
			$ppf->setCompany( $current_company->getId() );
			$ppf->setStatus(10); //Open
		} else {
			$ppf->setId($data['id']);
		}

		$ppf->setPayPeriodSchedule($data['pay_period_schedule_id']);
		$ppf->setStartDate($data['start_date']);
		$ppf->setEndDate($data['end_date']+59);
		$ppf->setTransactionDate($data['transaction_date']+59);

		if ( isset($data['advance_end_date']) ) {
			$ppf->setAdvanceEndDate($data['advance_end_date']);
		}
		if ( isset($data['advance_transaction_date']) ) {
			$ppf->setAdvanceTransactionDate($data['advance_transaction_date']);
		}

		if ( $ppf->isValid() ) {
			$ppf->Save();

			$ppf->CommitTransaction();
			Redirect::Page( URLBuilder::getURL( array('id' => $data['pay_period_schedule_id'] ), 'PayPeriodList.php') );
			break;
		}

		$ppf->FailTransaction();

	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$pplf = new PayPeriodListFactory();
			$pplf->getByIdAndCompanyId($id, $current_company->getId() );

			foreach ($pplf as $pp_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$data = array(
													'id' => $pp_obj->getId(),
													'company_id' => $pp_obj->getCompany(),
													'pay_period_schedule_id' => $pp_obj->getPayPeriodSchedule(),
													'pay_period_schedule_type_id' => $pp_obj->getPayPeriodScheduleObject()->getType(),
													'start_date' => $pp_obj->getStartDate(),
													'end_date' => $pp_obj->getEndDate(),
													'transaction_date' => $pp_obj->getTransactionDate(),
													'advance_end_date' => $pp_obj->getAdvanceEndDate(),
													'advance_transaction_date' => $pp_obj->getAdvanceTransactionDate(),
													'deleted' => $pp_obj->getDeleted(),
													'created_date' => $pp_obj->getCreatedDate(),
													'created_by' => $pp_obj->getCreatedBy(),
													'updated_date' => $pp_obj->getUpdatedDate(),
													'updated_by' => $pp_obj->getUpdatedBy(),
													'deleted_date' => $pp_obj->getDeletedDate(),
													'deleted_by' => $pp_obj->getDeletedBy()
												);
			}
		} else {
			if ( isset($pay_period_schedule_id) AND $pay_period_schedule_id != '') {
				$ppslf = new PayPeriodScheduleListFactory();
				$ppslf->getByIdAndCompanyId( $pay_period_schedule_id, $current_company->getId() );
				if ( $ppslf->getRecordCount() > 0 ) {
					$data['pay_period_schedule_type_id'] = $ppslf->getCurrent()->getType();
				}

				$data['pay_period_schedule_id'] = $pay_period_schedule_id;
			}
		}

		$smarty->assign_by_ref('data', $data);

		break;
}

$smarty->assign_by_ref('ppf', $ppf);

$smarty->display('payperiod/EditPayPeriod.tpl');
?>