<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: TimeTrexSoapClient.class.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
class TimeTrexSoapClient {
	var $soap_client_obj = NULL;

	function __construct() {
		$this->getSoapObject();

		return TRUE;
	}

	function getSoapObject() {
		if ( $this->soap_client_obj == NULL ) {
			$location = 'http://www.timetrex.com/ext_soap/server.php';
			//$location = 'http://localhost/timetrex/website/ext_soap/server.php';

			$this->soap_client_obj = new SoapClient(NULL, array(
											'location' => $location,
											'uri' => 'urn:test',
											'style' => SOAP_RPC,
											'use' => SOAP_ENCODED,
											'trace' => 1,
											'exceptions' => 0
											)
									);
		}

		return $this->soap_client_obj;
	}

	function printSoapDebug() {
		echo "<pre>\n";
		echo "Request :\n".htmlspecialchars($this->getSoapObject()->__getLastRequest()) ."\n";
		echo "Response :\n".htmlspecialchars($this->getSoapObject()->__getLastResponse()) ."\n";
		echo "</pre>\n";
	}

	function ping() {
		return $this->getSoapObject()->ping();
	}

	function isUpdateNotifyEnabled() {
		if ( getTTProductEdition() == 10 ) {
			$sslf = new SystemSettingListFactory();
			$sslf->getByName('update_notify');
			if ( $sslf->getRecordCount() == 1 ) {
				$value = $sslf->getCurrent()->getValue();

				if ( $value == 0 ) {
					return FALSE;
				}
			}
		}

		return TRUE;
	}

	function isLatestVersion( $company_id ) {
		$sslf = new SystemSettingListFactory();
		$sslf->getByName('system_version');
		if ( $sslf->getRecordCount() == 1 ) {
			$version = $sslf->getCurrent()->getValue();

			$retval =  $this->getSoapObject()->isLatestVersion( $this->getLocalRegistrationKey(), $company_id, $version);
			Debug::Text(' Current Version: '. $version .' Retval: '. (int)$retval, __FILE__, __LINE__, __METHOD__,10);

			return $retval;
		}

		return FALSE;
	}

	function isLatestTaxEngineVersion( $company_id ) {
		$sslf = new SystemSettingListFactory();
		$sslf->getByName('tax_engine_version');
		if ( $sslf->getRecordCount() == 1 ) {
			$version = $sslf->getCurrent()->getValue();

			$retval = $this->getSoapObject()->isLatestTaxEngineVersion( $this->getLocalRegistrationKey(), $company_id, $version);
			Debug::Text(' Current Version: '. $version .' Retval: '. (int)$retval, __FILE__, __LINE__, __METHOD__,10);

			return $retval;
		}

		return FALSE;
	}

	function isLatestTaxDataVersion( $company_id ) {
		$sslf = new SystemSettingListFactory();
		$sslf->getByName('tax_data_version');
		if ( $sslf->getRecordCount() == 1 ) {
			$version = $sslf->getCurrent()->getValue();

			$retval =  $this->getSoapObject()->isLatestTaxDataVersion( $this->getLocalRegistrationKey(), $company_id, $version);
			Debug::Text(' Current Version: '. $version .' Retval: '. (int)$retval, __FILE__, __LINE__, __METHOD__,10);

			return $retval;
		}

		return FALSE;
	}


	function getLocalRegistrationKey() {
		$sslf = new SystemSettingListFactory();
		$sslf->getByName('registration_key');
		if ( $sslf->getRecordCount() == 1 ) {
			return $sslf->getCurrent()->getValue();
		}

		return FALSE;
	}
	function getRegistrationKey() {
		return $this->getSoapObject()->generateRegistrationKey();
	}

	function saveRegistrationKey() {
		$sslf = new SystemSettingListFactory();
		$sslf->getByName('registration_key');
		if ( $sslf->getRecordCount() == 0 ) {
			//Get registration key from TimeTrex server.
			$key = $this->getRegistrationKey();

			Debug::Text('Registration Key from server: '. $key, __FILE__, __LINE__, __METHOD__,10);

			if ( $key != '' ) {
				$sslf->setName('registration_key');
				$sslf->setValue( $key );
				if ( $sslf->isValid() == TRUE ) {
					$sslf->Save();
				}

				return TRUE;
			} else {
				Debug::Text('Failed getting registration key...', __FILE__, __LINE__, __METHOD__,10);
				return FALSE;
			}
		} else {
			Debug::Text('Registration key is already set, skipping...', __FILE__, __LINE__, __METHOD__,10);
		}

		return TRUE;
	}

	function sendCompanyVersionData( $company_id ) {
		Debug::Text('Sending Company Version Data...', __FILE__, __LINE__, __METHOD__,10);
		$cf = new CompanyFactory();

		$tt_version_data['registration_key'] = $this->getLocalRegistrationKey();
		$tt_version_data['company_id'] = $company_id;

		$sslf = new SystemSettingListFactory();
		$sslf->getByName('system_version');
		if ( $sslf->getRecordCount() == 1 ) {
			$tt_version_data['system_version'] = $sslf->getCurrent()->getValue();
		}

		$sslf->getByName('tax_engine_version');
		if ( $sslf->getRecordCount() == 1 ) {
			$tt_version_data['tax_engine_version'] = $sslf->getCurrent()->getValue();
		}

		$sslf->getByName('tax_data_version');
		if ( $sslf->getRecordCount() == 1 ) {
			$tt_version_data['tax_data_version'] = $sslf->getCurrent()->getValue();
		}

		$sslf->getByName('schema_version_group_A');
		if ( $sslf->getRecordCount() == 1 ) {
			$tt_version_data['schema_version']['A'] = $sslf->getCurrent()->getValue();
		}
		$sslf->getByName('schema_version_group_B');
		if ( $sslf->getRecordCount() == 1 ) {
			$tt_version_data['schema_version']['B'] = $sslf->getCurrent()->getValue();
		}
		$sslf->getByName('schema_version_group_T');
		if ( $sslf->getRecordCount() == 1 ) {
			$tt_version_data['schema_version']['T'] = $sslf->getCurrent()->getValue();
		}

		if ( isset($_SERVER['SERVER_SOFTWARE']) ) {
			$server_software = $_SERVER['SERVER_SOFTWARE'];
		} else {
			$server_software = 'N/A';
		}
		if ( isset($_SERVER['SERVER_NAME']) ) {
			$server_name = $_SERVER['SERVER_NAME'];
		} else {
			$server_name = 'N/A';
		}

		$db_server_info = $cf->db->ServerInfo();
		$sys_version_data = array(
							'php_version' => phpversion(),
							'zend_version' => zend_version(),
							'web_server' => $server_software,
							'database_type' => $cf->db->databaseType,
							'database_version' => $db_server_info['version'],
							'database_description' => $db_server_info['description'],
							'server_name' => $server_name,
							'base_url' => Environment::getBaseURL(),
							'php_os' => PHP_OS,
							'system_information' => php_uname()
							);

		$version_data = array_merge( $tt_version_data, $sys_version_data);

		if ( isset($version_data) AND is_array( $version_data) ) {
			Debug::Text('Sent Company Version Data!', __FILE__, __LINE__, __METHOD__,10);
			$retval = $this->getSoapObject()->saveCompanyVersionData( $version_data );

			if ( $retval == FALSE ) {
				Debug::Text('Server failed saving data!', __FILE__, __LINE__, __METHOD__,10);
			}
			//$this->printSoapDebug();

			return $retval;
		}
		Debug::Text('NOT Sending Company Version Data!', __FILE__, __LINE__, __METHOD__,10);

		return FALSE;
	}

	function sendCompanyUserCountData( $company_id ) {
		$cuclf = new CompanyUserCountListFactory();
		$cuclf->getActiveUsers();
		if ( $cuclf->getRecordCount() > 0 ) {
			foreach( $cuclf as $cuc_obj ) {
				$user_counts[$cuc_obj->getColumn('company_id')]['active'] = $cuc_obj->getColumn('total');
			}
		}

		$cuclf->getInActiveUsers();
		if ( $cuclf->getRecordCount() > 0 ) {
			foreach( $cuclf as $cuc_obj ) {
				$user_counts[$cuc_obj->getColumn('company_id')]['inactive'] = $cuc_obj->getColumn('total');
			}
		}

		$cuclf->getDeletedUsers();
		if ( $cuclf->getRecordCount() > 0 ) {
			foreach( $cuclf as $cuc_obj ) {
				$user_counts[$cuc_obj->getColumn('company_id')]['deleted'] = $cuc_obj->getColumn('total');
			}
		}

		if ( isset($user_counts[$company_id]) ) {
			$user_counts[$company_id]['registration_key'] = $this->getLocalRegistrationKey();
			$user_counts[$company_id]['company_id'] = $company_id;

			return $this->getSoapObject()->saveCompanyUserCountData( $user_counts[$company_id] );
		}

		return FALSE;
	}

	function sendCompanyUserLocationData( $company_id ) {
		if ( $company_id == '' ) {
			return FALSE;
		}

		$clf = new CompanyListFactory();
		$clf->getById( $company_id );
		if ( $clf->getRecordCount() > 0 ) {

			$location_data['registration_key'] = $this->getLocalRegistrationKey();
			$location_data['company_id'] = $company_id;

			$ulf = new UserListFactory();
			$ulf->getByCompanyId( $company_id );
			if ( $ulf->getRecordCount() > 0 ) {
				foreach( $ulf as $u_obj ) {

					$key = str_replace(' ','', strtolower( $u_obj->getCity().$u_obj->getCity().$u_obj->getCountry() ) );

					$location_data['location_data'][$key] = array(
														'city' => $u_obj->getCity(),
														'province' => $u_obj->getProvince(),
														'country' => $u_obj->getCountry()
															);
				}

				if ( isset($location_data['location_data']) ) {
					return $this->getSoapObject()->saveCompanyUserLocationData( $location_data );
				}
			}

		}

		return FALSE;
	}

	function sendCompanyData( $company_id, $force = FALSE ) {
		Debug::Text('Sending Company Data...', __FILE__, __LINE__, __METHOD__,10);
		if ( $company_id == '' ) {
			return FALSE;
		}

		//Check for anonymous update notifications
		if ( $force == FALSE OR getTTProductEdition() == 10 ) {
			$sslf = new SystemSettingListFactory();
			$sslf->getByName('anonymous_update_notify');
			if ( $sslf->getRecordCount() == 1 ) {
				$anonymous_update_notify = $sslf->getCurrent()->getValue();
			} else {
				$anonymous_update_notify = 0;
			}
		} else {
			$anonymous_update_notify = 0;
		}

		$clf = new CompanyListFactory();
		$clf->getById( $company_id );
		if ( $clf->getRecordCount() > 0 ) {
			foreach( $clf as $c_obj ) {

				$company_data['id'] = $c_obj->getId();
				$company_data['registration_key'] = $this->getLocalRegistrationKey();
				$company_data['status_id'] = $c_obj->getStatus();
				$company_data['product_edition_id'] = $c_obj->getProductEdition();
				$company_data['is_professional_edition_available'] = getTTProductEdition();
				$company_data['product_edition_available'] = getTTProductEdition();

				if ( $anonymous_update_notify == 0 ) {
					$company_data['name'] = $c_obj->getName();
					$company_data['short_name'] = $c_obj->getShortName();
					$company_data['business_number'] = $c_obj->getBusinessNumber();
					$company_data['address1'] = $c_obj->getAddress1();
					$company_data['address2'] = $c_obj->getAddress2();
					$company_data['work_phone'] = $c_obj->getWorkPhone();
					$company_data['fax_phone'] = $c_obj->getFaxPhone();
				}

				$company_data['city'] = $c_obj->getCity();
				$company_data['country'] = $c_obj->getCountry();
				$company_data['province'] = $c_obj->getProvince();
				$company_data['postal_code'] = $c_obj->getPostalCode();

				Debug::Text('Sent Company Data...', __FILE__, __LINE__, __METHOD__,10);
				$retval = $this->getSoapObject()->saveCompanyData( $company_data );

				//$this->printSoapDebug();

				return $retval;
			}
		}

		return FALSE;
	}

	//
	// Currency Data Feed functions
	//
	function getCurrencyExchangeRates( $company_id, $currency_arr, $base_currency ) {
		/*

			Contact info@timetrex.com to request adding custom currency data feeds.

		*/
		if ( $company_id == '' ) {
			return FALSE;
		}

		if ( !is_array($currency_arr) ) {
			return FALSE;
		}

		if ( $base_currency == '' ) {
			return FALSE;
		}

		$currency_rates = $this->getSoapObject()->getCurrencyExchangeRates( $this->getLocalRegistrationKey(), $company_id, $currency_arr, $base_currency );

		if ( isset($currency_rates) AND is_array($currency_rates) AND count($currency_rates) > 0 ) {
			return $currency_rates;
		}

		return FALSE;
	}
}
?>
