<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1595 $
 * $Id: AccrualPolicyMilestoneFactory.class.php 1595 2008-01-04 04:09:57Z ipso $
 * $Date: 2008-01-03 20:09:57 -0800 (Thu, 03 Jan 2008) $
 */
class AccrualPolicyMilestoneFactory extends Factory {
	protected $table = 'accrual_policy_milestone';
	protected $pk_sequence_name = 'accrual_policy_milestone_id_seq'; //PK Sequence name

	protected $accrual_policy_obj = NULL;

	protected $length_of_service_multiplier = array(
										10 => 1,
										20 => 7,
										30 => 30.4167,
										40 => 365.25,
										50 => 0.04166666666666666667, //1/24th of a day.
									);

	function _getFactoryOptions( $name ) {

		$retval = NULL;
		switch( $name ) {
			case 'length_of_service_unit':
				$retval = array(
										10 => TTi18n::gettext('Day(s)'),
										20 => TTi18n::gettext('Week(s)'),
										30 => TTi18n::gettext('Month(s)'),
										40 => TTi18n::gettext('Year(s)'),
										50 => TTi18n::gettext('Hour(s)'),
									);
				break;

		}

		return $retval;
	}


	function getAccrualPolicyObject() {
		if ( is_object($this->accrual_policy_obj) ) {
			return $this->accrual_policy_obj;
		} else {
			$aplf = new AccrualPolicyListFactory();
			$aplf->getById( $this->getAccrualPolicyID() );
			if ( $aplf->getRecordCount() > 0 ) {
				$this->accrual_policy_obj = $aplf->getCurrent();
				return $this->accrual_policy_obj;
			}

			return FALSE;
		}
	}

	function getAccrualPolicy() {
		if ( isset($this->data['accrual_policy_id']) ) {
			return $this->data['accrual_policy_id'];
		}

		return FALSE;
	}
	function setAccrualPolicy($id) {
		$id = trim($id);

		$aplf = new AccrualPolicyListFactory();

		if ( $this->Validator->isResultSetWithRows(	'accrual_policy',
													$aplf->getByID($id),
													TTi18n::gettext('Accrual Policy is invalid')
													) ) {

			$this->data['accrual_policy_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function getLengthOfServiceDays() {
		if ( isset($this->data['length_of_service_days']) ) {
			return (int)$this->data['length_of_service_days'];
		}

		return FALSE;
	}
	function setLengthOfServiceDays($int) {
		$int = trim($int);

		if 	(	$int > 0
				AND
				$this->Validator->isFloat(			'length_of_service'.$this->getLabelID(),
													$int,
													TTi18n::gettext('Length of service is invalid')) ) {
			Debug::text('Length of Service Days', __FILE__, __LINE__, __METHOD__, 10);

			$this->data['length_of_service_days'] = bcmul( $int, $this->length_of_service_multiplier[$this->getLengthOfServiceUnit()], 4);

			return TRUE;
		}

		return FALSE;
	}

	function getLengthOfService() {
		if ( isset($this->data['length_of_service']) ) {
			return (int)$this->data['length_of_service'];
		}

		return FALSE;
	}
	function setLengthOfService($int) {
		$int = trim($int);

		if 	(	$int >= 0
				AND
				$this->Validator->isFloat(			'length_of_service'.$this->getLabelID(),
													$int,
													TTi18n::gettext('Length of service is invalid')) ) {
			$this->data['length_of_service'] = $int;

			return TRUE;
		}

		return FALSE;
	}

	function getLengthOfServiceUnit() {
		if ( isset($this->data['length_of_service_unit_id']) ) {
			return $this->data['length_of_service_unit_id'];
		}

		return FALSE;
	}
	function setLengthOfServiceUnit($value) {
		$value = trim($value);

		$key = Option::getByValue($value, $this->getOptions('length_of_service_unit') );
		if ($key !== FALSE) {
			$value = $key;
		}

		if ( $this->Validator->inArrayKey(	'length_of_service_unit_id'.$this->getLabelID(),
											$value,
											TTi18n::gettext('Incorrect Length of service unit'),
											$this->getOptions('length_of_service_unit')) ) {

			$this->data['length_of_service_unit_id'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getAccrualRate() {
		if ( isset($this->data['accrual_rate']) ) {
			return $this->data['accrual_rate'];
		}

		return FALSE;
	}
	function setAccrualRate($int) {
		$int = trim($int);

		if 	(	$int > 0
				AND
				$this->Validator->isNumeric(		'accrual_rate'.$this->getLabelID(),
													$int,
													TTi18n::gettext('Incorrect Accrual Rate')) ) {
			$this->data['accrual_rate'] = $int;

			return TRUE;
		}

		return FALSE;
	}

	function getMaximumTime() {
		if ( isset($this->data['maximum_time']) ) {
			return (int)$this->data['maximum_time'];
		}

		return FALSE;
	}
	function setMaximumTime($int) {
		$int = trim($int);

		if 	(	$this->Validator->isNumeric(		'maximum_time'.$this->getLabelID(),
													$int,
													TTi18n::gettext('Incorrect Maximum Time')) ) {
			$this->data['maximum_time'] = $int;

			return TRUE;
		}

		return FALSE;
	}

	function getMinimumTime() {
		if ( isset($this->data['minimum_time']) ) {
			return (int)$this->data['minimum_time'];
		}

		return FALSE;
	}
	function setMinimumTime($int) {
		$int = trim($int);

		if 	(	$this->Validator->isNumeric(		'minimum_time'.$this->getLabelID(),
													$int,
													TTi18n::gettext('Incorrect Minimum Time')) ) {
			$this->data['minimum_time'] = $int;

			return TRUE;
		}

		return FALSE;
	}

	function preSave() {
		//Set Length of service in days.
		$this->setLengthOfServiceDays( $this->getLengthOfService() );

		return TRUE;
	}
}
?>
