<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: InstallSchema.class.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
class InstallSchema extends Install {

	protected $schema_version = NULL;
	protected $obj = NULL;

	function __construct( $database_type, $version, $db_conn, $is_upgrade = FALSE ) {
		Debug::text('Database Type: '. $database_type .' Version: '. $version, __FILE__, __LINE__, __METHOD__, 10);
		$this->database_type = $database_type;
		$this->schema_version = $version;

		if ( $database_type == '' ) {
			return FALSE;
		}

		if ( $version == '' ) {
			return FALSE;
		}

		$schema_class_file_name = Environment::getBasePath() . DIRECTORY_SEPARATOR .'classes'. DIRECTORY_SEPARATOR .'modules'. DIRECTORY_SEPARATOR .'install'. DIRECTORY_SEPARATOR .'InstallSchema_'. $version .'.class.php';
		$schema_sql_file_name = $this->getSchemaSQLFilename( $version );
		if ( file_exists($schema_class_file_name)
				AND file_exists($schema_sql_file_name ) ) {

			include_once( $schema_class_file_name );

			$class_name = 'InstallSchema_'. $version;

			$this->obj = new $class_name;
			$this->obj->setDatabaseConnection( $db_conn );
			$this->obj->setIsUpgrade( $is_upgrade );
			$this->obj->setVersion( $version );
			$this->obj->setSchemaSQLFilename( $this->getSchemaSQLFilename() );

			return TRUE;
		} else {
			Debug::text('Schema Install Class File DOES NOT Exists - File Name: '. $schema_class_file_name .' Schema SQL File: '. $schema_sql_file_name, __FILE__, __LINE__, __METHOD__, 10);
		}

		return FALSE;
	}

	function getSQLFileDirectory() {
		return Environment::getBasePath() . DIRECTORY_SEPARATOR .'classes'. DIRECTORY_SEPARATOR .'modules'. DIRECTORY_SEPARATOR .'install'. DIRECTORY_SEPARATOR .'sql'. DIRECTORY_SEPARATOR . $this->database_type . DIRECTORY_SEPARATOR;
	}

	function getSchemaSQLFilename() {
		return $this->getSQLFileDirectory() . $this->schema_version .'.sql';
	}

	//load Schema file data
	function getSchemaSQLFileData() {

	}

	private function getObject() {
		if ( is_object($this->obj) ) {
			return $this->obj;
		}

		return FALSE;
	}

	function __call($function_name, $args = array() ) {
		if ( $this->getObject() !== FALSE ) {
			//Debug::text('Calling Sub-Class Function: '. $function_name, __FILE__, __LINE__, __METHOD__, 10);
			if ( is_callable( array($this->getObject(), $function_name) ) ) {
				$return = call_user_func_array(array($this->getObject(), $function_name), $args);

				return $return;
			}
		}

		Debug::text('Sub-Class Function Call FAILED!:'. $function_name, __FILE__, __LINE__, __METHOD__, 10);

		return FALSE;
	}

}
?>
