<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1936 $
 * $Id: CompanyDeductionFactory.class.php 1936 2008-06-23 23:18:15Z ipso $
 * $Date: 2008-06-23 16:18:15 -0700 (Mon, 23 Jun 2008) $
 */

/**
 * @package Module_Company
 */
class CompanyDeductionFactory extends Factory {
	protected $table = 'company_deduction';
	protected $pk_sequence_name = 'company_deduction_id_seq'; //PK Sequence name

	var $pay_stub_entry_account_link_obj = NULL;
	var $pay_stub_entry_account_obj = NULL;

	var $country_calculation_ids = array('100','200','300');
	var	$province_calculation_ids = array('200','300');
	var $district_calculation_ids = array('300');
	var $calculation_id_fields = array(
										'10' => '10',
										'15' => '15',
										'17' => '17',
										'18' => '15',
										'20' => '20',

										'80' => '80',

										'100' => '',
										'100-CA' => '100-CA',
										'100-US' => '100-US',
										'100-CR' => '100-CR',

										'200' => '',
										'200-CA-BC' => '200-CA',
										'200-CA-AB' => '200-CA',
										'200-CA-SK' => '200-CA',
										'200-CA-MB' => '200-CA',
										'200-CA-QC' => '200-CA',
										'200-CA-ON' => '200-CA',
										'200-CA-NF' => '200-CA',
										'200-CA-NB' => '200-CA',
										'200-CA-NS' => '200-CA',
										'200-CA-PE' => '200-CA',
										'200-CA-NT' => '200-CA',
										'200-CA-YU' => '200-CA',
										'200-CA-NU' => '200-CA',

										'200-US-AL' => '200-US-AL',
										'200-US-AK' => '',
										'200-US-AZ' => '200-US-AZ',
										'200-US-AR' => '200-US-OH',
										'200-US-CA' => '200-US',
										'200-US-CO' => '200-US-WI',
										'200-US-CT' => '200-US-CT',
										'200-US-DE' => '200-US-DE',
										'200-US-DC' => '200-US-DC',
										'200-US-FL' => '',
										'200-US-GA' => '200-US-GA',
										'200-US-HI' => '200-US-WI',
										'200-US-ID' => '200-US-WI',
										'200-US-IL' => '200-US-IL',
										'200-US-IN' => '200-US-IN',
										'200-US-IA' => '200-US-OH',
										'200-US-KS' => '200-US-WI',
										'200-US-KY' => '200-US-OH',
										'200-US-LA' => '200-US-IN',
										'200-US-ME' => '200-US-ME',
										'200-US-MD' => '', //District only
										'200-US-MA' => '200-US-MA',
										'200-US-MI' => '200-US-OH',
										'200-US-MN' => '200-US-WI',
										'200-US-MS' => '200-US',
										'200-US-MO' => '200-US',
										'200-US-MT' => '200-US-OH',
										'200-US-NE' => '200-US-WI',
										'200-US-NV' => '',
										'200-US-NH' => '',
										'200-US-NM' => '200-US-WI',
										'200-US-NJ' => '200-US-NJ',
										'200-US-NY' => '200-US',
										'200-US-NC' => '200-US-NC',
										'200-US-ND' => '200-US-WI',
										'200-US-OH' => '200-US-OH',
										'200-US-OK' => '200-US-WI',
										'200-US-OR' => '200-US-WI',
										'200-US-PA' => '200-US-PA',
										'200-US-RI' => '200-US-WI',
										'200-US-SC' => '200-US-OH',
										'200-US-SD' => '',
										'200-US-TN' => '',
										'200-US-TX' => '',
										'200-US-UT' => '200-US-WI',
										'200-US-VT' => '200-US-WI',
										'200-US-VA' => '200-US-VA',
										'200-US-WA' => '',
										'200-US-WV' => '200-US-WV',
										'200-US-WI' => '200-US-WI',
										'200-US-WY' => '',

										'300-US-AL' => '300-US-PERCENT',
										'300-US-AK' => '300-US-PERCENT',
										'300-US-AZ' => '300-US-PERCENT',
										'300-US-AR' => '300-US-PERCENT',
										'300-US-CA' => '300-US-PERCENT',
										'300-US-CT' => '300-US-PERCENT',
										'300-US-DE' => '300-US-PERCENT',
										'300-US-DC' => '300-US-PERCENT',
										'300-US-FL' => '300-US-PERCENT',
										'300-US-GA' => '300-US-PERCENT',
										'300-US-HI' => '300-US-PERCENT',
										'300-US-ID' => '300-US-PERCENT',
										'300-US-IL' => '300-US-PERCENT',
										'300-US-IN' => '300-US-IN',
										'300-US-IA' => '300-US-PERCENT',
										'300-US-KS' => '300-US-PERCENT',
										'300-US-KY' => '300-US-PERCENT',
										'300-US-LA' => '300-US-PERCENT',
										'300-US-ME' => '300-US-PERCENT',
										'300-US-MD' => '300-US-MD',
										'300-US-MA' => '300-US-PERCENT',
										'300-US-MI' => '300-US-PERCENT',
										'300-US-MN' => '300-US-PERCENT',
										'300-US-MS' => '300-US-PERCENT',
										'300-US-MO' => '300-US-PERCENT',
										'300-US-MT' => '300-US-PERCENT',
										'300-US-NE' => '300-US-PERCENT',
										'300-US-NV' => '300-US-PERCENT',
										'300-US-NH' => '300-US-PERCENT',
										'300-US-NM' => '300-US-PERCENT',
										'300-US-NJ' => '300-US-PERCENT',
										'300-US-NY' => '300-US',
										'300-US-NC' => '300-US-PERCENT',
										'300-US-ND' => '300-US-PERCENT',
										'300-US-OH' => '300-US-PERCENT',
										'300-US-OK' => '300-US-PERCENT',
										'300-US-OR' => '300-US-PERCENT',
										'300-US-PA' => '300-US-PERCENT',
										'300-US-RI' => '300-US-PERCENT',
										'300-US-SC' => '300-US-PERCENT',
										'300-US-SD' => '300-US-PERCENT',
										'300-US-TN' => '300-US-PERCENT',
										'300-US-TX' => '300-US-PERCENT',
										'300-US-UT' => '300-US-PERCENT',
										'300-US-VT' => '300-US-PERCENT',
										'300-US-VA' => '300-US-PERCENT',
										'300-US-WA' => '300-US-PERCENT',
										'300-US-WV' => '300-US-PERCENT',
										'300-US-WI' => '300-US-PERCENT',
										'300-US-WY' => '300-US-PERCENT',
										);

	function _getFactoryOptions( $name ) {
		$retval = NULL;
		switch( $name ) {
			case 'status':
				$retval = array(
										10 => TTi18n::gettext('Enabled'),
										20 => TTi18n::gettext('Disabled'),
									);
				break;
			case 'type':
				$retval = array(
										10 => TTi18n::gettext('Tax'),
										20 => TTi18n::gettext('Deduction'),
									);
				break;
			case 'calculation':
				$retval = array(
										10 => TTi18n::gettext('Percent'),
										15 => TTi18n::gettext('Advanced Percent'),
										17 => TTi18n::gettext('Advanced Percent (Range Bracket)'),
										18 => TTi18n::gettext('Advanced Percent (Tax Bracket)'),
										20 => TTi18n::gettext('Fixed Amount'),

										//US - Custom Formulas
										80 => TTi18n::gettext('US - Advance EIC Formula'),

										//Canada - Custom Formulas CPP and EI
										90 => TTi18n::gettext('Canada - CPP Formula'),
										91 => TTi18n::gettext('Canada - EI Formula'),

										//Federal
										100 => TTi18n::gettext('Federal Income Tax Formula'),

										//Province/State
										200 => TTi18n::gettext('Province/State Income Tax Formula'),

										//Sub-State/Tax Area
										300 => TTi18n::gettext('District / County Income Tax Formula'),
									);
				break;
			case 'us_eic_filing_status': //EIC certificate
				$retval = array(
														10 => TTi18n::gettext('Single or Head of Household'),
														20 => TTi18n::gettext('Married - Without Spouse Filing'),
														30 => TTi18n::gettext('Married - With Spouse Filing'),

									);
				break;
			case 'federal_filing_status': //US
				$retval = array(
														10 => TTi18n::gettext('Single'),
														20 => TTi18n::gettext('Married'),
									);
				break;
			case 'state_filing_status':
				$retval = array(
														10 => TTi18n::gettext('Single'),
														20 => TTi18n::gettext('Married - Spouse Works'),
														30 => TTi18n::gettext('Married - Spouse does not Work'),
														40 => TTi18n::gettext('Head of Household'),
									);
				break;
			case 'state_ga_filing_status':
				$retval = array(
														10 => TTi18n::gettext('Single'),
														20 => TTi18n::gettext('Married - Filing Separately'),
														30 => TTi18n::gettext('Married - Joint One Income'),
														40 => TTi18n::gettext('Married - Joint Two Incomes'),
														50 => TTi18n::gettext('Head of Household'),
									);
				break;
			case 'state_nj_filing_status':
				$retval = array(
														10 => TTi18n::gettext('Rate "A"'),
														20 => TTi18n::gettext('Rate "B"'),
														30 => TTi18n::gettext('Rate "C"'),
														40 => TTi18n::gettext('Rate "D"'),
														50 => TTi18n::gettext('Rate "E"'),
									);
				break;
			case 'state_nc_filing_status':
				$retval = array(
														10 => TTi18n::gettext('Single'),
														20 => TTi18n::gettext('Married or Qualified Widow(er)'),
														30 => TTi18n::gettext('Head of Household'),
									);
				break;
			case 'state_ma_filing_status':
				$retval = array(
														10 => TTi18n::gettext('Regular'),
														20 => TTi18n::gettext('Head of Household'),
														30 => TTi18n::gettext('Blind'),
														40 => TTi18n::gettext('Head of Household and Blind')
									);
				break;
			case 'state_al_filing_status':
				$retval = array(
														10 => TTi18n::gettext('Status "S" Claiming $1500'),
														20 => TTi18n::gettext('Status "M" Claiming $3000'),
														30 => TTi18n::gettext('Status "0"'),
														40 => TTi18n::gettext('Head of Household'),
														50 => TTi18n::gettext('Status "MS"')
									);
				break;
			case 'state_ct_filing_status':
				$retval = array(
														10 => TTi18n::gettext('Status "A"'),
														20 => TTi18n::gettext('Status "B"'),
														30 => TTi18n::gettext('Status "C"'),
														40 => TTi18n::gettext('Status "D"'),
														50 => TTi18n::gettext('Status "E"'),
														60 => TTi18n::gettext('Status "F"'),
									);
				break;
			case 'state_wv_filing_status':
				$retval = array(
														10 => TTi18n::gettext('Standard'),
														20 => TTi18n::gettext('Optional Two Earners'),
									);
				break;
			case 'state_me_filing_status':
				$retval = array(
														10 => TTi18n::gettext('Single'),
														20 => TTi18n::gettext('Married'),
														30 => TTi18n::gettext('Married with 2 incomes'),
									);
				break;
			case 'state_de_filing_status':
				$retval = array(
														10 => TTi18n::gettext('Single'),
														20 => TTi18n::gettext('Married (Filing Jointly)'),
														30 => TTi18n::gettext('Married (Filing Separately)'),
									);
				break;
			case 'state_dc_filing_status':
				$retval = array(
														10 => TTi18n::gettext('Single'),
														20 => TTi18n::gettext('Married (Filing Jointly)'),
														30 => TTi18n::gettext('Married (Filing Separately)'),
														40 => TTi18n::gettext('Head of Household'),
									);
				break;

		}

		return $retval;
	}


	function getPayStubEntryAccountLinkObject() {
		if ( is_object($this->pay_stub_entry_account_link_obj) ) {
			return $this->pay_stub_entry_account_link_obj;
		} else {
			$pseallf = new PayStubEntryAccountLinkListFactory();
			$pseallf->getByCompanyId( $this->getCompany() );
			if ( $pseallf->getRecordCount() > 0 ) {
				$this->pay_stub_entry_account_link_obj = $pseallf->getCurrent();
				return $this->pay_stub_entry_account_link_obj;
			}

			return FALSE;
		}
	}

	function getPayStubEntryAccountObject() {
		if ( is_object($this->pay_stub_entry_account_obj) ) {
			return $this->pay_stub_entry_account_obj;
		} else {
			$psealf = new PayStubEntryAccountListFactory();
			$psealf->getById( $this->getPayStubEntryAccount() );
			if ( $psealf->getRecordCount() > 0 ) {
				$this->pay_stub_entry_account_obj = $psealf->getCurrent();
				return $this->pay_stub_entry_account_obj;
			}

			return FALSE;
		}
	}

	function getCompany() {
		if ( isset($this->data['company_id']) ) {
			return $this->data['company_id'];
		}

		return FALSE;
	}
	function setCompany($id) {
		$id = trim($id);

		Debug::Text('Company ID: '. $id, __FILE__, __LINE__, __METHOD__,10);
		$clf = new CompanyListFactory();

		if ( $this->Validator->isResultSetWithRows(	'company',
													$clf->getByID($id),
													TTi18n::gettext('Company is invalid')
													) ) {

			$this->data['company_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function getStatus() {
		return (int)$this->data['status_id'];
	}
	function setStatus($status) {
		$status = trim($status);

		$key = Option::getByValue($status, $this->getOptions('status') );
		if ($key !== FALSE) {
			$status = $key;
		}

		if ( $this->Validator->inArrayKey(	'status',
											$status,
											TTi18n::gettext('Incorrect Status'),
											$this->getOptions('status')) ) {

			$this->data['status_id'] = $status;

			return FALSE;
		}

		return FALSE;
	}

	function getType() {
		if ( isset($this->data['type_id']) ) {
			return $this->data['type_id'];
		}

		return FALSE;
	}
	function setType($type) {
		$type = trim($type);

		$key = Option::getByValue($type, $this->getOptions('type') );
		if ($key !== FALSE) {
			$type = $key;
		}

		if ( $this->Validator->inArrayKey(	'type',
											$type,
											TTi18n::gettext('Incorrect Type'),
											$this->getOptions('type')) ) {

			$this->data['type_id'] = $type;

			return FALSE;
		}

		return FALSE;
	}

	function isUniqueName($name) {
		$ph = array(
					'company_id' => $this->getCompany(),
					'name' => $name,
					);

		$query = 'select id from '. $this->getTable() .' where company_id = ? AND  name = ? AND deleted=0';
		$id = $this->db->GetOne($query, $ph);
		Debug::Arr($id,'Unique Pay Stub Account: '. $name, __FILE__, __LINE__, __METHOD__,10);

		if ( $id === FALSE ) {
			return TRUE;
		} else {
			if ($id == $this->getId() ) {
				return TRUE;
			}
		}

		return FALSE;
	}
	function getName() {
		if ( isset($this->data['name']) ) {
			return $this->data['name'];
		}

		return FALSE;
	}
	function setName($value) {
		$value = trim($value);

		if 	(
					$this->Validator->isLength(		'name',
													$value,
													TTi18n::gettext('Name is too short or too long'),
													2,
													100)
				AND
				$this->Validator->isTrue(				'name',
														$this->isUniqueName($value),
														TTi18n::gettext('Name is already in use')
													)
													) {

			$this->data['name'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getCombinedCalculationID() {

		if ( in_array($this->getCalculation() , $this->country_calculation_ids )
				AND in_array($this->getCalculation(), $this->province_calculation_ids ) ) {
			$id = $this->getCalculation().'-'.$this->getCountry().'-'.$this->getProvince();
		} elseif ( in_array($this->getCalculation() , $this->country_calculation_ids ) ) {
			$id = $this->getCalculation().'-'.$this->getCountry();
		} else {
			$id = $this->getCalculation();
		}

		if ( isset($this->calculation_id_fields[$id]) ) {
			return $this->calculation_id_fields[$id];
		}

		return FALSE;
	}
	function getCalculation() {
		if ( isset($this->data['calculation_id']) ) {
			return $this->data['calculation_id'];
		}

		return FALSE;
	}
	function setCalculation($value) {
		$value = trim($value);

		$key = Option::getByValue($value, $this->getOptions('calculation') );
		if ($key !== FALSE) {
			$type = $key;
		}

		if ( $this->Validator->inArrayKey(	'calculation',
											$value,
											TTi18n::gettext('Incorrect Calculation'),
											$this->getOptions('calculation')) ) {

			$this->data['calculation_id'] = $value;

			return FALSE;
		}

		return FALSE;
	}

	function getCalculationOrder() {
		if ( isset($this->data['calculation_order']) ) {
			return $this->data['calculation_order'];
		}

		return FALSE;
	}
	function setCalculationOrder($value) {
		$value = trim($value);

		if ( $this->Validator->isNumeric(		'calculation_order',
												$value,
												TTi18n::gettext('Invalid Calculation Order')
										) ) {


			$this->data['calculation_order'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getCountry() {
		if ( isset($this->data['country']) ) {
			return $this->data['country'];
		}

		return FALSE;
	}
	function setCountry($country) {
		$country = trim($country);

		$cf = new CompanyFactory();

		if (	$country == ''
				OR
				$this->Validator->inArrayKey(	'country',
												$country,
												TTi18n::gettext('Invalid Country'),
												$cf->getOptions('country') ) ) {

			$this->data['country'] = $country;

			return TRUE;
		}

		return FALSE;
	}

	function getProvince() {
		if ( isset($this->data['province']) ) {
			return $this->data['province'];
		}

		return FALSE;
	}
	function setProvince($province) {
		$province = trim($province);

		Debug::Text('Country: '. $this->getCountry() .' Province: '. $province, __FILE__, __LINE__, __METHOD__,10);

		$cf = new CompanyFactory();
		$options_arr = $cf->getOptions('province');
		if ( isset($options_arr[$this->getCountry()]) ) {
			$options = $options_arr[$this->getCountry()];
		} else {
			$options = array();
		}

		if (	$province == ''
				OR
				$this->Validator->inArrayKey(	'province',
												$province,
												TTi18n::gettext('Invalid Province/State'),
												$options ) ) {

			$this->data['province'] = $province;

			return TRUE;
		}

		return FALSE;
	}

	//Used for getting district name on W2's
	function getDistrictName() {
		$retval = NULL;

		if ( strtolower($this->getDistrict()) == 'all'
				OR strtolower($this->getDistrict()) == '00' ) {
			if ( $this->getCompanyValue1() != '' ) {
				$retval = $this->getCompanyValue1();
			}
		} else {
			$retval = $this->getDistrict();
		}

		return $retval;
	}
	function getDistrict() {
		if ( isset($this->data['district']) ) {
			return $this->data['district'];
		}

		return FALSE;
	}
	function setDistrict($district) {
		$district = trim($district);

		Debug::Text('Country: '. $this->getCountry() .' District: '. $district, __FILE__, __LINE__, __METHOD__,10);

		$cf = new CompanyFactory();
		$options_arr = $cf->getOptions('district');
		if ( isset($options_arr[$this->getCountry()][$this->getProvince()]) ) {
			$options = $options_arr[$this->getCountry()][$this->getProvince()];
		} else {
			$options = array();
		}

		if (	( $district == '' OR $district == '00' )
				OR
				$this->Validator->inArrayKey(	'district',
												$district,
												TTi18n::gettext('Invalid District'),
												$options ) ) {

			$this->data['district'] = $district;

			return TRUE;
		}

		return FALSE;
	}

	function getCompanyValue1() {
		if ( isset($this->data['company_value1']) ) {
			return $this->data['company_value1'];
		}

		return FALSE;
	}
	function setCompanyValue1($value) {
		$value = trim($value);

		if 	(	$value == ''
				OR
				$this->Validator->isLength(		'company_value1',
												$value,
												TTi18n::gettext('Company Value 1 is too short or too long'),
												1,
												20) ) {

			$this->data['company_value1'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getCompanyValue2() {
		if ( isset($this->data['company_value2']) ) {
			return $this->data['company_value2'];
		}

		return FALSE;
	}
	function setCompanyValue2($value) {
		$value = trim($value);

		if 	(	$value == ''
				OR
				$this->Validator->isLength(		'company_value2',
												$value,
												TTi18n::gettext('Company Value 2 is too short or too long'),
												1,
												20) ) {

			$this->data['company_value2'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getUserValue1() {
		if ( isset($this->data['user_value1']) ) {
			return $this->data['user_value1'];
		}

		return FALSE;
	}
	function setUserValue1($value) {
		$value = trim($value);

		if 	(	$value == ''
				OR
				$this->Validator->isLength(		'user_value1',
												$value,
												TTi18n::gettext('User Value 1 is too short or too long'),
												1,
												20) ) {

			$this->data['user_value1'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getUserValue2() {
		if ( isset($this->data['user_value2']) ) {
			return $this->data['user_value2'];
		}

		return FALSE;
	}
	function setUserValue2($value) {
		$value = trim($value);

		if 	(	$value == ''
				OR
				$this->Validator->isLength(		'user_value2',
												$value,
												TTi18n::gettext('User Value 2 is too short or too long'),
												1,
												20) ) {

			$this->data['user_value2'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getUserValue3() {
		if ( isset($this->data['user_value3']) ) {
			return $this->data['user_value3'];
		}

		return FALSE;
	}
	function setUserValue3($value) {
		$value = trim($value);

		if 	(	$value == ''
				OR
				$this->Validator->isLength(		'user_value3',
												$value,
												TTi18n::gettext('User Value 3 is too short or too long'),
												1,
												20) ) {

			$this->data['user_value3'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getUserValue4() {
		if ( isset($this->data['user_value4']) ) {
			return $this->data['user_value4'];
		}

		return FALSE;
	}
	function setUserValue4($value) {
		$value = trim($value);

		if 	(	$value == ''
				OR
				$this->Validator->isLength(		'user_value4',
												$value,
												TTi18n::gettext('User Value 4 is too short or too long'),
												1,
												20) ) {

			$this->data['user_value4'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getUserValue5() {
		if ( isset($this->data['user_value5']) ) {
			return $this->data['user_value5'];
		}

		return FALSE;
	}
	function setUserValue5($value) {
		$value = trim($value);

		if 	(	$value == ''
				OR
				$this->Validator->isLength(		'user_value5',
												$value,
												TTi18n::gettext('User Value 5 is too short or too long'),
												1,
												20) ) {

			$this->data['user_value5'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getUserValue6() {
		if ( isset($this->data['user_value6']) ) {
			return $this->data['user_value6'];
		}

		return FALSE;
	}
	function setUserValue6($value) {
		$value = trim($value);

		if 	(	$value == ''
				OR
				$this->Validator->isLength(		'user_value6',
												$value,
												TTi18n::gettext('User Value 6 is too short or too long'),
												1,
												20) ) {

			$this->data['user_value6'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getUserValue7() {
		if ( isset($this->data['user_value7']) ) {
			return $this->data['user_value7'];
		}

		return FALSE;
	}
	function setUserValue7($value) {
		$value = trim($value);

		if 	(	$value == ''
				OR
				$this->Validator->isLength(		'user_value7',
												$value,
												TTi18n::gettext('User Value 7 is too short or too long'),
												1,
												20) ) {

			$this->data['user_value7'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getUserValue8() {
		if ( isset($this->data['user_value8']) ) {
			return $this->data['user_value8'];
		}

		return FALSE;
	}
	function setUserValue8($value) {
		$value = trim($value);

		if 	(	$value == ''
				OR
				$this->Validator->isLength(		'user_value8',
												$value,
												TTi18n::gettext('User Value 8 is too short or too long'),
												1,
												20) ) {

			$this->data['user_value8'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getUserValue9() {
		if ( isset($this->data['user_value9']) ) {
			return $this->data['user_value9'];
		}

		return FALSE;
	}
	function setUserValue9($value) {
		$value = trim($value);

		if 	(	$value == ''
				OR
				$this->Validator->isLength(		'user_value9',
												$value,
												TTi18n::gettext('User Value 9 is too short or too long'),
												1,
												20) ) {

			$this->data['user_value9'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getUserValue10() {
		if ( isset($this->data['user_value10']) ) {
			return $this->data['user_value10'];
		}

		return FALSE;
	}
	function setUserValue10($value) {
		$value = trim($value);

		if 	(	$value == ''
				OR
				$this->Validator->isLength(		'user_value10',
												$value,
												TTi18n::gettext('User Value 10 is too short or too long'),
												1,
												20) ) {

			$this->data['user_value10'] = $value;

			return TRUE;
		}

		return FALSE;
	}

	function getUserValue1Options() {
		//Debug::Text('Calculation: '. $this->getCalculation(), __FILE__, __LINE__, __METHOD__,10);
		switch ( $this->getCalculation() ) {
			case 100:
				//Debug::Text('Country: '. $this->getCountry(), __FILE__, __LINE__, __METHOD__,10);
				if ( $this->getCountry() == 'CA' ) {
				} elseif ( $this->getCountry() == 'US' ) {
					//$options = $this->federal_filing_status_options;
					$options = $this->getOptions('federal_filing_status');
				}

				break;
			case 200:
				//Debug::Text('Country: '. $this->getCountry(), __FILE__, __LINE__, __METHOD__,10);
				//Debug::Text('Province: '. $this->getProvince(), __FILE__, __LINE__, __METHOD__,10);
				if ( $this->getCountry() == 'CA' ) {
				} elseif ( $this->getCountry() == 'US' ) {
					$state_options_var = strtolower('state_'. $this->getProvince() .'_filing_status_options');
					//Debug::Text('Specific State Variable Name: '. $state_options_var, __FILE__, __LINE__, __METHOD__,10);
					if ( isset( $this->$state_options_var ) ) {
						//Debug::Text('Specific State Options: ', __FILE__, __LINE__, __METHOD__,10);
						//$options = $this->$state_options_var;
						$options = $this->getOptions($state_options_var);
					} elseif ( $this->getProvince() == 'IL' ) {
						$options = FALSE;
					} else {
						//Debug::Text('Default State Options: ', __FILE__, __LINE__, __METHOD__,10);
						//$options = $this->state_filing_status_options;
						$options = $this->getOptions('state_filing_status');
					}
				}

				break;
		}

		if ( isset($options) ) {
			return $options;
		}

		return FALSE;
	}

	function getPayStubEntryAccount() {
		if ( isset($this->data['pay_stub_entry_account_id']) ) {
			return $this->data['pay_stub_entry_account_id'];
		}

		return FALSE;
	}
	function setPayStubEntryAccount($id) {
		$id = trim($id);

		Debug::Text('ID: '. $id, __FILE__, __LINE__, __METHOD__,10);
		$psealf = new PayStubEntryAccountListFactory();

		if (
				( $id == '' OR $id == 0 )
				OR
				$this->Validator->isResultSetWithRows(	'pay_stub_entry_account',
														$psealf->getByID($id),
														TTi18n::gettext('Pay Stub Account is invalid')
													) ) {

			$this->data['pay_stub_entry_account_id'] = $id;

			return TRUE;
		}

		return FALSE;
	}

	function getLockUserValue1() {
		return $this->fromBool( $this->data['lock_user_value1'] );
	}
	function setLockUserValue1($bool) {
		$this->data['lock_user_value1'] = $this->toBool($bool);

		return true;
	}

	function getLockUserValue2() {
		return $this->fromBool( $this->data['lock_user_value2'] );
	}
	function setLockUserValue2($bool) {
		$this->data['lock_user_value2'] = $this->toBool($bool);

		return true;
	}

	function getLockUserValue3() {
		return $this->fromBool( $this->data['lock_user_value3'] );
	}
	function setLockUserValue3($bool) {
		$this->data['lock_user_value3'] = $this->toBool($bool);

		return true;
	}

	function getLockUserValue4() {
		return $this->fromBool( $this->data['lock_user_value4'] );
	}
	function setLockUserValue4($bool) {
		$this->data['lock_user_value4'] = $this->toBool($bool);

		return true;
	}

	function getLockUserValue5() {
		return $this->fromBool( $this->data['lock_user_value5'] );
	}
	function setLockUserValue5($bool) {
		$this->data['lock_user_value5'] = $this->toBool($bool);

		return true;
	}

	function getLockUserValue6() {
		return $this->fromBool( $this->data['lock_user_value6'] );
	}
	function setLockUserValue6($bool) {
		$this->data['lock_user_value6'] = $this->toBool($bool);

		return true;
	}

	function getLockUserValue7() {
		return $this->fromBool( $this->data['lock_user_value7'] );
	}
	function setLockUserValue7($bool) {
		$this->data['lock_user_value7'] = $this->toBool($bool);

		return true;
	}

	function getLockUserValue8() {
		return $this->fromBool( $this->data['lock_user_value8'] );
	}
	function setLockUserValue8($bool) {
		$this->data['lock_user_value8'] = $this->toBool($bool);

		return true;
	}

	function getLockUserValue9() {
		return $this->fromBool( $this->data['lock_user_value9'] );
	}
	function setLockUserValue9($bool) {
		$this->data['lock_user_value9'] = $this->toBool($bool);

		return true;
	}

	function getLockUserValue10() {
		return $this->fromBool( $this->data['lock_user_value10'] );
	}
	function setLockUserValue10($bool) {
		$this->data['lock_user_value10'] = $this->toBool($bool);

		return true;
	}

	function getIncludePayStubEntryAccount() {
		$cache_id = 'include_pay_stub_entry-'. $this->getId();
		$list = $this->getCache( $cache_id );
		if ( $list === FALSE ) {
			Debug::text('Caching Include IDs: '. $this->getId(), __FILE__, __LINE__, __METHOD__, 10);
			$cdpsealf = new CompanyDeductionPayStubEntryAccountListFactory();
			$cdpsealf->getByCompanyDeductionIdAndTypeId( $this->getId(), 10 );

			$list = NULL;
			foreach ($cdpsealf as $obj) {
				$list[] = $obj->getPayStubEntryAccount();
			}
			$this->saveCache( $list, $cache_id);
		} else {
			Debug::text('Reading Cached Include IDs: '. $this->getId(), __FILE__, __LINE__, __METHOD__, 10);
		}
		//Debug::Arr($list, 'Include IDs: ', __FILE__, __LINE__, __METHOD__, 10);

		if ( isset($list) AND is_array($list) ) {
			return $list;
		}

		return FALSE;
	}
	function setIncludePayStubEntryAccount($ids) {
		Debug::text('Setting Include IDs : ', __FILE__, __LINE__, __METHOD__, 10);
		if ( is_array($ids) ) {
			if ( !$this->isNew() ) {
				//If needed, delete mappings first.
				$cdpsealf = new CompanyDeductionPayStubEntryAccountListFactory();
				$cdpsealf->getByCompanyDeductionIdAndTypeId( $this->getId(), 10 );

				$tmp_ids = array();
				foreach ($cdpsealf as $obj) {
					$id = $obj->getPayStubEntryAccount();
					Debug::text('ID: '. $id, __FILE__, __LINE__, __METHOD__, 10);

					//Delete users that are not selected.
					if ( !in_array($id, $ids) ) {
						Debug::text('Deleting: '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$obj->Delete();
					} else {
						//Save ID's that need to be updated.
						Debug::text('NOT Deleting : '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$tmp_ids[] = $id;
					}
				}
				unset($id, $obj);
			}

			//Insert new mappings.
			//$lf = new UserListFactory();
			$psealf = new PayStubEntryAccountListFactory();

			foreach ($ids as $id) {
				if ( $id != FALSE AND isset($ids) AND !in_array($id, $tmp_ids) ) {
					$cdpseaf = new CompanyDeductionPayStubEntryAccountFactory();
					$cdpseaf->setCompanyDeduction( $this->getId() );
					$cdpseaf->setType(10); //Include
					$cdpseaf->setPayStubEntryAccount( $id );

					$obj = $psealf->getById( $id )->getCurrent();

					if ($this->Validator->isTrue(		'include_pay_stub_entry_account',
														$cdpseaf->Validator->isValid(),
														TTi18n::gettext('Include Pay Stub Account is invalid').' ('. $obj->getName() .')' )) {
						$cdpseaf->save();
					}
				}
			}

			return TRUE;
		}

		Debug::text('No IDs to set.', __FILE__, __LINE__, __METHOD__, 10);
		return FALSE;
	}

	function getExcludePayStubEntryAccount() {
		$cache_id = 'exclude_pay_stub_entry-'. $this->getId();
		$list = $this->getCache( $cache_id );
		if ( $list === FALSE ) {
			Debug::text('Caching Exclude IDs: '. $this->getId(), __FILE__, __LINE__, __METHOD__, 10);
			$cdpsealf = new CompanyDeductionPayStubEntryAccountListFactory();
			$cdpsealf->getByCompanyDeductionIdAndTypeId( $this->getId(), 20 );

			$list = NULL;
			foreach ($cdpsealf as $obj) {
				$list[] = $obj->getPayStubEntryAccount();
			}

			$this->saveCache( $list, $cache_id);
		} else {
			Debug::text('Reading Cached Exclude IDs: '. $this->getId(), __FILE__, __LINE__, __METHOD__, 10);
		}

		if ( isset($list) AND is_array($list) ) {
			return $list;
		}

		return FALSE;
	}
	function setExcludePayStubEntryAccount($ids) {
		Debug::text('Setting Exclude IDs : ', __FILE__, __LINE__, __METHOD__, 10);
		//if ( is_array($ids) and count($ids) > 0) {
		if ( is_array($ids) ) {
			if ( !$this->isNew() ) {
				//If needed, delete mappings first.
				$cdpsealf = new CompanyDeductionPayStubEntryAccountListFactory();
				$cdpsealf->getByCompanyDeductionIdAndTypeId( $this->getId(), 20 );

				$tmp_ids = array();
				foreach ($cdpsealf as $obj) {
					$id = $obj->getPayStubEntryAccount();
					Debug::text('ID: '. $id, __FILE__, __LINE__, __METHOD__, 10);

					//Delete users that are not selected.
					if ( !in_array($id, $ids) ) {
						Debug::text('Deleting: '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$obj->Delete();
					} else {
						//Save ID's that need to be updated.
						Debug::text('NOT Deleting : '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$tmp_ids[] = $id;
					}
				}
				unset($id, $obj);
			}

			//Insert new mappings.
			//$lf = new UserListFactory();
			$psealf = new PayStubEntryAccountListFactory();

			foreach ($ids as $id) {
				if ( $id != FALSE AND isset($ids) AND !in_array($id, $tmp_ids) ) {
					$cdpseaf = new CompanyDeductionPayStubEntryAccountFactory();
					$cdpseaf->setCompanyDeduction( $this->getId() );
					$cdpseaf->setType(20); //Include
					$cdpseaf->setPayStubEntryAccount( $id );

					$obj = $psealf->getById( $id )->getCurrent();

					if ($this->Validator->isTrue(		'exclude_pay_stub_entry_account',
														$cdpseaf->Validator->isValid(),
														TTi18n::gettext('Exclude Pay Stub Account is invalid').' ('. $obj->getName() .')' )) {
						$cdpseaf->save();
					}
				}
			}

			return TRUE;
		}

		Debug::text('No IDs to set.', __FILE__, __LINE__, __METHOD__, 10);
		return FALSE;
	}

	function getUser() {
		$udlf = new UserDeductionListFactory();
		$udlf->getByCompanyIdAndCompanyDeductionId( $this->getCompany(), $this->getId() );
		foreach ($udlf as $obj) {
			$list[] = $obj->getUser();
		}

		if ( isset($list) ) {
			return $list;
		}

		return FALSE;
	}
	function setUser($ids) {
		Debug::text('Setting User IDs : ', __FILE__, __LINE__, __METHOD__, 10);
		if ( is_array($ids) ) {
			if ( !$this->isNew() ) {
				//If needed, delete mappings first.
				$udlf = new UserDeductionListFactory();
				$udlf->getByCompanyIdAndCompanyDeductionId( $this->getCompany(), $this->getId() );

				$tmp_ids = array();
				foreach ($udlf as $obj) {
					$id = $obj->getUser();
					Debug::text('ID: '. $id, __FILE__, __LINE__, __METHOD__, 10);

					//Delete users that are not selected.
					if ( !in_array($id, $ids) ) {
						Debug::text('Deleting: '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$obj->Delete();
					} else {
						//Save ID's that need to be updated.
						Debug::text('NOT Deleting : '. $id, __FILE__, __LINE__, __METHOD__, 10);
						$tmp_ids[] = $id;
					}
				}
				unset($id, $obj);
			}

			//Insert new mappings.
			//$psealf = new PayStubEntryAccountListFactory();
			$ulf = new UserListFactory();

			foreach ($ids as $id) {
				if ( $id != FALSE AND isset($ids) AND !in_array($id, $tmp_ids) ) {
					$udf = new UserDeductionFactory();
					$udf->setUser( $id );
					$udf->setCompanyDeduction( $this->getId() );

					$obj = $ulf->getById( $id )->getCurrent();

					if ($this->Validator->isTrue(		'user',
														$udf->Validator->isValid(),
														TTi18n::gettext('Employee is invalid').' ('. $obj->getFullName() .')' )) {
						$udf->save();
					}
				}
			}

			return TRUE;
		}

		Debug::text('No IDs to set.', __FILE__, __LINE__, __METHOD__, 10);
		return FALSE;
	}

	function getExpandedPayStubEntryAccountIDs( $ids ) {
		//Debug::Arr($ids, 'Total Gross ID: '. $this->getPayStubEntryAccountLinkObject()->getTotalGross() .' IDs:', __FILE__, __LINE__, __METHOD__,10);
		$ids = (array)$ids;

		$total_gross_key = array_search( $this->getPayStubEntryAccountLinkObject()->getTotalGross(), $ids);
		if ( $total_gross_key !== FALSE ) {
			$type_ids[] = 10;
			$type_ids[] = 60; //Automatically inlcude Advance Earnings here?
			unset($ids[$total_gross_key]);
		}
		unset($total_gross_key);

		$total_employee_deduction_key = array_search( $this->getPayStubEntryAccountLinkObject()->getTotalEmployeeDeduction(), $ids);
		if ( $total_employee_deduction_key !== FALSE ) {
			$type_ids[] = 20;
			unset($ids[$total_employee_deduction_key]);
		}
		unset($total_employee_deduction_key);

		$total_employer_deduction_key = array_search( $this->getPayStubEntryAccountLinkObject()->getTotalEmployerDeduction(), $ids);
		if ( $total_employer_deduction_key !== FALSE ) {
			$type_ids[] = 30;
			unset($ids[$total_employer_deduction_key]);
		}
		unset($total_employer_deduction_key);

		$psea_ids_from_type_ids = array();
		if ( isset($type_ids) ) {
			$psealf = new PayStubEntryAccountListFactory();
			$psea_ids_from_type_ids = $psealf->getByCompanyIdAndStatusIdAndTypeIdArray( $this->getCompany(), array(10,20), $type_ids, FALSE );
			if ( is_array( $psea_ids_from_type_ids ) ) {
				$psea_ids_from_type_ids = array_keys( $psea_ids_from_type_ids );
			}
		}

		$retval = array_unique( array_merge( $ids, $psea_ids_from_type_ids ) );

		//Debug::Arr($retval, 'Retval: ', __FILE__, __LINE__, __METHOD__,10);
		return $retval;

	}

	//Combines include account IDs/Type IDs and exclude account IDs/Type Ids
	//and outputs just include account ids.
	function getCombinedIncludeExcludePayStubEntryAccount( $include_ids, $exclude_ids ) {
		$ret_include_ids = $this->getExpandedPayStubEntryAccountIDs( $include_ids );
		$ret_exclude_ids = $this->getExpandedPayStubEntryAccountIDs( $exclude_ids );

		$retarr = array_diff( $ret_include_ids, $ret_exclude_ids );

		//Debug::Arr($retarr, 'Retarr: ', __FILE__, __LINE__, __METHOD__,10);
		return $retarr;
	}

	function getPayStubEntryAmountSum( $pay_stub_obj, $ids ) {
		if ( !is_object($pay_stub_obj) ) {
			return FALSE;
		}

		if ( !is_array($ids) ) {
			return FALSE;
		}

		$pself = new PayStubEntryListFactory();

		//Get Linked accounts so we know which IDs are totals.
		$total_gross_key = array_search( $this->getPayStubEntryAccountLinkObject()->getTotalGross(), $ids);
		if ( $total_gross_key !== FALSE ) {
			$type_ids[] = 10;
			$type_ids[] = 60; //Automatically inlcude Advance Earnings here?
			unset($ids[$total_gross_key]);
		}
		unset($total_gross_key);

		$total_employee_deduction_key = array_search( $this->getPayStubEntryAccountLinkObject()->getTotalEmployeeDeduction(), $ids);
		if ( $total_employee_deduction_key !== FALSE ) {
			$type_ids[] = 20;
			unset($ids[$total_employee_deduction_key]);
		}
		unset($total_employee_deduction_key);

		$total_employer_deduction_key = array_search( $this->getPayStubEntryAccountLinkObject()->getTotalEmployerDeduction(), $ids);
		if ( $total_employer_deduction_key !== FALSE ) {
			$type_ids[] = 30;
			unset($ids[$total_employer_deduction_key]);
		}
		unset($total_employer_deduction_key);

		$type_amount_arr['amount'] = 0;
		if ( isset($type_ids) ) {
			//$type_amount_arr = $pself->getSumByPayStubIdAndType( $pay_stub_id, $type_ids );
			$type_amount_arr = $pay_stub_obj->getSumByEntriesArrayAndTypeIDAndPayStubAccountID( 'current', $type_ids );
		}

		$amount_arr['amount'] = 0;
		if ( count($ids) > 0 ) {
			//Still other IDs left to total.
			//$amount_arr = $pself->getAmountSumByPayStubIdAndEntryNameID( $pay_stub_id, $ids );
			$amount_arr = $pay_stub_obj->getSumByEntriesArrayAndTypeIDAndPayStubAccountID( 'current', NULL, $ids );
		}

		$retval = bcadd($type_amount_arr['amount'], $amount_arr['amount'] );

		Debug::text('Type Amount: '. $type_amount_arr['amount'] .' Regular Amount: '. $amount_arr['amount'] .' Total: '. $retval, __FILE__, __LINE__, __METHOD__, 10);

		return $retval;
	}

	//function getYTDPayStubEntryAmountSum( $user_id, $ids, $date = NULL ) {
	function getYTDPayStubEntryAmountSum( $pay_stub_obj, $ids ) {
		if ( !is_object($pay_stub_obj) ) {
			return FALSE;
		}

		if ( !is_array($ids) ) {
			return FALSE;
		}

		$pself = new PayStubEntryListFactory();

		//Get Linked accounts so we know which IDs are totals.
		$total_gross_key = array_search( $this->getPayStubEntryAccountLinkObject()->getTotalGross(), $ids);
		if ( $total_gross_key !== FALSE ) {
			$type_ids[] = 10;
			unset($ids[$total_gross_key]);
		}
		unset($total_gross_key);

		$total_employee_deduction_key = array_search( $this->getPayStubEntryAccountLinkObject()->getTotalEmployeeDeduction(), $ids);
		if ( $total_employee_deduction_key !== FALSE ) {
			$type_ids[] = 20;
			unset($ids[$total_employee_deduction_key]);
		}
		unset($total_employee_deduction_key);

		$total_employer_deduction_key = array_search( $this->getPayStubEntryAccountLinkObject()->getTotalEmployerDeduction(), $ids);
		if ( $total_employer_deduction_key !== FALSE ) {
			$type_ids[] = 30;
			unset($ids[$total_employer_deduction_key]);
		}
		unset($total_employer_deduction_key);

		$type_amount_arr['ytd_amount'] = 0;
		if ( isset($type_ids) ) {
			//$type_amount_arr = $pself->getYTDAmountSumByUserIdAndTypeIdAndDate( $user_id, $type_ids, $date );
			$type_amount_arr = $pay_stub_obj->getSumByEntriesArrayAndTypeIDAndPayStubAccountID( 'previous', $type_ids );
		}

		$amount_arr['ytd_amount'] = 0;
		if ( count($ids) > 0 ) {
			//Still other IDs left to total.
			//$amount_arr = $pself->getYTDAmountSumByUserIdAndTypeIdAndDate( $user_id, $ids, $date );
			$amount_arr = $pay_stub_obj->getSumByEntriesArrayAndTypeIDAndPayStubAccountID( 'previous', NULL, $ids );
		}

		$retval = bcadd($type_amount_arr['ytd_amount'], $amount_arr['ytd_amount'] );

		Debug::text('Type Amount: '. $type_amount_arr['ytd_amount'] .' Regular Amount: '. $amount_arr['ytd_amount'] .' Total: '. $retval, __FILE__, __LINE__, __METHOD__, 10);

		return $retval;
	}

	function getCalculationPayStubAmount( $pay_stub_obj ) {
		if ( !is_object($pay_stub_obj) ) {
			return FALSE;
		}

		$include_ids = $this->getIncludePayStubEntryAccount();
		$exclude_ids = $this->getExcludePayStubEntryAccount();

		//This totals up the includes, and minuses the excludes.

		/*
		$pself = new PayStubEntryListFactory();
		$include = $pself->getAmountSumByPayStubIdAndEntryNameID( $pay_stub_id, $include_ids );
		if ( is_array( $exclude_ids ) ) {
			$exclude = $pself->getAmountSumByPayStubIdAndEntryNameID( $pay_stub_id, $exclude_ids );
		} else {
			$exclude['amount'] = 0;
		}
		*/
		$include = $this->getPayStubEntryAmountSum( $pay_stub_obj, $include_ids );
		$exclude = $this->getPayStubEntryAmountSum( $pay_stub_obj, $exclude_ids );
		Debug::text('Include Amount: '. $include .' Exclude Amount: '. $exclude, __FILE__, __LINE__, __METHOD__, 10);

		$amount = bcsub( $include, $exclude);

		if ( $amount < 0 ) {
			$amount = 0;
		}

		Debug::text('Amount: '. $amount, __FILE__, __LINE__, __METHOD__, 10);

		return $amount;
	}

	function getCalculationYTDAmount( $pay_stub_obj ) {
		if ( !is_object($pay_stub_obj) ) {
			return FALSE;
		}

		//This totals up the includes, and minuses the excludes.

		$include_ids = $this->getIncludePayStubEntryAccount();
		$exclude_ids = $this->getExcludePayStubEntryAccount();

		//$include = $this->getYTDPayStubEntryAmountSum( $user_id, $include_ids, $date );
		//$exclude = $this->getYTDPayStubEntryAmountSum( $user_id, $exclude_ids, $date );

		$include = $this->getYTDPayStubEntryAmountSum( $pay_stub_obj, $include_ids );
		$exclude = $this->getYTDPayStubEntryAmountSum( $pay_stub_obj, $exclude_ids );

		/*
		$pself = new PayStubEntryListFactory();
		$include = $pself->getYTDAmountSumByUserIdAndEntryNameIdAndDate( $user_id, $this->getIncludePayStubEntryAccount(), $date );
		if ( is_array( $exclude_ids ) ) {
			$exclude = $pself->getYTDAmountSumByUserIdAndEntryNameIdAndDate( $user_id, $this->getExcludePayStubEntryAccount(), $date );
		} else {
			$exclude['amount'] = 0;
		}
		*/

		$amount = bcsub( $include, $exclude);

		if ( $amount < 0 ) {
			$amount = 0;
		}

		Debug::text('Amount: '. $amount, __FILE__, __LINE__, __METHOD__, 10);

		return $amount;
	}

	function getJavaScriptArrays() {
		$output = 'var fields = '. Misc::getJSArray( $this->calculation_id_fields, 'fields', TRUE );

		$output .= 'var country_calculation_ids = '. Misc::getJSArray( $this->country_calculation_ids );
		$output .= 'var province_calculation_ids = '. Misc::getJSArray( $this->province_calculation_ids );
		$output .= 'var district_calculation_ids = '. Misc::getJSArray( $this->district_calculation_ids );

		return $output;
	}

	static function getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, $type_id, $name ) {
		$psealf = new PayStubEntryAccountListFactory();
		$psealf->getByCompanyIdAndTypeAndFuzzyName( $company_id, $type_id, $name );
		if ( $psealf->getRecordCount() > 0 ) {
			return $psealf->getCurrent()->getId();
		}

		return FALSE;
	}

	static function addPresets($company_id) {
		if ( $company_id == '' ) {
			Debug::text('Company ID: '. $company_id , __FILE__, __LINE__, __METHOD__, 10);
			return FALSE;
		}

		$clf = new CompanyListFactory();
		$clf->getById( $company_id );
		if ( $clf->getRecordCount() > 0 ) {
			$company_obj = $clf->getCurrent();
			$country = $company_obj->getCountry();
			$province = $company_obj->getProvince();
		} else {
			Debug::text('bCompany ID: '. $company_id , __FILE__, __LINE__, __METHOD__, 10);
			return FALSE;
		}

		//Get PayStub Link accounts
		$pseallf = new PayStubEntryAccountLinkListFactory();
		$pseallf->getByCompanyId( $company_id );
		if  ( $pseallf->getRecordCount() > 0 ) {
			$psea_obj = $pseallf->getCurrent();
		} else {
			Debug::text('cCompany ID: '. $company_id , __FILE__, __LINE__, __METHOD__, 10);
			return FALSE;
		}

		$cdf = new CompanyDeductionFactory();
		$cdf->StartTransaction();

		/*
										10 => 'Percent',
										15 => 'Advanced Percent',
										20 => 'Fixed Amount',

										//Federal
										100 => 'Federal Income Tax Formula',

										//Province/State
										200 => 'Province/State Income Tax Formula',
										210 => 'Province/State UI Formula',
		*/

		Debug::text('Country: '. $country , __FILE__, __LINE__, __METHOD__, 10);
		switch (strtolower($country)) {
			case 'ca':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'Federal Income Tax' );
				$cdf->setCalculation( 100 );
				$cdf->setCalculationOrder( 100 );
				$cdf->setCountry( 'CA' );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 20, '%Federal Income%') );
				$cdf->setUserValue1( 9039 ); //2006

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$exclude_ids = array(
										self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 20, 'Union'),
										);
					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );
					//var_dump($exclude_ids);
					$cdf->setExcludePayStubEntryAccount( $exclude_ids );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'Additional Income Tax' );
				$cdf->setCalculation( 20 );
				$cdf->setCalculationOrder( 105 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 20, '%Additional Income Tax%') );
				$cdf->setUserValue1( 0 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'CPP - Employee' );
				//$cdf->setCalculation( 15 );
				$cdf->setCalculation( 90 ); // CPP Formula

				$cdf->setCalculationOrder( 80 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 20, 'CPP') );
				//$cdf->setUserValue1( 4.95 ); //2006
				//$cdf->setUserValue2( 42100 );
				//$cdf->setUserValue3( 3500 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ));

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'CPP - Employer' );
				$cdf->setCalculation( 10 );
				$cdf->setCalculationOrder( 85 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 30, '%CPP - Employer%') );
				$cdf->setUserValue1( 100 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 20, 'CPP') ) );

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'EI - Employee' );
				//$cdf->setCalculation( 15 );
				$cdf->setCalculation( 91 ); //EI Formula
				$cdf->setCalculationOrder( 90 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 20, 'EI') );
				//$cdf->setUserValue1( 1.87 ); //2006
				//$cdf->setUserValue2( 39000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'EI - Employer' );
				$cdf->setCalculation( 10 );
				$cdf->setCalculationOrder( 95 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 30, '%EI - Employer%') );
				$cdf->setUserValue1( 140 ); //2006

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 20, 'EI') ) );

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'WCB - Employer' );
				$cdf->setCalculation( 10 );
				$cdf->setCalculationOrder( 95 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 30, '%WCB%') );
				$cdf->setUserValue1( 0.10 ); //Default

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 20 ); //Deduction
				$cdf->setName( 'Vacation Accrual' );
				$cdf->setCalculation( 10 );
				$cdf->setCalculationOrder( 50 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 50, 'Vacation Accrual') );
				$cdf->setUserValue1( 4 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );
					$exclude_ids = array(
										self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 10, 'Vacation Accrual Release'),
										self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 10, 'Vacation Time'),
										);
					$cdf->setExcludePayStubEntryAccount( $exclude_ids );

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 20 ); //Deduction
				$cdf->setName( 'Vacation Release' );
				$cdf->setCalculation( 10 );
				$cdf->setCalculationOrder( 51 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 10, 'Vacation Accrual Release') );
				$cdf->setUserValue1( 4 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );
					$exclude_ids = array(
										self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 10, 'Vacation Accrual Release'),
										self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 10, 'Vacation Time'),
										);
					$cdf->setExcludePayStubEntryAccount( $exclude_ids );

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				break;
			case 'us':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'Federal Income Tax' );
				$cdf->setCalculation( 100 );
				$cdf->setCalculationOrder( 100 );
				$cdf->setCountry( 'US' );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 20, '%Federal Income%') );
				$cdf->setUserValue1( 10 ); //Single
				$cdf->setUserValue2( 1 ); //0 Allowances

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'Advance Earned Income Credit (EIC)' );
				$cdf->setCalculation( 80 );
				$cdf->setCalculationOrder( 105 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 20, '%Advance EIC%') );
				$cdf->setUserValue1( 10 ); //Single

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'Federal Unemployment Insurance - Employer' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 80 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 30, 'Fed. Unemployment Ins.') );
				$cdf->setUserValue1( 0.80 ); //2006
				$cdf->setUserValue2( 7000 );
				$cdf->setUserValue3( 0 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ));

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'Social Security - Employee' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 80 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 20, 'Social Security (FICA)') );
				$cdf->setUserValue1( 6.2 ); //2006
				$cdf->setUserValue2( 97500 );
				$cdf->setUserValue3( 0 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ));

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'Social Security - Employer' );
				$cdf->setCalculation( 10 );
				$cdf->setCalculationOrder( 85 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 30, 'Social Security%') );
				$cdf->setUserValue1( 100 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 20, 'Social Security (FICA)') ) );

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'Medicare - Employee' );
				$cdf->setCalculation( 10 );
				$cdf->setCalculationOrder( 90 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 20, 'Medicare') );
				$cdf->setUserValue1( 1.45 ); //2006

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ));

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( 'Medicare - Employer' );
				$cdf->setCalculation( 10 );
				$cdf->setCalculationOrder( 95 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 30, 'Medicare') );
				$cdf->setUserValue1( 100 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					//$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ));
					$cdf->setIncludePayStubEntryAccount( array( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 20, 'Medicare') ) );

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				break;
			case 'cr':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( TTi18n::gettext('Income Tax') );
				$cdf->setCalculation( 100 );
				$cdf->setCalculationOrder( 100 );
				$cdf->setCountry( 'CR' );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 20, '%Federal Income%') );
				$cdf->setUserValue1( 10 ); //Single
				$cdf->setUserValue2( 0 ); //0 Allowances

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
				   		$cdf->Save();
					}
				}

				break;
		}

		Debug::text('Province/State: '. $province , __FILE__, __LINE__, __METHOD__, 10);
		switch (strtolower($province)) {
			//Canada
			case 'bc':
				$provincial_claim_amount = 8858; //2006
				break;
			case 'ab':
				$provincial_claim_amount = 8000; //2006
				break;

			//US
			case 'al':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 8000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ak':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance - Employer' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 28700 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance - Employee' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 20, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 28700 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ar':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 10000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'az':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 7000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Job Training' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Employee Training') );
				$cdf->setUserValue1( 0.10 ); //2006
				$cdf->setUserValue2( 7000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				break;
			case 'ca':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Disability Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 180 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 20, 'State Disability Ins.') );
				$cdf->setUserValue1( 0.80 ); //2006
				$cdf->setUserValue2( 79418.00 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0 ); //2006
				$cdf->setUserValue2( 7000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Employee Training' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Employee Training') );
				$cdf->setUserValue1( 0.10 ); //2006
				$cdf->setUserValue2( 7000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'co':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 10000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ct':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 15000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'dc':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 9000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'de':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 8500 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'fl':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 7000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ga':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 8500 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'hi':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 34000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ia':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 21300 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'id':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 29200 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'il':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins. - Employer') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 11000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'in':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 7000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ks':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 8000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ky':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 8000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'la':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 7000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ma':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 14000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'md':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 8500 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'me':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 12000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'mi':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 9000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'mn':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 24000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'mo':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 4.00 ); //2006
				$cdf->setUserValue2( 11000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ms':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 7000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'mt':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 21600 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'nc':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 17300 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'nd':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 20300 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;

			case 'nh':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 8000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ne':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 8000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'nh':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 8000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'nj':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 20, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 25800 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 25800 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'nm':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 17900 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'nv':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 24000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ny':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0 ); //2006
				$cdf->setUserValue2( 8500 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Reemployment Service Fund' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Reemployment') );
				$cdf->setUserValue1( 0.075 ); //2006
				$cdf->setUserValue2( 8500 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Disability Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 180 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 20, 'State Disability Ins.') );
				$cdf->setUserValue1( 0.50 ); //2006
				$cdf->setUserValue2( 0 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				break;
			case 'oh':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 9000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ok':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 13500 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'or':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Insurance') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 28000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'pa':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 8000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ri':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Employment Security' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 16000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'sc':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 7000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'sd':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 7000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'tn':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 7000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'tx':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0 ); //2006
				$cdf->setUserValue2( 9000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}

				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Employee Training' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Employee Training') );
				$cdf->setUserValue1( 0.0 ); //2006
				$cdf->setUserValue2( 9000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'ut':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 24000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'va':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 8000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'vi':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 20000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'vt':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 8000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;

			case 'wa':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 30900 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'wi':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 10500 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'wv':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 8000 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;
			case 'wy':
				$cdf = new CompanyDeductionFactory();
				$cdf->setCompany( $company_id );
				$cdf->setStatus( 10 ); //Enabled
				$cdf->setType( 10 ); //Tax
				$cdf->setName( strtoupper($province).' - Unemployment Insurance' );
				$cdf->setCalculation( 15 );
				$cdf->setCalculationOrder( 185 );
				$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 30, 'State Unemployment Ins.') );
				$cdf->setUserValue1( 0.00 ); //2006
				$cdf->setUserValue2( 17100 );

				if ( $cdf->isValid() ) {
					$cdf->Save(FALSE);

					$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

					unset($exclude_ids);

					if ( $cdf->isValid() ) {
						$cdf->Save();
					}
				}
				break;

		}

		if ($country == 'CA' ) {
			$cdf = new CompanyDeductionFactory();
			$cdf->setCompany( $company_id );
			$cdf->setStatus( 10 ); //Enabled
			$cdf->setType( 10 ); //Tax
			$cdf->setName( strtoupper($province) .' - Provincial Income Tax' );
			$cdf->setCalculation( 200 );
			$cdf->setCalculationOrder( 110 );
			$cdf->setCountry( 'CA' );
			$cdf->setProvince( strtoupper($province) );
			$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 20, '%Provincial Income%') );
			$cdf->setUserValue1( $provincial_claim_amount );

			if ( $cdf->isValid() ) {
				$cdf->Save(FALSE);

				$exclude_ids = array(
									//Not proper way to do it with CPP/EI
									//self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 'CPP'),
									//self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 'EI'),
									self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName($company_id, 20, 'Union'),
									);
				$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );
				$cdf->setExcludePayStubEntryAccount( $exclude_ids );

				unset($exclude_ids);

				if ( $cdf->isValid() ) {
					$cdf->Save();
				}
			}
		} elseif ( $country = 'US' ) {
			$cdf = new CompanyDeductionFactory();
			$cdf->setCompany( $company_id );
			$cdf->setStatus( 10 ); //Enabled
			$cdf->setType( 10 ); //Tax
			$cdf->setName( 'State Income Tax' );
			$cdf->setCalculation( 200 );
			$cdf->setCalculationOrder( 200 );
			$cdf->setCountry( 'US' );
			$cdf->setProvince( strtoupper($province) );
			$cdf->setPayStubEntryAccount( self::getPayStubEntryAccountByCompanyIDAndTypeAndFuzzyName( $company_id, 20, '%State Income%') );
			$cdf->setUserValue1( 10 ); //Single
			$cdf->setUserValue2( 1 ); //0 Allowances

			if ( $cdf->isValid() ) {
				$cdf->Save(FALSE);

				$cdf->setIncludePayStubEntryAccount( array( $psea_obj->getTotalGross() ) );

				unset($exclude_ids);

				if ( $cdf->isValid() ) {
					$cdf->Save();
				}
			}
		}

		$cdf->CommitTransaction();
		//$cdf->FailTransaction();

		return TRUE;
	}

	function postSave() {
		$this->removeCache( $this->getId() );
		$this->removeCache( 'include_pay_stub_entry-'. $this->getId() );
		$this->removeCache( 'exclude_pay_stub_entry-'. $this->getId() );

		if ( $this->getDeleted() == TRUE ) {
			//Check if any users are assigned to this, if so, delete mappings.
			$udlf = new UserDeductionListFactory();

			$udlf->StartTransaction();
			$udlf->getByCompanyIdAndCompanyDeductionId( $this->getCompany(), $this->getId() );
			if ( $udlf->getRecordCount() ) {
				foreach( $udlf as $ud_obj ) {
					$ud_obj->setDeleted(TRUE);
					if ( $ud_obj->isValid() ) {
						$ud_obj->Save();
					}
				}
			}
			$udlf->CommitTransaction();
		}

		return TRUE;
	}

	function addLog( $log_action ) {
		return TTLog::addEntry( $this->getId(), $log_action,  TTi18n::getText('Company Deduction'), NULL, $this->getTable() );
	}
}
?>
