TCL_VERSION     = 8.4.2
TCLCURL_VERSION = 0.10.5
TclCurl_nodot   = 0.105
CURL_VERSION    = 7.10.5
ZLIB_VERSION    = 1.1.4

installFiles = ChangeLog changes license.terms ReadMe.txt ReadMeW32.txt ToDo.txt packages/Windows/SetUp.tcl
installDirs  = tests
certFiles    = curl-${CURL_VERSION}/lib/ca-bundle.crt
sslFiles     = libeay32.dll libssl32.dll
docFiles     = aolserver.txt OpenSSL-LICENSE.txt tclcurl.html tclcurl_multi.html

tclcurl-plain:        DESTDIR = TclCurl-${TCLCURL_VERSION}

tclcurl-ssl: 	    DESTDIR = TclCurl-SSL-${TCLCURL_VERSION}
tclcurl-ssl: 	    TclCurlFlags = --enable-ssl
tclcurl-ssl:          SSL = SSL\=1

tclcurl-threaded:     DESTDIR = TclCurl-THREADED-${TCLCURL_VERSION}
tclcurl-threaded:     TclFlags = --enable-threads

tclcurl-threaded-ssl: DESTDIR = TclCurl-THREADED-SSL-${TCLCURL_VERSION}
tclcurl-threaded-ssl: TclFlags = --enable-threads
tclcurl-threaded-ssl: TclCurlFlags = --enable-ssl
tclcurl-threaded-ssl: SSL = SSL\=1

zlib = ZLIB\=1

tclcurl-plain: tcl zlib curl tclcurlComp createDir extraFiles extraDirs docs rar

tclcurl-ssl: tcl zlib curl tclcurlComp createDir extraFiles extraDirs docs ssl rar

tclcurl-threaded: tcl zlib curl tclcurlComp createDir extraFiles extraDirs docs rar

tclcurl-threaded-ssl: tcl zlib curl tclcurlComp createDir extraFiles extraDirs ssl docs rar

clean: 
	rm TclCurl-${TCLCURL_VERSION}.exe TclCurl-SSL-${TCLCURL_VERSION}.exe TclCurl-THREADED-${TCLCURL_VERSION}.exe TclCurl-THREADED-SSL-${TCLCURL_VERSION}.exe

tcl:
	cd /home/Andres/tcl${TCL_VERSION}/win    ;\
	make distclean                           ;\
	./configure ${TclFlags}                  ;\
	make                         	           ;\
	make install

curl:
	cd curl-${CURL_VERSION}                  ;\
      cd lib                                   ;\
      make -f Makefile.m32 clean               ;\
      make -f Makefile.m32 ${SSL} ${zlib}      ;\
      cp -f libcurl.dll  /usr/local/lib        ;\
      cp -f libcurldll.a /usr/local/lib        ;\
      cp -f libcurl.a    /usr/local/lib        ;\
      cd ../src                                ;\
      make -f Makefile.m32 clean               ;\
      make -f Makefile.m32 ${SSL} ${zlib}      ;\
      cp -f curl.exe /usr/local/bin            ;\
	cd ..                                    ;\
	cp -rf include/curl /usr/local/include   ;\

zlib:
	cd zlib-${ZLIB_VERSION}                  ;\
	make distclean                           ;\
	./configure                              ;\
	make                                     ;\
	make install                             ;\

tclcurlComp:
	cd TclCurl                                                              ;\
	make distclean                                                          ;\
	CC=gcc ./configure ${TclFlags} ${TclCurlFlags} -enable-zlib             ;\
	make                                                                    ;\
	make install

createDir:
	mkdir ${DESTDIR}                                                        ;\
	cp -r /usr/local/lib/tclcurl${TclCurl_nodot} ${DESTDIR}                 ;\

extraFiles:
	for f in $(installFiles) ; do                                            \
      cp    TclCurl/$$f ${DESTDIR}                                            ;\
	done 

extraDirs:
	for f in $(installDirs) ; do                                             \
      cp -r TclCurl/$$f ${DESTDIR}/tclcurl${TclCurl_nodot}                    ;\
	done

ssl:
	mkdir ${DESTDIR}/certs                                                  ;\
	cp ${certFiles} ${DESTDIR}/certs                                        ;\
	mkdir ${DESTDIR}/ssl                                                    ;\
	for f in $(sslFiles) ; do                                                \
      cp -r /usr/local/lib/$$f ${DESTDIR}/ssl                                 ;\
	done 

docs:
	mkdir ${DESTDIR}/tclcurl${TclCurl_nodot}/doc                            ;\
	for f in $(docFiles) ; do                                                \
      cp -r TclCurl/doc/$$f ${DESTDIR}/tclcurl${TclCurl_nodot}/doc            ;\
	done

rar:
	c:/Archiv~1/WinRAR/rar a -r -s -sfx  ${DESTDIR}.exe ${DESTDIR}          ;\
	rm -r ${DESTDIR}
