/********************************************************/
/* These are the functions that parse the command line  */
/* arguments.                                           */
/********************************************************/
#ifndef lint
static const char rcsid[] = 
       "$Id: parser.c,v 1.13 2000/09/14 11:17:29 slay Exp $";
#endif

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>

#ifdef HAVE_NETINET_IN_SYSTM_H
#include <netinet/in_systm.h>
#else
#ifdef HAVE_NETINET_IN_SYSTEM_H
#include <netinet/in_system.h>
#endif
#endif

#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif

#ifdef HAVE_BSTRING_H
#include <bstring.h>
#endif

#ifdef STDC_HEADERS
#include <stdlib.h>
#endif

#ifdef HAVE_GETOPT_LONG_ONLY
#include <getopt.h>
#else
#include "getopt.h"
#endif

#include <stdarg.h>
#include <ctype.h>

#include "parser.h"


/*********************/
/* A parser function */
/*********************/
void 
parse_args( int argc, char **args, struct my_pack *packet )
{
   int max_cod=0, carac, ptr;
   int opt_ind;
   u_short noerror=1;
   char *code_icmp="NOTHING", **array_aux=NULL, *punt, *router, *pref;
   u_long router_addr, preference;
   struct protoent *proto;
   static struct mi_ifaz iface;
   struct sockaddr_in *aux2;
   static struct option options[] =
   {
    { "help",       0, 0, 'h' },
    { "Version",    0, 0, 'V' },
    { "K",          0, 0, 'n' },
    { "K",          0, 0, 'v' },
    { "K",          0, 0, 'R' },
    { "K",          0, 0, 'q' },
    { "K",          0, 0, 'Q' },
    { "K",          0, 0, 'O' },
    { "K",          0, 0, 'B' },
    { "K",          0, 0, 'G' },
    { "K",          0, 0, 'U' },
    { "K",          1, 0, 'i' },
    { "K",          1, 0, 'T' },
    { "K",          1, 0, 'c' },
    { "K",          1, 0, 'x' },
    { "K",          1, 0, 'S' },
    { "K",          1, 0, 'p' },
    { "K",          1, 0, 's' },
    { "K",          1, 0, 'F' },
    { "K",          1, 0, 'l' },
    { "K",          1, 0, 't' },
    { "K",          1, 0, 'M' },
    { "K",          1, 0, 'L' },
    { "prot",      1, 0, 0 },
    { "protocol",  1, 0, 0 },
    { "psrc",      1, 0, 0 },
    { "port_src",  1, 0, 0 },
    { "pdst",      1, 0, 0 },
    { "orig",      1, 0, 0 },
    { "orig_host", 1, 0, 0 },
    { "rta",       1, 0, 0 },
    { "router_advert", 1, 0, 0 },
    { "lt",           1, 0, 0 },
    { "lifetime",     1, 0, 0 },
    { "to",           1, 0, 0 },
    { "gw",           1, 0, 0 },
    { "gateway",      1, 0, 0 },
    { "dest",         1, 0, 0 },    
    { "route_dest",   1, 0, 0 },    
    { "id",           1, 0, 0 },
    { "seq",          1, 0, 0 },
    { "ip_id",        1, 0, 0 },
    { "ip_seq",       1, 0, 0 },
    { "ptr",          1, 0, 0 },
    { "pointer",      1, 0, 0 },
    { "TOS",          1, 0, 0 },
    { "reply",        0, 0, 0 },
    { "du",           0, 0, 0 },    
    { "dest_unreach", 0, 0, 0 },    
    { "sq",         0, 0, 0 },    
    { "src_quench", 0, 0, 0 },    
    { "red",        0, 0, 0 },    
    { "redirect",   0, 0, 0 },    
    { "tx",         0, 0, 0 },    
    { "time_exc",   0, 0, 0 },    
    { "tstamp",     0, 0, 0 },    
    { "timestamp",  0, 0, 0 },    
    { "mask",       0, 0, 0 },    
    { "mask_req",   0, 0, 0 },    
    { "info",       0, 0, 0 },    
    { "info_req",   0, 0, 0 },    
    { "rts",        0, 0, 0 },    
    { "router_solicit", 0, 0, 0 },    
    { "echo",     0, 0, 0 },    
    { "echo_req", 0, 0, 0 },    
    { "param",    0, 0, 0 },    
    { "param_problem", 0, 0, 0 },    
    { 0, 0, 0, 0 }
   };

   l_cod_t = long_cod_time;
   cod_u = cod_unreach;
   cod_r = cod_redirect;

   max_cod_r = MAX_C(cod_redirect);
   max_cod_u = MAX_C(cod_unreach);
   max_l_cod_t = MAX_C(long_cod_time);

   while( (carac=getopt_long_only(argc,args,"c:x:l:L:S:F:M:hi:s:p:T:t:UGBOqQmnRVv",
           options, &opt_ind)) != EOF)
   {
     switch(carac) 
     {
       case 0:

         if ( !strcmp(options[opt_ind].name, "prot") || 
              !strcmp(options[opt_ind].name, "protocol") )
         {
            if ( ( proto = getprotobyname( optarg )) == NULL )
            {
               if ( !are_digits(optarg) )
                  go_out(1,"Unknown protocol -> %s",optarg);
               packet->protocol = atoi(optarg);
            }
            else
               packet->protocol = proto->p_proto;               
         } else
         if ( !strcmp(options[opt_ind].name, "psrc") || 
              !strcmp(options[opt_ind].name, "port_src") )
         {
            packet->p_origen = atoi(optarg);
         } else
         if ( !strcmp(options[opt_ind].name, "pdst") || 
              !strcmp(options[opt_ind].name, "port_dst") )
         {
               packet->p_destino = atoi(optarg);
         } else
         if ( !strcmp(options[opt_ind].name, "orig") || 
              !strcmp(options[opt_ind].name, "orig_host") )
         {
            if ( exist_host( optarg, (u_long *)&(packet->orig) ) )
               go_out(1,"Wrong original host -> %s",optarg);
         } else
         if ( !strcmp(options[opt_ind].name, "reply") ) 
         {
            packet->tipo_icmp = ICMP_ECHO_REPLY;
         } else         
         if ( !strcmp(options[opt_ind].name, "du") || 
              !strcmp(options[opt_ind].name, "dest_unreach") )
         {
            packet->tipo_icmp = ICMP_DEST_UNREACH;
            array_aux = cod_unreach;
            max_cod = max_cod_u;
         } else
         if ( !strcmp(options[opt_ind].name, "sq") || 
              !strcmp(options[opt_ind].name, "src_quench") )
         {
            packet->tipo_icmp = ICMP_SOURCE_QUENCH;
            packet->cod_icmp = 0;
         } else
         if ( !strcmp(options[opt_ind].name, "red") || 
              !strcmp(options[opt_ind].name, "redirect") )
         {
            packet->tipo_icmp = ICMP_REDIRECT;
            array_aux = cod_redirect;
            max_cod = max_cod_r;
         } else
         if ( !strcmp(options[opt_ind].name, "tx") || 
              !strcmp(options[opt_ind].name, "time_exc") )
         {
            packet->tipo_icmp = ICMP_TIME_EXCEEDED;
            array_aux = cod_time;
            max_cod = MAX_C(cod_time);
         } else
         if ( !strcmp(options[opt_ind].name, "tstamp") || 
              !strcmp(options[opt_ind].name, "timestamp") )
         {
            packet->tipo_icmp = ICMP_TIMESTAMP;
            packet->cod_icmp = 0;
         } else
         if ( !strcmp(options[opt_ind].name, "mask") || 
              !strcmp(options[opt_ind].name, "mask_req") )
         {
            packet->tipo_icmp = ICMP_ADDRESS;
            packet->cod_icmp = 0;
         } else
         if ( !strcmp(options[opt_ind].name, "info") || 
              !strcmp(options[opt_ind].name, "info_req") )
         {
            packet->tipo_icmp = ICMP_INFO_REQUEST;
            packet->cod_icmp = 0;
         } else
         if ( !strcmp(options[opt_ind].name, "rts") || 
              !strcmp(options[opt_ind].name, "router_solicit") )
         {
            packet->tipo_icmp = ICMP_ROUTER_SOLICIT;
            packet->cod_icmp = 0;
         } else
         if ( !strcmp(options[opt_ind].name, "rta") || 
              !strcmp(options[opt_ind].name, "router_advert") )
         {
            packet->tipo_icmp = ICMP_ROUTER_ADVERT;
            packet->cod_icmp = 0;
            punt = optarg;
            if ( ( router = strtok( punt, "/")) != NULL )
            {
               if ( exist_host( router, (u_long *)&(router_addr) ) )
                  go_out(1,"Incorrect Advertisement router address/name -> %s",router);
               if ( (pref = strtok( NULL, "/")) != NULL )
                  preference = atoi(pref);
               else
                  preference = PREFERENCE_DFL;
               add_router( packet, router_addr, preference );
            }
            else
               fprintf(stderr, "strtok() error -> %s\n", sys_errlist[errno]);                     
         } else
         if ( !strcmp(options[opt_ind].name, "lt") || 
              !strcmp(options[opt_ind].name, "lifetime") )
         {
            packet->lifetime = atoi(optarg);
         } else
         if ( !strcmp(options[opt_ind].name, "echo") || 
              !strcmp(options[opt_ind].name, "echo_req") )
         {
            packet->tipo_icmp = ICMP_ECHO_REQUEST;
            packet->cod_icmp = 0;
         } else         
         if ( !strcmp(options[opt_ind].name, "gw") || 
              !strcmp(options[opt_ind].name, "gateway") )
         {
            if ( exist_host( optarg, (u_long *)&(packet->gway) ) )
               go_out(1,"Wrong Redirect gateway -> %s",optarg);
         }else
         if ( !strcmp(options[opt_ind].name, "dest") || 
              !strcmp(options[opt_ind].name, "route_dest") )
         {
            if ( exist_host( optarg, (u_long *)&(packet->dest_red) ) )
               go_out(1,"Incorrect Redirect route destination -> %s",optarg);            
         } else         
         if ( !strcmp(options[opt_ind].name, "ip_id") )
         {
            packet->p_origen = atoi(optarg);
         } else                  
         if ( !strcmp(options[opt_ind].name, "ip_seq") )
         {
            packet->p_destino = atoi(optarg);
         } else                           
         if ( !strcmp(options[opt_ind].name, "param") || 
              !strcmp(options[opt_ind].name, "param_problem") )
         {
            packet->tipo_icmp = ICMP_PARAM_PROB;
            packet->cod_icmp = 0;
         } else
         if ( !strcmp(options[opt_ind].name, "id") )
         {
            packet->info_id = atoi(optarg);
         } else                  
         if ( !strcmp(options[opt_ind].name, "seq") )
         {
            packet->info_seq = atoi(optarg);
         } else                                    
         if ( !strcmp(options[opt_ind].name, "ptr") || 
              !strcmp(options[opt_ind].name, "pointer") )
         {
            if ( (ptr = atoi(optarg)) > 255 )
               go_out(1,"Incorrect pointer Parameter Problem -> %s",optarg);
            if ( ptr < 0 )
               go_out(1,"Incorrect pointer Parameter Problem -> %s",optarg);
            packet->pointer = ptr;
         } else
         if ( !strcmp(options[opt_ind].name, "TOS") )
         {
            if ( (packet->tos = atoi(optarg)) > 255 )
               packet->tos = 255;
         }
       break;

       case 't': if ( (packet->ttl = atoi(optarg)) > 255 )
                    packet->ttl = TTL_DFL;
       break;

       case 'l': if ( (packet->flood = atoi(optarg)) < 0 )
                    packet->flood=0;
                 else
                    if (uid)
                       go_out(1,"Only root can use preload");
       break;

       case 'F':   
#ifdef CAN_FRAGMENT         
             packet->mtu = atoi(optarg);
#else
             write_log(1,"<*> Your OS seems to not allow fragmented packets :(<*>\n");
#endif            
       break;

       case 'G': set_df = 1;
       break;
       
       case 'U': set_rf = 1;
#if defined(FREEBSD) || defined(NETBSD) || defined(OPENBSD)
           packet->spoof=1;
           if (uid)
              go_out(1,"Only root can read IP Reserved bit on *BSD systems.");
#endif
       break;
       
       case 'O': do_fingerprint = 1;
       break;

       case 'B': bad_cksum = 1;
       break;

       case 's': if ( !strcmp("max", optarg) )
                 {
                    packet->garbage = SIZE_BIG;
                    max_gbg = 1;
                 }
                 else
                 {
                    if ( (packet->garbage = (u_long)atol(optarg)) < 1 ) 
                       go_out(1,"Garbage too small");
                 }
       break;
       
       case 'p': packet->pattern = optarg;
                 is_pattern = !is_pattern;
                 if ( (packet->size_pattern = strlen(optarg)) < 1 )
                    go_out(1,"Data pattern too small");
                 if ( packet->size_pattern > 
                      (SIZE_BIG - TCAB_IP - TCAB_ICMP_MSG ) )
                    go_out(1,"Data pattern len is too big");
       break;

       case 'M': if (!strcmp("win",optarg))
                    mimic=1;
                 else
                 if (!strcmp("unix",optarg))
                    mimic=2;
                 else
                 if (!strcmp("linux",optarg))
                    mimic=3;
                 else
                 if (!strcmp("cisco",optarg))
                    mimic=4;
                 else
                 if (!strcmp("shiva",optarg))
                    mimic=5;
                 else
                 if (!strcmp("solaris",optarg))
                    mimic=6;
                 else
                    go_out(1,"What mimic type?");
       break;
       
       case 'S': if (uid)
                    go_out(1,"Only root can use spoof");
                 if ( exist_host( optarg, (u_long *)&(packet->ip_spoof) ) )
                    go_out(1,"Wrong spoof IP or hostname -> %s", optarg);
                 packet->spoof=1;
       break;
              
       case 'x':code_icmp = optarg;
       break;

       case 'c': if ( (packet->count_rx = atoi(optarg)) < 0 )
                    packet->count_rx=0;
       break;

       case 'h': help();
       break;

       case 'i': strncpy(iface.name,optarg,sizeof(iface.name));
                 if ( !look4dev( (struct mi_ifaz *)&iface) )
                 {
                    aux2 = (struct sockaddr_in *)&iface.ip;
                    if ( exist_host( optarg, (u_long *)&(aux2->sin_addr.s_addr)) )
                       go_out(1,"Interface address/name incorrect -> %s", optarg);
                    /* Search network device by IP address */
                    iface.name[0]=0;
                    if ( !look4dev( (struct mi_ifaz *)&iface ) )
                       go_out(1,"Interface address/name incorrect -> %s", optarg);
                    packet->listen2dev = iface.name;
                 }
                 else
                    packet->listen2dev = optarg;
       break;

       case 'T': if ( (packet->timeout = atoi(optarg)) < 1 )
                    packet->timeout=1;
       break;
       
       case 'q': quiet=1;
       break;

       case 'Q': Quiet=quiet=1;
       break;

       case 'n': resolve=0;
       break;
       
       case 'R': packet->rr=1;
       break;

       case 'L': if ( (packet->logfile = fopen(optarg, "a+")) == NULL )
                    go_out_error(1, "fopen");
       break;
       
       case 'V': printf( "GNU %s %s %s\n", PACKAGE, VERSION, vers_date );
                 printf( "%s\n", disclaimer);
                 exit(0);
       break;
              
       case 'v': verbose=1;
       break;
       
       case '?': noerror=0;
       break;       
     }
   }

   if ( packet->tipo_icmp == 255 ) /* Bad icmp type... */
   {
      if (noerror)
         packet->tipo_icmp = ICMP_ECHO_REQUEST;
      else
         go_out(1,"Incorrect or missing ICMP packet type");
   }

   if ( argc - optind != 1)
      go_out(1,"Missing or wrong destination IP/name");
  
   if (mimic) /* Use of Mimic option... */
   {
      packet->garbage = 0; /* Disable garbage if any */
      switch(mimic)
      {
         case 1: /* Window$... Why the hell it doesn't send a timestamp? :( */
                packet->pattern = win_data;
                packet->size_pattern = sizeof(win_data);
                if (!packet->tipo_icmp)
                   packet->ttl = 128;
                else
                   packet->ttl = 64;
                if (!packet->info_seq)
                   packet->info_seq = 1;
                if (!packet->info_id)
                   packet->info_id = htons(0x01000);
         break;

         case 6: set_df=1; /* Solaris */        
         case 2: /* UNIX/Linux... */
         case 3: packet->pattern = unix_data;
                 packet->size_pattern = sizeof(unix_data);
                 if ( (mimic == 3) && packet->tipo_icmp ) /* Linux... */
                    packet->ttl = 64;
                 else
                    packet->ttl = 255;
         break;

         case 4: /* Cisco...Why the hell it doesn't use the seq field? :( */
                 packet->pattern = cisco_data;
                 packet->size_pattern = sizeof(cisco_data);
                 if (!packet->info_id) /* Seq don't vary, Id does :( */
                    packet->info_id = htons(0x0911);
                 if (!packet->info_seq)
                    packet->info_seq = 1;
         break;
         
         case 5: /* Shiva... Why the hell it doesn't send a timestamp?... */
                 /* and Why the hell it doesn't use the icmp seq field? :( */
                 packet->pattern = shiva_data; 
                 packet->size_pattern = sizeof(shiva_data);
                 if (!packet->info_id) /* Seq don't vary, Id does :( */
                    packet->info_id = htons(0x0001);
         break;
      } /* ...end case */
      
      if (packet->tipo_icmp && (packet->tipo_icmp != ICMP_ECHO_REQUEST) )
         go_out(1,"Mimic option valid only with Echo Request/Reply type");
   }
  
   ip_opt_control( args[optind] );

   if ( cont_gways )
      packet->destino.sin_addr.s_addr = gway_ip[0];
   else
   {
      if ( exist_host( args[argc-1],
              (u_long *)&(packet->destino.sin_addr.s_addr) ) )
         go_out(1,"Missing or wrong destination IP/name");
   }
   
   where2route((struct sockaddr_in *)&packet->destino);

#ifdef DEBUG
      printf(" -> Outgoing interface = %s\n", packet->iface2route.name);
      recorre_lista(packet);
#endif
   
   if ( packet->destino.sin_addr.s_addr == 1 ) /* Bad destination host...*/
      go_out(1,"Missing or wrong destination IP/name");

   if ( packet->ip_spoof == 0 )
   {
      aux2 = (struct sockaddr_in *)&packet->iface2route.ip;
      packet->ip_spoof = aux2->sin_addr.s_addr;
   }

   switch ( packet->tipo_icmp )
   {
      case ICMP_REDIRECT: if ( (packet->cod_icmp = exist_code(code_icmp,
                                array_aux, max_cod)) == -1 )
                             go_out(1,"Incorrect or missing redirect code");
                          if ( packet->dest_red == 1 )
                             go_out(1,"Incorrect or missing redirect route destination");
                          if ( packet->gway == 1 )
                             packet->gway = packet->ip_spoof;
                          if ( packet->orig == 1 )
                             packet->orig = packet->destino.sin_addr.s_addr;
      break;

      case ICMP_DEST_UNREACH:if( (packet->cod_icmp = exist_code(code_icmp,
                                  array_aux, max_cod)) == -1 )
                               go_out(1,"Incorrect or missing unreach code");
      break;

      case ICMP_TIME_EXCEEDED:if( (packet->cod_icmp = exist_code(code_icmp,
                                  array_aux, max_cod)) == -1 )
                               go_out(1,"Incorrect or missing exceeded code");
      break;

      case ICMP_ECHO_REQUEST:if ( do_fingerprint && !packet->cod_icmp )
                                 packet->cod_icmp=22;
                              else
                                 packet->cod_icmp=(strcmp(code_icmp,"NOTHING")?
                                                   atoi(code_icmp):0);
      break;

      case ICMP_ADDRESS: if (do_fingerprint && !packet->mtu)
                            packet->mtu=8;
                         packet->cod_icmp = (strcmp(code_icmp,"NOTHING")?
                                             atoi(code_icmp):0);
      break;
      
      case ICMP_ECHO_REPLY:
      case ICMP_ROUTER_ADVERT: packet->timeout = 0;
                      default: 
                               packet->cod_icmp = (strcmp(code_icmp,"NOTHING")?
                                                  atoi(code_icmp):0);
                        break;
   }

   if ( packet->orig == 1 )
      packet->orig = packet->ip_spoof;
}


/******************************/
/* Add a router to the linked */
/* list of Advertisements     */
/* entries.                   */
/******************************/
void 
add_router(struct my_pack *init, u_long router_addr, u_long preference)
{
   struct router *cursor = init->router;

   if ( init->router == NULL ) 
   {
      init->router = (struct router *)malloc(sizeof(struct router));
      if ( init->router == NULL )
         go_out_error(3,"Can't allocate memory for struct router");

      init->num_routers++;
      init->router->address = router_addr;
      init->router->pref = preference;
      init->router->next = NULL;
      return;
   }
      
   do
   {
      if ( !cursor->next )
      {
         if ( init->num_routers == (MAX_ROUTERS - 1))
         {
            if ( verbose )
               printf( "Sorry, no more than %d routers allowed.\n",
                             MAX_ROUTERS - 1);
            return;
         }
         cursor->next = (struct router *)malloc(sizeof(struct router));
         if (!cursor->next)
            go_out_error(3,"Can't allocate memory for struct router");
         init->num_routers++;
         cursor->next->address = router_addr;
         cursor->next->pref = preference;
         cursor->next->next = NULL;
         return;
      }
      cursor = cursor->next;
   }while ( cursor );
}


#ifdef DEBUG
void 
recorre_lista(struct my_pack *init )
{
   struct router *cursor = init->router;
   struct in_addr direc;
   while(cursor)
   { 
      direc.s_addr = cursor->address;
      printf( " -> Router = %s - Pref = %ld\n", inet_ntoa(direc),
       cursor->pref);
      cursor = cursor->next;
   }
}
#endif


/************************************/
/* Look for the code of the ICMP    */
/* type within the array_cod.       */
/* Return -1 on error.              */
/* Return the code value on success */
/************************************/
int 
exist_code( char *cod, char **array_cod, int max_cod )
{
  short int bucle;
  for (bucle=0; bucle <= (max_cod-1); bucle++)
     if ( !strcmp( cod, array_cod[bucle]) )
        return bucle;
  return -1;  
}



/********************************************/
/* If nom_host == NULL then we want to know */
/* if the IP (in binary format) is ok.      */
/* If nom_host != NULL then we put the      */
/* IP of nom_host into bin_host.            */
/* Return 1 on error, 0 on succes.          */
/********************************************/
/* We allow the 255.255.255.255 address !!  */
/********************************************/
int 
exist_host( char *nom_host, u_long *bin_host )
{
  struct hostent *hinfo;
  struct sockaddr_in host_tmp;
  struct in_addr host_binario;
    
  initmem( (char *)&host_tmp, sizeof(host_tmp) );
  initmem( (char *)&host_binario, sizeof(host_binario) );

  host_tmp.sin_family = AF_INET;
  
  if ( nom_host == NULL )   /* We wanna know if the binary IP is  OK. */
  {
     if ( (hinfo = gethostbyaddr( (char *)bin_host, 4, AF_INET )) )
        return 0;
     else
        return 1;
  }  
  
  if ( inet_aton( nom_host, &host_binario) )
  {
     copymem( (char *)&host_binario, (char *)bin_host, sizeof(host_binario));
     return 0; 
  }

  if ( (hinfo = gethostbyname( nom_host )) ) /* Put nom_host into bin_host */
  {
     copymem(hinfo->h_addr, (char *)&host_tmp.sin_addr, hinfo->h_length);
     copymem( (char *) &host_tmp.sin_addr.s_addr, (char *)bin_host,
              sizeof( host_tmp.sin_addr.s_addr));
     return 0;
  }

  return 1;
}

/***********************************/
/* Look if *ALL* of the characters */
/* are digits.                     */
/* Return 0 on error.              */
/***********************************/
int 
are_digits( char *charac )
{
   while (*charac)
   {
      if ( !isdigit((int)*charac) )
         return 0;
      charac++;
   }
   return 1;
}

